/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport.tcp;

import com.google.common.collect.Lists;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.ros.internal.transport.tcp.NamedChannelHandler;
import org.ros.internal.transport.tcp.TcpClient;

public class TcpClientManager {
    private final ChannelGroup channelGroup;
    private final Collection<TcpClient> tcpClients;
    private final List<NamedChannelHandler> namedChannelHandlers;
    private final Executor executor;

    public TcpClientManager(Executor executor) {
        this.executor = executor;
        this.channelGroup = new DefaultChannelGroup();
        this.tcpClients = Lists.newArrayList();
        this.namedChannelHandlers = Lists.newArrayList();
    }

    public void addNamedChannelHandler(NamedChannelHandler namedChannelHandler) {
        this.namedChannelHandlers.add(namedChannelHandler);
    }

    public void addAllNamedChannelHandlers(List<NamedChannelHandler> namedChannelHandlers) {
        this.namedChannelHandlers.addAll(namedChannelHandlers);
    }

    public TcpClient connect(String connectionName, SocketAddress socketAddress) {
        TcpClient tcpClient = new TcpClient(this.channelGroup, this.executor);
        tcpClient.addAllNamedChannelHandlers(this.namedChannelHandlers);
        tcpClient.connect(connectionName, socketAddress);
        this.tcpClients.add(tcpClient);
        return tcpClient;
    }

    public void shutdown() {
        this.channelGroup.close().awaitUninterruptibly();
        this.tcpClients.clear();
    }
}

