/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.ui.impl;

import javax.vecmath.Point3d;
import org.eclipse.apogy.addons.geometry.paths.ui.Activator;
import org.eclipse.apogy.addons.geometry.paths.ui.PathPresentationMode;
import org.eclipse.apogy.addons.geometry.paths.ui.WayPointPathPresentation;
import org.eclipse.apogy.addons.geometry.paths.ui.WayPointPathSceneObject;
import org.eclipse.apogy.addons.geometry.paths.ui.impl.WayPointPathPresentationImpl;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class WayPointPathPresentationCustomImpl
extends WayPointPathPresentationImpl {
    protected IPropertyChangeListener preferencesListener = null;

    protected WayPointPathPresentationCustomImpl() {
        this.applyPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    protected void updateSceneObject(Notification notification) {
        WayPointPathSceneObject wayPointPathSceneObject = (WayPointPathSceneObject)this.sceneObject;
        if (notification.getNotifier() instanceof WayPointPathPresentation) {
            int featureId = notification.getFeatureID(WayPointPathPresentation.class);
            switch (featureId) {
                case 17: {
                    wayPointPathSceneObject.setPathPresentationMode(this.presentationMode);
                    break;
                }
                case 16: {
                    wayPointPathSceneObject.setPointSize(this.pointSize);
                    break;
                }
                case 18: {
                    wayPointPathSceneObject.setEndPointsRadius(this.endPointsRadius);
                    break;
                }
            }
        }
        super.updateSceneObject(notification);
    }

    public Tuple3d basicGetCentroid() {
        Point3d point3d = new Point3d();
        if (this.sceneObject != null) {
            point3d = this.sceneObject.getCentroid();
        }
        return ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)point3d);
    }

    protected void initialSceneObject() {
        WayPointPathSceneObject object3D = (WayPointPathSceneObject)this.sceneObject;
        object3D.setPathPresentationMode(this.presentationMode);
        object3D.setPointSize(this.pointSize);
        object3D.setEndPointsRadius(this.endPointsRadius);
        super.initialSceneObject();
    }

    private IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    WayPointPathPresentationCustomImpl.this.applyPreferences();
                }
            };
        }
        return this.preferencesListener;
    }

    protected void applyPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_WAYPOINTPATH_COLOR_ID");
        if (rgb != null) {
            this.setColor(ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(rgb));
        }
        this.setVisible(store.getBoolean("DEFAULT_WAYPOINTPATH_VISIBILITY_ID"));
        this.setPresentationMode(PathPresentationMode.get(store.getInt("DEFAULT_WAYPOINTPATH_PRESENTATION_MODE_ID")));
        this.setPointSize(store.getInt("DEFAULT_WAYPOINTPATH_POINT_SIZE_ID"));
        this.setEndPointsRadius(store.getFloat("DEFAULT_WAYPOINTPATH_END_POINT_RADIUS_ID"));
        super.applyPreferences();
    }
}

