/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.impl;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.geometry.paths.impl.SegmentWayPointPathInterpolatorImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.core.runtime.IProgressMonitor;

public class SegmentWayPointPathInterpolatorCustomImpl
extends SegmentWayPointPathInterpolatorImpl {
    protected List<CartesianPositionCoordinates> interpolateSegment(CartesianPositionCoordinates p0, CartesianPositionCoordinates p1) {
        Point3d point1;
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
        Point3d point0 = p0.asPoint3d();
        double distance = point0.distance(point1 = p1.asPoint3d());
        if (distance > this.getMaximumDistanceInterval()) {
            double deltaX = point1.x - point0.x;
            double deltaY = point1.y - point0.y;
            double deltaZ = point1.z - point0.z;
            double deltaT = this.getMaximumDistanceInterval() / distance;
            double t = 0.0;
            while (t < 1.0) {
                double x = point0.x + t * deltaX;
                double y = point0.y + t * deltaY;
                double z = point0.z + t * deltaZ;
                CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
                points.add(point);
                t += deltaT;
            }
        } else {
            points.add(p0);
        }
        return points;
    }

    public WayPointPath doProcess(WayPointPath input, IProgressMonitor monitor) throws Exception {
        this.setInput(input);
        monitor.beginTask("Interpolating WayPointPath.", input.getPoints().size());
        WayPointPath result = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        this.setOutput(result);
        if (input.getPoints().size() > 1) {
            int i = 0;
            while (i < input.getPoints().size() - 1) {
                CartesianPositionCoordinates p0 = (CartesianPositionCoordinates)input.getPoints().get(i);
                CartesianPositionCoordinates p1 = (CartesianPositionCoordinates)input.getPoints().get(i + 1);
                result.getPoints().addAll(this.interpolateSegment(p0, p1));
                monitor.worked(1);
                ++i;
            }
            CartesianPositionCoordinates lastPoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(input.getEndPoint());
            result.getPoints().add((Object)lastPoint);
        } else if (input.getPoints().size() == 1) {
            CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(input.getStartPoint());
            result.getPoints().add((Object)point);
        }
        monitor.done();
        return result;
    }
}

