/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils;

import com.jme3.renderer.Camera;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.apogy.addons.sensors.fov.ConicalFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects.ProjectorData;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.AbstractFieldOfViewImageProjectorControl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.swt.graphics.RGB;

public class ConicalFieldOfViewImageProjectorControl
extends AbstractFieldOfViewImageProjectorControl<ConicalFieldOfView> {
    public ConicalFieldOfViewImageProjectorControl(JME3Application jme3Application, ConicalFieldOfView fieldOfView) {
        super(jme3Application, fieldOfView);
    }

    @Override
    public float getHorizontalFOVAngleDegrees() {
        return (float)Math.toDegrees(((ConicalFieldOfView)this.fieldOfView).getFieldOfViewAngle());
    }

    @Override
    public float getTextureHtoVRatio() {
        return 1.0f;
    }

    @Override
    public BufferedImage getProjectedImage() {
        int width = 256;
        int height = Math.round((float)width * this.getTextureHtoVRatio());
        AbstractEImage transparentImage = EImagesUtilities.INSTANCE.createTransparentImage(width, height);
        BufferedImage result = transparentImage.asBufferedImage();
        Graphics2D g2d = result.createGraphics();
        RGB projColor = this.getProjectionColor();
        g2d.setColor(new Color(projColor.red, projColor.green, projColor.blue));
        g2d.drawOval(0, 0, width, height);
        g2d.drawOval(1, 1, width - 1, height - 1);
        g2d.drawOval(2, 2, width - 2, height - 2);
        g2d.drawOval(3, 3, width - 3, height - 3);
        return result;
    }

    @Override
    public void updateProjectorFOVSettings() {
        ProjectorData projectorData = this.getProjectorData();
        projectorData.projector.setProjectiveTextureMap(this.createTexture());
        Camera projectorCamera = projectorData.projector.getProjectorCamera();
        projectorCamera.setLocation(this.getProjectorLocation());
        projectorCamera.setRotation(this.getProjectorRotation());
        if (this.getHorizontalFOVAngleDegrees() > 0.0f) {
            projectorCamera.setFrustumPerspective(this.getHorizontalFOVAngleDegrees(), this.getTextureHtoVRatio(), 1.0f, 5.0f);
        } else {
            projectorCamera.setFrustumPerspective(0.1f, this.getTextureHtoVRatio(), 1.0f, 5.0f);
        }
    }
}

