/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.awt.Color;
import java.text.DecimalFormat;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.AzimuthDirection;
import org.eclipse.apogy.addons.sensors.imaging.ElevationDirection;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.ImagingUtilities;
import org.eclipse.apogy.addons.sensors.imaging.camera.OverlayAlignment;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.FOVOverlayImpl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.swt.graphics.Point;

public class FOVOverlayCustomImpl
extends FOVOverlayImpl {
    protected DecimalFormat angleFormat = new DecimalFormat("0.0");

    @Override
    public String getToolTipText(AbstractCamera camera, ImageSnapshot imageSnapshot, int mouseButton, int x, int y) {
        String text = null;
        if (imageSnapshot != null) {
            double hAngle = Math.toDegrees(imageSnapshot.convertToHorizontalAngle(x));
            double vAngle = Math.toDegrees(imageSnapshot.convertToVerticalAngle(y));
            if (this.getAzimuthDirection() == AzimuthDirection.POSITIVE_TOWARD_RIGHT) {
                hAngle = -hAngle;
            }
            if (this.getElevationDirection() == ElevationDirection.POSITIVE_DOWN) {
                vAngle = -vAngle;
            }
            text = String.valueOf(this.angleFormat.format(hAngle)) + "\u00b0, " + this.angleFormat.format(vAngle) + "\u00b0";
        }
        return text;
    }

    @Override
    public AbstractEImage applyOverlay(AbstractCamera camera, AbstractEImage cameraImage, OverlayAlignment overlayAlignment, int overlayWidth, int overlayHeight) {
        RectangularFrustrumFieldOfView fov = camera.getFieldOfView();
        double horizontalFOVAngle = Math.toDegrees(fov.getHorizontalFieldOfViewAngle());
        double verticalFOVAngle = Math.toDegrees(fov.getVerticalFieldOfViewAngle());
        AbstractEImage overlayImage = ImagingUtilities.INSTANCE.getAzimuthElevationOverlay(overlayWidth, overlayHeight, 0.0, 0.0, horizontalFOVAngle, verticalFOVAngle, this.getAzimuthDirection(), this.getElevationDirection(), this.getAngleInterval(), this.getFontName(), this.getFontSize(), this.getColorOfPositive(), this.getColorOfNegative(), this.getLineWidth());
        AbstractEImage result = EImagesUtilities.INSTANCE.applyOverlay(cameraImage, overlayImage, false);
        return result;
    }

    protected Color getColorOfPositive() {
        if (this.getPositiveValuesColor() != null) {
            return new Color(this.getPositiveValuesColor().rgb.red, this.getPositiveValuesColor().rgb.green, this.getPositiveValuesColor().rgb.blue);
        }
        return Color.GREEN;
    }

    protected Color getColorOfNegative() {
        if (this.getNegativeValueColor() != null) {
            return new Color(this.getNegativeValueColor().rgb.red, this.getNegativeValueColor().rgb.green, this.getNegativeValueColor().rgb.blue);
        }
        return Color.GREEN;
    }

    protected Point getImageLocation(AbstractCamera camera, AbstractEImage cameraImage, double hAngle, double vAngle) {
        RectangularFrustrumFieldOfView fov = camera.getFieldOfView();
        int width = cameraImage.getWidth();
        int height = cameraImage.getHeight();
        int hDistanceToCenter = (int)Math.ceil(hAngle / fov.getHorizontalFieldOfViewAngle() * (double)width);
        int vDistanceToCenter = (int)Math.ceil(vAngle / fov.getVerticalFieldOfViewAngle() * (double)height);
        int hPosition = 0;
        hPosition = this.getAzimuthDirection() == AzimuthDirection.POSITIVE_TOWARD_LEFT ? (int)(Math.floor((float)width * 0.5f) - (double)hDistanceToCenter) : (int)(Math.floor((float)width * 0.5f) + (double)hDistanceToCenter);
        int vPosition = 0;
        vPosition = this.getElevationDirection() == ElevationDirection.POSITIVE_UP ? (int)(Math.floor((float)height * 0.5f) - (double)vDistanceToCenter) : (int)(Math.floor((float)height * 0.5f) + (double)vDistanceToCenter);
        Point point = new Point(hPosition, vPosition);
        return point;
    }
}

