/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehicleFactory;
import org.eclipse.apogy.addons.vehicle.ClosestNeighbourIteratorProvider;
import org.eclipse.apogy.addons.vehicle.MeshExtent2D;
import org.eclipse.apogy.addons.vehicle.MeshNodeEntry;
import org.eclipse.apogy.addons.vehicle.OrientationCorrectionMode;
import org.eclipse.apogy.addons.vehicle.WheelVehicleUtilities;
import org.eclipse.apogy.addons.vehicle.ZCorrectionMode;
import org.eclipse.apogy.addons.vehicle.impl.VehiclePoseCorrectorImpl;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.dynamics.PhysicalBody;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayerNode;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehiclePoseCorrectorCustomImpl
extends VehiclePoseCorrectorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(VehiclePoseCorrectorImpl.class);
    protected Map<PhysicalBody, Point3d> bodyToContactsMap = new HashMap<PhysicalBody, Point3d>();
    protected Map<CartesianTriangularMesh, MeshExtent2D> meshToMeshExtent2DMap = new HashMap<CartesianTriangularMesh, MeshExtent2D>();
    protected Map<CartesianTriangularMesh, ClosestNeighbourIteratorProvider> meshToClosestNeighbourIteratorProviderMap = new HashMap<CartesianTriangularMesh, ClosestNeighbourIteratorProvider>();
    protected Matrix4x4 lastCorrectedPose = null;
    protected boolean busy;

    @Override
    public EList<PhysicalBody> getContactBodies() {
        if (super.getContactBodies().isEmpty() && this.getContactProvider() != null) {
            super.getContactBodies().addAll(this.getContactProvider().extractContactBodies());
        }
        return super.getContactBodies();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Matrix4x4 applyCorrection(Matrix4x4 originalPose) {
        Matrix4x4 startPose = originalPose;
        if (startPose == null) {
            startPose = ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4();
        }
        if (this.getSystemRootNode() == null) return startPose;
        if (!this.isInitializing()) {
            if (this.busy) return this.lastCorrectedPose;
            this.busy = true;
            if (this.getZCorrectionMode() != ZCorrectionMode.NO_ZCORRECTION || this.getOrientationCorrectionMode() != OrientationCorrectionMode.NO_ORIENTATION_CORRECTION) {
                Matrix4x4 correctedPose;
                if (this.getContactProvider() != null) {
                    this.getContactProvider().updateContactPoints(startPose, this.bodyToContactsMap);
                }
                Matrix4d correctionMatrix = new Matrix4d();
                correctionMatrix.setIdentity();
                if (this.getZCorrectionMode() != ZCorrectionMode.NO_ZCORRECTION) {
                    try {
                        double zCorrection = this.computeZCorrection(this.bodyToContactsMap, startPose);
                        this.setZCorrection(zCorrection);
                        correctionMatrix.set(new Vector3d(0.0, 0.0, this.getZCorrection()));
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
                if (this.getOrientationCorrectionMode() != OrientationCorrectionMode.NO_ORIENTATION_CORRECTION) {
                    try {
                        Matrix3d rotationCorrection = new Matrix3d();
                        rotationCorrection.setIdentity();
                        rotationCorrection = this.computeOrientationCorrection(startPose);
                        this.setOrientationCorrection(ApogyCommonMathFacade.INSTANCE.createMatrix3x3(rotationCorrection));
                        Matrix4d rot = new Matrix4d();
                        rot.setIdentity();
                        rot.set(rotationCorrection);
                        correctionMatrix.mul(rot);
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
                Matrix4d corrected = new Matrix4d(startPose.asMatrix4d());
                corrected.mul(correctionMatrix);
                this.lastCorrectedPose = correctedPose = ApogyCommonMathFacade.INSTANCE.createMatrix4x4(corrected);
                this.busy = false;
                return correctedPose;
            }
            this.busy = false;
            return startPose;
        }
        this.updateMeshes();
        this.bodyToContactsMap.clear();
        this.getMeshes();
        this.setInitializing(false);
        return startPose;
    }

    @Override
    public void reInitialize() {
        this.setInitializing(true);
    }

    @Override
    public MeshExtent2D getMeshExtent2D(CartesianTriangularMesh mesh) {
        return this.meshToMeshExtent2DMap.get(mesh);
    }

    @Override
    public ClosestNeighbourIteratorProvider getClosestNeighbourIteratorProvider(CartesianTriangularMesh mesh) {
        return this.meshToClosestNeighbourIteratorProviderMap.get(mesh);
    }

    protected void updateMeshes() {
        this.getMeshes().clear();
        this.getMeshes().addAll(this.extractMeshes());
        this.meshToClosestNeighbourIteratorProviderMap.clear();
        this.meshToMeshExtent2DMap.clear();
        for (MeshNodeEntry contentNode : this.getMeshes()) {
            CartesianTriangularMesh mesh = contentNode.getMesh();
            this.meshToClosestNeighbourIteratorProviderMap.put(mesh, new ClosestNeighbourIteratorProvider(mesh));
            MeshExtent2D meshExtent = WheelVehicleUtilities.INSTANCE.findMeshExtent2D(mesh);
            this.meshToMeshExtent2DMap.put(mesh, meshExtent);
        }
    }

    @Override
    public List<MeshNodeEntry> extractMeshes() {
        ArrayList<MeshNodeEntry> extractedMeshes = new ArrayList<MeshNodeEntry>();
        ArrayList<Object> extractedNodes = new ArrayList<Object>();
        try {
            GroupNode root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
            Node systemRoot = this.getSystemRootNode();
            EList systemNodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCommonTopologyPackage.Literals.NODE, systemRoot);
            EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCommonTopologyPackage.Literals.REFERENCED_CONTENT_NODE, (Node)root);
            nodes.addAll(ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCommonTopologyPackage.Literals.CONTENT_NODE, (Node)root));
            nodes.addAll(ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_MAP_LAYER_NODE, (Node)root));
            for (Node node : nodes) {
                CartesianTriangularMeshMapLayerNode cartesianTriangularMeshMapLayerNode;
                MeshNodeEntry entry;
                if (systemNodes.contains(node)) continue;
                if (node instanceof ContentNode) {
                    ContentNode contentNode = (ContentNode)node;
                    if (!(contentNode.getContent() instanceof CartesianTriangularMesh) || extractedNodes.contains(contentNode)) continue;
                    entry = ApogyAddonsVehicleFactory.eINSTANCE.createMeshNodeEntry();
                    entry.setNode((Node)contentNode);
                    entry.setMesh((CartesianTriangularMesh)contentNode.getContent());
                    extractedMeshes.add(entry);
                    extractedNodes.add(contentNode);
                    continue;
                }
                if (!(node instanceof CartesianTriangularMeshMapLayerNode) || (cartesianTriangularMeshMapLayerNode = (CartesianTriangularMeshMapLayerNode)node).getCartesianTriangularMeshMapLayer() == null || extractedNodes.contains(cartesianTriangularMeshMapLayerNode)) continue;
                entry = ApogyAddonsVehicleFactory.eINSTANCE.createMeshNodeEntry();
                entry.setNode((Node)cartesianTriangularMeshMapLayerNode);
                entry.setMesh(cartesianTriangularMeshMapLayerNode.getCartesianTriangularMeshMapLayer().getCurrentMesh());
                extractedMeshes.add(entry);
                extractedNodes.add(cartesianTriangularMeshMapLayerNode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info("Extracted " + extractedMeshes.size() + " meshes.");
        return extractedMeshes;
    }

    protected double computeZCorrection(Map<PhysicalBody, Point3d> wheelToContactsPointsMap, Matrix4x4 originalPose) {
        double zCorrection = 0.0;
        switch (this.getZCorrectionMode().getValue()) {
            case 0: {
                zCorrection = this.computeZCorrectionAverageContact(wheelToContactsPointsMap, originalPose);
                break;
            }
            case 1: {
                zCorrection = this.computeZCorrectionHighestContact(wheelToContactsPointsMap, originalPose);
                break;
            }
            case 2: {
                zCorrection = this.computeZCorrectionLowestContact(wheelToContactsPointsMap, originalPose);
                break;
            }
        }
        return zCorrection;
    }

    protected double computeZCorrectionHighestContact(Map<PhysicalBody, Point3d> bodyToPositionMap, Matrix4x4 originalPose) {
        PhysicalBody highestBody = null;
        for (PhysicalBody body : this.getContactBodies()) {
            Point3d bodyPosition = bodyToPositionMap.get(body);
            if (bodyPosition == null) continue;
            if (highestBody == null) {
                highestBody = body;
                continue;
            }
            if (!(bodyPosition.z > bodyToPositionMap.get((Object)highestBody).z)) continue;
            highestBody = body;
        }
        if (highestBody != null) {
            Matrix4d bodyToWorldTransform = this.getPhysicalBodyToWorldTransform(highestBody, originalPose);
            Point3d originalBodyPosition = new Point3d();
            bodyToWorldTransform.transform(originalBodyPosition);
            return bodyToPositionMap.get((Object)highestBody).z - originalBodyPosition.z;
        }
        return 0.0;
    }

    protected double computeZCorrectionLowestContact(Map<PhysicalBody, Point3d> bodyToPositionMap, Matrix4x4 originalPose) {
        PhysicalBody lowestBody = null;
        for (PhysicalBody body : this.getContactBodies()) {
            Point3d bodyPosition = bodyToPositionMap.get(body);
            if (bodyPosition == null) continue;
            if (lowestBody == null) {
                lowestBody = body;
                continue;
            }
            if (!(bodyPosition.z < bodyToPositionMap.get((Object)lowestBody).z)) continue;
            lowestBody = body;
        }
        if (lowestBody != null) {
            Matrix4d bodyToWorldTransform = this.getPhysicalBodyToWorldTransform(lowestBody, originalPose);
            Point3d originalBodyPosition = new Point3d();
            bodyToWorldTransform.transform(originalBodyPosition);
            return bodyToPositionMap.get((Object)lowestBody).z - originalBodyPosition.z;
        }
        return 0.0;
    }

    protected double computeZCorrectionAverageContact(Map<PhysicalBody, Point3d> bodyToPositionMap, Matrix4x4 originalPose) {
        double zCorrectionSum = 0.0;
        double correctionCount = 0.0;
        for (PhysicalBody body : this.getContactBodies()) {
            Point3d bodyPosition = bodyToPositionMap.get(body);
            if (bodyPosition == null) continue;
            Matrix4d bodyToWorldTransform = this.getPhysicalBodyToWorldTransform(body, originalPose);
            Point3d originalBodyPosition = new Point3d();
            bodyToWorldTransform.transform(originalBodyPosition);
            double bodyCorrection = bodyPosition.z - originalBodyPosition.z;
            zCorrectionSum += bodyCorrection;
            correctionCount += 1.0;
        }
        if (correctionCount > 0.0) {
            zCorrectionSum /= correctionCount;
        }
        return zCorrectionSum;
    }

    protected Matrix3d computeOrientationCorrection(Matrix4x4 originalPose) {
        double theta;
        double dotProduct;
        Vector3d planeContact;
        Vector3d planeOriginal;
        Matrix3d correction = new Matrix3d();
        correction.setIdentity();
        ArrayList<Point3d> originalWheelPoints = new ArrayList<Point3d>();
        ArrayList<Point3d> contactWheelPoints = new ArrayList<Point3d>();
        for (PhysicalBody wheel : this.bodyToContactsMap.keySet()) {
            Point3d contactPoint = this.bodyToContactsMap.get(wheel);
            Matrix4d contactToSystem = new Matrix4d(originalPose.asMatrix4d());
            contactToSystem.invert();
            if (contactPoint == null) continue;
            Matrix4d wheelToSystem = this.getPhysicalBodyToSystemTransform(wheel);
            Point3d wheelHub = new Point3d();
            wheelToSystem.transform(wheelHub);
            originalWheelPoints.add(wheelHub);
            Point3d contactInSystem = new Point3d(contactPoint);
            contactToSystem.transform(contactInSystem);
            contactWheelPoints.add(contactInSystem);
        }
        if (contactWheelPoints.size() >= 3 && (planeOriginal = WheelVehicleUtilities.INSTANCE.findBestFitPlane(originalWheelPoints)) != null && (planeContact = WheelVehicleUtilities.INSTANCE.findBestFitPlane(contactWheelPoints)) != null && -1.0 <= (dotProduct = planeContact.dot(planeOriginal)) && dotProduct <= 1.0 && (theta = Math.acos(dotProduct)) != 0.0) {
            Vector3d cross = new Vector3d();
            cross.cross(planeContact, planeOriginal);
            cross.normalize();
            AxisAngle4d axisAngle = new AxisAngle4d(cross, theta);
            correction.set(axisAngle);
            correction.invert();
        }
        return correction;
    }

    protected Matrix4d getPhysicalBodyToSystemTransform(PhysicalBody wheel) {
        Node root = this.getSystemRootNode();
        Matrix4d transform = ApogyCommonTopologyFacade.INSTANCE.expressInFrame((Node)wheel, root);
        return transform;
    }

    protected Matrix4d getPhysicalBodyToWorldTransform(PhysicalBody body, Matrix4x4 originalPose) {
        Matrix4d bodyToSystemTransform = this.getPhysicalBodyToSystemTransform(body);
        Matrix4d bodyToWorldTransform = new Matrix4d(originalPose.asMatrix4d());
        bodyToWorldTransform.mul(bodyToSystemTransform);
        return bodyToWorldTransform;
    }
}

