/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data25d.impl;

import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.common.geometry.data.Mesh;
import org.eclipse.apogy.common.geometry.data25d.Coordinates25D;
import org.eclipse.apogy.common.geometry.data25d.impl.CoordinatesSet25DImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class CoordinatesSet25DCustomImpl
extends CoordinatesSet25DImpl {
    protected TreeSet<Coordinates25D> coordinateSet = null;
    private Adapter pointsAdapter = null;

    @Override
    public void setEnforceUniqueness(boolean newEnforceUniqueness) {
        boolean oldEnforceUniqueness = this.enforceUniqueness;
        this.enforceUniqueness = newEnforceUniqueness;
        if (this.enforceUniqueness && !this.eAdapters().contains((Object)this.getPointsAdapter())) {
            this.eAdapters().add((Object)this.getPointsAdapter());
        } else if (!this.enforceUniqueness) {
            this.eAdapters().remove((Object)this.getPointsAdapter());
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldEnforceUniqueness, this.enforceUniqueness));
        }
    }

    protected TreeSet<Coordinates25D> getCoordinateSet() {
        if (this.coordinateSet == null) {
            this.coordinateSet = new TreeSet<Coordinates25D>(new Comparator<Coordinates25D>(){

                @Override
                public int compare(Coordinates25D o1, Coordinates25D o2) {
                    if (o1.getU() == o2.getU()) {
                        if (o1.getV() > o2.getV()) {
                            return 1;
                        }
                        if (o1.getV() < o2.getV()) {
                            return -1;
                        }
                        return 0;
                    }
                    if (o1.getU() > o2.getU()) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        return this.coordinateSet;
    }

    private Adapter getPointsAdapter() {
        if (this.pointsAdapter == null) {
            this.pointsAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(Mesh.class) == 0 && (notification.getEventType() == 3 || notification.getEventType() == 5) && notification.getNewValue() != null) {
                        if (notification.getNewValue() instanceof List) {
                            List points = (List)notification.getNewValue();
                            for (Coordinates25D point : points) {
                                CoordinatesSet25DCustomImpl.this.pointAdded(point);
                            }
                        } else {
                            Coordinates25D point = (Coordinates25D)notification.getNewValue();
                            CoordinatesSet25DCustomImpl.this.pointAdded(point);
                        }
                    }
                }
            };
        }
        return this.pointsAdapter;
    }

    private void pointAdded(Coordinates25D point) {
        Coordinates25D duplicate;
        SortedSet<Coordinates25D> tailSet = this.getCoordinateSet().tailSet(point);
        if (tailSet.size() > 0 && (duplicate = tailSet.first()).getU() == point.getU() && duplicate.getV() == point.getV()) {
            this.getPoints().remove((Object)duplicate);
            this.getCoordinateSet().remove(duplicate);
        }
        this.getCoordinateSet().add(point);
    }

    @Override
    public EList<Coordinates25D> getPoints() {
        if (this.isEnforceUniqueness() && !this.eAdapters().contains((Object)this.getPointsAdapter())) {
            this.eAdapters().add((Object)this.getPointsAdapter());
        }
        return super.getPoints();
    }
}

