/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.ui.impl;

import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ui.Activator;
import org.eclipse.apogy.common.geometry.data3d.ui.impl.CartesianTriangularMeshPresentationImpl;
import org.eclipse.apogy.common.geometry.data3d.ui.scene_objects.CartesianTriangularMeshSceneObject;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.SceneObject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class CartesianTriangularMeshPresentationCustomImpl
extends CartesianTriangularMeshPresentationImpl {
    protected IPropertyChangeListener preferencesListener = null;

    protected CartesianTriangularMeshPresentationCustomImpl() {
        this.applyPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    @Override
    public int getNumberOfPoints() {
        if (this.getMesh() != null) {
            return this.getMesh().getPoints().size();
        }
        return 0;
    }

    @Override
    public int getNumberOfPolygons() {
        if (this.getMesh() != null) {
            return this.getMesh().getPolygons().size();
        }
        return 0;
    }

    @Override
    public CartesianTriangularMesh basicGetMesh() {
        ContentNode cNode;
        CartesianTriangularMesh mesh = null;
        if (this.getNode() != null && (cNode = (ContentNode)this.getNode()).getContent() instanceof CartesianTriangularMesh) {
            mesh = (CartesianTriangularMesh)cNode.getContent();
        }
        return mesh;
    }

    public boolean isSetMesh() {
        return this.getNode() != null;
    }

    public void setSceneObject(SceneObject newSceneObject) {
        if (newSceneObject != null && !(newSceneObject instanceof CartesianTriangularMeshSceneObject)) {
            throw new IllegalArgumentException();
        }
        super.setSceneObject(newSceneObject);
    }

    protected void updateSceneObject(Notification notification) {
        if (this.sceneObject != null) {
            CartesianTriangularMeshSceneObject meshSceneObject = (CartesianTriangularMeshSceneObject)this.sceneObject;
            if (notification.getNotifier() instanceof CartesianTriangularMeshPresentationCustomImpl) {
                int featureID = notification.getFeatureID(CartesianTriangularMeshPresentationCustomImpl.class);
                switch (featureID) {
                    case 17: {
                        int newPointSizeValue = notification.getNewIntValue();
                        meshSceneObject.setPointSize(newPointSizeValue);
                        break;
                    }
                    case 20: {
                        MeshPresentationMode newMode = (MeshPresentationMode)notification.getNewValue();
                        meshSceneObject.setPresentationMode(newMode);
                        break;
                    }
                    case 21: {
                        meshSceneObject.setTransparency(notification.getNewFloatValue());
                        break;
                    }
                    case 22: {
                        meshSceneObject.setUseShading(notification.getNewBooleanValue());
                        break;
                    }
                }
            }
        }
        super.updateSceneObject(notification);
    }

    protected void initialSceneObject() {
        CartesianTriangularMeshSceneObject meshSceneObject = (CartesianTriangularMeshSceneObject)this.sceneObject;
        meshSceneObject.setPointSize(this.getPointSize());
        meshSceneObject.setPresentationMode(this.getPresentationMode());
        meshSceneObject.setTransparency(this.getTransparency());
        super.initialSceneObject();
    }

    public Tuple3d basicGetCentroid() {
        Tuple3d centroid = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
        if (this.getSceneObject() != null) {
            centroid = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)this.getSceneObject().getCentroid());
        }
        return centroid;
    }

    public boolean isEnableTextureProjection() {
        return true;
    }

    protected void applyPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_TRIANGULAR_MESH_COLOR_ID");
        if (rgb != null) {
            this.setColor(ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(rgb));
        }
        this.setVisible(store.getBoolean("DEFAULT_TRIANGULAR_MESH_VISIBILITY_ID"));
        this.setUseShading(store.getBoolean("DEFAULT_TRIANGULAR_MESH_USE_SHADING_ID"));
        this.setPointSize(store.getInt("DEFAULT_TRIANGULAR_MESH_POINT_SIZE_ID"));
        this.setPresentationMode(MeshPresentationMode.get((int)store.getInt("DEFAULT_TRIANGULAR_MESH_PRESENTATION_MODE_ID")));
        super.applyPreferences();
    }

    protected IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    CartesianTriangularMeshPresentationCustomImpl.this.applyPreferences();
                }
            };
        }
        return this.preferencesListener;
    }
}

