/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsPackage;
import org.eclipse.apogy.common.topology.bindings.BindingsList;
import org.eclipse.apogy.common.topology.bindings.EnumerationCase;
import org.eclipse.apogy.common.topology.bindings.EnumerationSwitchBinding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class EnumerationSwitchBindingCasesComposite
extends Composite {
    private EnumerationSwitchBinding enumerationSwitchBinding;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Button btnNew;
    private final Button btnDelete;
    private DataBindingContext m_bindingContext;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public EnumerationSwitchBindingCasesComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CustomContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (object instanceof EnumerationCase) {
                    EnumerationCase enumerationCase = (EnumerationCase)object;
                    EnumerationSwitchBindingCasesComposite.this.enumerationCaseSelected(enumerationCase);
                }
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setToolTipText("Create a new Enumeration Case.");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                    String name = ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)EnumerationSwitchBindingCasesComposite.this.getEnumerationSwitchBinding(), null, (ETypedElement)ApogyCommonTopologyBindingsPackage.Literals.ENUMERATION_SWITCH_BINDING__CASES);
                    settings.getUserDataMap().put("name", name);
                    settings.getUserDataMap().put("enumerationSwitchBinding", EnumerationSwitchBindingCasesComposite.this.enumerationSwitchBinding);
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setToolTipText("Deletes the selected Enumeration Case(s).");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String deleteMessage = "";
                Iterator<EnumerationCase> bindingsIterator = EnumerationSwitchBindingCasesComposite.this.getSelectedBindings().iterator();
                while (bindingsIterator.hasNext()) {
                    EnumerationCase binding = bindingsIterator.next();
                    deleteMessage = String.valueOf(deleteMessage) + binding.getEnumerationLiterals();
                    if (!bindingsIterator.hasNext()) continue;
                    deleteMessage = String.valueOf(deleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Enumeration Case", null, "Are you sure to delete these  Enumeration Case : " + deleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    List<EnumerationCase> toRemove = EnumerationSwitchBindingCasesComposite.this.getSelectedBindings();
                    ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)EnumerationSwitchBindingCasesComposite.this.getEnumerationSwitchBinding(), (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ENUMERATION_SWITCH_BINDING__CASES, toRemove);
                }
                if (!EnumerationSwitchBindingCasesComposite.this.treeViewer.isBusy()) {
                    EnumerationSwitchBindingCasesComposite.this.treeViewer.setInput((Object)EnumerationSwitchBindingCasesComposite.this.getEnumerationSwitchBinding());
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EnumerationSwitchBindingCasesComposite.this.m_bindingContext != null) {
                    EnumerationSwitchBindingCasesComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public EnumerationSwitchBinding getEnumerationSwitchBinding() {
        return this.enumerationSwitchBinding;
    }

    public void setEnumerationSwitchBinding(EnumerationSwitchBinding newEnumerationSwitchBinding) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.enumerationSwitchBinding = newEnumerationSwitchBinding;
        if (newEnumerationSwitchBinding != null) {
            this.m_bindingContext = this.initDataBindingsCustom();
        }
        this.treeViewer.setInput((Object)newEnumerationSwitchBinding);
    }

    public List<EnumerationCase> getSelectedBindings() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void enumerationCaseSelected(EnumerationCase selectedEnumerationCase) {
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private class CustomContentProvider
    implements ITreeContentProvider {
        private CustomContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EnumerationSwitchBinding) {
                EnumerationSwitchBinding bindingsList = (EnumerationSwitchBinding)inputElement;
                return bindingsList.getCases().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EnumerationSwitchBinding) {
                EnumerationSwitchBinding bindingsList = (EnumerationSwitchBinding)parentElement;
                return bindingsList.getCases().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BindingsList) {
                EnumerationSwitchBinding bindingsList = (EnumerationSwitchBinding)element;
                return !bindingsList.getCases().isEmpty();
            }
            return false;
        }
    }
}

