/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.viewer;

import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ui.viewer.ApogyCommonTopologyUIViewerFactory;
import org.eclipse.apogy.common.topology.ui.viewer.TopologyViewerRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Activator
extends AbstractUIPlugin
implements BundleActivator,
IPropertyChangeListener {
    private static final Logger Logger = LoggerFactory.getLogger(Activator.class);
    public static final String ID = "org.eclipse.apogy.common.topology.ui.viewer";
    private static BundleContext context;
    private static TopologyViewerRegistry topologyViewerRegistry;
    private boolean antialiasing = true;
    private int maximumFrameRate = 15;
    private RGB ambientLightColor = new RGB(255, 255, 255);
    private Tuple3d ambientLightDirection = null;
    private double navigationLinearLowSpeedFactor = 1.0;
    private double navigationLinearHighSpeedFactor = 10.0;
    private static Activator plugin;

    static {
        topologyViewerRegistry = null;
    }

    public Activator() {
        plugin = this;
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        this.antialiasing = this.getPreferenceStore().getBoolean("VIEWER_ANTI_ALIASING_ID");
        this.maximumFrameRate = this.getPreferenceStore().getInt("VIEWER_MAX_FRAME_RATE_ID");
        this.navigationLinearLowSpeedFactor = this.getPreferenceStore().getDouble("DEFAULT_LINEAR_LOW_SPEED_FACTOR_ID");
        this.navigationLinearHighSpeedFactor = this.getPreferenceStore().getDouble("DEFAULT_LINEAR_HIGH_SPEED_FACTOR_ID");
        this.ambientLightColor = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"AMBIENT_LIGHT_COLOR_ID");
        this.ambientLightDirection = this.fromString(this.getPreferenceStore().getString("AMBIENT_LIGHT_DIRECTION_ID"));
    }

    public void stop(BundleContext context) throws Exception {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        context = null;
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public static TopologyViewerRegistry getTopologyViewerRegistry() {
        if (topologyViewerRegistry == null) {
            topologyViewerRegistry = ApogyCommonTopologyUIViewerFactory.eINSTANCE.createTopologyViewerRegistry();
        }
        return topologyViewerRegistry;
    }

    public double getNavigationLinearLowSpeedFactor() {
        return this.navigationLinearLowSpeedFactor;
    }

    public double getNavigationLinearHighSpeedFactor() {
        return this.navigationLinearHighSpeedFactor;
    }

    public int getMaximumFrameRate() {
        return this.maximumFrameRate;
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public RGB getAmbientLightColor() {
        return this.ambientLightColor;
    }

    public Tuple3d getAmbientLightDirection() {
        if (this.ambientLightDirection == null) {
            this.ambientLightDirection = this.fromString(this.getPreferenceStore().getString("AMBIENT_LIGHT_DIRECTION_ID"));
        }
        return this.ambientLightDirection;
    }

    public void propertyChange(PropertyChangeEvent event) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String propertyID = event.getProperty();
        try {
            Tuple3d dir;
            if (propertyID.equals("VIEWER_ANTI_ALIASING_ID")) {
                this.antialiasing = store.getBoolean("VIEWER_ANTI_ALIASING_ID");
                Logger.info("Antialiasing changed to  <" + this.antialiasing + ">.");
            } else if (propertyID.equals("VIEWER_MAX_FRAME_RATE_ID")) {
                this.maximumFrameRate = store.getInt("VIEWER_MAX_FRAME_RATE_ID");
                Logger.info("Maximum Frame Rate set to <" + this.maximumFrameRate + "> fps.");
            } else if (propertyID.equals("DEFAULT_LINEAR_HIGH_SPEED_FACTOR_ID")) {
                this.navigationLinearHighSpeedFactor = store.getDouble("DEFAULT_LINEAR_HIGH_SPEED_FACTOR_ID");
                Logger.info("Updated Linear High Speed to   <" + this.navigationLinearHighSpeedFactor + ">.");
            } else if (propertyID.equals("DEFAULT_LINEAR_LOW_SPEED_FACTOR_ID")) {
                this.navigationLinearLowSpeedFactor = store.getDouble("DEFAULT_LINEAR_LOW_SPEED_FACTOR_ID");
                Logger.info("Updated Linear Low Speed to   <" + this.navigationLinearLowSpeedFactor + ">.");
            } else if (propertyID.equals("AMBIENT_LIGHT_COLOR_ID")) {
                this.ambientLightColor = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"AMBIENT_LIGHT_COLOR_ID");
                Logger.info("Updated Ambient Light Color to   <" + this.ambientLightColor + ">.");
            } else if (propertyID.equals("AMBIENT_LIGHT_DIRECTION_ID") && (dir = this.fromString(store.getString("AMBIENT_LIGHT_DIRECTION_ID"))) != null) {
                this.ambientLightDirection = dir;
                Logger.info("Updated Ambient Light Direction to   <" + this.ambientLightColor + ">.");
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private Tuple3d fromString(String string) {
        String[] items;
        Tuple3d direction = null;
        if (string != null && (items = string.split(",")).length >= 3) {
            double x = Double.parseDouble(items[0].trim());
            double y = Double.parseDouble(items[1].trim());
            double z = Double.parseDouble(items[2].trim());
            direction = ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z);
        }
        return direction;
    }
}

