/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.birt.composites;

import com.ibm.icu.util.Calendar;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.apogy.common.ui.birt.composites.AbstractBIRTChartComposite;
import org.eclipse.apogy.common.ui.birt.composites.ApogyBIRTUtilities;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.SeriesValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class ValueVsTimeBIRTChartComposite
extends AbstractBIRTChartComposite {
    public static int DEFAULT_HISTORY_TIME_LENGTH_MS = 60000;
    public static String DEFAULT_TIME_AXIS_FORMAT_STRING = "HH:mm:ss.SSS";
    public static String DEFAULT_Y_AXIS_FORMAT_STRING = "0.0";
    protected int historySize = DEFAULT_HISTORY_SIZE;
    protected int historyTimeLength = DEFAULT_HISTORY_TIME_LENGTH_MS;
    protected String timeFormatString = DEFAULT_TIME_AXIS_FORMAT_STRING;
    protected String yAxisFormatString = DEFAULT_Y_AXIS_FORMAT_STRING;
    protected SortedMap<CDateTime, Double> currentSeriesData = new TreeMap<CDateTime, Double>();
    protected SortedMap<CDateTime, Double> bufferedSeriesData = new TreeMap<CDateTime, Double>();
    protected DateTimeDataSet xValuesDataSet;
    protected NumberDataSet yValuesDataSet;
    private boolean dataUpdated = false;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public ValueVsTimeBIRTChartComposite(Composite parent, int style) {
        super(parent, style);
    }

    public String getTimeFormatString() {
        return this.timeFormatString;
    }

    public void setTimeFormatString(String timeFormatString) {
        this.timeFormatString = timeFormatString;
        if (this.xAxis != null) {
            JavaDateFormatSpecifier xAxisFormatSpecifier = JavaDateFormatSpecifierImpl.create((String)timeFormatString);
            this.xAxis.setFormatSpecifier((FormatSpecifier)xAxisFormatSpecifier);
            this.updateChart();
        }
    }

    public String getYAxisFormatString() {
        return this.yAxisFormatString;
    }

    public void setYAxisFormatString(String yAxisFormatString) {
        this.yAxisFormatString = yAxisFormatString;
        if (this.yAxis != null) {
            JavaNumberFormatSpecifier yAxisFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)yAxisFormatString);
            this.yAxis.setFormatSpecifier((FormatSpecifier)yAxisFormatSpecifier);
            this.updateChart();
        }
    }

    @Override
    public void setSeriesColor(RGB seriesColor) {
        super.setSeriesColor(seriesColor);
        if (seriesColor != null) {
            if (this.ySeriesDefinition != null) {
                this.ySeriesDefinition.getSeriesPalette().update((Fill)ApogyBIRTUtilities.convertToColorDefinition(seriesColor));
            }
        } else {
            throw new InvalidParameterException("seriesColor cannot be null!");
        }
    }

    @Override
    public int getHistorySize() {
        return this.historySize;
    }

    @Override
    public void setHistorySize(int historySize) {
        if (historySize <= 0) {
            throw new InvalidParameterException("historySize must be greater than 0 !");
        }
        this.historySize = historySize;
    }

    public int getHistoryTimeLength() {
        return this.historyTimeLength;
    }

    public void setHistoryTimeLength(int historyTimeLength) {
        if (historyTimeLength != 0) {
            this.historyTimeLength = historyTimeLength;
        }
    }

    public void addValue(Date date, double value) {
        this.lock.writeLock().lock();
        try {
            this.dataUpdated = true;
            this.bufferedSeriesData.put(new CDateTime(date), value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    protected void updateValuesAndChart() {
        if (this.dataUpdated) {
            this.lock.readLock().lock();
            try {
                this.currentSeriesData.putAll(this.bufferedSeriesData);
                this.bufferedSeriesData.clear();
                if (this.getHistorySize() > 0) {
                    while (this.currentSeriesData.size() > this.getHistorySize()) {
                        this.currentSeriesData.remove(this.currentSeriesData.firstKey());
                    }
                }
                if (this.getHistoryTimeLength() > 0) {
                    CDateTime latest = this.currentSeriesData.lastKey();
                    CDateTime start = latest.backward(14, this.getHistoryTimeLength());
                    TreeMap<CDateTime, Double> toKeep = new TreeMap<CDateTime, Double>();
                    toKeep.putAll(this.currentSeriesData.tailMap(start));
                    this.currentSeriesData.clear();
                    this.currentSeriesData.putAll(toKeep);
                }
                if (this.currentSeriesData.isEmpty()) {
                    this.currentSeriesData.put(new CDateTime(new Date()), new Double(0.0));
                }
                this.xValuesDataSet = DateTimeDataSetImpl.create(this.currentSeriesData.keySet());
                this.yValuesDataSet = NumberDataSetImpl.create(this.currentSeriesData.values());
                this.xSeries.setDataSet((DataSet)this.xValuesDataSet);
                this.ySeries.setDataSet((DataSet)this.yValuesDataSet);
                this.updateChart();
                this.dataUpdated = false;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    public void updateValues(List<Date> dates, List<Double> yValues) {
        if (dates.size() == yValues.size()) {
            this.lock.writeLock().lock();
            try {
                this.dataUpdated = true;
                this.currentSeriesData.clear();
                int i = 0;
                while (i < dates.size()) {
                    this.currentSeriesData.put(new CDateTime(dates.get(i)), yValues.get(i));
                    ++i;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            System.err.println("Invalid size");
        }
    }

    @Override
    protected Chart createChart() {
        ChartWithAxes chart = ChartWithAxesImpl.create();
        chart.getBlock().setBackground((Fill)ColorDefinitionImpl.BLACK());
        chart.getTitle().getLabel().getCaption().setValue("");
        chart.getTitle().getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        Plot plot = chart.getPlot();
        plot.setBackground((Fill)ColorDefinitionImpl.BLACK());
        plot.getClientArea().setBackground((Fill)ColorDefinitionImpl.BLACK());
        chart.setUnitSpacing(20.0);
        Legend lg = chart.getLegend();
        LineAttributes lia = lg.getOutline();
        lg.getText().getFont().setSize(16.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        lg.getInsets().set(10.0, 5.0, 0.0, 0.0);
        lg.getOutline().setVisible(false);
        lg.setAnchor(Anchor.NORTH_LITERAL);
        lg.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEDOWN_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.TOGGLE_VISIBILITY_LITERAL, (ActionValue)SeriesValueImpl.create((String)"not-used"))));
        this.xAxis = chart.getPrimaryBaseAxes()[0];
        this.xAxis.setType(AxisType.DATE_TIME_LITERAL);
        this.xAxis.setAligned(true);
        this.xAxis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxis.setCategoryAxis(false);
        this.xAxis.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_X_AXIS_COLOR));
        TextAlignment timeAxisAlignment = TextAlignmentImpl.createDefault();
        FontDefinition timeAxisFont = FontDefinitionImpl.create((String)"", (float)10.0f, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (double)90.0, (TextAlignment)timeAxisAlignment);
        this.xAxis.getLabel().getCaption().setFont(timeAxisFont);
        this.xAxis.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_X_AXIS_COLOR));
        this.xAxis.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_X_AXIS_COLOR));
        this.xAxis.getMajorGrid().getTickAttributes().setVisible(true);
        this.xAxis.getMinorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_X_AXIS_COLOR));
        this.xAxis.getMinorGrid().getTickAttributes().setVisible(false);
        JavaDateFormatSpecifier xAxisFormatSpecifier = JavaDateFormatSpecifierImpl.create((String)DEFAULT_TIME_AXIS_FORMAT_STRING);
        this.xAxis.setFormatSpecifier((FormatSpecifier)xAxisFormatSpecifier);
        this.yAxis = chart.getPrimaryOrthogonalAxis(this.xAxis);
        this.yAxis.setType(AxisType.LINEAR_LITERAL);
        this.yAxis.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.yAxis.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_Y_AXIS_COLOR));
        TextAlignment valueAxisAlignment = TextAlignmentImpl.createDefault();
        FontDefinition valuesAxisFont = FontDefinitionImpl.create((String)"", (float)10.0f, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (double)0.0, (TextAlignment)valueAxisAlignment);
        this.yAxis.getLabel().getCaption().setFont(valuesAxisFont);
        this.yAxis.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_Y_AXIS_COLOR));
        this.yAxis.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_Y_AXIS_COLOR));
        this.yAxis.getMajorGrid().getTickAttributes().setVisible(true);
        this.yAxis.getMinorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_Y_AXIS_COLOR));
        this.yAxis.getMinorGrid().getTickAttributes().setVisible(false);
        JavaNumberFormatSpecifier yAxisFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)DEFAULT_Y_AXIS_FORMAT_STRING);
        this.yAxis.setFormatSpecifier((FormatSpecifier)yAxisFormatSpecifier);
        this.xAxis.getMajorGrid().getLineAttributes().setStyle(LineStyle.DASH_DOTTED_LITERAL);
        this.xAxis.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_PLOT_GRID_COLOR));
        this.xAxis.getMajorGrid().getLineAttributes().setVisible(true);
        this.xAxis.getMinorGrid().getLineAttributes().setVisible(false);
        this.yAxis.getMajorGrid().getLineAttributes().setStyle(LineStyle.DASH_DOTTED_LITERAL);
        this.yAxis.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_PLOT_GRID_COLOR));
        this.yAxis.getMajorGrid().getLineAttributes().setVisible(true);
        this.yAxis.getMinorGrid().getLineAttributes().setVisible(false);
        ArrayList<Double> ys = new ArrayList<Double>();
        ys.add(0.0);
        this.xValuesDataSet = DateTimeDataSetImpl.create((Object)Calendar.getInstance());
        this.yValuesDataSet = NumberDataSetImpl.create(ys);
        this.xSeries = SeriesImpl.create();
        this.xSeries.setDataSet((DataSet)this.xValuesDataSet);
        this.ySeries = (LineSeries)LineSeriesImpl.create();
        this.ySeries.setStacked(true);
        this.ySeries.getLabel().setVisible(false);
        this.ySeries.setDataSet((DataSet)this.yValuesDataSet);
        this.ySeries.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_PLOT_GRID_COLOR));
        int i = 0;
        while (i < this.ySeries.getMarkers().size()) {
            ((Marker)this.ySeries.getMarkers().get(i)).setType(MarkerType.CIRCLE_LITERAL);
            ((Marker)this.ySeries.getMarkers().get(i)).setSize(1);
            ((Marker)this.ySeries.getMarkers().get(i)).setVisible(false);
            ++i;
        }
        this.xSeriesDefinition = SeriesDefinitionImpl.create();
        this.xSeriesDefinition.getSeriesPalette().shift(0);
        this.xAxis.getSeriesDefinitions().add((Object)this.xSeriesDefinition);
        this.ySeriesDefinition = SeriesDefinitionImpl.create();
        this.ySeriesDefinition.getSeriesPalette().update((Fill)ApogyBIRTUtilities.convertToColorDefinition(DEFAULT_SERIES_COLOR));
        this.yAxis.getSeriesDefinitions().add((Object)this.ySeriesDefinition);
        this.xSeriesDefinition.getSeries().add((Object)this.xSeries);
        this.ySeriesDefinition.getSeries().add((Object)this.ySeries);
        chart.getLegend().setVisible(false);
        this.setTimeFormatString(DEFAULT_TIME_AXIS_FORMAT_STRING);
        this.setYAxisFormatString(DEFAULT_Y_AXIS_FORMAT_STRING);
        ArrayList<CDateTime> cDateTimes = new ArrayList<CDateTime>();
        cDateTimes.add(new CDateTime(new Date()));
        ArrayList<Double> v = new ArrayList<Double>();
        v.add(new Double(0.0));
        this.xValuesDataSet = DateTimeDataSetImpl.create(cDateTimes);
        this.yValuesDataSet = NumberDataSetImpl.create(v);
        this.xSeries.setDataSet((DataSet)this.xValuesDataSet);
        this.ySeries.setDataSet((DataSet)this.yValuesDataSet);
        return chart;
    }

    @Override
    protected DataSet getXSeriesDataSet() {
        return null;
    }

    @Override
    protected DataSet getYSeriesDataSet() {
        return null;
    }
}

