/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.jme3;

import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.font.Rectangle;
import com.jme3.material.Material;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.TextureCubeMap;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.util.BufferUtils;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.EclipseUtils;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.URLEImage;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.core.environment.earth.surface.ui.jme3.EarthSurfaceEnvironmentJMEConstants;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentUIJME3Utilities {
    private static final Logger Logger = LoggerFactory.getLogger(EnvironmentUIJME3Utilities.class);
    private static DecimalFormat decimalFormat = new DecimalFormat("0.0");
    private static Map<Double, String> labelMap;

    public static Mesh createGrid(float gridSize, float planeSize) {
        Vector3f p2;
        Vector3f p1;
        Vector3f p22;
        Vector3f p12;
        float planeHalfSize = planeSize / 2.0f;
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        float x = 0.0f;
        while (x <= planeHalfSize) {
            p12 = new Vector3f(x, -planeHalfSize, 0.0f);
            p22 = new Vector3f(x, planeHalfSize, 0.0f);
            verticesList.add(p12);
            verticesList.add(p22);
            indexesList.add(verticesList.indexOf(p12));
            indexesList.add(verticesList.indexOf(p22));
            x += gridSize;
        }
        x = 0.0f;
        while (x >= -planeHalfSize) {
            p12 = new Vector3f(x, -planeHalfSize, 0.0f);
            p22 = new Vector3f(x, planeHalfSize, 0.0f);
            verticesList.add(p12);
            verticesList.add(p22);
            indexesList.add(verticesList.indexOf(p12));
            indexesList.add(verticesList.indexOf(p22));
            x -= gridSize;
        }
        float y = 0.0f;
        while (y <= planeHalfSize) {
            p1 = new Vector3f(-planeHalfSize, y, 0.0f);
            p2 = new Vector3f(planeHalfSize, y, 0.0f);
            verticesList.add(p1);
            verticesList.add(p2);
            indexesList.add(verticesList.indexOf(p1));
            indexesList.add(verticesList.indexOf(p2));
            y += gridSize;
        }
        y = 0.0f;
        while (y >= -planeHalfSize) {
            p1 = new Vector3f(-planeHalfSize, y, 0.0f);
            p2 = new Vector3f(planeHalfSize, y, 0.0f);
            verticesList.add(p1);
            verticesList.add(p2);
            indexesList.add(verticesList.indexOf(p1));
            indexesList.add(verticesList.indexOf(p2));
            y -= gridSize;
        }
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    public static Mesh createPlane(float planeSize) {
        float planeHalfSize = planeSize / 2.0f;
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        Vector3f p0 = new Vector3f(-planeHalfSize, -planeHalfSize, 0.0f);
        Vector3f p1 = new Vector3f(planeHalfSize, -planeHalfSize, 0.0f);
        Vector3f p2 = new Vector3f(planeHalfSize, planeHalfSize, 0.0f);
        Vector3f p3 = new Vector3f(-planeHalfSize, planeHalfSize, 0.0f);
        verticesList.add(p0);
        verticesList.add(p1);
        verticesList.add(p2);
        verticesList.add(p3);
        indexesList.add(new Integer(0));
        indexesList.add(new Integer(1));
        indexesList.add(new Integer(2));
        indexesList.add(new Integer(0));
        indexesList.add(new Integer(2));
        indexesList.add(new Integer(3));
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    public static Node createAzimuthDisplay(AssetManager assetManager) {
        Vector3f p1;
        Vector3f p0;
        float z1;
        float z0;
        float y;
        float x;
        Node node = new Node("Worksite Azimuth Display.");
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        float angle = 0.0f;
        while (angle < 360.0f) {
            x = (float)(15000.0 * Math.cos(Math.toRadians(angle)));
            y = (float)(15000.0 * Math.sin(Math.toRadians(angle)));
            z0 = 0.0f;
            z1 = EarthSurfaceEnvironmentJMEConstants.AZIMUTH_MAJOR_TICKS_HEIGHT;
            p0 = new Vector3f(x, y, z0);
            p1 = new Vector3f(x, y, z1);
            verticesList.add(p0);
            verticesList.add(p1);
            indexesList.add(verticesList.indexOf(p0));
            indexesList.add(verticesList.indexOf(p1));
            node.attachChild((Spatial)EnvironmentUIJME3Utilities.createLabel(assetManager, EnvironmentUIJME3Utilities.getAzimuthLabelText(360.0f - angle), x, y, z1 * 1.1f, Math.toRadians(angle), 0.0, EarthSurfaceEnvironmentJMEConstants.MAJOR_TICKS_FONT_SIZE));
            angle += 90.0f;
        }
        angle = 45.0f;
        while (angle < 360.0f) {
            if (Math.IEEEremainder(angle, 90.0) != 0.0) {
                x = (float)(15000.0 * Math.cos(Math.toRadians(angle)));
                y = (float)(15000.0 * Math.sin(Math.toRadians(angle)));
                z0 = 0.0f;
                z1 = EarthSurfaceEnvironmentJMEConstants.AZIMUTH_MIDDLE_TICKS_HEIGHT;
                p0 = new Vector3f(x, y, z0);
                p1 = new Vector3f(x, y, z1);
                verticesList.add(p0);
                verticesList.add(p1);
                indexesList.add(verticesList.indexOf(p0));
                indexesList.add(verticesList.indexOf(p1));
                node.attachChild((Spatial)EnvironmentUIJME3Utilities.createLabel(assetManager, EnvironmentUIJME3Utilities.getAzimuthLabelText(360.0f - angle), x, y, z1 * 3.0f, Math.toRadians(angle), 0.0, EarthSurfaceEnvironmentJMEConstants.MIDDLE_TICKS_FONT_SIZE));
            }
            angle += 90.0f;
        }
        angle = 0.0f;
        while (angle < 360.0f) {
            if (Math.IEEEremainder(angle, 90.0) != 0.0 && Math.IEEEremainder(angle, 45.0) != 0.0) {
                x = (float)(15000.0 * Math.cos(Math.toRadians(angle)));
                y = (float)(15000.0 * Math.sin(Math.toRadians(angle)));
                z0 = 0.0f;
                z1 = EarthSurfaceEnvironmentJMEConstants.AZIMUTH_MINOR_TICKS_HEIGHT;
                p0 = new Vector3f(x, y, z0);
                p1 = new Vector3f(x, y, z1);
                verticesList.add(p0);
                verticesList.add(p1);
                indexesList.add(verticesList.indexOf(p0));
                indexesList.add(verticesList.indexOf(p1));
                node.attachChild((Spatial)EnvironmentUIJME3Utilities.createLabel(assetManager, EnvironmentUIJME3Utilities.getAzimuthLabelText(360.0f - angle), x, y, z1 * 3.0f, Math.toRadians(angle), 0.0, EarthSurfaceEnvironmentJMEConstants.MINOR_TICKS_FONT_SIZE));
            }
            angle += 5.0f;
        }
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        Geometry azimuthGeometry = new Geometry("Azimuth lines", mesh);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", EarthSurfaceEnvironmentJMEConstants.DEFAULT_AZIMUTH_LINES_COLOR.clone());
        azimuthGeometry.setMaterial(mat);
        azimuthGeometry.setShadowMode(RenderQueue.ShadowMode.Off);
        node.attachChild((Spatial)azimuthGeometry);
        return node;
    }

    public static Node createElevationCirclesDisplay(AssetManager assetManager) {
        Node node = new Node("Elevation Circles Display.");
        Node zenithCross = EnvironmentUIJME3Utilities.createZenithCross(assetManager, 1.0f);
        node.attachChild((Spatial)zenithCross);
        double elevationAngleInDeg = 5.0;
        while (elevationAngleInDeg < 90.0) {
            Node elevationCircle = EnvironmentUIJME3Utilities.createElevationCircle(assetManager, elevationAngleInDeg, 5.0, 45.0, 0.5f, 1);
            elevationAngleInDeg += 5.0;
            node.attachChild((Spatial)elevationCircle);
        }
        return node;
    }

    public static Node createElevationCircle(AssetManager assetManager, double elevationAngleInDeg, double azimuthAngleIncrementInDeg, double labelAzimuthIntervalInDeg, float lineWidth, int linePattern) {
        float z;
        Node node = new Node("Elevation Circle");
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        double azimuthAngleInDeg = 0.0;
        while (azimuthAngleInDeg < 360.0) {
            float d = (float)(15000.0 * Math.cos(Math.toRadians(elevationAngleInDeg)));
            float x0 = (float)((double)d * Math.cos(Math.toRadians(azimuthAngleInDeg)));
            float x1 = (float)((double)d * Math.cos(Math.toRadians(azimuthAngleInDeg + 5.0)));
            float y0 = (float)((double)d * Math.sin(Math.toRadians(azimuthAngleInDeg)));
            float y1 = (float)((double)d * Math.sin(Math.toRadians(azimuthAngleInDeg + 5.0)));
            z = (float)(15000.0 * Math.sin(Math.toRadians(elevationAngleInDeg)));
            Vector3f p0 = new Vector3f(x0, y0, z);
            Vector3f p1 = new Vector3f(x1, y1, z);
            verticesList.add(p0);
            verticesList.add(p1);
            indexesList.add(verticesList.indexOf(p0));
            indexesList.add(verticesList.indexOf(p1));
            azimuthAngleInDeg += azimuthAngleIncrementInDeg;
        }
        float labelAzimuthAngleInDeg = 5.0f;
        String labelText = EnvironmentUIJME3Utilities.getElevationLabelText(elevationAngleInDeg);
        while (labelAzimuthAngleInDeg < 360.0f) {
            float d = (float)(15000.0 * Math.cos(Math.toRadians(elevationAngleInDeg)));
            float x = (float)((double)d * Math.cos(Math.toRadians(labelAzimuthAngleInDeg)));
            float y = (float)((double)d * Math.sin(Math.toRadians(labelAzimuthAngleInDeg)));
            z = (float)(15000.0 * Math.sin(Math.toRadians(elevationAngleInDeg)));
            node.attachChild((Spatial)EnvironmentUIJME3Utilities.createLabel(assetManager, labelText, x, y, z, Math.toRadians(labelAzimuthAngleInDeg), Math.toRadians(elevationAngleInDeg), EarthSurfaceEnvironmentJMEConstants.MINOR_TICKS_FONT_SIZE));
            labelAzimuthAngleInDeg = (float)((double)labelAzimuthAngleInDeg + labelAzimuthIntervalInDeg);
        }
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        Geometry azimuthGeometry = new Geometry("Elevation Circle", mesh);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", EarthSurfaceEnvironmentJMEConstants.DEFAULT_AZIMUTH_LINES_COLOR.clone());
        azimuthGeometry.setMaterial(mat);
        node.attachChild((Spatial)azimuthGeometry);
        return node;
    }

    public static Node createAzimuthCirclesDisplay(AssetManager assetManager) {
        Node node = new Node("Azimuth Display Circles");
        Node zenithCross = EnvironmentUIJME3Utilities.createZenithCross(assetManager, 1.0f);
        node.attachChild((Spatial)zenithCross);
        double azimuthAngleInDeg = 10.0;
        while (azimuthAngleInDeg <= 360.0) {
            Node azimuthCircle = EnvironmentUIJME3Utilities.createAzimuthCircle(assetManager, azimuthAngleInDeg, 5.0, 1.5, 85.0, 45.0, 0.5f, 1);
            azimuthAngleInDeg += 10.0;
            node.attachChild((Spatial)azimuthCircle);
        }
        return node;
    }

    public static Node createAzimuthCircle(AssetManager assetManager, double azimuthAngleInDeg, double elevationAngleIncrementInDeg, double minimumElevationAngleInDeg, double maximumElevationAngleInDeg, double labelElevationIntervalInDeg, float lineWidth, int linePattern) {
        Node node = new Node("Azimuth Circle");
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        double elevationAngleInDeg = minimumElevationAngleInDeg;
        while (elevationAngleInDeg < maximumElevationAngleInDeg) {
            double elevationAngleInDegHigh = elevationAngleInDeg + elevationAngleIncrementInDeg;
            if (elevationAngleInDegHigh > maximumElevationAngleInDeg) {
                elevationAngleInDegHigh = maximumElevationAngleInDeg;
            }
            float d0 = (float)(15000.0 * Math.cos(Math.toRadians(elevationAngleInDeg)));
            float d1 = (float)(15000.0 * Math.cos(Math.toRadians(elevationAngleInDegHigh)));
            float x0 = (float)((double)d0 * Math.cos(Math.toRadians(azimuthAngleInDeg)));
            float x1 = (float)((double)d1 * Math.cos(Math.toRadians(azimuthAngleInDeg)));
            float y0 = (float)((double)d0 * Math.sin(Math.toRadians(azimuthAngleInDeg)));
            float y1 = (float)((double)d1 * Math.sin(Math.toRadians(azimuthAngleInDeg)));
            float z0 = (float)(15000.0 * Math.sin(Math.toRadians(elevationAngleInDeg)));
            float z1 = (float)(15000.0 * Math.sin(Math.toRadians(elevationAngleInDegHigh)));
            Vector3f p0 = new Vector3f(x0, y0, z0);
            Vector3f p1 = new Vector3f(x1, y1, z1);
            verticesList.add(p0);
            verticesList.add(p1);
            indexesList.add(verticesList.indexOf(p0));
            indexesList.add(verticesList.indexOf(p1));
            elevationAngleInDeg += elevationAngleIncrementInDeg;
        }
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        Geometry azimuthGeometry = new Geometry("Azimuth lines", mesh);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", EarthSurfaceEnvironmentJMEConstants.DEFAULT_AZIMUTH_LINES_COLOR.clone());
        azimuthGeometry.setMaterial(mat);
        azimuthGeometry.setShadowMode(RenderQueue.ShadowMode.Off);
        node.attachChild((Spatial)azimuthGeometry);
        return node;
    }

    public static Spatial createSky(AssetManager assetManager, String texturesLocation) throws Exception {
        Logger.info("Creating Sky Box using images found in location <" + texturesLocation + ">.");
        String urlString = "platform:plugin/" + ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(EnvironmentUIJME3Utilities.class) + "/assets";
        URL url = FileLocator.toFileURL((URL)new URL(urlString));
        assetManager.registerLocator(url.getPath(), com.jme3.asset.plugins.FileLocator.class);
        String assetLocation = texturesLocation;
        if (!assetLocation.endsWith("/")) {
            assetLocation = String.valueOf(assetLocation) + "/";
        }
        Texture west = assetManager.loadTexture(String.valueOf(assetLocation) + "west.png");
        Texture east = assetManager.loadTexture(String.valueOf(assetLocation) + "east.png");
        Texture north = assetManager.loadTexture(String.valueOf(assetLocation) + "north.png");
        Texture south = assetManager.loadTexture(String.valueOf(assetLocation) + "south.png");
        Texture up = assetManager.loadTexture(String.valueOf(assetLocation) + "up.png");
        Texture down = assetManager.loadTexture(String.valueOf(assetLocation) + "down.png");
        return EnvironmentUIJME3Utilities.createSky(assetManager, west, east, north, south, up, down);
    }

    public static Spatial createSky(AssetManager assetManager, Texture west, Texture east, Texture north, Texture south, Texture up, Texture down) throws Exception {
        Image westImg = west.getImage();
        Image eastImg = east.getImage();
        Image northImg = north.getImage();
        Image southImg = south.getImage();
        Image upImg = up.getImage();
        Image downImg = down.getImage();
        Image cubeImage = new Image(westImg.getFormat(), westImg.getWidth(), westImg.getHeight(), null);
        cubeImage.addData(westImg.getData(0));
        cubeImage.addData(eastImg.getData(0));
        cubeImage.addData(downImg.getData(0));
        cubeImage.addData(upImg.getData(0));
        cubeImage.addData(southImg.getData(0));
        cubeImage.addData(northImg.getData(0));
        TextureCubeMap cubeMap = new TextureCubeMap(cubeImage);
        try {
            String urlString = "platform:plugin/" + ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(EnvironmentUIJME3Utilities.class) + "/assets";
            URL url = FileLocator.toFileURL((URL)new URL(urlString));
            assetManager.registerLocator(url.getPath(), com.jme3.asset.plugins.FileLocator.class);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        Sphere sphereMesh = new Sphere(10, 10, 10.0f, false, true);
        Geometry sky = new Geometry("Sky", (Mesh)sphereMesh);
        sky.setQueueBucket(RenderQueue.Bucket.Sky);
        sky.setCullHint(Spatial.CullHint.Never);
        sky.setModelBound((BoundingVolume)new BoundingSphere(Float.POSITIVE_INFINITY, Vector3f.ZERO));
        Material skyMat = new Material(assetManager, "MatDefs/EarthSky.j3md");
        skyMat.setVector3("NormalScale", Vector3f.UNIT_XYZ);
        skyMat.setVector3("SunPosition", new Vector3f());
        skyMat.setFloat("Alpha", 1.0f);
        skyMat.setTransparent(true);
        String urlString = "platform:plugin/" + ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(EnvironmentUIJME3Utilities.class) + "/assets/Textures/sunglow.png";
        URL url = EclipseUtils.resolveURL((Bundle)ApogyCommonOSGiUtilities.INSTANCE.getBundle(EnvironmentUIJME3Utilities.class), (String)urlString);
        skyMat.setTexture("SunGlowTexture", (Texture)EnvironmentUIJME3Utilities.createTexture2D(url, 1.0f));
        cubeMap.setMagFilter(Texture.MagFilter.Bilinear);
        cubeMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
        cubeMap.setAnisotropicFilter(0);
        cubeMap.setWrap(Texture.WrapMode.EdgeClamp);
        skyMat.setTexture("Texture", (Texture)cubeMap);
        skyMat.setTransparent(true);
        sky.setMaterial(skyMat);
        Matrix3f skyRot = new Matrix3f();
        skyRot.fromAngleAxis((float)Math.toRadians(-90.0), new Vector3f(1.0f, 0.0f, 0.0f));
        sky.setLocalRotation(skyRot);
        return sky;
    }

    public static Texture2D createTexture2D(URL url, float alpha) throws Exception {
        Texture2D texture2D = null;
        URLEImage tmp = ApogyCommonImagesFactory.eINSTANCE.createURLEImage();
        tmp.setUrl(url.toString());
        BufferedImage image = tmp.asBufferedImage();
        AWTLoader awtLoader = new AWTLoader();
        if ((double)alpha != 1.0) {
            EImage originalImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            originalImage.setImageContent(image);
            AbstractEImage alphaImage = EImagesUtilities.INSTANCE.applyAlpha((AbstractEImage)originalImage, alpha);
            texture2D = new Texture2D(awtLoader.load(alphaImage.asBufferedImage(), false));
        } else {
            texture2D = new Texture2D(awtLoader.load(image, false));
        }
        return texture2D;
    }

    public static TextureCubeMap createTextureCubeMap(URL url, float alpha) throws Exception {
        TextureCubeMap texture2D = null;
        URLEImage tmp = ApogyCommonImagesFactory.eINSTANCE.createURLEImage();
        tmp.setUrl(url.toString());
        BufferedImage image = tmp.asBufferedImage();
        AWTLoader awtLoader = new AWTLoader();
        if ((double)alpha != 1.0) {
            EImage originalImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            originalImage.setImageContent(image);
            AbstractEImage alphaImage = EImagesUtilities.INSTANCE.applyAlpha((AbstractEImage)originalImage, alpha);
            texture2D = new TextureCubeMap(awtLoader.load(alphaImage.asBufferedImage(), false));
        } else {
            texture2D = new TextureCubeMap(awtLoader.load(image, false));
        }
        return texture2D;
    }

    private static Node createZenithCross(AssetManager assetManager, float crossAngularSpanInDeg) {
        Node node = new Node("Zenith Cross.");
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        float elevation = (float)Math.toRadians(90.0f - crossAngularSpanInDeg / 2.0f);
        float delta = (float)(15000.0 * Math.cos(elevation));
        float z = (float)(15000.0 * Math.sin(elevation));
        Vector3f p0 = new Vector3f(delta, 0.0f, z);
        Vector3f p1 = new Vector3f(-delta, 0.0f, z);
        verticesList.add(p0);
        verticesList.add(p1);
        indexesList.add(verticesList.indexOf(p0));
        indexesList.add(verticesList.indexOf(p1));
        Vector3f p2 = new Vector3f(0.0f, delta, z);
        Vector3f p3 = new Vector3f(0.0f, -delta, z);
        verticesList.add(p2);
        verticesList.add(p3);
        indexesList.add(verticesList.indexOf(p2));
        indexesList.add(verticesList.indexOf(p3));
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        Geometry zenithCrossGeometry = new Geometry("Zenith Cross", mesh);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", EarthSurfaceEnvironmentJMEConstants.DEFAULT_AZIMUTH_LINES_COLOR.clone());
        zenithCrossGeometry.setMaterial(mat);
        zenithCrossGeometry.setShadowMode(RenderQueue.ShadowMode.Off);
        node.attachChild((Spatial)zenithCrossGeometry);
        return node;
    }

    private static String getAzimuthLabelText(double angle) {
        String label = EnvironmentUIJME3Utilities.getLabelMap().get(new Double(angle));
        if (label == null) {
            label = new String(String.valueOf(decimalFormat.format(angle)) + "\u00b0");
        }
        return label;
    }

    private static String getElevationLabelText(double angle) {
        return new String(String.valueOf(decimalFormat.format(angle)) + "\u00b0");
    }

    private static Map<Double, String> getLabelMap() {
        if (labelMap == null) {
            labelMap = new HashMap<Double, String>();
            labelMap.put(new Double(0.0), "N");
            labelMap.put(new Double(360.0), "N");
            labelMap.put(new Double(45.0), "NE");
            labelMap.put(new Double(90.0), "E");
            labelMap.put(new Double(135.0), "SE");
            labelMap.put(new Double(180.0), "S");
            labelMap.put(new Double(225.0), "SW");
            labelMap.put(new Double(270.0), "W");
            labelMap.put(new Double(315.0), "NW");
        }
        return labelMap;
    }

    private static Node createLabel(AssetManager assetManager, String text, double x, double y, double z, double azimuthAngle, double elevationAngle, int fontSize) {
        Node root = new Node();
        float textWidth = (float)(text.length() * fontSize) * 0.45f;
        BitmapFont bitmapFont = assetManager.loadFont("Interface/Fonts/Default.fnt");
        BitmapText bitmapText = bitmapFont.createLabel(text);
        bitmapText.setSize((float)fontSize);
        bitmapText.setText(text);
        bitmapText.setColor(EarthSurfaceEnvironmentJMEConstants.DEFAULT_AZIMUTH_LINES_COLOR.clone());
        bitmapText.setBox(new Rectangle(-textWidth / 2.0f, 0.0f, textWidth, 100.0f));
        bitmapText.setQueueBucket(RenderQueue.Bucket.Transparent);
        Transform3D translation = new Transform3D();
        translation.setTranslation(new Vector3d(x, y, z));
        Transform3D t1 = new Transform3D();
        t1.rotX(Math.toRadians(90.0));
        Transform3D t2 = new Transform3D();
        t2.rotY(azimuthAngle - Math.toRadians(90.0));
        Transform3D t3 = new Transform3D();
        t3.rotX(elevationAngle);
        Transform3D t = new Transform3D();
        t.mul(translation, t1);
        t.mul(t2);
        t.mul(t3);
        Matrix4d transformMatrix = new Matrix4d();
        t.get(transformMatrix);
        root.setLocalTransform(JME3Utilities.createTransform((Matrix4d)transformMatrix));
        root.attachChild((Spatial)bitmapText);
        return root;
    }
}

