/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.shadow.DirectionalLightShadowFilter;
import com.jme3.shadow.DirectionalLightShadowRenderer;
import com.jme3.shadow.EdgeFilteringMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.apogy.core.environment.StarField;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.apogy.core.environment.earth.surface.EarthSkyNode;
import org.eclipse.apogy.core.environment.earth.surface.ui.EarthSurfaceUIUtilities;
import org.eclipse.apogy.core.environment.earth.surface.ui.jme3.Activator;
import org.eclipse.apogy.core.environment.earth.surface.ui.jme3.EnvironmentUIJME3Utilities;
import org.eclipse.apogy.core.environment.earth.surface.ui.scene_objects.EarthSkySceneObject;
import org.eclipse.apogy.core.environment.ui.StarFieldPresentation;
import org.eclipse.apogy.core.environment.ui.scene_objects.StarFieldSceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthSkyNodeJME3Object
extends DefaultJME3SceneObject<EarthSkyNode>
implements IPropertyChangeListener,
EarthSkySceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(EarthSkyNodeJME3Object.class);
    private Adapter sunAdapter;
    private Adapter moonAdapter;
    private EarthSky earthSky;
    private AssetManager assetManager = this.jme3Application.getAssetManager();
    private static ColorRGBA SUN_SPHERE_COLOR = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    private static ColorRGBA MOON_SPHERE_COLOR = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.2f);
    private boolean horizonVisible = true;
    private com.jme3.scene.Node sunTransform = null;
    private Geometry sunSphere;
    private DirectionalLight sunLight;
    private boolean sunVisible = false;
    private boolean sunShadowsEnabled = true;
    private boolean sunCastingShadows = false;
    private com.jme3.scene.Node moonTransform = null;
    private Geometry moonSphere;
    private DirectionalLight moonLight;
    private boolean moonVisible = false;
    private boolean moonShadowsEnabled = true;
    private boolean moonCastingShadows = false;
    private boolean enableBloom = true;
    private FilterPostProcessor bloomFilterPostProcessor;
    private BloomFilter bloomFilter;
    private int shadowMapSize = 2048;
    private FilterPostProcessor shadowsFilterPostProcessor;
    private DirectionalLightShadowRenderer directionalLightShadowRenderer;
    private DirectionalLightShadowFilter directionalLightShadowFilter;
    private Spatial sky = null;
    private float alpha = 1.0f;

    public EarthSkyNodeJME3Object(EarthSkyNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager.registerLocator("/", FileLocator.class);
        this.earthSky = (EarthSky)node.getSky();
        Job job = new Job("EarthSkyNodeJME3Object initialize."){

            protected IStatus run(IProgressMonitor monitor) {
                EarthSkyNodeJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        EarthSkyNodeJME3Object.this.attachSun();
                        EarthSkyNodeJME3Object.this.attachMoon();
                        EarthSkyNodeJME3Object.this.requestUpdate();
                        EarthSkyNodeJME3Object.this.enableBloom(Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_BLOOM_ENABLED_ID"));
                        EarthSkyNodeJME3Object.this.setShadowMapSize(Activator.getDefault().getPreferenceStore().getInt("DEFAULT_SHADOW_MAP_SIZE_ID"));
                        EarthSkyNodeJME3Object.this.setSunShadowsEnabled(Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_SUN_CAST_SHADOWS_ENABLED_ID"));
                        EarthSkyNodeJME3Object.this.setMoonShadowsEnabled(Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_MOON_CAST_SHADOWS_ENABLED_ID"));
                        EarthSkyNodeJME3Object.this.updateSunMoonVisibilityAndShadows();
                        EarthSkyNodeJME3Object.this.earthSky.getSun().getParent().eAdapters().add((Object)EarthSkyNodeJME3Object.this.getSunAdapter());
                        EarthSkyNodeJME3Object.this.earthSky.getMoon().getParent().eAdapters().add((Object)EarthSkyNodeJME3Object.this.getMoonAdapter());
                        EarthSkyNodeJME3Object.this.sky = EnvironmentUIJME3Utilities.createSky(EarthSkyNodeJME3Object.this.assetManager, "Textures/ClearSky/");
                        EarthSkyNodeJME3Object.this.jme3Application.getSceneRoot().attachChild(EarthSkyNodeJME3Object.this.sky);
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void updateGeometry(float tpf) {
        this.updateSunMoonVisibilityAndShadows();
        this.updateSun();
        this.updateMoon();
    }

    public void dispose() {
        this.setLightSourceCreatingShadow(null);
        if (this.jme3Application.getViewPort().getProcessors().contains(this.getBloomFilterPostProcessor())) {
            this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getBloomFilterPostProcessor());
        }
        if (this.sunLight != null) {
            this.jme3Application.getRootNode().removeLight((Light)this.sunLight);
        }
        if (this.moonLight != null) {
            this.jme3Application.getRootNode().removeLight((Light)this.moonLight);
        }
        super.dispose();
    }

    public void propertyChange(final PropertyChangeEvent event) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (event.getProperty().compareTo("DEFAULT_BLOOM_ENABLED_ID") == 0) {
                    boolean value = Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_BLOOM_ENABLED_ID");
                    EarthSkyNodeJME3Object.this.enableBloom(value);
                    EarthSkyNodeJME3Object.this.updateSun();
                } else if (event.getProperty().compareTo("DEFAULT_SHADOW_MAP_SIZE_ID") == 0) {
                    EarthSkyNodeJME3Object.this.setShadowMapSize(Activator.getDefault().getPreferenceStore().getInt("DEFAULT_SHADOW_MAP_SIZE_ID"));
                } else if (event.getProperty().compareTo("DEFAULT_SUN_CAST_SHADOWS_ENABLED_ID") == 0) {
                    boolean value = Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_SUN_CAST_SHADOWS_ENABLED_ID");
                    EarthSkyNodeJME3Object.this.setSunShadowsEnabled(value);
                } else if (event.getProperty().compareTo("DEFAULT_MOON_CAST_SHADOWS_ENABLED_ID") == 0) {
                    boolean value = Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_MOON_CAST_SHADOWS_ENABLED_ID");
                    EarthSkyNodeJME3Object.this.setMoonShadowsEnabled(value);
                }
                return null;
            }
        });
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (this.sunSphere != null) {
            geometries.add(this.sunSphere);
        }
        if (this.moonSphere != null) {
            geometries.add(this.moonSphere);
        }
        geometries.addAll(super.getGeometries());
        return geometries;
    }

    public void setHorizonVisible(final boolean newHorizonVisible) {
        this.horizonVisible = true;
        Logger.info("Setting Horizon visibility to <" + newHorizonVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthSkyNodeJME3Object.this.getAttachmentNode() == null) {
                    Logger.error("Failed to set Horizon visibility to <" + newHorizonVisible + ">.");
                }
                return null;
            }
        });
    }

    public void setSunShadowsEnabled(boolean newSunShadowsEnabled) {
        this.sunShadowsEnabled = newSunShadowsEnabled;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                EarthSkyNodeJME3Object.this.updateSun();
                EarthSkyNodeJME3Object.this.updateMoon();
                return null;
            }
        });
    }

    public boolean areSunShadowsEnabled() {
        return this.sunShadowsEnabled;
    }

    public void setMoonShadowsEnabled(boolean newMoonShadowsEnabled) {
        this.moonShadowsEnabled = newMoonShadowsEnabled;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                EarthSkyNodeJME3Object.this.updateSun();
                EarthSkyNodeJME3Object.this.updateMoon();
                return null;
            }
        });
    }

    public boolean areMoonShadowsEnabled() {
        return this.moonShadowsEnabled;
    }

    private boolean isSunCastingShadows() {
        return this.sunCastingShadows;
    }

    private boolean isSunVisible() {
        return this.sunVisible;
    }

    private boolean isMoonVisible() {
        return this.moonVisible;
    }

    private boolean isMoonCastingShadows() {
        return this.moonCastingShadows;
    }

    private void updateSunMoonVisibilityAndShadows() {
        TransformNode sunTranformNode = (TransformNode)this.earthSky.getSun().getParent();
        Matrix4d mSun = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)sunTranformNode);
        Vector3d vSun = new Vector3d();
        mSun.get(vSun);
        vSun.normalize();
        double rSun = vSun.length();
        double sunAltitude = Math.asin(vSun.z / rSun);
        this.sunVisible = sunAltitude > 0.0;
        this.sunCastingShadows = this.areSunShadowsEnabled() && this.sunVisible;
        TransformNode moonTranformNode = (TransformNode)this.earthSky.getMoon().getParent();
        Matrix4d mMoon = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)moonTranformNode);
        Vector3d vMoon = new Vector3d();
        mMoon.get(vMoon);
        vMoon.normalize();
        double rMoon = vMoon.length();
        double moonAltitude = Math.asin(vMoon.z / rMoon);
        this.moonVisible = moonAltitude > 0.0;
        boolean bl = this.moonCastingShadows = this.areMoonShadowsEnabled() && this.moonVisible && !this.sunVisible;
        if (this.isSunCastingShadows()) {
            this.setLightSourceCreatingShadow(this.getSunLight());
        } else if (this.isMoonCastingShadows()) {
            this.setLightSourceCreatingShadow(this.getMoonLight());
        } else {
            this.setLightSourceCreatingShadow(null);
        }
    }

    private void setLightSourceCreatingShadow(DirectionalLight light) {
        if (this.jme3Application != null) {
            if (light != null) {
                if (!this.jme3Application.getViewPort().getProcessors().contains(this.getDirectionalLightShadowRenderer())) {
                    this.jme3Application.getViewPort().addProcessor((SceneProcessor)this.getDirectionalLightShadowRenderer());
                }
                if (!this.jme3Application.getViewPort().getProcessors().contains(this.getSunFilterPostProcessor())) {
                    this.jme3Application.getViewPort().addProcessor((SceneProcessor)this.getSunFilterPostProcessor());
                }
                this.getDirectionalLightShadowRenderer().setLight(light);
                this.getDirectionalLightShadowFilter().setLight(light);
            } else {
                if (this.jme3Application.getViewPort().getProcessors().contains(this.getDirectionalLightShadowRenderer())) {
                    this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getDirectionalLightShadowRenderer());
                }
                if (this.jme3Application.getViewPort().getProcessors().contains(this.getSunFilterPostProcessor())) {
                    this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getSunFilterPostProcessor());
                }
            }
        }
    }

    private void enableBloom(boolean newEnableBloom) {
        this.enableBloom = newEnableBloom;
        if (this.jme3Application != null) {
            if (newEnableBloom) {
                if (!this.jme3Application.getViewPort().getProcessors().contains(this.getBloomFilterPostProcessor())) {
                    this.jme3Application.getViewPort().addProcessor((SceneProcessor)this.getBloomFilterPostProcessor());
                }
                Logger.info("Enabled Bloom.");
            } else {
                if (this.jme3Application.getViewPort().getProcessors().contains(this.getBloomFilterPostProcessor())) {
                    this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getBloomFilterPostProcessor());
                }
                Logger.info("Disabled Bloom.");
            }
        }
    }

    private FilterPostProcessor getBloomFilterPostProcessor() {
        if (this.bloomFilterPostProcessor == null) {
            this.bloomFilterPostProcessor = new FilterPostProcessor(this.assetManager);
            this.bloomFilterPostProcessor.addFilter((Filter)this.getBloomFilter());
        }
        return this.bloomFilterPostProcessor;
    }

    private BloomFilter getBloomFilter() {
        if (this.bloomFilter == null) {
            this.bloomFilter = new BloomFilter(BloomFilter.GlowMode.Objects);
            this.bloomFilter.setDownSamplingFactor(2.0f);
            this.bloomFilter.setBlurScale(1.5f);
            this.bloomFilter.setExposurePower(3.3f);
            this.bloomFilter.setExposureCutOff(0.2f);
            this.bloomFilter.setBloomIntensity(20.0f);
        }
        return this.bloomFilter;
    }

    private void setShadowMapSize(int newShadowMapSize) {
        this.shadowMapSize = newShadowMapSize;
        if (this.jme3Application != null) {
            if (this.jme3Application.getViewPort().getProcessors().contains(this.getDirectionalLightShadowRenderer())) {
                this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getDirectionalLightShadowRenderer());
            }
            if (this.jme3Application.getViewPort().getProcessors().contains(this.getSunFilterPostProcessor())) {
                this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getSunFilterPostProcessor());
            }
            this.shadowsFilterPostProcessor = null;
            this.directionalLightShadowRenderer = null;
            this.directionalLightShadowFilter = null;
            this.updateSunMoonVisibilityAndShadows();
        }
        Logger.info("Shadow Map Size set to <" + newShadowMapSize + ">.");
    }

    private DirectionalLightShadowRenderer getDirectionalLightShadowRenderer() {
        if (this.directionalLightShadowRenderer == null) {
            this.directionalLightShadowRenderer = new DirectionalLightShadowRenderer(this.assetManager, this.shadowMapSize, 3);
            this.directionalLightShadowRenderer.setLight(this.getSunLight());
            this.directionalLightShadowRenderer.setLambda(0.55f);
            this.directionalLightShadowRenderer.setShadowIntensity(0.6f);
            this.directionalLightShadowRenderer.setEdgeFilteringMode(EdgeFilteringMode.Nearest);
            this.directionalLightShadowRenderer.setEnabledStabilization(true);
        }
        return this.directionalLightShadowRenderer;
    }

    private FilterPostProcessor getSunFilterPostProcessor() {
        if (this.shadowsFilterPostProcessor == null) {
            this.shadowsFilterPostProcessor = new FilterPostProcessor(this.assetManager);
            this.shadowsFilterPostProcessor.addFilter((Filter)this.getDirectionalLightShadowFilter());
        }
        return this.shadowsFilterPostProcessor;
    }

    private DirectionalLightShadowFilter getDirectionalLightShadowFilter() {
        if (this.directionalLightShadowFilter == null) {
            this.directionalLightShadowFilter = new DirectionalLightShadowFilter(this.assetManager, this.shadowMapSize, 3);
            this.directionalLightShadowFilter.setLight(this.getSunLight());
            this.directionalLightShadowFilter.setLambda(0.55f);
            this.directionalLightShadowFilter.setShadowIntensity(0.6f);
            this.directionalLightShadowFilter.setEdgeFilteringMode(EdgeFilteringMode.Nearest);
            this.directionalLightShadowFilter.setEnabled(false);
        }
        return this.directionalLightShadowFilter;
    }

    private void attachSun() {
        this.getAttachmentNode().attachChild((Spatial)this.getSunTransform());
        this.getSunTransform().attachChild((Spatial)this.getSunSphere());
        if (this.jme3Application != null) {
            this.jme3Application.getRootNode().addLight((Light)this.getSunLight());
        }
    }

    private void updateSun() {
        this.updateSunMoonVisibilityAndShadows();
        TransformNode sunTranformNode = (TransformNode)this.earthSky.getSun().getParent();
        Vector3d v = new Vector3d(sunTranformNode.getPosition().asTuple3d());
        v.normalize();
        this.updateSunLight();
        v.scale(18000.0);
        this.getSunTransform().setLocalTranslation((float)v.x, (float)v.y, (float)v.z);
        this.alpha = (float)(1.0 - EarthSurfaceUIUtilities.INSTANCE.getSkyTransparency(this.earthSky.getSunHorizontalCoordinates().getAltitude()));
        Material mat = ((Geometry)this.sky).getMaterial();
        mat.setFloat("Alpha", this.alpha);
        mat.setVector3("SunPosition", this.getSunTransform().getWorldTranslation());
        StarFieldSceneObject starFieldSceneObject = this.resolveStarFieldSceneObject();
        if (starFieldSceneObject != null) {
            starFieldSceneObject.setTransparency(this.alpha);
        }
    }

    private StarFieldSceneObject resolveStarFieldSceneObject() {
        NodePresentation nodePresentation;
        StarField node;
        if (this.earthSky != null && (node = this.earthSky.getStarField()) != null && (nodePresentation = org.eclipse.apogy.common.topology.ui.Activator.getTopologyPresentationRegistry().getPresentationNode((Node)node)) instanceof StarFieldPresentation && nodePresentation.getSceneObject() instanceof StarFieldSceneObject) {
            return (StarFieldSceneObject)nodePresentation.getSceneObject();
        }
        return null;
    }

    private com.jme3.scene.Node getSunTransform() {
        if (this.sunTransform == null) {
            this.sunTransform = new com.jme3.scene.Node("Sun Transform");
        }
        return this.sunTransform;
    }

    private Geometry getSunSphere() {
        if (this.sunSphere == null) {
            float sunRadius = 0.01f;
            Sphere sphere = new Sphere(10, 36, sunRadius);
            Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.setColor("GlowColor", SUN_SPHERE_COLOR.clone());
            mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
            this.sunSphere = new Geometry("Sun", (Mesh)sphere);
            this.sunSphere.setMaterial(mat);
            this.sunSphere.setShadowMode(RenderQueue.ShadowMode.Off);
        }
        return this.sunSphere;
    }

    private DirectionalLight getSunLight() {
        if (this.sunLight == null) {
            TransformNode sunTransformNode = (TransformNode)this.earthSky.getSun().getParent();
            float x = (float)sunTransformNode.getPosition().getX();
            float y = (float)sunTransformNode.getPosition().getY();
            float z = (float)sunTransformNode.getPosition().getZ();
            Vector3f direction = new Vector3f(x, y, z);
            this.sunLight = new DirectionalLight();
            this.sunLight.setName("Sun");
            this.sunLight.setDirection(direction.normalize());
            this.sunLight.setColor(this.getSunColor(direction));
        }
        return this.sunLight;
    }

    private void updateSunLight() {
        TransformNode sunTranformNode = (TransformNode)this.earthSky.getSun().getParent();
        Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)sunTranformNode);
        Vector3d v = new Vector3d();
        m.get(v);
        v.normalize();
        Vector3f direction = new Vector3f((float)v.x, (float)v.y, (float)v.z);
        ColorRGBA color = this.getSunColor(direction);
        this.getSunLight().setColor(color);
        direction.negateLocal();
        this.getSunLight().setDirection(direction.normalize());
        Material mat = this.getSunSphere().getMaterial().clone();
        mat.setColor("GlowColor", color.clone());
        this.getSunSphere().setMaterial(mat);
    }

    private ColorRGBA getSunColor(Vector3f sunPosition) {
        double r = sunPosition.length();
        double sunAltitude = Math.asin((double)sunPosition.z / r);
        ColorRGBA sunColor = null;
        sunColor = this.isSunVisible() ? JME3Utilities.convertToColorRGBA((RGBA)EarthSurfaceUIUtilities.INSTANCE.getSunLightColor(sunAltitude)) : ColorRGBA.BlackNoAlpha;
        return sunColor;
    }

    private void attachMoon() {
        this.getAttachmentNode().attachChild((Spatial)this.getMoonTransform());
        this.getMoonTransform().attachChild((Spatial)this.getMoonSphere());
        if (this.jme3Application instanceof JME3Application) {
            JME3Application viewer = this.jme3Application;
            viewer.getRootNode().addLight((Light)this.getMoonLight());
        }
    }

    private void updateMoon() {
        this.updateSunMoonVisibilityAndShadows();
        TransformNode moonTranformNode = (TransformNode)this.earthSky.getMoon().getParent();
        Vector3d v = new Vector3d(moonTranformNode.getPosition().asTuple3d());
        v.normalize();
        v.scale(18000.0);
        this.getMoonTransform().setLocalTranslation((float)v.x, (float)v.y, (float)v.z);
        this.updateMoonLight();
    }

    private void updateMoonLight() {
        TransformNode moonTranformNode = (TransformNode)this.earthSky.getMoon().getParent();
        Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)moonTranformNode);
        Vector3d v = new Vector3d();
        m.get(v);
        v.normalize();
        Vector3f direction = new Vector3f((float)v.x, (float)v.y, (float)v.z);
        ColorRGBA color = this.getMoonColor(direction);
        this.getMoonLight().setColor(color);
        Material mat = this.getSunSphere().getMaterial().clone();
        mat.setColor("GlowColor", color.clone());
        this.getMoonSphere().setMaterial(mat);
        direction.negateLocal();
        this.getMoonLight().setDirection(direction.normalize());
    }

    private DirectionalLight getMoonLight() {
        if (this.moonLight == null) {
            TransformNode sunTransformNode = (TransformNode)this.earthSky.getMoon().getParent();
            float x = (float)sunTransformNode.getPosition().getX();
            float y = (float)sunTransformNode.getPosition().getY();
            float z = (float)sunTransformNode.getPosition().getZ();
            Vector3f direction = new Vector3f(x, y, z);
            this.moonLight = new DirectionalLight();
            this.moonLight.setName("Moon");
            this.moonLight.setDirection(direction.normalize());
            this.moonLight.setColor(this.getMoonColor(direction));
        }
        return this.moonLight;
    }

    private ColorRGBA getMoonColor(Vector3f moonPosition) {
        ColorRGBA moonColor = null;
        if (this.sunVisible) {
            moonColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            double rMoon = moonPosition.length();
            double moonAltitude = Math.asin((double)moonPosition.z / rMoon);
            moonColor = this.isMoonVisible() ? JME3Utilities.convertToColorRGBA((RGBA)EarthSurfaceUIUtilities.INSTANCE.getSunLightColor(moonAltitude)) : ColorRGBA.BlackNoAlpha;
        }
        return moonColor;
    }

    private com.jme3.scene.Node getMoonTransform() {
        if (this.moonTransform == null) {
            this.moonTransform = new com.jme3.scene.Node("Moon Transform");
        }
        return this.moonTransform;
    }

    private Geometry getMoonSphere() {
        if (this.moonSphere == null) {
            float moonRadius = (float)(18000.0 * Math.tan(this.earthSky.getMoonAngularDiameter() / 2.0));
            Sphere sphere = new Sphere(10, 36, moonRadius);
            Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.setColor("GlowColor", MOON_SPHERE_COLOR.clone());
            mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
            this.moonSphere = new Geometry("Moon", (Mesh)sphere);
            this.moonSphere.setMaterial(mat);
            this.moonSphere.setShadowMode(RenderQueue.ShadowMode.Off);
        }
        return this.moonSphere;
    }

    private Adapter getSunAdapter() {
        if (this.sunAdapter == null) {
            this.sunAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    EarthSkyNodeJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            EarthSkyNodeJME3Object.this.updateSun();
                            return null;
                        }
                    });
                }
            };
        }
        return this.sunAdapter;
    }

    private Adapter getMoonAdapter() {
        if (this.moonAdapter == null) {
            this.moonAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    EarthSkyNodeJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            EarthSkyNodeJME3Object.this.updateMoon();
                            return null;
                        }
                    });
                }
            };
        }
        return this.moonAdapter;
    }

    static /* synthetic */ boolean access$13(EarthSkyNodeJME3Object earthSkyNodeJME3Object) {
        return earthSkyNodeJME3Object.horizonVisible;
    }
}

