/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Dome;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.JME3PrimitivesUtilities;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.apogy.core.environment.earth.surface.ui.SunVector3DTool;
import org.eclipse.apogy.core.environment.earth.surface.ui.SunVector3DToolNode;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SunVector3DToolNodeJME3Object
extends DefaultJME3SceneObject<SunVector3DToolNode> {
    private static final Logger Logger = LoggerFactory.getLogger(SunVector3DToolNodeJME3Object.class);
    public static final ColorRGBA TO_COLOR = ColorRGBA.Blue;
    public static final ColorRGBA SUN_INTENSITY_LEVEL_COLOR = ColorRGBA.Green;
    public static final float OUTER_CYLINDER_ALPHA = 0.1f;
    public static final float CYLINDER_RADIUS = 0.01f;
    public static final float SUN_INTENSITY_CYLINDER_RADIUS = 0.005f;
    public static final float TIP_BASE_RADIUS = 0.02f;
    public static final float TIP_LENGTH = 0.1f;
    private Adapter adapter;
    private AssetManager assetManager;
    private com.jme3.scene.Node toTransformNode;
    private com.jme3.scene.Node sunVectorTipNode = null;
    private Geometry sunVectorTipGeometry = null;
    private com.jme3.scene.Node sunVectorBodyNode = null;
    private Geometry sunVectorBodyGeometry = null;
    private com.jme3.scene.Node sunIntensityLevelNode = null;
    private Geometry sunIntensityLevelGeometry = null;
    private Geometry toSphere = null;
    private ColorRGBA sunVectorColor = ColorRGBA.Red;
    private ColorRGBA sunLevelColor = SUN_INTENSITY_LEVEL_COLOR;

    public SunVector3DToolNodeJME3Object(SunVector3DToolNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.sunVectorColor = JME3Utilities.convertToColorRGBA((RGBA)((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool().getVectorColor());
        this.sunLevelColor = JME3Utilities.convertToColorRGBA((RGBA)((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool().getSunIntensityLevelColor());
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SunVector3DToolNodeJME3Object.this.createGeometry();
                ((SunVector3DToolNode)SunVector3DToolNodeJME3Object.this.getTopologyNode()).getSunVector3DTool().eAdapters().add((Object)SunVector3DToolNodeJME3Object.this.getAdapter());
                return null;
            }
        });
    }

    public void updateGeometry(float tpf) {
        this.updateFromTo();
        this.updateSunVectorTip();
        this.updateSunVectorBody();
        this.updateSunIntensityLevelBody();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.sunVectorTipGeometry);
        geometries.add(this.sunVectorBodyGeometry);
        geometries.add(this.sunIntensityLevelGeometry);
        return geometries;
    }

    public void setVisible(final boolean visible) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (!visible && SunVector3DToolNodeJME3Object.this.isVisible()) {
                    if (SunVector3DToolNodeJME3Object.this.toTransformNode != null) {
                        SunVector3DToolNodeJME3Object.this.jme3Application.getRootNode().detachChild((Spatial)SunVector3DToolNodeJME3Object.this.toTransformNode);
                    }
                    SunVector3DToolNodeJME3Object.this.getRoot().detachChild((Spatial)SunVector3DToolNodeJME3Object.this.getAttachmentNode());
                } else if (visible && !SunVector3DToolNodeJME3Object.this.isVisible()) {
                    if (SunVector3DToolNodeJME3Object.this.toTransformNode != null) {
                        SunVector3DToolNodeJME3Object.this.jme3Application.getRootNode().attachChild((Spatial)SunVector3DToolNodeJME3Object.this.toTransformNode);
                    }
                    SunVector3DToolNodeJME3Object.this.getRoot().attachChild((Spatial)SunVector3DToolNodeJME3Object.this.getAttachmentNode());
                }
                return null;
            }
        });
    }

    public void setColor(RGBA rgb) {
        if (rgb != null) {
            Logger.info("Setting color to <" + rgb + ">.");
            this.sunVectorColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (SunVector3DToolNodeJME3Object.this.sunVectorTipGeometry != null) {
                        SunVector3DToolNodeJME3Object.this.sunVectorTipGeometry.getMaterial().setColor("Color", SunVector3DToolNodeJME3Object.this.sunVectorColor.clone());
                    }
                    if (SunVector3DToolNodeJME3Object.this.sunVectorBodyGeometry != null) {
                        ColorRGBA color = SunVector3DToolNodeJME3Object.this.sunVectorColor.clone();
                        color.a = 0.5f;
                        SunVector3DToolNodeJME3Object.this.sunVectorBodyGeometry.getMaterial().setColor("Color", color);
                    }
                    return null;
                }
            });
        }
    }

    public void setLevelColor(RGBA rgb) {
        if (rgb != null) {
            Logger.info("Setting level color to <" + rgb + ">.");
            this.sunLevelColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (SunVector3DToolNodeJME3Object.this.sunIntensityLevelGeometry != null) {
                        SunVector3DToolNodeJME3Object.this.sunIntensityLevelGeometry.getMaterial().setColor("Color", SunVector3DToolNodeJME3Object.this.sunLevelColor.clone());
                    }
                    return null;
                }
            });
        }
    }

    public void dispose() {
        if (this.getTopologyNode() != null && ((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool() != null) {
            ((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool().eAdapters().remove((Object)this.getAdapter());
        }
        this.jme3Application.getRootNode().detachChild((Spatial)this.toTransformNode);
        this.getAttachmentNode().detachAllChildren();
        super.dispose();
    }

    public void setEndPointRadius(final float newRadius) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (SunVector3DToolNodeJME3Object.this.toSphere != null) {
                    SunVector3DToolNodeJME3Object.this.toTransformNode.detachChild((Spatial)SunVector3DToolNodeJME3Object.this.toSphere);
                }
                if (newRadius >= 0.0f) {
                    SunVector3DToolNodeJME3Object.this.toSphere = JME3PrimitivesUtilities.createSphere((float)newRadius, (AssetManager)SunVector3DToolNodeJME3Object.this.assetManager);
                    SunVector3DToolNodeJME3Object.this.toSphere.setMaterial(SunVector3DToolNodeJME3Object.this.createToSphereMaterial());
                    SunVector3DToolNodeJME3Object.this.toTransformNode.attachChild((Spatial)SunVector3DToolNodeJME3Object.this.toSphere);
                }
                return null;
            }
        });
    }

    private void createGeometry() {
        this.sunVectorColor = JME3Utilities.convertToColorRGBA((RGBA)((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool().getVectorColor());
        this.toTransformNode = new com.jme3.scene.Node("Sun Vector To");
        this.jme3Application.getRootNode().attachChild((Spatial)this.toTransformNode);
        this.sunVectorTipNode = this.createSunVectorTipNode();
        this.sunVectorTipGeometry = this.createSunVectorTipGeometry();
        this.sunVectorTipNode.attachChild((Spatial)this.sunVectorTipGeometry);
        this.toTransformNode.attachChild((Spatial)this.sunVectorTipNode);
        this.sunVectorBodyNode = this.createSunVectorBodyNode();
        this.sunVectorBodyGeometry = this.createSunVectorBodyGeometry();
        this.sunVectorBodyNode.attachChild((Spatial)this.sunVectorBodyGeometry);
        this.sunVectorTipNode.attachChild((Spatial)this.sunVectorBodyNode);
        this.sunIntensityLevelNode = this.createSunIntensityLevelBodyNode();
        this.sunIntensityLevelGeometry = this.createSunIntensityLevelGeometry();
        this.sunIntensityLevelNode.attachChild((Spatial)this.sunIntensityLevelGeometry);
        this.sunVectorTipNode.attachChild((Spatial)this.sunIntensityLevelNode);
        this.toSphere = JME3PrimitivesUtilities.createSphere((float)((float)((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool().getEndPointRadius()), (AssetManager)this.assetManager);
        this.toSphere.setMaterial(this.createToSphereMaterial());
        this.toTransformNode.attachChild((Spatial)this.toSphere);
        this.updateFromTo();
        this.updateSunVectorBody();
        this.updateSunVectorTip();
        this.updateSunIntensityLevelBody();
    }

    private void updateFromTo() {
        Node toNode;
        SunVector3DTool tool;
        if (this.getTopologyNode() != null && (tool = ((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool()) != null && (toNode = tool.getToNode()) != null) {
            this.toTransformNode.setLocalTranslation(JME3Utilities.convertToVector3f((Tuple3d)tool.getToAbsolutePosition().asTuple3d()));
        }
    }

    private com.jme3.scene.Node createSunVectorBodyNode() {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Sun Vector Body");
        return node;
    }

    private Geometry createSunVectorBodyGeometry() {
        Geometry geometry = new Geometry("Ruler Body", this.getSunVectorBodyMesh());
        geometry.setMaterial(this.createSunVectorBodyMaterial());
        geometry.setQueueBucket(RenderQueue.Bucket.Transparent);
        Quaternion q = new Quaternion();
        q = q.fromAngleAxis(1.5707964f, new Vector3f(0.0f, 1.0f, 0.0f));
        geometry.setLocalRotation(q);
        return geometry;
    }

    private Material createSunVectorBodyMaterial() {
        ColorRGBA color = this.sunVectorColor.clone();
        color.a = 0.1f;
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.setColor("Color", color);
        return mat;
    }

    private Mesh getSunVectorBodyMesh() {
        Cylinder cylinder = new Cylinder(4, 10, 0.01f, 1.0f, true);
        return cylinder;
    }

    private void updateSunVectorBody() {
        SunVector3DTool tool;
        if (this.getTopologyNode() != null && (tool = ((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool()) != null) {
            float length = (float)tool.getVectorLength();
            this.sunVectorBodyGeometry.setLocalScale(1.0f, 1.0f, length);
            this.sunVectorBodyNode.setLocalTranslation(length / 2.0f + 0.1f, 0.0f, 0.0f);
        }
    }

    private com.jme3.scene.Node createSunIntensityLevelBodyNode() {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Sun Intensity Level Body");
        return node;
    }

    private Geometry createSunIntensityLevelGeometry() {
        Geometry geometry = new Geometry("Sun Intensity Level", this.getSunIntensityLevelMesh());
        geometry.setMaterial(this.createSunIntensityLevelMaterial());
        Quaternion q = new Quaternion();
        q = q.fromAngleAxis(1.5707964f, new Vector3f(0.0f, 1.0f, 0.0f));
        geometry.setLocalRotation(q);
        return geometry;
    }

    private Material createSunIntensityLevelMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.setColor("Color", this.sunLevelColor.clone());
        return mat;
    }

    private Mesh getSunIntensityLevelMesh() {
        Cylinder cylinder = new Cylinder(10, 10, 0.01f, 1.0f);
        return cylinder;
    }

    private void updateSunIntensityLevelBody() {
        SunVector3DTool tool;
        if (this.getTopologyNode() != null && (tool = ((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool()) != null) {
            float fullLength = (float)tool.getVectorLength();
            float relativeSunIntensity = (float)(((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool().getCurrentSunIntensityPercentage() / 100.0);
            float length = relativeSunIntensity * fullLength;
            this.sunIntensityLevelGeometry.setLocalScale(1.0f, 1.0f, length);
            this.sunIntensityLevelNode.setLocalTranslation(length / 2.0f + 0.1f, 0.0f, 0.0f);
        }
    }

    private com.jme3.scene.Node createSunVectorTipNode() {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Sun Vector Tip");
        return node;
    }

    private Geometry createSunVectorTipGeometry() {
        Geometry geometry = new Geometry("Sun Vector Tip", this.createSunVectorTipMesh());
        geometry.setMaterial(this.createSunVectorTipMaterial());
        geometry.setLocalScale(1.0f, 5.0f, 1.0f);
        geometry.setLocalTranslation(0.1f, 0.0f, 0.0f);
        Quaternion q = new Quaternion();
        q = q.fromAngleAxis(1.5707964f, new Vector3f(0.0f, 0.0f, 1.0f));
        geometry.setLocalRotation(q);
        return geometry;
    }

    private Material createSunVectorTipMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setColor("Color", this.sunVectorColor.clone());
        return mat;
    }

    private Mesh createSunVectorTipMesh() {
        Dome dome = new Dome(2, 12, 0.02f);
        return dome;
    }

    private void updateSunVectorTip() {
        SunVector3DTool tool;
        SunVector3DToolNode sunVector3DToolNode = (SunVector3DToolNode)this.getTopologyNode();
        if (sunVector3DToolNode != null && (tool = sunVector3DToolNode.getSunVector3DTool()) != null) {
            if (tool.getFromNode() != null && tool.getToNode() != null) {
                Vector3f v = this.getSunVectorDirection();
                v = v.normalize();
                Quaternion rot = this.getQuarternionV1ToV2(new Vector3f(1.0f, 0.0f, 0.0f), v);
                this.sunVectorTipNode.setLocalRotation(rot);
                if (!this.toTransformNode.getChildren().contains(this.sunVectorTipNode)) {
                    this.toTransformNode.attachChild((Spatial)this.sunVectorTipNode);
                }
            } else {
                this.toTransformNode.detachChild((Spatial)this.sunVectorTipNode);
            }
        }
    }

    private Material createToSphereMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setColor("Color", TO_COLOR);
        return mat;
    }

    private Vector3f getSunVectorDirection() {
        Matrix4d sunMatrix = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool().getFromNode());
        Vector3d sun = new Vector3d();
        sunMatrix.get(sun);
        Matrix4d toMatrix = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(((SunVector3DToolNode)this.getTopologyNode()).getSunVector3DTool().getToNode());
        Vector3d to = new Vector3d();
        toMatrix.get(to);
        Vector3d dir = new Vector3d(sun);
        dir.sub((Tuple3d)to);
        Vector3f v = new Vector3f((float)dir.x, (float)dir.y, (float)dir.z);
        return v;
    }

    private Quaternion getQuarternionV1ToV2(Vector3f v1, Vector3f v2) {
        float angle = v2.angleBetween(v1);
        Vector3f axis = v1.cross(v2);
        axis = axis.normalize();
        Quaternion q = new Quaternion();
        q = q.fromAngleAxis(angle, axis);
        return q;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    SunVector3DTool sunVector3DTool;
                    if (msg.getNotifier() instanceof SunVector3DToolNode) {
                        int featureId = msg.getFeatureID(SunVector3DToolNode.class);
                        if (featureId == 3) {
                            if (msg.getOldValue() instanceof SunVector3DToolNode) {
                                SunVector3DToolNode oldValue = (SunVector3DToolNode)msg.getOldValue();
                                oldValue.eAdapters().remove((Object)SunVector3DToolNodeJME3Object.this.getAdapter());
                                SunVector3DToolNodeJME3Object.this.requestUpdate();
                            }
                            if (msg.getNewValue() instanceof SunVector3DToolNode) {
                                SunVector3DToolNode newValue = (SunVector3DToolNode)msg.getNewValue();
                                newValue.eAdapters().add((Object)SunVector3DToolNodeJME3Object.this.getAdapter());
                                SunVector3DToolNodeJME3Object.this.requestUpdate();
                            }
                        }
                    } else if (msg.getNotifier() instanceof SunVector3DTool && !(sunVector3DTool = (SunVector3DTool)msg.getNotifier()).isDisposed()) {
                        int featureId = msg.getFeatureID(SunVector3DTool.class);
                        switch (featureId) {
                            case 8: 
                            case 9: 
                            case 13: 
                            case 14: 
                            case 21: 
                            case 23: {
                                SunVector3DToolNodeJME3Object.this.requestUpdate();
                                break;
                            }
                            case 19: {
                                if (!(msg.getNewValue() instanceof RGBA)) break;
                                RGBA color = (RGBA)msg.getNewValue();
                                SunVector3DToolNodeJME3Object.this.setColor(color);
                                break;
                            }
                            case 20: {
                                if (!(msg.getNewValue() instanceof RGBA)) break;
                                RGBA color = (RGBA)msg.getNewValue();
                                SunVector3DToolNodeJME3Object.this.setLevelColor(color);
                                break;
                            }
                            case 22: {
                                SunVector3DToolNodeJME3Object.this.setEndPointRadius((float)msg.getNewDoubleValue());
                                break;
                            }
                            case 6: {
                                SunVector3DToolNodeJME3Object.this.setVisible(msg.getNewBooleanValue());
                                break;
                            }
                            case 26: {
                                if (((SunVector3DToolNode)SunVector3DToolNodeJME3Object.this.getTopologyNode()).getSunVector3DTool() != null) {
                                    ((SunVector3DToolNode)SunVector3DToolNodeJME3Object.this.getTopologyNode()).getSunVector3DTool().eAdapters().remove((Object)SunVector3DToolNodeJME3Object.this.getAdapter());
                                }
                                if (msg.getNewValue() != null) break;
                                SunVector3DToolNodeJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                                    @Override
                                    public Object call() throws Exception {
                                        SunVector3DToolNodeJME3Object.this.dispose();
                                        return null;
                                    }
                                });
                                break;
                            }
                            case 1: {
                                SunVector3DToolNodeJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                                    @Override
                                    public Object call() throws Exception {
                                        SunVector3DToolNodeJME3Object.this.dispose();
                                        return null;
                                    }
                                });
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

