/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.ApogyCoreFacade;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFactory;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.Moon;
import org.eclipse.apogy.core.environment.SkyNode;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFacade;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFactory;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.apogy.core.environment.earth.surface.EarthSkyNode;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.impl.ApogyEarthSurfaceEnvironmentFacadeImpl;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshURLMapLayer;
import org.eclipse.apogy.core.environment.surface.FeaturesOfInterestMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.MapsList;
import org.eclipse.apogy.core.environment.surface.URLImageMapLayer;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyEarthSurfaceEnvironmentFacadeCustomImpl
extends ApogyEarthSurfaceEnvironmentFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyEarthSurfaceEnvironmentFacadeImpl.class);
    private Adapter activeWorksiteAdapter = null;
    private Adapter earthSurfaceWorksiteAdapter = null;

    protected ApogyEarthSurfaceEnvironmentFacadeCustomImpl() {
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getWorksiteAdapter());
    }

    @Override
    public EarthSky createEarthSky(GeographicCoordinates siteGeographicCoordinates) {
        EarthSky earthSky = ApogyEarthSurfaceEnvironmentFactory.eINSTANCE.createEarthSky();
        earthSky.setTime(new Date());
        return earthSky;
    }

    @Override
    public EarthSkyNode createEarthSkyNode(GeographicCoordinates siteGeographicCoordinates) {
        Date now = new Date();
        EarthSkyNode earthSkyNode = ApogyEarthSurfaceEnvironmentFactory.eINSTANCE.createEarthSkyNode();
        ApogyCoreEnvironmentFacade.INSTANCE.initializeSkyNode((SkyNode)earthSkyNode);
        Moon moon = ApogyCoreEnvironmentFactory.eINSTANCE.createMoon();
        moon.setDescription("The Moon.");
        moon.setNodeId("MOON");
        HorizontalCoordinates moonHorizontalCoordinates = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createHorizontalCoordinates();
        if (siteGeographicCoordinates != null) {
            moonHorizontalCoordinates = AstronomyUtils.INSTANCE.getHorizontalMoonPosition(now, siteGeographicCoordinates.getLongitude(), siteGeographicCoordinates.getLatitude());
        }
        Point3d moonPosition = AstronomyUtils.INSTANCE.convertFromHorizontalCoordinatesToHorizontalRectangular(moonHorizontalCoordinates);
        TransformNode moonTransformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(moonPosition.x, moonPosition.y, moonPosition.z, 0.0, 0.0, 0.0);
        moonTransformNode.setDescription("Transform attaching the Moon to the Sky.");
        moonTransformNode.setNodeId("MOON_TRANSFORM");
        earthSkyNode.getChildren().add((Object)moonTransformNode);
        moonTransformNode.getChildren().add((Object)moon);
        earthSkyNode.setDescription("Earth's Sky.");
        earthSkyNode.setNodeId("SKY");
        return earthSkyNode;
    }

    @Override
    public EarthSurfaceWorksite createAndInitializeDefaultCSAWorksite() {
        Date now = new Date();
        EarthSurfaceWorksite worksite = ApogyEarthSurfaceEnvironmentFactory.eINSTANCE.createEarthSurfaceWorksite();
        worksite.setName("CSA AT");
        worksite.setDescription("The CSA Default Worksite.");
        worksite.setGeographicalCoordinates(this.getMarsYardGeographicalCoordinates());
        worksite.setXAxisAzimuth(Math.toRadians(179.4));
        EarthSky earthSky = this.createEarthSky(worksite.getGeographicalCoordinates());
        worksite.setSky(earthSky);
        earthSky.setWorksite((Worksite)worksite);
        worksite.getEarthSky().setTime(now);
        MapsList mapList = ApogySurfaceEnvironmentFactory.eINSTANCE.createMapsList();
        worksite.setMapsList(mapList);
        Map map = this.getDefaultMarsTerrainMap();
        worksite.getMapsList().getMaps().add((Object)map);
        return worksite;
    }

    @Override
    public EarthSurfaceWorksite createEmptyEarthSurfaceWorksite() {
        EarthSurfaceWorksite worksite = this.createAndInitializeDefaultCSAWorksite();
        worksite.setName(null);
        worksite.setDescription(null);
        worksite.setXAxisAzimuth(Math.toRadians(179.4));
        worksite.setGeographicalCoordinates(this.getMarsYardGeographicalCoordinates());
        worksite.getMapsList().getMaps().clear();
        return worksite;
    }

    @Override
    public GeographicCoordinates getMarsYardGeographicalCoordinates() {
        GeographicCoordinates coordinates = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(Math.toRadians(-73.393904468182), Math.toRadians(45.518206644445), 30.0);
        return coordinates;
    }

    @Override
    public TransformNode getMarsYardTransformNode() {
        TransformNode marsYardTransformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        marsYardTransformNode.setDescription("Mars Yard Transform that orients the terrain coordinate system to north.");
        return marsYardTransformNode;
    }

    @Override
    public InvocatorSession createApogySession() {
        InvocatorSession session = ApogyCoreEnvironmentFacade.INSTANCE.createApogySession(true, true, true, true);
        ApogyEnvironment environment = (ApogyEnvironment)session.getEnvironment();
        EarthSurfaceWorksite worksite = this.createAndInitializeDefaultCSAWorksite();
        environment.getWorksitesList().getWorksites().add((Object)worksite);
        environment.setActiveWorksite((AbstractWorksite)worksite);
        return session;
    }

    private Map getDefaultMarsTerrainMap() {
        Map map = ApogySurfaceEnvironmentFactory.eINSTANCE.createMap();
        map.setName("MarsYard");
        map.setDescription("Simple Mars Yard Map.");
        Matrix4d matrix = this.getMarsYardTransformNode().asMatrix4d();
        map.setTransformation(ApogyCommonMathFacade.INSTANCE.createMatrix4x4(matrix));
        CartesianTriangularMeshURLMapLayer meshLayer = ApogySurfaceEnvironmentFactory.eINSTANCE.createCartesianTriangularMeshURLMapLayer();
        meshLayer.setUrl("platform:/plugin/org.eclipse.apogy.examples.worksites.surface/data/CSAAnalogTerrainDEM100cm.tri");
        meshLayer.setName("MarsYardDEM 1.0 meters resolution");
        meshLayer.setDescription("MarsYard DEM at 1.0 meters resolution");
        map.getLayers().add((Object)meshLayer);
        URLImageMapLayer imageLayer = ApogySurfaceEnvironmentFactory.eINSTANCE.createURLImageMapLayer();
        imageLayer.setUrl("platform:/plugin/org.eclipse.apogy.examples.worksites.surface/data/CSA-AT-NGC-MET-seen-from-sky.jpg");
        imageLayer.setName("Mars Yard Aerial Image.");
        imageLayer.setDescription("Mars Yard seen from above.");
        imageLayer.setWidth(60.0);
        imageLayer.setHeight(120.0);
        map.getLayers().add((Object)imageLayer);
        FeaturesOfInterestMapLayer foiLayer = ApogySurfaceEnvironmentFactory.eINSTANCE.createFeaturesOfInterestMapLayer();
        foiLayer.setFeatures(ApogyCoreFactory.eINSTANCE.createFeatureOfInterestList());
        foiLayer.setName("CSA AT Features");
        foiLayer.setDescription("CSA AT Features Of Interest.");
        String foiURL = "platform:/plugin/org.eclipse.apogy.examples.worksites.surface/data/CSA-AT-FOI.csv";
        try {
            List features = ApogyCoreFacade.INSTANCE.loadFeatureOfInterestFromFile(foiURL);
            foiLayer.getFeatures().getFeaturesOfInterest().addAll((Collection)features);
        }
        catch (Throwable t) {
            FeatureOfInterest foi = ApogyCoreFactory.eINSTANCE.createFeatureOfInterest();
            foi.setPose(ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4());
            foiLayer.getFeatures().getFeaturesOfInterest().add((Object)foi);
            Logger.error("Failed to load Feature Of Interest from <" + foiURL + ">.");
        }
        map.getLayers().add((Object)foiLayer);
        return map;
    }

    private void updateEarthSurfaceWorksite(AbstractWorksite abstractWorksite) {
        if (this.getActiveEarthSurfaceWorksite() != null) {
            this.getActiveEarthSurfaceWorksite().eAdapters().remove((Object)this.getEarthSurfaceWorksiteAdapter());
        }
        if (abstractWorksite instanceof EarthSurfaceWorksite) {
            EarthSurfaceWorksite earthSurfaceWorksite = (EarthSurfaceWorksite)abstractWorksite;
            earthSurfaceWorksite.eAdapters().add((Object)this.getEarthSurfaceWorksiteAdapter());
            this.setActiveEarthSurfaceWorksite(earthSurfaceWorksite);
            if (earthSurfaceWorksite.getSky() instanceof EarthSky) {
                EarthSky earthSky = (EarthSky)earthSurfaceWorksite.getSky();
                this.setActiveMoon(earthSky.getMoon());
            }
        } else {
            this.setActiveEarthSurfaceWorksite(null);
            this.setActiveMoon(null);
        }
    }

    private Adapter getWorksiteAdapter() {
        if (this.activeWorksiteAdapter == null) {
            this.activeWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyCoreEnvironmentFacade) {
                        int featureID = msg.getFeatureID(ApogyCoreEnvironmentFacade.class);
                        switch (featureID) {
                            case 1: {
                                ApogyEarthSurfaceEnvironmentFacadeCustomImpl.this.updateEarthSurfaceWorksite((AbstractWorksite)msg.getNewValue());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.activeWorksiteAdapter;
    }

    private Adapter getEarthSurfaceWorksiteAdapter() {
        if (this.earthSurfaceWorksiteAdapter == null) {
            this.earthSurfaceWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof EarthSurfaceWorksite) {
                        int featureID = msg.getFeatureID(EarthSurfaceWorksite.class);
                        switch (featureID) {
                            case 5: {
                                if (!(msg.getNewValue() instanceof EarthSky)) break;
                                EarthSky earthSky = (EarthSky)msg.getNewValue();
                                ApogyEarthSurfaceEnvironmentFacadeCustomImpl.this.setActiveMoon(earthSky.getMoon());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.earthSurfaceWorksiteAdapter;
    }
}

