/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.impl;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.vecmath.Point3d;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFactory;
import org.eclipse.apogy.core.environment.EnvironmentUtilities;
import org.eclipse.apogy.core.environment.EquatorialCoordinates;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFactory;
import org.eclipse.apogy.core.environment.earth.EclipticCoordinates;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.impl.AstronomyUtilsImpl;

public class AstronomyUtilsCustomImpl
extends AstronomyUtilsImpl {
    public static final double J2000 = 2451545.0;
    public static final double ECLIPTIC_OBLIQUITY = Math.toRadians(23.4406);
    public static final double EARTH_EQUATORIAL_RADIUS = 6378100.0;
    public static final double METERS_PER_ASTRONOMICAL_UNIT = 1.495978707E11;
    public static final double GOLDEN_RATIO = (1.0 + Math.sqrt(5.0)) / 2.0;

    @Override
    public EquatorialCoordinates getSunEquatorialPosition(double julianDay) {
        double d = this.getTimeSinceJ2000(julianDay);
        double L = 280.461 + 0.9856474 * d;
        L = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(L)));
        double g = 357.528 + 0.9856003 * d;
        g = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(g)));
        double lambda = L + 1.915 * Math.sin(Math.toRadians(g)) + 0.02 * Math.sin(Math.toRadians(2.0 * g));
        double epsilon = 23.439 - 4.0E-7 * d;
        double y = Math.cos(Math.toRadians(epsilon)) * Math.sin(Math.toRadians(lambda));
        double x = Math.cos(Math.toRadians(lambda));
        double r = Math.sqrt(x * x + y * y) * 1.49598261E11;
        double a = Math.toDegrees(Math.atan(y / x));
        double alpha = x < 0.0 ? a + 180.0 : (y < 0.0 && x > 0.0 ? a + 360.0 : a);
        alpha = Math.toRadians(alpha);
        double delta = Math.asin(Math.sin(Math.toRadians(epsilon)) * Math.sin(Math.toRadians(lambda)));
        EquatorialCoordinates coordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createEquatorialCoordinates();
        coordinates.setRightAscension(alpha);
        coordinates.setDeclination(delta);
        coordinates.setRadius(r);
        return coordinates;
    }

    @Override
    public HorizontalCoordinates getHorizontalSunPosition(Date date, double observerLongitude, double observerLatitude) {
        double julianDay = EnvironmentUtilities.INSTANCE.convertToJulianDate(date);
        EquatorialCoordinates equatorialCoordinates = this.getSunEquatorialPosition(julianDay);
        HorizontalCoordinates horizontalCoords = this.convertToHorizontalCoordinates(equatorialCoordinates, observerLongitude, observerLatitude, date);
        horizontalCoords.setAzimuth(this.clampAngleToZero2PI(horizontalCoords.getAzimuth()));
        return horizontalCoords;
    }

    @Override
    public EquatorialCoordinates getMoonEquatorialPosition(double julianDay) {
        double d = this.getTimeSinceJ2000(julianDay) + 1.5;
        double longitudeOfAscendingNode = 125.1228 - 0.0529538083 * d;
        longitudeOfAscendingNode = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(longitudeOfAscendingNode)));
        double i = 5.1454;
        double argumentOfPerigee = 318.0634 + 0.1643573223 * d;
        argumentOfPerigee = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(argumentOfPerigee)));
        double a = 60.2666;
        double e = 0.0549;
        double moonMeanAnomaly = 115.3654 + 13.0649929509 * d;
        moonMeanAnomaly = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(moonMeanAnomaly)));
        double E0 = 10.0;
        double E1 = 0.0;
        while (Math.abs(E1 - E0) > 0.005) {
            E0 = moonMeanAnomaly + 57.29577951308232 * e * Math.sin(Math.toRadians(moonMeanAnomaly)) * (1.0 + e * Math.cos(Math.toRadians(moonMeanAnomaly)));
            E0 = E1 = E0 - (E0 - 57.29577951308232 * e * Math.sin(Math.toRadians(E0)) - moonMeanAnomaly) / (1.0 - e * Math.cos(Math.toRadians(E0)));
        }
        double E = E1;
        double x = a * (Math.cos(Math.toRadians(E)) - e);
        double y = a * (Math.sqrt(1.0 - e * e) * Math.sin(Math.toRadians(E)));
        double r = Math.sqrt(x * x + y * y);
        double v = Math.atan2(y, x);
        v = Math.toDegrees(this.clampAngleToZero2PI(v));
        double xeclip = r * (Math.cos(Math.toRadians(longitudeOfAscendingNode)) * Math.cos(Math.toRadians(v + argumentOfPerigee)) - Math.sin(Math.toRadians(longitudeOfAscendingNode)) * Math.sin(Math.toRadians(v + argumentOfPerigee)) * Math.cos(Math.toRadians(i)));
        double yeclip = r * (Math.sin(Math.toRadians(longitudeOfAscendingNode)) * Math.cos(Math.toRadians(v + argumentOfPerigee)) + Math.cos(Math.toRadians(longitudeOfAscendingNode)) * Math.sin(Math.toRadians(v + argumentOfPerigee)) * Math.cos(Math.toRadians(i)));
        double zeclip = r * Math.sin(Math.toRadians(v + argumentOfPerigee)) * Math.sin(Math.toRadians(i));
        EclipticCoordinates eclipCoord = this.convertFromEclipticRectangularToEclipticCoordinates(new Point3d(xeclip, yeclip, zeclip));
        double sunMeanAnomaly = 356.047 + 0.9856002585 * d;
        sunMeanAnomaly = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(sunMeanAnomaly)));
        double sunLongitudeOfPerihelion = 282.9404 + 4.70935E-5 * d;
        sunLongitudeOfPerihelion = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(sunLongitudeOfPerihelion)));
        double sunMeanLongitude = sunMeanAnomaly + sunLongitudeOfPerihelion;
        sunMeanLongitude = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(sunMeanLongitude)));
        double moonMeanLongitude = longitudeOfAscendingNode + argumentOfPerigee + moonMeanAnomaly;
        moonMeanLongitude = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(moonMeanLongitude)));
        double moonMeanElongation = moonMeanLongitude - sunMeanLongitude;
        moonMeanElongation = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(moonMeanElongation)));
        double moonArgumentOfLatitude = moonMeanLongitude - longitudeOfAscendingNode;
        moonArgumentOfLatitude = Math.toDegrees(this.clampAngleToZero2PI(Math.toRadians(moonArgumentOfLatitude)));
        double distancePerturbations = this.computeMoonDistancePerturbations(Math.toRadians(moonMeanAnomaly), Math.toRadians(moonMeanElongation));
        double longitudePerturbations = this.computeMoonLongitudePerturbations(Math.toRadians(moonMeanAnomaly), Math.toRadians(sunMeanAnomaly), Math.toRadians(moonMeanElongation), Math.toRadians(moonArgumentOfLatitude));
        double latitudePerturbations = this.computeMoonLatitudePerturbations(Math.toRadians(moonMeanAnomaly), Math.toRadians(moonMeanElongation), Math.toRadians(moonArgumentOfLatitude));
        double correctedLongitude = this.clampAngleToZero2PI(eclipCoord.getLongitude() + longitudePerturbations);
        double correctedLatitude = this.clampAngleToZero2PI(eclipCoord.getLatitude() + latitudePerturbations);
        double correctedRadius = eclipCoord.getRadius() + distancePerturbations;
        eclipCoord.setLongitude(correctedLongitude);
        eclipCoord.setLatitude(correctedLatitude);
        eclipCoord.setRadius(correctedRadius);
        EquatorialCoordinates equatorialCoordinates = this.convertToEquatorialCoordinates(eclipCoord);
        return equatorialCoordinates;
    }

    private double computeMoonLongitudePerturbations(double moonMeanAnomaly, double sunMeanAnomaly, double moonMeanElongation, double moonArgumentOfLatitude) {
        double longitudePerturbations = 0.0;
        longitudePerturbations += -1.274 * Math.sin(moonMeanAnomaly - 2.0 * moonMeanElongation);
        longitudePerturbations += 0.658 * Math.sin(2.0 * moonMeanElongation);
        longitudePerturbations += -0.186 * Math.sin(sunMeanAnomaly);
        longitudePerturbations += -0.059 * Math.sin(2.0 * moonMeanAnomaly - 2.0 * moonMeanElongation);
        longitudePerturbations += -0.057 * Math.sin(moonMeanAnomaly - 2.0 * moonMeanElongation + sunMeanAnomaly);
        longitudePerturbations += 0.053 * Math.sin(moonMeanAnomaly + 2.0 * moonMeanElongation);
        longitudePerturbations += 0.046 * Math.sin(2.0 * moonMeanElongation - sunMeanAnomaly);
        longitudePerturbations += 0.041 * Math.sin(moonMeanAnomaly - sunMeanAnomaly);
        longitudePerturbations += -0.035 * Math.sin(moonMeanElongation);
        longitudePerturbations += -0.031 * Math.sin(moonMeanAnomaly + sunMeanAnomaly);
        longitudePerturbations += -0.015 * Math.sin(2.0 * moonArgumentOfLatitude - 2.0 * moonMeanElongation);
        return Math.toRadians(longitudePerturbations += 0.011 * Math.sin(moonMeanAnomaly - 4.0 * moonMeanElongation));
    }

    private double computeMoonLatitudePerturbations(double moonMeanAnomaly, double moonMeanElongation, double moonArgumentOfLatitude) {
        double latitudePerturbations = 0.0;
        latitudePerturbations += -0.173 * Math.sin(moonArgumentOfLatitude - 2.0 * moonMeanElongation);
        latitudePerturbations += -0.055 * Math.sin(moonMeanAnomaly - moonArgumentOfLatitude - 2.0 * moonMeanElongation);
        latitudePerturbations += -0.046 * Math.sin(moonMeanAnomaly + moonArgumentOfLatitude - 2.0 * moonMeanElongation);
        latitudePerturbations += 0.033 * Math.sin(moonArgumentOfLatitude + 2.0 * moonMeanElongation);
        return Math.toRadians(latitudePerturbations += 0.017 * Math.sin(2.0 * moonMeanAnomaly + moonArgumentOfLatitude));
    }

    private double computeMoonDistancePerturbations(double moonMeanAnomaly, double moonMeanElongation) {
        double distancePerturbations = 0.0;
        distancePerturbations += -0.58 * Math.cos(moonMeanAnomaly - 2.0 * moonMeanElongation);
        return distancePerturbations += -0.46 * Math.cos(2.0 * moonMeanElongation);
    }

    @Override
    public EquatorialCoordinates getMoonTopocentricEquatorialPosition(Date date, double observerLongitude, double observerLatitude) {
        double julianDay = EnvironmentUtilities.INSTANCE.convertToJulianDate(date);
        EquatorialCoordinates geocentricCoords = this.getMoonEquatorialPosition(julianDay);
        double mpar = Math.asin(1.0 / geocentricCoords.getRadius());
        double gclat = Math.toRadians(Math.toDegrees(observerLatitude) - 0.1924 * Math.sin(2.0 * observerLatitude));
        double rho = 0.99833 + 0.00167 * Math.cos(2.0 * observerLatitude);
        double hourAngle = this.getLocalSideralTime(date, observerLongitude) - geocentricCoords.getRightAscension();
        hourAngle = this.clampAngleToZero2PI(hourAngle);
        double g = Math.atan(Math.tan(gclat) / Math.cos(hourAngle));
        if (g == 0.0) {
            g = 1.0E-9;
        }
        double rightAscensionCorrection = -mpar * rho * Math.cos(gclat) * Math.sin(hourAngle) / Math.cos(geocentricCoords.getDeclination());
        double declinationCorrection = -mpar * rho * Math.sin(gclat) * Math.sin(g - geocentricCoords.getDeclination()) / Math.sin(g);
        double correctedRightAscension = this.clampAngleToZero2PI(geocentricCoords.getRightAscension() + rightAscensionCorrection);
        double correctedDeclination = geocentricCoords.getDeclination() + declinationCorrection;
        EquatorialCoordinates equatorialCoordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createEquatorialCoordinates();
        equatorialCoordinates.setRightAscension(correctedRightAscension);
        equatorialCoordinates.setDeclination(correctedDeclination);
        equatorialCoordinates.setRadius(rho * geocentricCoords.getRadius() * 6378100.0);
        return equatorialCoordinates;
    }

    @Override
    public HorizontalCoordinates getHorizontalMoonPosition(Date date, double observerLongitude, double observerLatitude) {
        EquatorialCoordinates equatorialCoordinates = this.getMoonTopocentricEquatorialPosition(date, observerLongitude, observerLatitude);
        HorizontalCoordinates horizontalCoords = this.convertToHorizontalCoordinates(equatorialCoordinates, observerLongitude, observerLatitude, date);
        horizontalCoords.setAzimuth(this.clampAngleToZero2PI(horizontalCoords.getAzimuth()));
        return horizontalCoords;
    }

    @Override
    public double getTimeSinceJ2000(double julianDay) {
        return julianDay - 2451545.0;
    }

    @Override
    public double getLocalSideralTime(Date date, double observerLongitude) {
        double jd = EnvironmentUtilities.INSTANCE.convertToJulianDate(date);
        double d = this.getTimeSinceJ2000(jd);
        double gmst = 18.697374558 + 24.06570982441908 * d;
        if (gmst > 24.0 || gmst < -24.0) {
            gmst -= Math.floor(gmst / 24.0) * 24.0;
        }
        double gmstInRadians = gmst / 24.0 * 2.0 * Math.PI;
        double localSideralTime = gmstInRadians + observerLongitude;
        localSideralTime = this.clampAngleToZero2PI(localSideralTime);
        return localSideralTime;
    }

    @Override
    public double getUTCDecimalHours(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        int miliseconds = cal.get(14);
        double time = (double)hours + (double)minutes / 60.0 + (double)seconds / 3600.0 + (double)miliseconds / 3600000.0;
        return time;
    }

    @Override
    public HorizontalCoordinates convertToHorizontalCoordinates(EquatorialCoordinates equatorialCoordinates, double observerLongitude, double observerLatitude, Date date) {
        double radius;
        HorizontalCoordinates result = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createHorizontalCoordinates();
        double localSideralTime = this.getLocalSideralTime(date, observerLongitude);
        double hourAngle = localSideralTime - equatorialCoordinates.getRightAscension();
        double sinA = Math.sin(observerLatitude) * Math.sin(equatorialCoordinates.getDeclination()) + Math.cos(observerLatitude) * Math.cos(equatorialCoordinates.getDeclination()) * Math.cos(hourAngle);
        double cosAcosAlpha = Math.cos(observerLatitude) * Math.sin(equatorialCoordinates.getDeclination()) - Math.sin(observerLatitude) * Math.cos(equatorialCoordinates.getDeclination()) * Math.cos(hourAngle);
        double sinAcosAlpha = -Math.cos(equatorialCoordinates.getDeclination()) * Math.sin(hourAngle);
        double x = cosAcosAlpha;
        double y = sinAcosAlpha;
        double azimuth = Math.atan2(y, x);
        x = radius = Math.sqrt(x * x + y * y);
        y = sinA;
        double altitude = Math.atan2(y, x);
        radius = Math.sqrt(x * x + y * y);
        result.setAltitude(altitude);
        result.setAzimuth(azimuth);
        result.setRadius(equatorialCoordinates.getRadius());
        return result;
    }

    @Override
    public double convertTimeToAngle(int hours, int minutes, int seconds) {
        double result = ((double)hours + (double)minutes / 60.0 + (double)seconds / 3600.0) * Math.toRadians(15.0);
        return result;
    }

    @Override
    public double clampAngleToZero2PI(double angleInRadians) {
        double clampedAngle = angleInRadians < 0.0 || angleInRadians > Math.PI * 2 ? angleInRadians - Math.floor(angleInRadians / (Math.PI * 2)) * 2.0 * Math.PI : angleInRadians;
        return clampedAngle;
    }

    @Override
    public EquatorialCoordinates convertToEquatorialCoordinates(EclipticCoordinates eclipticCoordinates) {
        EquatorialCoordinates equatorialCoordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createEquatorialCoordinates();
        double eradius = eclipticCoordinates.getRadius();
        double elongitude = eclipticCoordinates.getLongitude();
        double elatitude = eclipticCoordinates.getLatitude();
        double xeclip = eradius * Math.cos(elongitude) * Math.cos(elatitude);
        double yeclip = eradius * Math.sin(elongitude) * Math.cos(elatitude);
        double zeclip = eradius * Math.sin(elatitude);
        double xequat = xeclip;
        double yequat = yeclip * Math.cos(ECLIPTIC_OBLIQUITY) - zeclip * Math.sin(ECLIPTIC_OBLIQUITY);
        double zequat = yeclip * Math.sin(ECLIPTIC_OBLIQUITY) + zeclip * Math.cos(ECLIPTIC_OBLIQUITY);
        double r = Math.sqrt(xequat * xequat + yequat * yequat + zequat * zequat);
        double ra = this.clampAngleToZero2PI(Math.atan2(yequat, xequat));
        double dec = Math.asin(zequat / r);
        equatorialCoordinates.setDeclination(dec);
        equatorialCoordinates.setRightAscension(ra);
        equatorialCoordinates.setRadius(r);
        return equatorialCoordinates;
    }

    @Override
    public EclipticCoordinates convertToEclipticCoordinates(EquatorialCoordinates equatorialCoordinates) {
        EclipticCoordinates eclipticCoordinates = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createEclipticCoordinates();
        double rightAscension = equatorialCoordinates.getRightAscension();
        double declination = equatorialCoordinates.getDeclination();
        double xEquatorial = Math.cos(rightAscension) * Math.cos(declination);
        double yEquatorial = Math.sin(rightAscension) * Math.cos(declination);
        double zEquatorial = Math.sin(declination);
        double xEcliptic = xEquatorial;
        double yEcliptic = yEquatorial * Math.cos(ECLIPTIC_OBLIQUITY) - zEquatorial * Math.sin(-ECLIPTIC_OBLIQUITY);
        double zEcliptic = yEquatorial * Math.sin(-ECLIPTIC_OBLIQUITY) + zEquatorial * Math.cos(-ECLIPTIC_OBLIQUITY);
        double r = Math.sqrt(xEcliptic * xEcliptic + yEcliptic * yEcliptic + zEcliptic * zEcliptic);
        double longitude = Math.atan2(yEcliptic, xEcliptic);
        double latitude = Math.asin(zEcliptic / r);
        eclipticCoordinates.setLatitude(latitude);
        eclipticCoordinates.setLongitude(longitude);
        return eclipticCoordinates;
    }

    @Override
    public Point3d convertFromEquatorialRectangularToEclipticRectangular(Point3d equatorialRectangularCoordinates) {
        Point3d eclipticCoordinates = new Point3d();
        eclipticCoordinates.x = equatorialRectangularCoordinates.x;
        eclipticCoordinates.y = equatorialRectangularCoordinates.y * Math.cos(-ECLIPTIC_OBLIQUITY) - equatorialRectangularCoordinates.z * Math.sin(-ECLIPTIC_OBLIQUITY);
        eclipticCoordinates.z = equatorialRectangularCoordinates.y * Math.sin(-ECLIPTIC_OBLIQUITY) + equatorialRectangularCoordinates.z * Math.cos(-ECLIPTIC_OBLIQUITY);
        return eclipticCoordinates;
    }

    @Override
    public Point3d convertFromEclipticRectangularToEquatorialRectangular(Point3d eclipticCoordinates) {
        Point3d equatorialCoordinates = new Point3d();
        equatorialCoordinates.x = eclipticCoordinates.x;
        equatorialCoordinates.y = eclipticCoordinates.y * Math.cos(ECLIPTIC_OBLIQUITY) - eclipticCoordinates.z * Math.sin(ECLIPTIC_OBLIQUITY);
        equatorialCoordinates.z = eclipticCoordinates.y * Math.sin(ECLIPTIC_OBLIQUITY) + eclipticCoordinates.z * Math.cos(ECLIPTIC_OBLIQUITY);
        return equatorialCoordinates;
    }

    @Override
    public EclipticCoordinates convertFromEclipticRectangularToEclipticCoordinates(Point3d eclipticCoordinates) {
        EclipticCoordinates eclipticCoord = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createEclipticCoordinates();
        double radius = Math.sqrt(eclipticCoordinates.x * eclipticCoordinates.x + eclipticCoordinates.y * eclipticCoordinates.y + eclipticCoordinates.z * eclipticCoordinates.z);
        double latitude = Math.asin(eclipticCoordinates.z / radius);
        double longitude = Math.atan2(eclipticCoordinates.y, eclipticCoordinates.x);
        eclipticCoord.setLatitude(latitude);
        eclipticCoord.setLongitude(longitude);
        eclipticCoord.setRadius(radius);
        return eclipticCoord;
    }

    @Override
    public EquatorialCoordinates convertFromEquatorialRectangularToEquatorialCoordinates(Point3d equatorialCoordinates) {
        EquatorialCoordinates equatorialCoord = ApogyCoreEnvironmentFactory.eINSTANCE.createEquatorialCoordinates();
        double radius = Math.sqrt(equatorialCoordinates.x * equatorialCoordinates.x + equatorialCoordinates.y * equatorialCoordinates.y + equatorialCoordinates.z * equatorialCoordinates.z);
        double declination = Math.asin(equatorialCoordinates.z / radius);
        double rightAscension = Math.atan2(equatorialCoordinates.y, equatorialCoordinates.x);
        equatorialCoord.setRightAscension(rightAscension);
        equatorialCoord.setDeclination(declination);
        equatorialCoord.setRadius(radius);
        return equatorialCoord;
    }

    @Override
    public Point3d convertFromHorizontalCoordinatesToHorizontalRectangular(HorizontalCoordinates horizontalCoordinates) {
        Point3d position = new Point3d();
        double r = horizontalCoordinates.getRadius();
        position.x = r * Math.cos(horizontalCoordinates.getAltitude()) * Math.cos(horizontalCoordinates.getAzimuth());
        position.y = -r * Math.cos(horizontalCoordinates.getAltitude()) * Math.sin(horizontalCoordinates.getAzimuth());
        position.z = r * Math.sin(horizontalCoordinates.getAltitude());
        return position;
    }

    @Override
    public Point3d convertFromEquatorialCoordinatesToEquatorialRectangular(EquatorialCoordinates equatorialCoordinates) {
        Point3d position = new Point3d();
        double r = equatorialCoordinates.getRadius();
        position.x = r * Math.cos(equatorialCoordinates.getRightAscension()) * Math.cos(equatorialCoordinates.getDeclination());
        position.y = r * Math.sin(equatorialCoordinates.getRightAscension()) * Math.cos(equatorialCoordinates.getDeclination());
        position.z = r * Math.sin(equatorialCoordinates.getDeclination());
        return position;
    }

    @Override
    public double convertAUtoMeters(double astronomicalUnits) {
        return astronomicalUnits * 1.495978707E11;
    }

    @Override
    public double getMaximumSunAltitude(double observerLatitude) {
        double maximumSunAltitude = 1.5707963267948966 - Math.abs(observerLatitude) + ECLIPTIC_OBLIQUITY;
        if (maximumSunAltitude > 1.5707963267948966) {
            maximumSunAltitude = 1.5707963267948966;
        }
        return maximumSunAltitude;
    }

    @Override
    public String convertToHHmmssString(double sideralTime) {
        String string = new String();
        double hoursOfDay = sideralTime / (Math.PI * 2) * 24.0;
        DecimalFormat numberFormat = new DecimalFormat("00");
        long hours = Math.round(Math.floor(hoursOfDay));
        string = String.valueOf(string) + numberFormat.format(hours) + ":";
        double minutesOfHour = (hoursOfDay - (double)hours) * 60.0;
        long minutes = Math.round(Math.floor(minutesOfHour));
        string = String.valueOf(string) + numberFormat.format(minutes) + ":";
        double secondsOfMinute = (minutesOfHour - (double)minutes) * 60.0;
        long seconds = Math.round(Math.floor(secondsOfMinute));
        string = String.valueOf(string) + numberFormat.format(seconds);
        string.trim();
        return string;
    }

    private Date findHorizonCrossing(Date from, Date to, double observerLongitude, double observerLatitude) {
        long a = from.getTime();
        long b = to.getTime();
        long c = 0L;
        long output = 0L;
        int i = 0;
        while (i < 10) {
            double fa = this.getHorizontalSunPosition(new Date(a), observerLongitude, observerLatitude).getAltitude();
            double fb = this.getHorizontalSunPosition(new Date(b), observerLongitude, observerLatitude).getAltitude();
            double slope = (fb - fa) / (double)(b - a);
            double deltaX = -fb / slope;
            c = b + Math.round(deltaX);
            ++i;
            double fc = this.getHorizontalSunPosition(new Date(c), observerLongitude, observerLatitude).getAltitude();
            if (Math.abs(fc) < Math.toRadians(0.1)) {
                output = c;
                break;
            }
            if (fa * fc > 0.0) {
                a = c;
                continue;
            }
            b = c;
        }
        if (output >= from.getTime() && output <= to.getTime()) {
            return new Date(output);
        }
        return null;
    }

    @Override
    public Date getSunRiseTime(Date day, double observerLongitude, double observerLatitude) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 1);
        Date from = calendar.getTime();
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date to = calendar.getTime();
        return this.findHorizonCrossing(from, to, observerLongitude, observerLatitude);
    }

    @Override
    public Date getSunSetTime(Date day, double observerLongitude, double observerLatitude) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date from = calendar.getTime();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date to = calendar.getTime();
        return this.findHorizonCrossing(from, to, observerLongitude, observerLatitude);
    }

    private double goldenSectionSearch(UnimodalFunction function, double a, double b, double c, double tau) {
        double x = c - b > b - a ? b + (2.0 - GOLDEN_RATIO) * (c - b) : b - (2.0 - GOLDEN_RATIO) * (b - a);
        if (Math.abs(c - a) < tau * (Math.abs(b) + Math.abs(x))) {
            return (c + a) / 2.0;
        }
        assert (function.f(x) != function.f(b));
        if (function.f(x) < function.f(b)) {
            if (c - b > b - a) {
                return this.goldenSectionSearch(function, b, x, c, tau);
            }
            return this.goldenSectionSearch(function, a, x, b, tau);
        }
        if (c - b > b - a) {
            return this.goldenSectionSearch(function, a, b, x, tau);
        }
        return this.goldenSectionSearch(function, x, b, c, tau);
    }

    @Override
    public Date getSunHighestElevationTime(Date day, double observerLongitude, double observerLatitude) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        double x2 = calendar.getTime().getTime();
        double x1 = x2 - 1.08E7;
        double x3 = x2 + 1.08E7;
        double tau = 1.0E-10;
        SunElevationFunction function = new SunElevationFunction(observerLongitude, observerLatitude);
        long time = Math.round(this.goldenSectionSearch(function, x1, x2, x3, tau));
        return new Date(time);
    }

    protected class SunElevationFunction
    extends UnimodalFunction {
        private double observerLongitude;
        private double observerLatitude;

        public SunElevationFunction(double observerLongitude, double observerLatitude) {
            this.observerLongitude = 0.0;
            this.observerLatitude = 0.0;
            this.observerLongitude = observerLongitude;
            this.observerLatitude = observerLatitude;
        }

        @Override
        public double f(double x) {
            long time = Math.round(x);
            return Math.toRadians(90.0) - AstronomyUtilsCustomImpl.this.getHorizontalSunPosition(new Date(time), this.observerLongitude, this.observerLatitude).getAltitude();
        }
    }

    protected abstract class UnimodalFunction {
        protected UnimodalFunction() {
        }

        public abstract double f(double var1);
    }
}

