/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import edu.wlu.cs.levy.CG.KDTree;
import edu.wlu.cs.levy.CG.KeySizeException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data.Coordinates;
import org.eclipse.apogy.common.geometry.data.Polygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.surface.RectangularRegion;
import org.eclipse.apogy.core.environment.surface.RectangularVolumeRegion;
import org.eclipse.apogy.core.environment.surface.impl.CartesianTriangularMeshDerivedImageMapLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CartesianTriangularMeshDerivedImageMapLayerCustomImpl
extends CartesianTriangularMeshDerivedImageMapLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CartesianTriangularMeshDerivedImageMapLayerImpl.class);
    public static final int TRANSPARENT_COLOR = -1;
    private double[] queryBuffer1;
    private double[] queryBuffer2;

    @Override
    public RectangularRegion getRegion() {
        return this.getRectangularVolumeRegion();
    }

    @Override
    public double getWidth() {
        return this.getRegion().getXDimension();
    }

    @Override
    public double getHeight() {
        return this.getRegion().getYDimension();
    }

    @Override
    public void dispose() {
    }

    protected RectangularVolumeRegion getRectangularVolumeRegion() {
        if (this.getCartesianTriangularMeshMapLayer() != null && this.getCartesianTriangularMeshMapLayer().getCurrentMesh() != null) {
            return ApogySurfaceEnvironmentFacade.INSTANCE.getRectangularVolumeRegion(this.getCartesianTriangularMeshMapLayer().getCurrentMesh());
        }
        return null;
    }

    protected String getJobFamilyName() {
        return "UpdateImage";
    }

    protected int getNumberOfProcessorToUse() {
        int cores = Runtime.getRuntime().availableProcessors();
        if (cores > 1) {
            --cores;
        }
        return cores;
    }

    protected int getNumberOfPixels(CartesianTriangularMesh mesh) {
        RectangularRegion meshRegion = (RectangularRegion)EcoreUtil.copy((EObject)this.getRegion());
        int numberPixelAlongX = (int)Math.round(meshRegion.getXDimension() / this.getRequiredResolution());
        int numberPixelAlongY = (int)Math.round(meshRegion.getYDimension() / this.getRequiredResolution());
        return numberPixelAlongX * numberPixelAlongY;
    }

    protected Point3d[][] getPixelsLocation(CartesianTriangularMesh mesh, IProgressMonitor progressMonitor) {
        CreatePixelLocationJob job = new CreatePixelLocationJob("Get Pixel Locations", "GetPixelLocation", mesh);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)job.getNumberOfTicks());
        try {
            job.setProgressGroup((IProgressMonitor)subMonitor, job.getNumberOfTicks());
            job.schedule();
            job.join();
            return job.getOutput();
        }
        catch (InterruptedException e) {
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected CartesianTriangle[][] getPixelsIntersectionTriangle(Point3d[][] pixelsLocation, CartesianTriangularMesh mesh, KDTree kdTree, double averagingRadius, IProgressMonitor progressMonitor) {
        progressMonitor.subTask("Finding pixel intersection with mesh.");
        int numberPixelAlongX = pixelsLocation.length;
        int numberPixelAlongY = pixelsLocation[0].length;
        Logger.info("getPixelsIntersectionTriangle() starts.");
        CartesianTriangle[][] intersectionTriangles = new CartesianTriangle[numberPixelAlongX][numberPixelAlongY];
        int numberOfJobs = this.getNumberOfProcessorToUse();
        int xIndexSlotSize = Math.floorDiv(numberPixelAlongX, numberOfJobs);
        int xStartIndex = 0;
        int xEndIndex = xIndexSlotSize;
        String family = "GetPixelsIntersectionTriangle";
        long startTime = System.currentTimeMillis();
        int jobNumber = 0;
        while (jobNumber < numberOfJobs) {
            String jobName = "GetPixel Intersection Triangle(" + Integer.toString(jobNumber + 1) + " of " + numberOfJobs + ") [" + xStartIndex + " ," + xEndIndex + "]";
            new GetPixelsIntersectionTrianglesJob(jobName, family, xStartIndex, xEndIndex, mesh, pixelsLocation, intersectionTriangles, kdTree, averagingRadius).schedule();
            xEndIndex = (xStartIndex += xIndexSlotSize + 1) + xIndexSlotSize;
            if (xEndIndex >= numberPixelAlongX) {
                xEndIndex = numberPixelAlongX - 1;
            }
            ++jobNumber;
        }
        try {
            IJobManager manager = Job.getJobManager();
            manager.join((Object)family, progressMonitor);
        }
        catch (Exception manager) {
            // empty catch block
        }
        progressMonitor.done();
        long endTime = System.currentTimeMillis();
        double duration = (double)(endTime - startTime) * 0.001;
        Logger.info("getPixelsIntersectionTriangle() completed in <" + duration + "> seconds.");
        return intersectionTriangles;
    }

    protected Point3d[][] getPixelsIntersectionPoints(Point3d[][] pixelsLocation, CartesianTriangularMesh mesh, KDTree kdTree, double averagingRadius, IProgressMonitor progressMonitor) {
        progressMonitor.subTask("Finding pixel intersection with mesh.");
        int numberPixelAlongX = pixelsLocation.length;
        int numberPixelAlongY = pixelsLocation[0].length;
        Point3d[][] intersectionPoints = new Point3d[numberPixelAlongX][numberPixelAlongY];
        int numberOfJobs = this.getNumberOfProcessorToUse();
        int xIndexSlotSize = Math.floorDiv(numberPixelAlongX, numberOfJobs);
        int xStartIndex = 0;
        int xEndIndex = xIndexSlotSize;
        String family = "GetPixelsIntersectionPoints";
        int jobNumber = 0;
        while (jobNumber < numberOfJobs) {
            String jobName = "GetPixel Intersection (" + Integer.toString(jobNumber + 1) + " of " + numberOfJobs + ") [" + xStartIndex + " ," + xEndIndex + "]";
            new GetPixelsIntersectionPointsJob(jobName, "GetPixelsIntersectionPoints", xStartIndex, xEndIndex, mesh, pixelsLocation, intersectionPoints, kdTree, averagingRadius).schedule();
            xEndIndex = (xStartIndex += xIndexSlotSize + 1) + xIndexSlotSize;
            if (xEndIndex >= numberPixelAlongX) {
                xEndIndex = numberPixelAlongX - 1;
            }
            ++jobNumber;
        }
        try {
            IJobManager manager = Job.getJobManager();
            manager.join((Object)family, progressMonitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        progressMonitor.done();
        Logger.info("getPixelsIntersectionPoints() completed.");
        return intersectionPoints;
    }

    protected Vector3d[][] getNormals(Point3d[][] pixelsLocation, CartesianTriangle[][] pixelsIntersectionTriangles, CartesianTriangularMesh mesh, KDTree kdTree, double averagingRadius, IProgressMonitor progressMonitor) {
        int numberPixelAlongX = pixelsLocation.length;
        int numberPixelAlongY = pixelsLocation[0].length;
        Vector3d[][] normalArray = new Vector3d[numberPixelAlongX][numberPixelAlongY];
        int numberOfJobs = this.getNumberOfProcessorToUse();
        int xIndexSlotSize = Math.floorDiv(numberPixelAlongX, numberOfJobs);
        int xStartIndex = 0;
        int xEndIndex = xIndexSlotSize;
        String family = "GetNormals";
        int jobNumber = 0;
        while (jobNumber < numberOfJobs) {
            String jobName = "GetNormals (" + Integer.toString(jobNumber + 1) + " of " + numberOfJobs + ") [" + xStartIndex + " ," + xEndIndex + "]";
            new GetNormalsJob(jobName, family, xStartIndex, xEndIndex, normalArray, pixelsLocation, pixelsIntersectionTriangles, mesh, kdTree, averagingRadius, progressMonitor).schedule();
            xEndIndex = (xStartIndex += xIndexSlotSize + 1) + xIndexSlotSize;
            if (xEndIndex >= numberPixelAlongX) {
                xEndIndex = numberPixelAlongX - 1;
            }
            ++jobNumber;
        }
        try {
            IJobManager manager = Job.getJobManager();
            manager.join((Object)family, progressMonitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        progressMonitor.done();
        return normalArray;
    }

    protected DirectedGraph<CartesianTriangle, DefaultEdge> createMeshGraph(CartesianTriangularMesh mesh, IProgressMonitor progressMonitor) {
        DefaultDirectedGraph directedGraph = new DefaultDirectedGraph(DefaultEdge.class);
        for (CartesianTriangle triangle : mesh.getPolygons()) {
            directedGraph.addVertex((Object)triangle);
        }
        for (CartesianTriangle triangle : mesh.getPolygons()) {
            EList neighbours = mesh.getPolygonNeighbours((Polygon)triangle);
            for (CartesianTriangle neighbour : neighbours) {
                if (!directedGraph.containsEdge((Object)triangle, (Object)neighbour)) {
                    directedGraph.addEdge((Object)triangle, (Object)neighbour);
                }
                if (directedGraph.containsEdge((Object)neighbour, (Object)triangle)) continue;
                directedGraph.addEdge((Object)neighbour, (Object)triangle);
            }
        }
        progressMonitor.done();
        return directedGraph;
    }

    protected BreadthFirstIterator<CartesianTriangle, DefaultEdge> createBreadthFirstIterator(DirectedGraph<CartesianTriangle, DefaultEdge> directedGraph, CartesianTriangle startTriangle) {
        if (startTriangle != null) {
            return new BreadthFirstIterator(directedGraph, (Object)startTriangle);
        }
        return new BreadthFirstIterator(directedGraph);
    }

    protected KDTree createTriangleKDTree(CartesianTriangularMesh mesh, IProgressMonitor progressMonitor) {
        CreateKDTreeJob job = new CreateKDTreeJob("Create KD Tree", "KDTreeCreation", mesh);
        try {
            job.setProgressGroup(progressMonitor, job.getNumberOfTicks());
            job.schedule();
            job.join();
            return job.getOutput();
        }
        catch (InterruptedException e) {
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected List<CartesianTriangle> findClosestTriangles(KDTree kdTree, Point3d centerPoint) {
        ArrayList<CartesianTriangle> closestTriangle = new ArrayList<CartesianTriangle>();
        double[] key = new double[]{centerPoint.getX(), centerPoint.getY()};
        try {
            Object[] range = kdTree.nearest(key, 6);
            int i = 0;
            while (i < range.length) {
                if (range[i] instanceof List) {
                    closestTriangle.addAll((List)range[i]);
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        catch (KeySizeException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return closestTriangle;
    }

    protected List<CartesianTriangle> findTrianglesWithinRadius(KDTree kdTree, double radius, Point3d centerPoint) {
        ArrayList<CartesianTriangle> trianglesWithinRadius = new ArrayList<CartesianTriangle>();
        this.getQueryBuffer1()[0] = centerPoint.getX() - Math.abs(radius);
        this.getQueryBuffer1()[1] = centerPoint.getY() - Math.abs(radius);
        this.getQueryBuffer2()[0] = centerPoint.getX() + Math.abs(radius);
        this.getQueryBuffer2()[1] = centerPoint.getY() + Math.abs(radius);
        try {
            Object[] range = kdTree.range(this.getQueryBuffer1(), this.getQueryBuffer2());
            int i = 0;
            while (i < range.length) {
                if (range[i] instanceof List) {
                    trianglesWithinRadius.addAll((List)range[i]);
                }
                ++i;
            }
        }
        catch (KeySizeException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return trianglesWithinRadius;
    }

    private double[] getQueryBuffer1() {
        if (this.queryBuffer1 == null) {
            this.queryBuffer1 = new double[2];
        }
        return this.queryBuffer1;
    }

    private double[] getQueryBuffer2() {
        if (this.queryBuffer2 == null) {
            this.queryBuffer2 = new double[2];
        }
        return this.queryBuffer2;
    }

    protected AbstractEImage convertToImage(int[][] pixelColors, IProgressMonitor progressMonitor) {
        int width = pixelColors.length;
        int height = pixelColors[0].length;
        BufferedImage bufferedImage = EImagesUtilities.INSTANCE.createTransparentImage(width, height).asBufferedImage();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int rgb = pixelColors[x][y];
                if (rgb != -1) {
                    bufferedImage.setRGB(x, height - 1 - y, rgb);
                }
                ++y;
            }
            progressMonitor.worked(height);
            ++x;
        }
        EImage eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        eImage.setImageContent(bufferedImage);
        return eImage;
    }

    protected Vector3d computeAverageNormal(CartesianTriangularMesh mesh, Point3d pixelLocation, CartesianTriangle triangle, double averagingRadius) {
        EList triangles = mesh.getPolygonNeighbours((Polygon)triangle);
        Vector3d normal = Geometry3DUtilities.getAreaWeightedAverageNormal((List)triangles);
        return normal;
    }

    protected int convertColor(RGBA color) {
        if (color == null) {
            return -1;
        }
        if (color.alpha == 0) {
            return -1;
        }
        RGB rgb = color.rgb;
        Color tmpColor = new Color((float)rgb.red / 255.0f, (float)rgb.green / 255.0f, (float)rgb.blue / 255.0f);
        return tmpColor.getRGB();
    }

    protected class CreateKDTreeJob
    extends CustomJob<KDTree> {
        protected CartesianTriangularMesh mesh;
        protected KDTree kdTree;

        public CreateKDTreeJob(String name, String family, CartesianTriangularMesh mesh) {
            super(name, family);
            this.mesh = null;
            this.mesh = mesh;
            this.numberOfTicks = mesh.getPolygons().size();
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Create KD Tree", this.numberOfTicks);
            Logger.info("KDTree building starts.");
            long startTime = System.currentTimeMillis();
            this.kdTree = new KDTree(2);
            long keyCount = 0L;
            for (CartesianTriangle triangle : this.mesh.getPolygons()) {
                for (CartesianPositionCoordinates vertex : triangle.getVertices()) {
                    EList triangles = this.mesh.getPolygonsSharingPoint((Coordinates)vertex);
                    triangles.add(triangle);
                    CartesianPositionCoordinates center = triangle.getCentroid();
                    double[] key = new double[]{center.getX(), center.getY()};
                    try {
                        this.kdTree.insert(key, (Object)triangles);
                        ++keyCount;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                monitor.worked(1);
            }
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) * 0.001;
            Logger.info("KDTree built completed. KDTree contains <" + keyCount + "> keys and was built in <" + duration + "> seconds.");
            return Status.OK_STATUS;
        }

        @Override
        public KDTree getOutput() {
            return this.kdTree;
        }
    }

    protected class CreatePixelLocationJob
    extends CustomJob<Point3d[][]> {
        protected CartesianTriangularMesh mesh;
        protected Point3d[][] points;
        protected int numberPixelAlongX;
        protected int numberPixelAlongY;
        protected RectangularRegion meshRegion;

        public CreatePixelLocationJob(String name, String family, CartesianTriangularMesh mesh) {
            super(name, family);
            this.mesh = null;
            this.numberPixelAlongX = 0;
            this.numberPixelAlongY = 0;
            this.mesh = mesh;
            this.meshRegion = (RectangularRegion)EcoreUtil.copy((EObject)CartesianTriangularMeshDerivedImageMapLayerCustomImpl.this.getRegion());
            this.numberPixelAlongX = (int)Math.round(this.meshRegion.getXDimension() / CartesianTriangularMeshDerivedImageMapLayerCustomImpl.this.getRequiredResolution());
            this.numberPixelAlongY = (int)Math.round(this.meshRegion.getYDimension() / CartesianTriangularMeshDerivedImageMapLayerCustomImpl.this.getRequiredResolution());
            this.numberOfTicks = this.numberPixelAlongX * this.numberPixelAlongY;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Create Pixel Location", this.numberOfTicks);
            this.points = new Point3d[this.numberPixelAlongX][this.numberPixelAlongY];
            double xIncrement = this.meshRegion.getXDimension() / (double)this.numberPixelAlongX;
            double yIncrement = this.meshRegion.getYDimension() / (double)this.numberPixelAlongY;
            double x = this.meshRegion.getXMin() + xIncrement / 2.0;
            int i = 0;
            while (i < this.numberPixelAlongX) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                double y = this.meshRegion.getYMin() + yIncrement / 2.0;
                int j = 0;
                while (j < this.numberPixelAlongY) {
                    Point3d point;
                    this.points[i][j] = point = new Point3d(x, y, 0.0);
                    y += yIncrement;
                    ++j;
                }
                monitor.worked(this.numberPixelAlongY);
                x += xIncrement;
                ++i;
            }
            return Status.OK_STATUS;
        }

        @Override
        public Point3d[][] getOutput() {
            return this.points;
        }
    }

    protected abstract class CustomJob<T>
    extends Job {
        protected String name;
        protected String family;
        protected int numberOfTicks;

        public CustomJob(String name, String family) {
            super(name);
            this.numberOfTicks = 0;
            this.name = name;
            this.family = family;
        }

        public boolean belongsTo(Object family) {
            return this.family.equals(family);
        }

        public int getNumberOfTicks() {
            return this.numberOfTicks;
        }

        public abstract T getOutput();
    }

    protected class GetNormalsJob
    extends ProcessPixelArrayJob<Vector3d[][]> {
        protected Vector3d[][] normalsArray;
        protected CartesianTriangle[][] pixelsIntersectionTriangles;
        protected KDTree kdTree;
        protected double averagingRadius;

        public GetNormalsJob(String name, String family, int xStartIndex, int xEndIndex, Vector3d[][] normalsArray, Point3d[][] pixelsLocation, CartesianTriangle[][] pixelsIntersectionTriangles, CartesianTriangularMesh mesh, KDTree kdTree, double averagingRadius, IProgressMonitor progressMonitor) {
            super(name, family, xStartIndex, xEndIndex, mesh, pixelsLocation);
            this.pixelsIntersectionTriangles = pixelsIntersectionTriangles;
            this.normalsArray = normalsArray;
            this.kdTree = kdTree;
            this.averagingRadius = averagingRadius;
            this.numberOfTicks = xEndIndex - xStartIndex;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getNumberOfTicks());
            subMonitor.beginTask("Get Pixel Intersections Triangles", this.numberOfTicks);
            int numberPixelAlongY = this.pixelsLocation[0].length;
            int i = this.xStartIndex;
            while (i <= this.xEndIndex) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int j = 0;
                while (j < numberPixelAlongY) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    CartesianTriangle triangle = this.pixelsIntersectionTriangles[i][j];
                    if (triangle != null) {
                        this.normalsArray[i][j] = CartesianTriangularMeshDerivedImageMapLayerCustomImpl.this.computeAverageNormal(this.mesh, this.pixelsLocation[i][j], triangle, this.averagingRadius);
                    }
                    ++j;
                }
                subMonitor.worked(1);
                ++i;
            }
            subMonitor.done();
            return Status.OK_STATUS;
        }

        @Override
        public Vector3d[][] getOutput() {
            return this.normalsArray;
        }
    }

    protected class GetPixelsIntersectionPointsJob
    extends ProcessPixelArrayJob<Point3d[][]> {
        protected KDTree kdTree;
        protected Point3d[][] intersectionPoints;
        protected double averagingRadius;

        public GetPixelsIntersectionPointsJob(String name, String family, int xStartIndex, int xEndIndex, CartesianTriangularMesh mesh, Point3d[][] pixelsLocation, Point3d[][] intersectionPoints, KDTree kdTree, double averagingRadius) {
            super(name, family, xStartIndex, xEndIndex, mesh, pixelsLocation);
            this.averagingRadius = 0.0;
            this.kdTree = kdTree;
            this.intersectionPoints = intersectionPoints;
            this.averagingRadius = averagingRadius;
            this.numberOfTicks = xEndIndex - xStartIndex;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getNumberOfTicks());
            subMonitor.beginTask("Get Pixel Intersections", this.numberOfTicks);
            int numberPixelAlongY = this.pixelsLocation[0].length;
            int i = this.xStartIndex;
            while (i <= this.xEndIndex) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int j = 0;
                while (j < numberPixelAlongY) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Point3d point = this.pixelsLocation[i][j];
                    List<CartesianTriangle> triangles = CartesianTriangularMeshDerivedImageMapLayerCustomImpl.this.findClosestTriangles(this.kdTree, point);
                    Iterator<CartesianTriangle> it = triangles.iterator();
                    CartesianPositionCoordinates projection = null;
                    while (it.hasNext() && projection == null) {
                        projection = Geometry3DUtilities.getProjectionAlongAxisOnToPolygon((CartesianAxis)CartesianAxis.Z, (Point3d)point, (CartesianPolygon)((CartesianPolygon)it.next()));
                        if (projection == null) continue;
                        this.intersectionPoints[i][j] = projection.asPoint3d();
                    }
                    ++j;
                }
                subMonitor.worked(1);
                ++i;
            }
            return Status.OK_STATUS;
        }

        @Override
        public Point3d[][] getOutput() {
            return this.intersectionPoints;
        }

        protected Point3d getAveragedHeight(KDTree kdTree, CartesianPositionCoordinates projection, double averagingRadius) {
            if (averagingRadius > 0.0) {
                List<CartesianTriangle> triangles = CartesianTriangularMeshDerivedImageMapLayerCustomImpl.this.findTrianglesWithinRadius(kdTree, averagingRadius, projection.asPoint3d());
                double averagedHeight = 0.0;
                double totalSurface = 0.0;
                for (CartesianTriangle triangle : triangles) {
                    averagedHeight += (totalSurface += triangle.getSurface()) * triangle.getCentroid().getZ();
                }
                return new Point3d(projection.getX(), projection.getY(), averagedHeight /= totalSurface);
            }
            return projection.asPoint3d();
        }
    }

    protected class GetPixelsIntersectionTrianglesJob
    extends ProcessPixelArrayJob<CartesianTriangle[][]> {
        protected KDTree kdTree;
        protected CartesianTriangle[][] intersectionTriangles;
        protected double averagingRadius;

        public GetPixelsIntersectionTrianglesJob(String name, String family, int xStartIndex, int xEndIndex, CartesianTriangularMesh mesh, Point3d[][] pixelsLocation, CartesianTriangle[][] intersectionTriangles, KDTree kdTree, double averagingRadius) {
            super(name, family, xStartIndex, xEndIndex, mesh, pixelsLocation);
            this.averagingRadius = 0.0;
            this.kdTree = kdTree;
            this.averagingRadius = averagingRadius;
            this.intersectionTriangles = intersectionTriangles;
            this.numberOfTicks = xEndIndex - xStartIndex;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getNumberOfTicks());
            subMonitor.beginTask("Get Pixel Intersections Triangles", this.numberOfTicks);
            int numberPixelAlongY = this.pixelsLocation[0].length;
            int i = this.xStartIndex;
            while (i <= this.xEndIndex) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int j = 0;
                while (j < numberPixelAlongY) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Point3d point = this.pixelsLocation[i][j];
                    List<CartesianTriangle> triangles = CartesianTriangularMeshDerivedImageMapLayerCustomImpl.this.findClosestTriangles(this.kdTree, point);
                    Iterator<CartesianTriangle> it = triangles.iterator();
                    CartesianPositionCoordinates projection = null;
                    while (it.hasNext() && projection == null) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        CartesianTriangle triangle = it.next();
                        projection = Geometry3DUtilities.getProjectionAlongAxisOnToPolygon((CartesianAxis)CartesianAxis.Z, (Point3d)point, (CartesianPolygon)triangle);
                        if (projection == null) continue;
                        this.intersectionTriangles[i][j] = triangle;
                    }
                    ++j;
                }
                subMonitor.worked(1);
                ++i;
            }
            subMonitor.done();
            return Status.OK_STATUS;
        }

        @Override
        public CartesianTriangle[][] getOutput() {
            return this.intersectionTriangles;
        }
    }

    protected abstract class ProcessPixelArrayJob<T>
    extends CustomJob<T> {
        protected int xStartIndex;
        protected int xEndIndex;
        protected Point3d[][] pixelsLocation;
        protected CartesianTriangularMesh mesh;

        public ProcessPixelArrayJob(String name, String family, int xStartIndex, int xEndIndex, CartesianTriangularMesh mesh, Point3d[][] pixelsLocation) {
            super(name, family);
            this.xStartIndex = 0;
            this.xEndIndex = 0;
            this.xStartIndex = xStartIndex;
            this.xEndIndex = xEndIndex;
            this.mesh = mesh;
            this.pixelsLocation = pixelsLocation;
        }
    }
}

