/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import edu.wlu.cs.levy.CG.KDTree;
import java.text.DecimalFormat;
import java.util.Iterator;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.RectangularVolumeRegion;
import org.eclipse.apogy.core.environment.surface.impl.CartesianTriangularMeshDerivedImageMapLayerCustomImpl;
import org.eclipse.apogy.core.environment.surface.impl.FixedPositionLineOfSightImageMapLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedPositionLineOfSightImageMapLayerCustomImpl
extends FixedPositionLineOfSightImageMapLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(FixedPositionLineOfSightImageMapLayerImpl.class);
    private DecimalFormat decimalFormat = new DecimalFormat("0.00");

    @Override
    public void updateImage(IProgressMonitor progressMonitor) {
        CartesianTriangularMesh mesh;
        if (this.getCartesianTriangularMeshMapLayer() != null && (mesh = this.getCartesianTriangularMeshMapLayer().getCurrentMesh()) != null) {
            SubMonitor subMonitor = null;
            subMonitor = this.isUseHeightPerpendicularToGround() ? SubMonitor.convert((IProgressMonitor)progressMonitor, (int)6) : SubMonitor.convert((IProgressMonitor)progressMonitor, (int)4);
            long startTime = System.currentTimeMillis();
            RectangularVolumeRegion meshRegion = this.getRectangularVolumeRegion();
            if (meshRegion.getXDimension() > 0.0 && meshRegion.getYDimension() > 0.0) {
                progressMonitor.subTask("Generating pixel locations");
                Point3d[][] pixelsLocation = this.getPixelsLocation(this.getCartesianTriangularMeshMapLayer().getCurrentMesh(), (IProgressMonitor)subMonitor.newChild(1));
                progressMonitor.worked(1);
                int numberPixelAlongX = pixelsLocation.length;
                int numberPixelAlongY = pixelsLocation[0].length;
                double xIncrement = meshRegion.getXDimension() / (double)numberPixelAlongX;
                double yIncrement = meshRegion.getYDimension() / (double)numberPixelAlongY;
                double averagingRadius = Math.sqrt(xIncrement * xIncrement + yIncrement * yIncrement);
                progressMonitor.subTask("Create KD tree");
                KDTree kdTree = this.createTriangleKDTree(mesh, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.worked(1);
                if (progressMonitor.isCanceled()) {
                    return;
                }
                progressMonitor.subTask("Find pixel intersection");
                this.pixelsIntersectionPoints = this.getPixelsIntersectionPoints(pixelsLocation, mesh, kdTree, averagingRadius, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.worked(1);
                if (progressMonitor.isCanceled()) {
                    return;
                }
                this.lineOfSights = null;
                if (this.isUseHeightPerpendicularToGround()) {
                    CartesianTriangle[][] pixelsIntersectionTriangles = this.getPixelsIntersectionTriangle(pixelsLocation, mesh, kdTree, averagingRadius, progressMonitor);
                    subMonitor.worked(1);
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    this.pixelNormals = this.getNormals(pixelsLocation, pixelsIntersectionTriangles, mesh, kdTree, averagingRadius, progressMonitor);
                    subMonitor.worked(1);
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    this.lineOfSights = this.getLineOfSights(this.pixelsIntersectionPoints, this.pixelNormals, mesh, this.getObserverPosition(), this.targetHeightAboveGround, progressMonitor);
                    progressMonitor.worked(1);
                } else {
                    progressMonitor.subTask("Find line of sight");
                    this.lineOfSights = this.getLineOfSights(this.pixelsIntersectionPoints, mesh, this.getObserverPosition(), this.getTargetHeightAboveGround(), progressMonitor);
                    progressMonitor.worked(1);
                }
                if (progressMonitor.isCanceled()) {
                    return;
                }
                int[][] pixelColors = this.getPixelsColor(this.lineOfSights);
                if (progressMonitor.isCanceled()) {
                    return;
                }
                AbstractEImage image = this.convertToImage(pixelColors, (IProgressMonitor)subMonitor.newChild(1));
                long endTime = System.currentTimeMillis();
                double duration = (double)(endTime - startTime) * 0.001;
                Logger.info("Updated image in <" + this.decimalFormat.format(duration) + "> seconds.");
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__IMAGE, (Object)image, true);
            }
        }
    }

    protected short[][] getLineOfSights(Point3d[][] pixelsIntersectionPoints, CartesianTriangularMesh mesh, Tuple3d observerPose, double targetHeightAboveGround, IProgressMonitor progressMonitor) {
        progressMonitor.subTask("Finding line of sights.");
        Logger.info("getLineOfSights() starts.");
        int numberPixelAlongX = pixelsIntersectionPoints.length;
        int numberPixelAlongY = pixelsIntersectionPoints[0].length;
        short[][] lineOfSights = new short[numberPixelAlongX][numberPixelAlongY];
        int numberOfJobs = this.getNumberOfProcessorToUse();
        int xIndexSlotSize = Math.floorDiv(numberPixelAlongX, numberOfJobs);
        int xStartIndex = 0;
        int xEndIndex = xIndexSlotSize;
        String family = "GetLineOfSight";
        int jobNumber = 0;
        while (jobNumber < numberOfJobs) {
            String jobName = "Get Line Of Sight (" + Integer.toString(jobNumber + 1) + " of " + numberOfJobs + ") [" + xStartIndex + " ," + xEndIndex + "]";
            new GetLineOfSightsJob(jobName, family, xStartIndex, xEndIndex, pixelsIntersectionPoints, mesh, lineOfSights).schedule();
            xEndIndex = (xStartIndex += xIndexSlotSize + 1) + xIndexSlotSize;
            if (xEndIndex >= numberPixelAlongX) {
                xEndIndex = numberPixelAlongX - 1;
            }
            ++jobNumber;
        }
        try {
            IJobManager manager = Job.getJobManager();
            manager.join((Object)family, progressMonitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        progressMonitor.done();
        Logger.info("getLineOfSights() completed.");
        return lineOfSights;
    }

    protected short[][] getLineOfSights(Point3d[][] pixelsIntersectionPoints, Vector3d[][] pixelsNormals, CartesianTriangularMesh mesh, Tuple3d observerPose, double targetHeightAboveGround, IProgressMonitor progressMonitor) {
        progressMonitor.subTask("Finding line of sights.");
        int numberPixelAlongX = pixelsNormals.length;
        int numberPixelAlongY = pixelsNormals[0].length;
        short[][] lineOfSights = new short[numberPixelAlongX][numberPixelAlongY];
        int numberOfJobs = this.getNumberOfProcessorToUse();
        int xIndexSlotSize = Math.floorDiv(numberPixelAlongX, numberOfJobs);
        int xStartIndex = 0;
        int xEndIndex = xIndexSlotSize;
        String family = "GetLineOfSightJob";
        int jobNumber = 0;
        while (jobNumber < numberOfJobs) {
            String jobName = "Get Line Of Sight (" + Integer.toString(jobNumber + 1) + " of " + numberOfJobs + ") [" + xStartIndex + " ," + xEndIndex + "]";
            new GetLineOfSightsPerpendicularToGroundJob(jobName, family, xStartIndex, xEndIndex, pixelsIntersectionPoints, pixelsNormals, mesh, lineOfSights).schedule();
            xEndIndex = (xStartIndex += xIndexSlotSize + 1) + xIndexSlotSize;
            if (xEndIndex >= numberPixelAlongX) {
                xEndIndex = numberPixelAlongX - 1;
            }
            ++jobNumber;
        }
        try {
            IJobManager manager = Job.getJobManager();
            manager.join((Object)family, progressMonitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        progressMonitor.done();
        Logger.info("getLineOfSights() completed.");
        return lineOfSights;
    }

    @Override
    protected int[][] getPixelsColor(short[][] lineOfSights) {
        int numberPixelAlongX = lineOfSights.length;
        int numberPixelAlongY = lineOfSights[0].length;
        int lineOfSightRGB = this.getLineOfSightColor();
        int noLineOfSightRGB = this.noLineOfSightColor();
        int[][] pixelColors = new int[numberPixelAlongX][numberPixelAlongY];
        int i = 0;
        while (i < numberPixelAlongX) {
            int j = 0;
            while (j < numberPixelAlongY) {
                short data = lineOfSights[i][j];
                switch (data) {
                    case 2: {
                        pixelColors[i][j] = lineOfSightRGB;
                        break;
                    }
                    case 1: {
                        pixelColors[i][j] = noLineOfSightRGB;
                        break;
                    }
                    case 0: {
                        pixelColors[i][j] = -1;
                    }
                }
                ++j;
            }
            ++i;
        }
        return pixelColors;
    }

    protected int getLineOfSightColor() {
        return this.convertColor(this.getLineOfSightAvailableColor());
    }

    protected int noLineOfSightColor() {
        return this.convertColor(this.getLineOfSightNotAvailableColor());
    }

    protected class GetLineOfSightsJob
    extends CartesianTriangularMeshDerivedImageMapLayerCustomImpl.ProcessPixelArrayJob<short[][]> {
        protected Point3d[][] pixelsIntersectionPoints;
        protected short[][] lineOfSights;

        public GetLineOfSightsJob(String name, String family, int xStartIndex, int xEndIndex, Point3d[][] pixelsIntersectionPoints, CartesianTriangularMesh mesh, short[][] lineOfSights) {
            super(FixedPositionLineOfSightImageMapLayerCustomImpl.this, name, family, xStartIndex, xEndIndex, mesh, null);
            this.pixelsIntersectionPoints = pixelsIntersectionPoints;
            this.lineOfSights = lineOfSights;
            this.numberOfTicks = xEndIndex - xStartIndex;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getNumberOfTicks());
            subMonitor.beginTask("Get Line Of Sight", this.numberOfTicks);
            int numberPixelAlongY = this.pixelsIntersectionPoints[0].length;
            Vector3d observerPosition = new Vector3d(FixedPositionLineOfSightImageMapLayerCustomImpl.this.getObserverPosition().asTuple3d());
            double heightAboveGround = FixedPositionLineOfSightImageMapLayerCustomImpl.this.getTargetHeightAboveGround();
            int i = this.xStartIndex;
            while (i <= this.xEndIndex) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int j = 0;
                while (j < numberPixelAlongY) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Point3d positionOnSurface = this.pixelsIntersectionPoints[i][j];
                    if (positionOnSurface != null) {
                        Vector3d target = new Vector3d(positionOnSurface.x, positionOnSurface.y, positionOnSurface.z + heightAboveGround);
                        Point3d intersection = null;
                        Iterator it = this.mesh.getPolygons().iterator();
                        while (intersection == null && it.hasNext()) {
                            CartesianTriangle triangle = (CartesianTriangle)it.next();
                            intersection = Geometry3DUtilities.getLineAndPolygonIntersectionPoint((Vector3d)observerPosition, (Vector3d)target, (CartesianPolygon)triangle);
                        }
                        this.lineOfSights[i][j] = intersection == null ? 2 : 1;
                    } else {
                        this.lineOfSights[i][j] = 0;
                    }
                    ++j;
                }
                subMonitor.worked(1);
                ++i;
            }
            return Status.OK_STATUS;
        }

        @Override
        public short[][] getOutput() {
            return this.lineOfSights;
        }
    }

    protected class GetLineOfSightsPerpendicularToGroundJob
    extends CartesianTriangularMeshDerivedImageMapLayerCustomImpl.ProcessPixelArrayJob<short[][]> {
        protected Point3d[][] pixelsIntersectionPoints;
        protected Vector3d[][] pixelsNormals;
        protected short[][] lineOfSights;

        public GetLineOfSightsPerpendicularToGroundJob(String name, String family, int xStartIndex, int xEndIndex, Point3d[][] pixelsIntersectionPoints, Vector3d[][] pixelsNormals, CartesianTriangularMesh mesh, short[][] lineOfSights) {
            super(FixedPositionLineOfSightImageMapLayerCustomImpl.this, name, family, xStartIndex, xEndIndex, mesh, null);
            this.pixelsIntersectionPoints = pixelsIntersectionPoints;
            this.pixelsNormals = pixelsNormals;
            this.lineOfSights = lineOfSights;
            this.numberOfTicks = xEndIndex - xStartIndex;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getNumberOfTicks());
            subMonitor.beginTask("Get Line Of Sight Perpendicular To Ground", this.numberOfTicks);
            int numberPixelAlongY = this.pixelsIntersectionPoints[0].length;
            Vector3d observerPosition = new Vector3d(FixedPositionLineOfSightImageMapLayerCustomImpl.this.getObserverPosition().asTuple3d());
            double heightAboveGround = FixedPositionLineOfSightImageMapLayerCustomImpl.this.getTargetHeightAboveGround();
            int i = this.xStartIndex;
            while (i <= this.xEndIndex) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int j = 0;
                while (j < numberPixelAlongY) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Point3d positionOnSurface = this.pixelsIntersectionPoints[i][j];
                    if (positionOnSurface != null) {
                        Vector3d target = new Vector3d(positionOnSurface.x, positionOnSurface.y, positionOnSurface.z + heightAboveGround);
                        Vector3d antennaPosition = new Vector3d(this.pixelsNormals[i][j]);
                        antennaPosition.scale(heightAboveGround);
                        target.add((javax.vecmath.Tuple3d)antennaPosition);
                        Point3d intersection = null;
                        Iterator it = this.mesh.getPolygons().iterator();
                        while (intersection == null && it.hasNext()) {
                            CartesianTriangle triangle = (CartesianTriangle)it.next();
                            intersection = Geometry3DUtilities.getLineAndPolygonIntersectionPoint((Vector3d)observerPosition, (Vector3d)target, (CartesianPolygon)triangle);
                        }
                        this.lineOfSights[i][j] = intersection == null ? 2 : 1;
                    } else {
                        this.lineOfSights[i][j] = 0;
                    }
                    ++j;
                }
                subMonitor.worked(1);
                ++i;
            }
            return Status.OK_STATUS;
        }

        @Override
        public short[][] getOutput() {
            return this.lineOfSights;
        }
    }
}

