/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.impl;

import java.util.Date;
import java.util.Iterator;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFactory;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.SkyNode;
import org.eclipse.apogy.core.environment.StarField;
import org.eclipse.apogy.core.environment.Sun;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.impl.SkyImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;

public class SkyCustomImpl
extends SkyImpl {
    protected Adapter worksiteAdapter;

    protected SkyCustomImpl() {
        this.eAdapters().add((Object)this.getWorksiteAdapter());
    }

    @Override
    public NotificationChain basicSetWorksite(Worksite newWorksite, NotificationChain msgs) {
        if (this.basicGetWorksite() != null) {
            this.basicGetWorksite().eAdapters().remove((Object)this.getWorksiteAdapter());
        }
        if (newWorksite != null) {
            newWorksite.eAdapters().add((Object)this.getWorksiteAdapter());
        }
        return super.basicSetWorksite(newWorksite, msgs);
    }

    @Override
    public SkyNode getSkyNode() {
        if (super.getSkyNode() == null) {
            this.skyNode = ApogyCoreEnvironmentFactory.eINSTANCE.createSkyNode();
            ApogyCoreEnvironmentFacade.INSTANCE.initializeSkyNode(this.skyNode);
            this.skyNode.setSky(this);
        }
        return super.getSkyNode();
    }

    @Override
    public Sun getSun() {
        if (this.basicGetSun() == null) {
            this.sun = this.findSunInTopology();
        }
        return this.sun;
    }

    @Override
    public StarField getStarField() {
        if (this.basicGetStarField() == null) {
            this.starField = this.findStarFieldInTopology();
        }
        return this.starField;
    }

    @Override
    public double getSunAngularDiameter() {
        double angularDiameter = Math.toRadians(0.535833333);
        return angularDiameter;
    }

    private Sun findSunInTopology() {
        Sun sunFound = null;
        EList children = this.getSkyNode().getChildren();
        Iterator it = children.iterator();
        while (it.hasNext() && sunFound == null) {
            Node node = (Node)it.next();
            if (!(node instanceof TransformNode)) continue;
            TransformNode t = (TransformNode)node;
            EList tChildren = t.getChildren();
            Iterator tIt = tChildren.iterator();
            while (tIt.hasNext() && sunFound == null) {
                Node n = (Node)tIt.next();
                if (!(n instanceof Sun)) continue;
                sunFound = (Sun)n;
            }
        }
        return sunFound;
    }

    private StarField findStarFieldInTopology() {
        StarField foundStarField = null;
        EList children = this.getSkyNode().getChildren();
        Iterator it = children.iterator();
        while (it.hasNext() && foundStarField == null) {
            Node node = (Node)it.next();
            if (!(node instanceof TransformNode)) continue;
            TransformNode t = (TransformNode)node;
            EList tChildren = t.getChildren();
            Iterator tIt = tChildren.iterator();
            while (tIt.hasNext() && foundStarField == null) {
                Node n = (Node)tIt.next();
                if (!(n instanceof StarField)) continue;
                foundStarField = (StarField)n;
            }
        }
        return foundStarField;
    }

    protected Adapter getWorksiteAdapter() {
        if (this.worksiteAdapter == null) {
            this.worksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof AbstractWorksite) {
                        int featureId = msg.getFeatureID(AbstractWorksite.class);
                        if (featureId == 2 && msg.getNewValue() instanceof Date) {
                            Date newDate = (Date)msg.getNewValue();
                            SkyCustomImpl.this.setTime(newDate);
                        }
                    } else if (msg.getNotifier() instanceof Sky) {
                        int featureId = msg.getFeatureID(Sky.class);
                        switch (featureId) {
                            case 1: {
                                if (msg.getOldValue() instanceof Worksite) {
                                    Worksite oldWorksite = (Worksite)msg.getOldValue();
                                    oldWorksite.eAdapters().remove((Object)SkyCustomImpl.this.getWorksiteAdapter());
                                }
                                if (!(msg.getNewValue() instanceof Worksite)) break;
                                Worksite newWorksite = (Worksite)msg.getNewValue();
                                newWorksite.eAdapters().add((Object)SkyCustomImpl.this.getWorksiteAdapter());
                                SkyCustomImpl.this.setTime(newWorksite.getTime());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.worksiteAdapter;
    }
}

