/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import java.text.DecimalFormat;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.PoseProvider;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.VariablesList;
import org.eclipse.apogy.core.invocator.ui.composites.VariableFeatureReferenceComposite;
import org.eclipse.apogy.core.ui.composites.ApogySystemApiAdapterBasedComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ApogySystemPoseComposite
extends ApogySystemApiAdapterBasedComposite {
    public static final String DEGREE_STRING = "\u00b0";
    public static final int ATTITUDE_INDICATOR_WIDTH = 200;
    public static final int ATTITUDE_INDICATOR_HEIGHT = 200;
    private Adapter poseAdapter;
    private VariablesList variables;
    private Tuple3d previousPosition = null;
    private final Tuple3d position = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
    private final Tuple3d orientation = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
    private double minimumDeltaPosition = 0.05;
    private double tripDistance = 0.0;
    private final DecimalFormat distanceFormat = new DecimalFormat("0.00");
    private Text txtVariableFeatureReference;
    private Text txtTripDistance;
    private Button btnTripReset;
    private Button btnTripSet;
    private Tuple3dComposite translationComposite;
    private Tuple3dComposite rotationComposite;

    public ApogySystemPoseComposite(Composite parent, int style) {
        this(parent, style, null, null, 0.0);
    }

    public ApogySystemPoseComposite(Composite parent, int style, VariablesList variables, VariableFeatureReference variableFeatureReference, double tripDistance) {
        super(parent, style);
        this.tripDistance = tripDistance;
        this.variables = variables;
        GridLayout layout = new GridLayout(4, false);
        this.setLayout((Layout)layout);
        Label lblVariableFeatureReference = new Label((Composite)this, 0);
        lblVariableFeatureReference.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVariableFeatureReference.setText("Variable Feature : ");
        this.txtVariableFeatureReference = new Text((Composite)this, 2048);
        GridData gd_txtVariableFeatureReference = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_txtVariableFeatureReference.widthHint = 300;
        this.txtVariableFeatureReference.setLayoutData((Object)gd_txtVariableFeatureReference);
        Button btnSelectVariableFeatureReference = new Button((Composite)this, 8);
        btnSelectVariableFeatureReference.setText("Select...");
        btnSelectVariableFeatureReference.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                Dialog dialog = new Dialog(shell){
                    VariableFeatureReferenceComposite vfrComposite;
                    {
                        this.vfrComposite = null;
                    }

                    protected Control createDialogArea(Composite parent) {
                        Composite area = (Composite)super.createDialogArea(parent);
                        this.vfrComposite = new VariableFeatureReferenceComposite(area, 0);
                        this.vfrComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
                        this.vfrComposite.setRootEObject((EObject)ApogySystemPoseComposite.this.getVariableFeatureReference());
                        return area;
                    }

                    public boolean close() {
                        if (this.vfrComposite != null && !this.vfrComposite.isDisposed()) {
                            this.vfrComposite.setRootEObject(null);
                            this.vfrComposite.dispose();
                        }
                        return super.close();
                    }
                };
                int result = dialog.open();
                if (result == 0) {
                    ApogySystemPoseComposite.this.updateDisplayedVariableFeatureReference();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblPOdometer = new Label((Composite)this, 0);
        lblPOdometer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPOdometer.setText("Trip Odometer (m):");
        this.txtTripDistance = new Text((Composite)this, 2052);
        this.txtTripDistance.setText(this.distanceFormat.format(this.tripDistance));
        this.txtTripDistance.setEnabled(false);
        GridData gd_lblTripdistancelabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTripdistancelabel.widthHint = 150;
        gd_lblTripdistancelabel.minimumWidth = 150;
        this.txtTripDistance.setLayoutData((Object)gd_lblTripdistancelabel);
        this.btnTripReset = new Button((Composite)this, 0);
        this.btnTripReset.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.btnTripReset.setText("Reset");
        this.btnTripReset.setEnabled(false);
        this.btnTripReset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ApogySystemPoseComposite.this.setTripDistance(0.0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnTripSet = new Button((Composite)this, 0);
        this.btnTripSet.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.btnTripSet.setText("Set To Value");
        this.btnTripSet.setEnabled(false);
        this.btnTripSet.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OdometrySetValueDialog dialog = new OdometrySetValueDialog(ApogySystemPoseComposite.this.getShell());
                if (dialog.open() == 0) {
                    ApogySystemPoseComposite.this.setTripDistance(dialog.tripDistanceValue);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblPosition = new Label((Composite)this, 0);
        lblPosition.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPosition.setAlignment(131072);
        lblPosition.setText("Position (m):");
        this.translationComposite = new Tuple3dComposite((Composite)this, 0, "0.00");
        this.translationComposite.setEnabled(false);
        GridData gd_translationComposite = new GridData(16384, 0x1000000, false, false, 3, 1);
        gd_translationComposite.minimumWidth = 300;
        gd_translationComposite.widthHint = 300;
        this.translationComposite.setLayoutData((Object)gd_translationComposite);
        this.translationComposite.setTuple3d(this.position);
        this.translationComposite.setEnableEditing(false);
        Label lblOrientation = new Label((Composite)this, 0);
        lblOrientation.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOrientation.setAlignment(131072);
        lblOrientation.setText("Orientation (\u00b0):");
        this.rotationComposite = new Tuple3dComposite((Composite)this, 0, "0.0");
        this.rotationComposite.setEnabled(false);
        GridData gd_rotationComposite = new GridData(16384, 0x1000000, false, false, 3, 1);
        gd_rotationComposite.minimumWidth = 300;
        gd_rotationComposite.widthHint = 300;
        this.rotationComposite.setLayoutData((Object)gd_rotationComposite);
        this.rotationComposite.setTuple3d(this.orientation);
        this.rotationComposite.setEnableEditing(false);
        this.setVariableFeatureReference(variableFeatureReference);
        this.updateDisplayedVariableFeatureReference();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ApogySystemPoseComposite.this.getApogySystemApiAdapter() != null) {
                    ApogySystemPoseComposite.this.getApogySystemApiAdapter().eAdapters().remove((Object)ApogySystemPoseComposite.this.getPoseAdapter());
                }
                if (!ApogySystemPoseComposite.this.translationComposite.isDisposed()) {
                    ApogySystemPoseComposite.this.translationComposite.setTuple3d(null);
                }
                if (!ApogySystemPoseComposite.this.rotationComposite.isDisposed()) {
                    ApogySystemPoseComposite.this.rotationComposite.setTuple3d(null);
                }
            }
        });
    }

    public double getTripDistance() {
        return this.tripDistance;
    }

    public void setTripDistance(final double tripDistance) {
        this.tripDistance = tripDistance;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ApogySystemPoseComposite.this.txtTripDistance != null && !ApogySystemPoseComposite.this.txtTripDistance.isDisposed()) {
                    ApogySystemPoseComposite.this.txtTripDistance.setText(ApogySystemPoseComposite.this.distanceFormat.format(tripDistance));
                }
            }
        });
    }

    @Override
    protected void apogySystemApiAdapterChanged(final ApogySystemApiAdapter oldApogySystemApiAdapter, final ApogySystemApiAdapter newApogySystemApiAdapter) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ApogySystemPoseComposite.this.updateApogySystemApiAdapter(oldApogySystemApiAdapter, newApogySystemApiAdapter);
            }
        });
    }

    public void setVariableList(VariablesList variables) {
        this.variables = variables;
    }

    @Override
    public void setVariableFeatureReference(VariableFeatureReference newVariableFeatureReference) {
        super.setVariableFeatureReference(newVariableFeatureReference);
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ApogySystemPoseComposite.this.updateDisplayedVariableFeatureReference();
            }
        });
    }

    public double getMinimumDeltaPosition() {
        return this.minimumDeltaPosition;
    }

    public void setMinimumDeltaPosition(double minimumDeltaPosition) {
        this.minimumDeltaPosition = minimumDeltaPosition;
    }

    protected void updateApogySystemApiAdapter(ApogySystemApiAdapter oldApogySystemApiAdapter, ApogySystemApiAdapter newApogySystemApiAdapter) {
        if (oldApogySystemApiAdapter != null) {
            oldApogySystemApiAdapter.eAdapters().remove((Object)this.getPoseAdapter());
        }
        if (newApogySystemApiAdapter != null) {
            this.updatePose(newApogySystemApiAdapter.getPoseTransform());
            newApogySystemApiAdapter.eAdapters().add((Object)this.getPoseAdapter());
        }
        this.setDisplaysEnabled(newApogySystemApiAdapter != null);
    }

    protected void setDisplaysEnabled(boolean enabled) {
        if (this.translationComposite != null && !this.translationComposite.isDisposed()) {
            this.translationComposite.setEnabled(enabled);
        }
        if (this.rotationComposite != null && !this.rotationComposite.isDisposed()) {
            this.rotationComposite.setEnabled(enabled);
        }
        if (this.txtTripDistance != null && !this.txtTripDistance.isDisposed()) {
            this.txtTripDistance.setEnabled(enabled);
        }
        if (this.btnTripReset != null && !this.btnTripReset.isDisposed()) {
            this.btnTripReset.setEnabled(enabled);
        }
        if (this.btnTripSet != null && !this.btnTripSet.isDisposed()) {
            this.btnTripSet.setEnabled(enabled);
        }
    }

    protected void updateDisplayedVariableFeatureReference() {
        if (this.txtVariableFeatureReference != null && !this.txtVariableFeatureReference.isDisposed()) {
            String text = ApogyCoreInvocatorFacade.INSTANCE.getVariableFeatureReferenceString(this.getVariableFeatureReference());
            this.txtVariableFeatureReference.setText(text);
        }
    }

    protected void updatePose(Matrix4x4 newPose) {
        if (newPose != null) {
            Tuple3d pos = ApogyCommonMathFacade.INSTANCE.extractPosition(newPose);
            this.position.setX(pos.getX());
            this.position.setY(pos.getY());
            this.position.setZ(pos.getZ());
            Tuple3d ori = ApogyCommonMathFacade.INSTANCE.extractOrientation(newPose);
            this.orientation.setX(Math.toDegrees(ori.getX()));
            this.orientation.setY(Math.toDegrees(ori.getY()));
            this.orientation.setZ(Math.toDegrees(ori.getZ()));
            if (this.previousPosition != null) {
                Point3d p1;
                Point3d p0 = new Point3d(this.previousPosition.asTuple3d());
                double distanceDelta = p0.distance(p1 = new Point3d(pos.asTuple3d()));
                if (distanceDelta >= this.minimumDeltaPosition) {
                    this.tripDistance += distanceDelta;
                    this.previousPosition = (Tuple3d)EcoreUtil.copy((EObject)this.position);
                }
            } else {
                this.previousPosition = (Tuple3d)EcoreUtil.copy((EObject)this.position);
            }
            if (this.txtTripDistance != null && !this.txtTripDistance.isDisposed()) {
                this.txtTripDistance.setText(this.distanceFormat.format(this.tripDistance));
            }
        }
    }

    protected Adapter getPoseAdapter() {
        if (this.poseAdapter == null) {
            this.poseAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof PoseProvider) {
                        int featureID = msg.getFeatureID(PoseProvider.class);
                        switch (featureID) {
                            case 0: {
                                if (!(msg.getNewValue() instanceof Matrix4x4)) break;
                                final Matrix4x4 newPose = (Matrix4x4)msg.getNewValue();
                                if (ApogySystemPoseComposite.this.isDisposed()) break;
                                ApogySystemPoseComposite.this.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ApogySystemPoseComposite.this.updatePose(newPose);
                                    }
                                });
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.poseAdapter;
    }

    private class OdometrySetValueDialog
    extends Dialog {
        public double tripDistanceValue;

        public OdometrySetValueDialog(Shell parentShell) {
            super(parentShell);
            this.tripDistanceValue = 0.0;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(container, 0);
            label.setText("Trip distance (m) :");
            final Text text = new Text(container, 2048);
            text.setText("0.0");
            GridData gd = new GridData(16384, 0x1000000, false, false);
            gd.minimumWidth = 250;
            gd.widthHint = 250;
            text.setLayoutData((Object)gd);
            text.addKeyListener(new KeyListener(){
                Color color;
                {
                    this.color = new Color((Device)ApogySystemPoseComposite.this.getDisplay(), text2.getBackground().getRed(), text2.getBackground().getGreen(), text2.getBackground().getBlue());
                }

                public void keyReleased(KeyEvent e) {
                    try {
                        OdometrySetValueDialog.this.tripDistanceValue = Double.parseDouble(text.getText());
                        text.setBackground(this.color);
                    }
                    catch (Exception ex) {
                        text.setBackground(new Color((Device)ApogySystemPoseComposite.this.getDisplay(), 255, 0, 0));
                    }
                }

                public void keyPressed(KeyEvent e) {
                    try {
                        OdometrySetValueDialog.this.tripDistanceValue = Double.parseDouble(text.getText());
                        text.setBackground(this.color);
                    }
                    catch (Exception ex) {
                        text.setBackground(new Color((Device)ApogySystemPoseComposite.this.getDisplay(), 255, 0, 0));
                    }
                }
            });
            return container;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Set current trip distance value");
        }

        protected Point getInitialSize() {
            return new Point(450, 300);
        }
    }
}

