/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import java.util.Iterator;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.AssemblyLink;
import org.eclipse.apogy.core.AssemblyLinksList;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AssemblyLinkListComposite
extends EMFFormsEListComposite<ApogySystem, AssemblyLinksList, AssemblyLink> {
    public AssemblyLinkListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCorePackage.Literals.APOGY_SYSTEM__ASSEMBLY_LINKS_LIST}), (EStructuralFeature)ApogyCorePackage.Literals.ASSEMBLY_LINKS_LIST__ASSEMBLY_LINKS, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
    }

    protected void createNewButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> !this.areAllTypeMembersLinked((ApogySystem)this.getRootEObject()));
    }

    protected void doNew() {
        MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
        String name = ApogyCommonEMFFacade.INSTANCE.getDefaultName(this.getResolvedEObject(), null, (ETypedElement)ApogyCorePackage.Literals.ASSEMBLY_LINKS_LIST__ASSEMBLY_LINKS);
        settings.getUserDataMap().put("name", name);
        ApogySystem apogySystem = (ApogySystem)this.getRootEObject();
        settings.getUserDataMap().put("apogySystem", apogySystem);
        EObjectWizard wizard = new EObjectWizard(this.getResolvedEObject(), null, ApogyCorePackage.Literals.ASSEMBLY_LINKS_LIST__ASSEMBLY_LINKS, ApogyCorePackage.Literals.ASSEMBLY_LINK, (EClassSettings)settings);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void doDelete(AssemblyLink assemblyLink) {
        String deleteMessage = assemblyLink.getName();
        MessageDialog dialog = new MessageDialog(null, "Delete the selected Assembly Link", null, "Are you sure to delete these Assembly Link: " + deleteMessage, 3, new String[]{"Yes", "No"}, 1);
        int result = dialog.open();
        if (result == 0) {
            ApogyCommonTransactionFacade.INSTANCE.basicRemove(this.getResolvedEObject(), (EStructuralFeature)ApogyCorePackage.Literals.ASSEMBLY_LINKS_LIST__ASSEMBLY_LINKS, (Object)assemblyLink, true);
        }
    }

    protected boolean areAllTypeMembersLinked(ApogySystem apogySystem) {
        boolean result = false;
        for (TypeMember member : apogySystem.getMembers()) {
            boolean typeMemberUsed = false;
            Iterator it = apogySystem.getAssemblyLinksList().getAssemblyLinks().iterator();
            while (it.hasNext() && !typeMemberUsed) {
                AssemblyLink assemblyLink = (AssemblyLink)it.next();
                if (assemblyLink.getSubSystemTypeMember() != member) continue;
                typeMemberUsed = true;
            }
            if (typeMemberUsed) continue;
            return false;
        }
        return result;
    }
}

