/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.rcp.mainmenu.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartSashContainerImpl;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartStackImpl;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.ViewContentProvider;
import org.eclipse.ui.internal.dialogs.ViewLabelProvider;

public class AddViewDialog
extends Dialog {
    TreeViewer treeViewerViews;
    private final MApplication application;
    private final MPerspective perspective;
    private final EModelService modelService;
    @Inject
    private EPartService partService;
    private final IResourceUtilities<?> resourceUtilities;
    private final MTrimmedWindow window;

    @Inject
    public AddViewDialog(@Named(value="activeShell") Shell parentShell, MApplication application, EModelService modelService) {
        super(parentShell);
        this.setShellStyle(268436720);
        this.application = application;
        this.resourceUtilities = (IResourceUtilities)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IResourceUtilities.class);
        this.window = (MTrimmedWindow)modelService.find("org.eclipse.apogy.rcp.windows.main", (MUIElement)application);
        this.modelService = modelService;
        this.perspective = (MPerspective)((MPerspectiveStack)modelService.find("org.eclipse.apogy.rcp.perspectivesStack", (MUIElement)this.window)).getSelectedElement();
    }

    protected void configureShell(Shell shell) {
        shell.setText("Add View");
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.treeViewerViews = new TreeViewer(composite, 68356);
        Tree treeViews = this.treeViewerViews.getTree();
        treeViews.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        treeViews.setLinesVisible(true);
        treeViews.setHeaderVisible(true);
        this.treeViewerViews.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddViewDialog.this.getButton(0).setEnabled(AddViewDialog.this.canBeAdded());
            }
        });
        this.treeViewerViews.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (AddViewDialog.this.getSelectedPart() != null && AddViewDialog.this.canBeAdded()) {
                    AddViewDialog.this.okPressed();
                } else if (AddViewDialog.this.treeViewerViews.getSelection() != null) {
                    Object selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (AddViewDialog.this.treeViewerViews.getExpandedState(selectedObject)) {
                        AddViewDialog.this.treeViewerViews.collapseToLevel(selectedObject, -1);
                    } else {
                        AddViewDialog.this.treeViewerViews.expandToLevel(selectedObject, 1);
                    }
                    if (!AddViewDialog.this.treeViewerViews.isBusy()) {
                        TreeColumn[] treeColumnArray = AddViewDialog.this.treeViewerViews.getTree().getColumns();
                        int n = treeColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn treeColumn = treeColumnArray[n2];
                            treeColumn.pack();
                            ++n2;
                        }
                    }
                }
            }
        });
        this.treeViewerViews.getTree().addListener(17, new Listener(){

            public void handleEvent(Event e) {
                TreeItem treeItem = (TreeItem)e.item;
                final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeColumn[] treeColumnArray = treeColumns;
                        int n = treeColumns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn treeColumn = treeColumnArray[n2];
                            treeColumn.pack();
                            ++n2;
                        }
                    }
                });
            }
        });
        TreeViewerColumn treeViewerNameColumn = new TreeViewerColumn(this.treeViewerViews, 0);
        TreeColumn treeclmnName = treeViewerNameColumn.getColumn();
        treeclmnName.setWidth(100);
        treeclmnName.setText("Name");
        TreeViewerColumn treeViewerDescriptionColumn = new TreeViewerColumn(this.treeViewerViews, 0);
        TreeColumn treeclmnDescription = treeViewerDescriptionColumn.getColumn();
        treeclmnDescription.setWidth(100);
        treeclmnDescription.setText("Description");
        this.treeViewerViews.setContentProvider((IContentProvider)new ViewsContentProvider(this.application));
        this.treeViewerViews.setLabelProvider((IBaseLabelProvider)new ViewsLabelProvider(this.application.getContext(), this.modelService, this.partService, (MWindow)this.modelService.find("org.eclipse.apogy.rcp.windows.main", (MUIElement)this.application), Display.getCurrent().getSystemColor(2)));
        this.treeViewerViews.setInput((Object)this.application);
        if (!this.treeViewerViews.isBusy()) {
            TreeColumn[] treeColumnArray = this.treeViewerViews.getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.pack();
                ++n2;
            }
        }
        return composite;
    }

    private boolean canBeAdded() {
        MPart part;
        Object selection = this.treeViewerViews.getStructuredSelection().getFirstElement();
        if (selection instanceof MPerspective || selection instanceof MPartDescriptor) {
            return true;
        }
        return selection instanceof MPart && (part = (MPart)selection).getPersistedState() != null && part.getPersistedState().containsKey("Standalone");
    }

    protected void okPressed() {
        Object selection = this.treeViewerViews.getStructuredSelection().getFirstElement();
        MUIElement elementToAdd = null;
        if (selection instanceof MPart || selection instanceof MPerspective) {
            elementToAdd = this.modelService.cloneElement((MUIElement)selection, null);
        } else if (selection instanceof MPartDescriptor) {
            elementToAdd = this.partService.createPart(((MPartDescriptor)selection).getElementId());
        }
        EPartService partService = (EPartService)this.window.getContext().get(EPartService.class);
        if (elementToAdd instanceof MPart) {
            MPartStack partStack = null;
            if (this.perspective.getChildren().isEmpty()) {
                MPartSashContainer container = (MPartSashContainer)this.modelService.cloneSnippet((MSnippetContainer)this.application, this.findEmptySnippetID(MPartSashContainer.class), (MWindow)this.window);
                partStack = (MPartStack)this.modelService.cloneSnippet((MSnippetContainer)this.application, this.findEmptySnippetID(MPartStack.class), (MWindow)this.window);
                this.makeIDsUnique(this.perspective, (MUIElement)container);
                this.makeIDsUnique(this.perspective, (MUIElement)partStack);
                container.getChildren().add(partStack);
                this.perspective.getChildren().add(container);
            } else {
                MElementContainer element = partService.getActivePart().getParent();
                if (element instanceof MPartStack) {
                    partStack = (MPartStack)element;
                } else {
                    List elements = this.perspective.getChildren();
                    partStack = this.getFirstPartStack(elements);
                }
            }
            if (!(selection instanceof MPartDescriptor) && selection instanceof MPart && ((MPart)selection).getContributorURI().equals("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView")) {
                this.makeIDsUnique(this.perspective, elementToAdd);
            }
            partStack.getChildren().add((MStackElement)elementToAdd);
            partService.showPart((MPart)elementToAdd, EPartService.PartState.ACTIVATE);
        } else if (elementToAdd instanceof MPerspective) {
            MPerspective perspectiveToAdd = (MPerspective)elementToAdd;
            int j = this.getUniqueNumberID(perspectiveToAdd);
            ArrayList partSashElementToAdd = new ArrayList();
            partSashElementToAdd.addAll(this.modelService.findElements((MUIElement)perspectiveToAdd, null, MPart.class, null));
            partSashElementToAdd.addAll(this.modelService.findElements((MUIElement)perspectiveToAdd, null, MPartSashContainer.class, null));
            partSashElementToAdd.addAll(this.modelService.findElements((MUIElement)perspectiveToAdd, null, MPartStack.class, null));
            for (MUIElement element : partSashElementToAdd) {
                if (element instanceof MPart && element instanceof MPart && ((MPart)element).getContributionURI().equals("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView")) continue;
                element.setElementId(String.valueOf(element.getElementId()) + "_" + j + "_" + this.perspective.getElementId());
            }
            Iterator ite = perspectiveToAdd.getChildren().iterator();
            while (ite.hasNext()) {
                MPartSashContainerElement element = (MPartSashContainerElement)ite.next();
                ite.remove();
                this.splitPerspective(this.perspective).getChildren().add(element);
            }
        }
        super.okPressed();
    }

    private int getUniqueNumberID(MPerspective perspective) {
        MPerspective perspectiveToAddCopy = (MPerspective)this.modelService.cloneElement((MUIElement)perspective, null);
        List elements = perspectiveToAddCopy.getChildren();
        ArrayList partSashElements = new ArrayList();
        for (MPartSashContainerElement element : elements) {
            partSashElements.addAll(this.modelService.findElements((MUIElement)element, null, MPart.class, null));
            partSashElements.addAll(this.modelService.findElements((MUIElement)element, null, MPartSashContainer.class, null));
            partSashElements.addAll(this.modelService.findElements((MUIElement)element, null, MPartStack.class, null));
        }
        int i = 1;
        for (MPartSashContainerElement element : elements) {
            String originalID = element.getElementId();
            element.setElementId(String.valueOf(originalID) + "_" + i);
            while (this.recursiveFindSameID((MUIElement)element, (MElementContainer<? extends MUIElement>)this.perspective)) {
                element.setElementId(String.valueOf(originalID) + "_" + ++i);
            }
        }
        return i;
    }

    private void makeIDsUnique(MPerspective perspective, MUIElement element) {
        int j = 0;
        String originalID = element.getElementId();
        while (this.recursiveFindSameID(element, (MElementContainer<? extends MUIElement>)perspective)) {
            element.setElementId(originalID.concat("_" + Integer.toString(++j)));
        }
        if (element instanceof MElementContainer) {
            for (MPart part : this.modelService.findElements(element, null, MPart.class, null)) {
                this.makeIDsUnique(perspective, (MUIElement)part);
            }
        }
        if (element instanceof MPart || element instanceof MPartSashContainer || element instanceof MPartStack) {
            element.setElementId(element.getElementId().concat("_" + perspective.getElementId()));
        }
    }

    private boolean recursiveFindSameID(MUIElement element, MElementContainer<? extends MUIElement> container) {
        for (MUIElement containedElement : container.getChildren()) {
            if (containedElement.getElementId().startsWith(element.getElementId())) {
                return true;
            }
            if (!(containedElement instanceof MElementContainer) || !this.recursiveFindSameID(element, (MElementContainer<? extends MUIElement>)((MElementContainer)containedElement))) continue;
            return true;
        }
        return false;
    }

    private String findEmptySnippetID(Class<?> clazz) {
        for (MUIElement element : this.application.getSnippets()) {
            if (!clazz.isAssignableFrom(element.getClass())) continue;
            return element.getElementId();
        }
        return "";
    }

    private MPartSashContainer splitPerspective(MPerspective perspective) {
        ArrayList children = new ArrayList(perspective.getChildren());
        if (children.size() == 0) {
            MPartSashContainer sashContainer = (MPartSashContainer)this.modelService.cloneSnippet((MSnippetContainer)this.application, this.findEmptySnippetID(MPartSashContainer.class), (MWindow)this.window);
            this.makeIDsUnique(perspective, (MUIElement)sashContainer);
            perspective.getChildren().add(sashContainer);
            return sashContainer;
        }
        int i = 0;
        if (children.size() != 1) {
            i = children.size() - 1;
        }
        MPartSashContainer sashContainer = (MPartSashContainer)this.modelService.cloneSnippet((MSnippetContainer)this.application, this.findEmptySnippetID(MPartSashContainer.class), (MWindow)this.window);
        this.makeIDsUnique(perspective, (MUIElement)sashContainer);
        perspective.getChildren().remove(children.get(i));
        sashContainer.getChildren().add((MPartSashContainerElement)children.get(i));
        perspective.getChildren().add(sashContainer);
        return sashContainer;
    }

    public MPart getSelectedPart() {
        if (this.treeViewerViews.getStructuredSelection() != null) {
            if (this.treeViewerViews.getStructuredSelection().getFirstElement() instanceof MPart) {
                return (MPart)this.treeViewerViews.getStructuredSelection().getFirstElement();
            }
            if (this.treeViewerViews.getStructuredSelection().getFirstElement() instanceof MPartDescriptor) {
                return this.partService.createPart(((MPartDescriptor)this.treeViewerViews.getStructuredSelection().getFirstElement()).getElementId());
            }
        }
        return null;
    }

    private MPartStack getFirstPartStack(MPartSashContainerElement element) {
        if (element instanceof PartStackImpl) {
            return (PartStackImpl)element;
        }
        if (element instanceof PartSashContainerImpl) {
            return this.getFirstPartStack(((PartSashContainerImpl)element).getChildren());
        }
        return null;
    }

    private MPartStack getFirstPartStack(List<MPartSashContainerElement> elements) {
        MPartStack partStack = null;
        for (MPartSashContainerElement elementChild : elements) {
            if (!(elementChild instanceof MWindow) && (partStack = this.getFirstPartStack(elementChild)) != null) break;
        }
        return partStack;
    }

    private class ViewsContentProvider
    extends ViewContentProvider {
        private final String APOGY_PERSPECTIVE_STR = "Apogy Perspectives";
        private final String APOGY_PART_STR = "Apogy Views";

        public ViewsContentProvider(MApplication application) {
            super(application);
            this.APOGY_PERSPECTIVE_STR = "Apogy Perspectives";
            this.APOGY_PART_STR = "Apogy Views";
        }

        public Object[] getElements(Object element) {
            List<Object> elements = new ArrayList<Object>();
            elements.addAll(Arrays.asList(super.getElements(element)));
            elements = this.sortAlphabetically(elements);
            elements.add(0, "Apogy Views");
            elements.add(0, "Apogy Perspectives");
            return elements.toArray();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof String && ((String)element == "Apogy Perspectives" || (String)element == "Apogy Views")) {
                ArrayList<MPerspective> perspectives = new ArrayList<MPerspective>();
                ArrayList<MPart> parts = new ArrayList<MPart>();
                for (MUIElement muiElement : AddViewDialog.this.application.getSnippets()) {
                    MPart part2;
                    if (muiElement instanceof MPerspective) {
                        if (muiElement.getPersistedState() == null || !muiElement.getPersistedState().containsKey("Standalone") || !Boolean.parseBoolean((String)muiElement.getPersistedState().get("Standalone"))) continue;
                        perspectives.add((MPerspective)muiElement);
                        for (MPart part2 : AddViewDialog.this.modelService.findElements(muiElement, null, MPart.class, null)) {
                            if (part2.getPersistedState() == null || !part2.getPersistedState().containsKey("Standalone") || !Boolean.parseBoolean((String)part2.getPersistedState().get("Standalone"))) continue;
                            parts.add(part2);
                        }
                        continue;
                    }
                    if (!(muiElement instanceof MPart) || (part2 = (MPart)muiElement).getPersistedState() == null || !part2.getPersistedState().containsKey("Standalone") || !Boolean.parseBoolean((String)part2.getPersistedState().get("Standalone"))) continue;
                    parts.add(part2);
                }
                if ((String)element == "Apogy Perspectives") {
                    List<MPerspective> sorted = this.sortMPerspectiveAlphabetically(perspectives);
                    return sorted.toArray();
                }
                if ((String)element == "Apogy Views") {
                    List<MPart> sortedParts = this.sortMPartsAlphabetically(parts);
                    return sortedParts.toArray();
                }
            }
            if (element instanceof MPerspective) {
                List parts = AddViewDialog.this.modelService.findElements((MUIElement)((MPerspective)element), null, MPart.class, null);
                List<MPart> sortedParts = this.sortMPartsAlphabetically(parts);
                return sortedParts.toArray();
            }
            return super.getChildren(element);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof MPerspective) {
                return !((MPerspective)element).getChildren().isEmpty();
            }
            return super.hasChildren(element);
        }

        private List<MPerspective> sortMPerspectiveAlphabetically(List<MPerspective> mUIElements) {
            TreeSet<MPerspective> sorted = new TreeSet<MPerspective>(new Comparator<MPerspective>(){

                @Override
                public int compare(MPerspective arg0, MPerspective arg1) {
                    if (arg0.getLabel() != null && arg1.getLabel() != null) {
                        if (arg0.getLabel().compareTo(arg1.getLabel()) > 0) {
                            return 1;
                        }
                        if (arg0.getLabel().compareTo(arg1.getLabel()) < 0) {
                            return -1;
                        }
                        if (arg0.hashCode() > arg1.hashCode()) {
                            return 1;
                        }
                        return -1;
                    }
                    if (arg0.hashCode() > arg1.hashCode()) {
                        return 1;
                    }
                    return -1;
                }
            });
            sorted.addAll(mUIElements);
            ArrayList<MPerspective> result = new ArrayList<MPerspective>();
            result.addAll(sorted);
            return result;
        }

        private List<MPart> sortMPartsAlphabetically(List<MPart> mParts) {
            TreeSet<MPart> sorted = new TreeSet<MPart>(new Comparator<MPart>(){

                @Override
                public int compare(MPart arg0, MPart arg1) {
                    if (arg0.getLabel() != null && arg1.getLabel() != null) {
                        if (arg0.getLabel().compareTo(arg1.getLabel()) > 0) {
                            return 1;
                        }
                        if (arg0.getLabel().compareTo(arg1.getLabel()) < 0) {
                            return -1;
                        }
                        if (arg0.hashCode() > arg1.hashCode()) {
                            return 1;
                        }
                        return -1;
                    }
                    if (arg0.hashCode() > arg1.hashCode()) {
                        return 1;
                    }
                    return -1;
                }
            });
            sorted.addAll(mParts);
            ArrayList<MPart> result = new ArrayList<MPart>();
            result.addAll(sorted);
            return result;
        }

        private List<Object> sortAlphabetically(List<Object> elements) {
            TreeSet<Object> sorted = new TreeSet<Object>();
            sorted.addAll(elements);
            ArrayList<Object> result = new ArrayList<Object>();
            result.addAll(sorted);
            return result;
        }
    }

    private class ViewsLabelProvider
    extends ViewLabelProvider
    implements ITableLabelProvider {
        private final int NAME_COLUMN = 0;
        private final int DESCRIPTION_COLUMN = 1;

        public ViewsLabelProvider(IEclipseContext context, EModelService modelService, EPartService partService, MWindow window, Color dimmedForeground) {
            super(context, modelService, partService, window, dimmedForeground);
            this.NAME_COLUMN = 0;
            this.DESCRIPTION_COLUMN = 1;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof MUILabel || element instanceof MPartSashContainer) {
                        String iconURI = "";
                        if (element instanceof MUILabel) {
                            iconURI = ((MUILabel)element).getIconURI();
                        }
                        if (iconURI != null && iconURI != "") {
                            URI uri = URI.createURI((String)iconURI);
                            if (uri != null) {
                                ImageDescriptor descriptor = (ImageDescriptor)AddViewDialog.this.resourceUtilities.imageDescriptorFromURI(uri);
                                return descriptor.createImage();
                            }
                        } else {
                            URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.ui/icons/full/eview16/defaultview_misc.png");
                            ImageDescriptor descriptor = (ImageDescriptor)AddViewDialog.this.resourceUtilities.imageDescriptorFromURI(uri);
                            return descriptor.createImage();
                        }
                    }
                    return super.getImage(element);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof String) {
                        return (String)element;
                    }
                    if (element instanceof MUILabel) {
                        return ((MUILabel)element).getLabel();
                    }
                }
                case 1: {
                    if (element instanceof String) {
                        return "";
                    }
                    if (!(element instanceof MUILabel)) break;
                    return ((MUILabel)element).getTooltip();
                }
            }
            return "";
        }
    }
}

