/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.workspace.ui.composites;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.EObjectReference;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.NamedReferencesListComposite;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.core.invocator.OperationCallsList;
import org.eclipse.apogy.core.invocator.ProgramsGroup;
import org.eclipse.apogy.workspace.ApogyProjectSettings;
import org.eclipse.apogy.workspace.ApogyWorkspaceFacade;
import org.eclipse.apogy.workspace.ApogyWorkspacePackage;
import org.eclipse.apogy.workspace.PlatformApogyProject;
import org.eclipse.apogy.workspace.PlatformApogyProjectsList;
import org.eclipse.apogy.workspace.ui.wizards.NewProjectWizard;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformProjectsListComposite
extends NamedReferencesListComposite<ApogyWorkspaceFacade, PlatformApogyProjectsList, PlatformApogyProject> {
    private static final Logger Logger = LoggerFactory.getLogger(PlatformProjectsListComposite.class);

    public PlatformProjectsListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, settings);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(e -> {
            this.setRootEObject(null);
            this.setRootEObject((EObject)ApogyWorkspaceFacade.INSTANCE);
        });
        this.setRootEObject((EObject)ApogyWorkspaceFacade.INSTANCE);
    }

    protected void createButtons(Composite parent, int style) {
        this.createOpenButton(parent, style);
        this.createCloseButton(parent, style);
        this.createSaveButton(parent, style);
        this.createSeparator(parent, style);
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createTestButton(parent, style);
    }

    protected void doTest() {
        InvocatorSession session = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        OperationCall call = (OperationCall)((OperationCallsList)((ProgramsGroup)session.getProgramsList().getProgramsGroups().get(0)).getPrograms().get(0)).getOperationCalls().get(0);
        System.err.println("PlatformProjectsListComposite.doTest(): " + call);
    }

    protected void createOpenButtonBindings(Button button) {
        this.getDataBindingContext().bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)button), EMFProperties.value((EStructuralFeature)ApogyWorkspacePackage.Literals.APOGY_WORKSPACE_FACADE__ACTIVE_PROJECT).observe((Object)ApogyWorkspaceFacade.INSTANCE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(IConverter.create(PlatformApogyProject.class, Boolean.class, o -> {
            if (o == null) {
                return true;
            }
            return false;
        })));
    }

    protected void createCloseButtonBindings(Button button) {
        this.getDataBindingContext().bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)button), EMFProperties.value((EStructuralFeature)ApogyWorkspacePackage.Literals.APOGY_WORKSPACE_FACADE__ACTIVE_PROJECT).observe((Object)ApogyWorkspaceFacade.INSTANCE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(IConverter.create(PlatformApogyProject.class, Boolean.class, o -> {
            if (o != null) {
                return true;
            }
            return false;
        })));
    }

    protected void doOpen() {
        try {
            ApogyWorkspaceFacade.INSTANCE.openProject((PlatformApogyProject)this.getSelectedItemObjects().get(0));
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Session loaded", (String)("Successfully loaded session: \n\n" + ((PlatformApogyProject)this.getSelectedItemObjects().get(0)).getName()));
        }
        catch (Exception e) {
            String message = "Unable to open project <" + ((PlatformApogyProject)this.getSelectedItemObjects().get(0)).getName() + ">";
            Logger.error(message, (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
        }
    }

    protected void doClose() {
        MessageDialog dialog = new MessageDialog(this.getShell(), "Closing the session", null, "Would you like to save the active session?", 6, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL});
        int result = dialog.open();
        if (result != 2) {
            String errorMessage;
            if (result == 0) {
                try {
                    ApogyWorkspaceFacade.INSTANCE.saveActiveProject();
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Apogy session saved", (String)("The Apogy session saved successfully:\n\n" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName()));
                }
                catch (Exception e) {
                    errorMessage = "Problems while saving Apogy session:\n\n" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName();
                    MessageDialog.openError((Shell)this.getShell(), (String)"Unable to save", (String)errorMessage);
                    Logger.error(errorMessage, (Throwable)e);
                }
            }
            try {
                ApogyWorkspaceFacade.INSTANCE.closeActiveProject();
            }
            catch (Exception e) {
                errorMessage = "Problems while closing Apogy session:\n\n" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName();
                MessageDialog.openError((Shell)this.getShell(), (String)"Unable to close", (String)errorMessage);
                Logger.error(errorMessage, (Throwable)e);
            }
        }
    }

    protected void doNew() {
        NewProjectWizard wizard = new NewProjectWizard((EObjectReference<ApogyProjectSettings>)ApogyCommonEMFFactory.eINSTANCE.createEObjectReference());
        wizard.setWindowTitle("Create a new Apogy project");
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void doDelete(PlatformApogyProject project) {
        try {
            super.doDelete((Object)project);
            ApogyWorkspaceFacade.INSTANCE.deleteProject(project);
        }
        catch (Exception e) {
            String message = "Unable to delete the project <" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName() + ">";
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            Logger.error(message, (Throwable)e);
        }
    }

    protected void doSave() {
        try {
            ApogyWorkspaceFacade.INSTANCE.saveActiveProject();
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Apogy session saved", (String)("The Apogy session saved successfully:\n\n" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName()));
        }
        catch (Exception e) {
            String errorMessage = "Problems while saving Apogy session:\n\n" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName();
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to save", (String)errorMessage);
            Logger.error(errorMessage, (Throwable)e);
        }
    }

    protected PlatformApogyProjectsList processResolvedEObject(ApogyWorkspaceFacade rootEObject, FeaturePath featurePath) {
        return ApogyWorkspaceFacade.INSTANCE.getPlatformProjectsList();
    }
}

