/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.perspectiveswitcher.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.internal.dialogs.SelectPerspectiveDialog;

public final class ShowPerspectiveHandler {
    @Execute
    public void execute(IEclipseContext context, @Optional @Named(value="org.eclipse.e4.ui.perspectives.parameters.perspectiveId") String perspectiveID, @Optional @Named(value="org.eclipse.e4.ui.perspectives.parameters.newWindow") String newWindow) throws InvocationTargetException, InterruptedException {
        if (perspectiveID == null || perspectiveID.equals("")) {
            this.openSelectionDialog(context);
        } else if (Boolean.parseBoolean(newWindow)) {
            this.openNewWindowPerspective(context, perspectiveID);
        } else {
            this.openPerspective(context, perspectiveID);
        }
    }

    private void openNewWindowPerspective(IEclipseContext context, String perspectiveID) {
        MApplication application = (MApplication)context.get(MApplication.class);
        EPartService partService = (EPartService)context.get(EPartService.class);
        EModelService modelService = (EModelService)context.get(EModelService.class);
        List perspectives = modelService.findElements((MUIElement)application, perspectiveID, MPerspective.class, null);
        partService.switchPerspective((MPerspective)perspectives.get(0));
    }

    private final void openSelectionDialog(IEclipseContext context) {
        SelectPerspectiveDialog dialog = (SelectPerspectiveDialog)((Object)ContextInjectionFactory.make(SelectPerspectiveDialog.class, (IEclipseContext)context));
        dialog.open();
    }

    private final void openPerspective(IEclipseContext context, String perspectiveID) {
        MApplication application = (MApplication)context.get(MApplication.class);
        EPartService partService = (EPartService)context.get(EPartService.class);
        EModelService modelService = (EModelService)context.get(EModelService.class);
        List perspectives = modelService.findElements((MUIElement)application, perspectiveID, MPerspective.class, null);
        partService.switchPerspective((MPerspective)perspectives.get(0));
    }
}

