/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.perspectiveswitcher.internal.dialogs;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.internal.dialogs.DelegatingLabelProviderWithTooltip;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.internal.dialogs.PerspectiveContentProvider;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.internal.dialogs.PerspectiveLabelDecorator;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.internal.dialogs.PerspectiveLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

@Creatable
public class SelectPerspectiveDialog
extends Dialog
implements ISelectionChangedListener {
    @Inject
    private IEclipseContext context;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private MWindow window;
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 300;
    private TableViewer viewer;
    private Button okButton;
    Object selection;

    @Inject
    public SelectPerspectiveDialog(@Named(value="activeShell") Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void cancelPressed() {
        this.selection = null;
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        shell.setText("Open Perspective");
        this.setBlockOnOpen(false);
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        this.createViewer(composite);
        this.layoutTopControl(this.viewer.getControl());
        return composite;
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 2820);
        this.viewer.getTable().setFont(parent.getFont());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DelegatingLabelProviderWithTooltip((ILabelProvider)ContextInjectionFactory.make(PerspectiveLabelProvider.class, (IEclipseContext)this.context), (ILabelDecorator)ContextInjectionFactory.make(PerspectiveLabelDecorator.class, (IEclipseContext)this.context)){

            @Override
            protected Object unwrapElement(Object element) {
                return element;
            }
        });
        this.viewer.setContentProvider((IContentProvider)ContextInjectionFactory.make(PerspectiveContentProvider.class, (IEclipseContext)this.context));
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setInput((Object)this.window);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectPerspectiveDialog.this.handleDoubleClickEvent();
            }
        });
    }

    protected void handleDoubleClickEvent() {
        this.okPressed();
    }

    private void layoutTopControl(Control control) {
        GridData spec = new GridData(1808);
        spec.widthHint = 300;
        spec.heightHint = 300;
        control.setLayoutData((Object)spec);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
    }

    protected void updateButtons() {
        this.okButton.setEnabled(this.selection != null);
    }

    protected void updateSelection(SelectionChangedEvent event) {
        Object obj;
        this.selection = null;
        IStructuredSelection _sel = (IStructuredSelection)event.getSelection();
        if (!_sel.isEmpty() && (obj = _sel.getFirstElement()) instanceof MPerspective) {
            this.selection = obj;
        }
    }

    protected void okPressed() {
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put("org.eclipse.e4.ui.perspectives.parameters.perspectiveId", ((MPerspective)this.selection).getElementId());
        parameters.put("org.eclipse.e4.ui.perspectives.parameters.newWindow", "false");
        ParameterizedCommand command = this.commandService.createCommand("org.eclipse.e4.ui.perspectives.showPerspective", parameters);
        this.handlerService.executeHandler(command);
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

