/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import java.net.URI;
import java.util.Map;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.topic.SubscriberIdentifier;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.namespace.GraphName;

public class SubscriberDeclaration {
    private final SubscriberIdentifier subscriberIdentifier;
    private final TopicDeclaration topicDeclaration;

    public static SubscriberDeclaration newFromHeader(Map<String, String> header) {
        NodeIdentifier nodeIdentifier = new NodeIdentifier(GraphName.of(header.get("callerid")), null);
        TopicDeclaration topicDeclaration = TopicDeclaration.newFromHeader(header);
        return new SubscriberDeclaration(new SubscriberIdentifier(nodeIdentifier, topicDeclaration.getIdentifier()), topicDeclaration);
    }

    public SubscriberDeclaration(SubscriberIdentifier subscriberIdentifier, TopicDeclaration topicDeclaration) {
        this.subscriberIdentifier = subscriberIdentifier;
        this.topicDeclaration = topicDeclaration;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.subscriberIdentifier.getNodeIdentifier();
    }

    public URI getSlaveUri() {
        return this.subscriberIdentifier.getUri();
    }

    public GraphName getTopicName() {
        return this.topicDeclaration.getName();
    }

    public ConnectionHeader toConnectionHeader() {
        ConnectionHeader connectionHeader = new ConnectionHeader();
        connectionHeader.merge(this.subscriberIdentifier.toConnectionHeader());
        connectionHeader.merge(this.topicDeclaration.toConnectionHeader());
        return connectionHeader;
    }

    public String toString() {
        return "SubscriberDefinition<" + this.subscriberIdentifier + ", " + this.topicDeclaration + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subscriberIdentifier == null ? 0 : this.subscriberIdentifier.hashCode());
        result = 31 * result + (this.topicDeclaration == null ? 0 : this.topicDeclaration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriberDeclaration other = (SubscriberDeclaration)obj;
        if (this.subscriberIdentifier == null ? other.subscriberIdentifier != null : !this.subscriberIdentifier.equals(other.subscriberIdentifier)) {
            return false;
        }
        return !(this.topicDeclaration == null ? other.topicDeclaration != null : !this.topicDeclaration.equals(other.topicDeclaration));
    }
}

