/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport.tcp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.transport.tcp.NamedChannelHandler;
import org.ros.internal.transport.tcp.TcpClientPipelineFactory;

public class TcpClient {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(TcpClient.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT_DURATION = 5;
    private static final TimeUnit DEFAULT_CONNECTION_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final boolean DEFAULT_KEEP_ALIVE = true;
    private final ChannelGroup channelGroup;
    private final ChannelFactory channelFactory;
    private final ChannelBufferFactory channelBufferFactory;
    private final ClientBootstrap bootstrap;
    private final List<NamedChannelHandler> namedChannelHandlers;
    private Channel channel;

    public TcpClient(ChannelGroup channelGroup, Executor executor) {
        this.channelGroup = channelGroup;
        this.channelFactory = new NioClientSocketChannelFactory(executor, executor);
        this.channelBufferFactory = new HeapChannelBufferFactory(ByteOrder.LITTLE_ENDIAN);
        this.bootstrap = new ClientBootstrap(this.channelFactory);
        this.bootstrap.setOption("bufferFactory", (Object)this.channelBufferFactory);
        this.setConnectionTimeout(5L, DEFAULT_CONNECTION_TIMEOUT_UNIT);
        this.setKeepAlive(true);
        this.namedChannelHandlers = Lists.newArrayList();
    }

    public void setConnectionTimeout(long duration, TimeUnit unit) {
        this.bootstrap.setOption("connectionTimeoutMillis", (Object)TimeUnit.MILLISECONDS.convert(duration, unit));
    }

    public void setKeepAlive(boolean value) {
        this.bootstrap.setOption("keepAlive", (Object)value);
    }

    public void addNamedChannelHandler(NamedChannelHandler namedChannelHandler) {
        this.namedChannelHandlers.add(namedChannelHandler);
    }

    public void addAllNamedChannelHandlers(List<NamedChannelHandler> namedChannelHandlers) {
        this.namedChannelHandlers.addAll(namedChannelHandlers);
    }

    public void connect(String connectionName, SocketAddress socketAddress) {
        TcpClientPipelineFactory tcpClientPipelineFactory = new TcpClientPipelineFactory(this.channelGroup){

            @Override
            public ChannelPipeline getPipeline() {
                ChannelPipeline pipeline = super.getPipeline();
                for (NamedChannelHandler namedChannelHandler : TcpClient.this.namedChannelHandlers) {
                    pipeline.addLast(namedChannelHandler.getName(), (ChannelHandler)namedChannelHandler);
                }
                return pipeline;
            }
        };
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)tcpClientPipelineFactory);
        ChannelFuture future = this.bootstrap.connect(socketAddress).awaitUninterruptibly();
        if (!future.isSuccess()) {
            throw new RosRuntimeException("Connection exception: " + socketAddress, future.getCause());
        }
        this.channel = future.getChannel();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture write(ChannelBuffer buffer) {
        Preconditions.checkNotNull((Object)this.channel);
        Preconditions.checkNotNull((Object)buffer);
        return this.channel.write((Object)buffer);
    }
}

