/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.ui.composites;

import org.eclipse.apogy.addons.ros.ApogyAddonsROSPackage;
import org.eclipse.apogy.addons.ros.ROSInterface;
import org.eclipse.apogy.addons.ros.ROSListener;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ROSListenerListComposite
extends EMFFormsEListComposite<ROSInterface, ROSInterface, ROSListener<?>> {
    public static final int TOPIC_STATE_MIN_WIDTH = 150;
    public static final int TOPIC_NAME_MIN_WIDTH = 250;
    public static final int TOPIC_TYPE_MIN_WIDTH = 200;

    public ROSListenerListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsROSPackage.Literals.ROS_TOPIC_LAUNCHER__LISTENER_LIST, settings);
    }

    protected void createButtons(Composite parent, int style) {
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn topicStateColumn = new TreeViewerColumn(viewer, 0);
        topicStateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        topicStateColumn.getColumn().setText("State");
        topicStateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ROSListener rosListener = (ROSListener)element;
                return rosListener.getListenerState().getLiteral();
            }

            public Color getBackground(Object element) {
                ROSListener rosListener = (ROSListener)element;
                return ROSListenerListComposite.this.getBackground(rosListener);
            }
        });
        TreeViewerColumn topicNameColumn = new TreeViewerColumn(viewer, 0);
        topicNameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)250);
        topicNameColumn.getColumn().setText("Topic Name");
        topicNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ROSListener)element).getTopicName() == null ? "?" : ((ROSListener)element).getTopicName();
            }

            public Color getBackground(Object element) {
                ROSListener rosListener = (ROSListener)element;
                return ROSListenerListComposite.this.getBackground(rosListener);
            }
        });
        TreeViewerColumn topicTypeColumn = new TreeViewerColumn(viewer, 0);
        topicTypeColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        topicTypeColumn.getColumn().setText("Type");
        topicTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ROSListener rosListener = (ROSListener)element;
                return rosListener.getMessageType();
            }

            public Color getBackground(Object element) {
                ROSListener rosListener = (ROSListener)element;
                return ROSListenerListComposite.this.getBackground(rosListener);
            }
        });
    }

    protected Color getBackground(ROSListener<?> rosListener) {
        Color color = this.getBackground();
        switch (rosListener.getListenerState().getValue()) {
            case 1: {
                color = PlatformUI.getWorkbench().getDisplay().getSystemColor(7);
                break;
            }
            case 2: {
                color = PlatformUI.getWorkbench().getDisplay().getSystemColor(5);
                break;
            }
            case 3: {
                color = PlatformUI.getWorkbench().getDisplay().getSystemColor(3);
                break;
            }
        }
        return color;
    }
}

