/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.composites;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.RectifiedImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraImageAnnotation;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraTool;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewDisplayRotation;
import org.eclipse.apogy.addons.sensors.imaging.camera.DrawnCameraOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.ImageCameraOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.ImageFilter;
import org.eclipse.apogy.addons.sensors.imaging.camera.OverlayAlignment;
import org.eclipse.apogy.addons.sensors.imaging.camera.ToolTipTextProvider;
import org.eclipse.apogy.addons.sensors.imaging.camera.listeners.CameraViewConfigurationListener;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ImageAlignment;
import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CameraViewConfigurationComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(CameraViewConfigurationComposite.class);
    public static final int DEFAULT_IMAGE_WIDTH = 640;
    public static final int DEFAULT_IMAGE_HEIGHT = 480;
    private CameraViewConfigurationListener cameraViewConfigurationListener = null;
    private Adapter cameraAdapter;
    protected CameraViewConfiguration cameraViewConfiguration;
    protected AbstractCamera camera = null;
    private boolean displayRectifiedImage = false;
    private ScrolledComposite scrolledComposite = null;
    private ImageDisplayComposite imageDisplayComposite = null;
    private ImageSnapshot lastImageSnapshot = null;
    private MouseListener mouseListener;
    private MouseMoveListener mouseMoveListener;
    private int mouseButton = 0;
    private boolean busy = false;

    public CameraViewConfigurationComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CameraViewConfigurationComposite.this.getCameraViewConfiguration() != null) {
                    CameraViewConfigurationComposite.this.disposeOfAnnotations();
                }
                CameraViewConfigurationComposite.this.setCameraViewConfiguration(null);
            }
        });
        this.scrolledComposite = new ScrolledComposite((Composite)this, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.imageDisplayComposite = new ImageDisplayComposite((Composite)this.scrolledComposite, 2048);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        this.imageDisplayComposite.setLayoutData((Object)gridData);
        this.imageDisplayComposite.addImageMouseListener(this.getMouseListener());
        this.imageDisplayComposite.addImageMouseMoveListener(this.getMouseMoveListener());
        this.scrolledComposite.setContent((Control)this.imageDisplayComposite);
        this.imageDisplayComposite.setSize(this.getImageSize());
        this.scrolledComposite.setMinSize(this.getImageSize());
        this.imageDisplayComposite.setImageData(EImagesUtilities.INSTANCE.convertToImageData(this.getNoDataImage().asBufferedImage()));
        this.imageDisplayComposite.setImageData(EImagesUtilities.INSTANCE.convertToImageData(this.getNoDataImage().asBufferedImage()));
        this.imageDisplayComposite.fitImage();
        this.imageDisplayComposite.getToolTip().setHideOnMouseDown(false);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
            }
        });
        this.setDisplaySize(640, 480);
        Cursor cursor = new Cursor((Device)this.getDisplay(), 2);
        this.imageDisplayComposite.setCursor(cursor);
    }

    public boolean isDisplayRectifiedImage() {
        return this.displayRectifiedImage;
    }

    public void setDisplayRectifiedImage(boolean displayRectifiedImage) {
        this.displayRectifiedImage = displayRectifiedImage;
        this.forceImageUpdate();
    }

    public CameraViewConfiguration getCameraViewConfiguration() {
        return this.cameraViewConfiguration;
    }

    public void setCameraViewConfiguration(CameraViewConfiguration newCameraViewConfiguration) {
        if (this.cameraViewConfiguration != null) {
            this.disposeOfAnnotations();
        }
        this.cameraViewConfiguration = newCameraViewConfiguration;
        this.getCameraViewConfigurationListener().setCameraViewConfiguration(newCameraViewConfiguration);
        if (newCameraViewConfiguration != null) {
            this.setCamera(newCameraViewConfiguration.getCamera());
            this.setDisplaySize(newCameraViewConfiguration.getImageWidth(), newCameraViewConfiguration.getImageHeight());
            this.setDisplayRectifiedImage(newCameraViewConfiguration.isDisplayRectifiedImage());
        } else {
            this.setDisplaySize(640, 480);
            this.setDisplayRectifiedImage(false);
            this.setCamera(null);
        }
    }

    protected AbstractCamera getCamera() {
        return this.camera;
    }

    protected void setCamera(AbstractCamera newCamera) {
        if (this.camera != null) {
            this.camera.eAdapters().remove((Object)this.getCameraAdapter());
        }
        if (this.camera != newCamera) {
            this.lastImageSnapshot = null;
        }
        this.busy = false;
        this.camera = newCamera;
        if (newCamera != null) {
            newCamera.eAdapters().add((Object)this.getCameraAdapter());
            this.updateImageSnapshot(newCamera.getLatestImageSnapshot());
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CameraViewConfigurationComposite.this.setDisplaySize(640, 480);
                    CameraViewConfigurationComposite.this.imageDisplayComposite.setImageData(EImagesUtilities.INSTANCE.convertToImageData(CameraViewConfigurationComposite.this.getNoDataImage().asBufferedImage()));
                }
            });
        }
        this.updateToolsCamera(newCamera);
    }

    protected void disposeOfAnnotations() {
        this.disposeOfOverlays();
        this.disposeOfFilters();
        this.disposeOfCameraTools();
    }

    protected void forceImageUpdate() {
        this.updateImageSnapshot(this.lastImageSnapshot);
    }

    protected void updateImageSnapshot(ImageSnapshot newImageSnapshot) {
        if (!this.busy && this.getCameraViewConfiguration() != null) {
            try {
                AbstractEImage cameraImage = null;
                if (newImageSnapshot != null) {
                    this.busy = true;
                    if (newImageSnapshot != this.lastImageSnapshot) {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.getCameraViewConfiguration(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__IMAGE_COUNT, (Object)(this.getCameraViewConfiguration().getImageCount() + 1));
                    }
                    if (this.isDisplayRectifiedImage() && newImageSnapshot instanceof RectifiedImageSnapshot) {
                        RectifiedImageSnapshot rectifiedImageSnapshot = (RectifiedImageSnapshot)newImageSnapshot;
                        cameraImage = rectifiedImageSnapshot.getRectifiedImage();
                    } else {
                        cameraImage = newImageSnapshot.getImage();
                    }
                }
                cameraImage = cameraImage == null ? this.getNoDataImage() : this.applyFilters(cameraImage);
                this.updateToolsImageSnapshot(newImageSnapshot);
                Point imageSize = this.getImageSize();
                AbstractEImage resizedCameraImage = EImagesUtilities.INSTANCE.resize(cameraImage, imageSize.x, imageSize.y);
                AbstractEImage displayedImage = this.applyOverlays(resizedCameraImage);
                AbstractEImage rotatedImage = this.applyCameraViewDisplayRotation(this.getCameraViewConfiguration().getCameraViewDisplayRotation(), displayedImage);
                this.updateDisplayedImage(rotatedImage);
                if (newImageSnapshot != this.lastImageSnapshot) {
                    this.saveImages(resizedCameraImage, displayedImage);
                }
                this.lastImageSnapshot = newImageSnapshot;
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
                this.busy = false;
            }
        }
    }

    protected void saveImages(AbstractEImage rawImage, AbstractEImage displayedImage) {
        if (this.getCameraViewConfiguration() != null && this.getCameraViewConfiguration().isImageAutoSaveEnable()) {
            AbstractEImage imageToSave = null;
            imageToSave = this.getCameraViewConfiguration().isSaveImageWithOverlays() ? displayedImage : rawImage;
            if (imageToSave != null) {
                final long timeStamp = System.currentTimeMillis();
                final AbstractEImage image = imageToSave;
                Job job = new Job("Save Image"){

                    protected IStatus run(IProgressMonitor monitor) {
                        String fileName = String.valueOf(CameraViewConfigurationComposite.this.getCameraViewConfiguration().getName().replaceAll(" ", "_")) + "_" + Long.toString(timeStamp) + ".png";
                        String filePath = String.valueOf(CameraViewConfigurationComposite.this.getCameraViewConfiguration().getImageAutoSaveFolderPath()) + File.separator + fileName;
                        try {
                            EImagesUtilities.INSTANCE.saveImageAsPNG(filePath, image);
                            return Status.OK_STATUS;
                        }
                        catch (Throwable t) {
                            Logger.error("Failed to save image to <" + filePath + "> !", t);
                            return Status.OK_STATUS;
                        }
                    }
                };
                job.schedule();
            }
        }
    }

    protected AbstractEImage applyFilters(AbstractEImage cameraImage) {
        AbstractEImage filteredImage = EImagesUtilities.INSTANCE.copy(cameraImage);
        if (this.getCameraViewConfiguration() != null) {
            for (ImageFilter filter : this.getCameraViewConfiguration().getFilterList().getImageFilters()) {
                if (!filter.isEnabled()) continue;
                filteredImage = filter.filter(this.getCameraViewConfiguration().getCamera(), filteredImage);
            }
        }
        return filteredImage;
    }

    protected AbstractEImage applyOverlays(AbstractEImage cameraImage) {
        AbstractEImage displayedImage = null;
        if (this.getCameraViewConfiguration() != null) {
            AbstractCamera camera = this.getCameraViewConfiguration().getCamera();
            displayedImage = EImagesUtilities.INSTANCE.copy(cameraImage);
            if (camera != null) {
                List<CameraImageAnnotation> cameraImageAnnotationList = this.getCameraViewConfiguration().getCameraImageAnnotations();
                for (CameraImageAnnotation cameraImageAnnotation : cameraImageAnnotationList) {
                    if (!(cameraImageAnnotation instanceof CameraOverlay)) continue;
                    CameraOverlay cameraOverlay = (CameraOverlay)cameraImageAnnotation;
                    try {
                        if (!cameraOverlay.isVisible()) continue;
                        int overlayWidth = this.getCameraViewConfiguration().getImageWidth();
                        int overlayHeight = this.getCameraViewConfiguration().getImageHeight();
                        OverlayAlignment overlayAlignment = cameraOverlay.getOverlayAlignment();
                        if (cameraOverlay instanceof DrawnCameraOverlay) {
                            DrawnCameraOverlay drawnCameraOverlay = (DrawnCameraOverlay)cameraOverlay;
                            displayedImage = drawnCameraOverlay.applyOverlay(camera, displayedImage, overlayAlignment, overlayWidth, overlayHeight);
                            continue;
                        }
                        if (!(cameraOverlay instanceof ImageCameraOverlay)) continue;
                        if (cameraOverlay.getOverlayAlignment() != OverlayAlignment.CENTER) {
                            overlayWidth = (int)Math.floor((float)this.getCameraViewConfiguration().getImageWidth() * 0.5f);
                            overlayHeight = (int)Math.floor((float)this.getCameraViewConfiguration().getImageHeight() * 0.5f);
                        }
                        ImageCameraOverlay imageCameraOverlay = (ImageCameraOverlay)cameraOverlay;
                        AbstractEImage overlayImage = imageCameraOverlay.getOverlay(camera, overlayAlignment, overlayWidth, overlayHeight);
                        ImageAlignment alignment = ImageAlignment.CENTER;
                        switch (cameraOverlay.getOverlayAlignment().getValue()) {
                            case 2: {
                                alignment = ImageAlignment.LOWER_LEFT_CORNER;
                                break;
                            }
                            case 4: {
                                alignment = ImageAlignment.LOWER_RIGHT_CORNER;
                                break;
                            }
                            case 3: {
                                alignment = ImageAlignment.UPPER_LEFT_CORNER;
                                break;
                            }
                            case 5: {
                                alignment = ImageAlignment.UPPER_RIGHT_CORNER;
                                break;
                            }
                            default: {
                                alignment = ImageAlignment.CENTER;
                            }
                        }
                        displayedImage = EImagesUtilities.INSTANCE.superPoseImages(displayedImage, overlayImage, false, alignment);
                    }
                    catch (Throwable t) {
                        Logger.error("Error while applying overlay <" + cameraOverlay + ">!", t);
                    }
                }
            }
        } else {
            displayedImage = cameraImage;
        }
        return displayedImage;
    }

    protected AbstractEImage applyCameraViewDisplayRotation(CameraViewDisplayRotation cameraViewDisplayRotation, AbstractEImage originalImage) {
        AbstractEImage rotatedImage = null;
        switch (cameraViewDisplayRotation.getValue()) {
            case 0: {
                rotatedImage = originalImage;
                break;
            }
            case 1: {
                rotatedImage = EImagesUtilities.INSTANCE.rotate(originalImage, 1.5707963267948966, true);
                break;
            }
            case 2: {
                rotatedImage = EImagesUtilities.INSTANCE.rotate(originalImage, -1.5707963267948966, true);
                break;
            }
            case 3: {
                rotatedImage = EImagesUtilities.INSTANCE.rotate(originalImage, Math.PI, true);
                break;
            }
        }
        return rotatedImage;
    }

    protected void updateDisplayedImage(final AbstractEImage newImage) {
        if (this.imageDisplayComposite != null && !this.imageDisplayComposite.isDisposed() && newImage != null) {
            final ImageData imgData = EImagesUtilities.INSTANCE.convertToImageData(newImage.asBufferedImage());
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (newImage.asBufferedImage() != null) {
                            CameraViewConfigurationComposite.this.imageDisplayComposite.setSize(newImage.getWidth(), newImage.getHeight());
                            CameraViewConfigurationComposite.this.scrolledComposite.setMinSize(newImage.getWidth(), newImage.getHeight());
                            CameraViewConfigurationComposite.this.imageDisplayComposite.setImageData(imgData);
                            CameraViewConfigurationComposite.this.imageDisplayComposite.fitImage();
                        }
                        CameraViewConfigurationComposite.this.busy = false;
                    }
                    catch (Throwable t) {
                        CameraViewConfigurationComposite.this.busy = false;
                    }
                }
            });
        }
    }

    protected void setDisplaySize(final int width, final int height) {
        if (this.imageDisplayComposite != null && !this.imageDisplayComposite.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CameraViewConfigurationComposite.this.imageDisplayComposite.isDisposed()) {
                        CameraViewConfigurationComposite.this.imageDisplayComposite.setSize(width, height);
                        CameraViewConfigurationComposite.this.scrolledComposite.setMinSize(width, height);
                        CameraViewConfigurationComposite.this.imageDisplayComposite.fitImage();
                    }
                }
            });
        }
    }

    protected Adapter getCameraAdapter() {
        if (this.cameraAdapter == null) {
            this.cameraAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (CameraViewConfigurationComposite.this.getCameraViewConfiguration() != null && CameraViewConfigurationComposite.this.getCameraViewConfiguration().getCamera() == msg.getNotifier() && msg.getFeatureID(AbstractCamera.class) == 7) {
                        ImageSnapshot newImageSnapshot = (ImageSnapshot)msg.getNewValue();
                        CameraViewConfigurationComposite.this.updateImageSnapshot(newImageSnapshot);
                    }
                }
            };
        }
        return this.cameraAdapter;
    }

    protected void updateToolsImageSnapshot(ImageSnapshot imageSnapshot) {
        if (this.getCameraViewConfiguration() != null) {
            for (CameraTool cameraTool : this.getCameraViewConfiguration().getToolList().getTools()) {
                try {
                    cameraTool.updateImageSnapshot(imageSnapshot);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        }
    }

    protected void updateToolsCamera(AbstractCamera newCamera) {
        if (this.getCameraViewConfiguration() != null) {
            for (CameraTool cameraTool : this.getCameraViewConfiguration().getToolList().getTools()) {
                try {
                    cameraTool.initializeCamera(newCamera);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        }
    }

    protected void disposeOfOverlays() {
        if (this.getCameraViewConfiguration() != null) {
            for (CameraOverlay cameraOverlay : this.getCameraViewConfiguration().getOverlayList().getOverlays()) {
                try {
                    cameraOverlay.dispose();
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        }
    }

    protected void disposeOfFilters() {
        if (this.getCameraViewConfiguration() != null) {
            for (ImageFilter imageFilter : this.getCameraViewConfiguration().getFilterList().getImageFilters()) {
                try {
                    imageFilter.dispose();
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        }
    }

    protected void disposeOfCameraTools() {
        if (this.getCameraViewConfiguration() != null) {
            for (CameraTool cameraTool : this.getCameraViewConfiguration().getToolList().getTools()) {
                try {
                    cameraTool.dispose();
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        }
    }

    protected Point getImageSize() {
        int width = 0;
        int height = 0;
        if (this.getCameraViewConfiguration() != null) {
            width = this.getCameraViewConfiguration().getImageWidth();
            height = this.getCameraViewConfiguration().getImageHeight();
        } else {
            width = 640;
            height = 480;
        }
        return new Point(width, height);
    }

    protected AbstractEImage getNoDataImage() {
        Point size = this.getImageSize();
        String text = "";
        Font font = new Font("SansSerif", 0, 24);
        Color textColor = new Color(255, 0, 0);
        Color backgroundColor = new Color(255, 0, 0);
        if (this.getCameraViewConfiguration() == null) {
            text = "No Camera View Configuration Selected !";
            textColor = new Color(255, 0, 0);
            backgroundColor = new Color(0, 0, 0);
        } else if (this.getCamera() == null) {
            text = "The Camera is not initialized.";
            textColor = new Color(255, 255, 0);
            backgroundColor = new Color(0, 0, 0);
        } else if (this.getCamera().getLatestImageSnapshot() == null) {
            text = "No image available.";
            textColor = new Color(0, 255, 0);
            backgroundColor = new Color(0, 0, 0);
        }
        AbstractEImage backgroundImage = EImagesUtilities.INSTANCE.createUniformColorImage(size.x, size.y, backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 255);
        AbstractEImage textImage = EImagesUtilities.INSTANCE.createTextImage(text, font, textColor, backgroundColor, 2);
        AbstractEImage image = EImagesUtilities.INSTANCE.applyOverlay(backgroundImage, textImage, false);
        return image;
    }

    protected CameraViewConfigurationListener getCameraViewConfigurationListener() {
        if (this.cameraViewConfigurationListener == null) {
            this.cameraViewConfigurationListener = new CameraViewConfigurationListener(null){

                @Override
                protected void cameraChanged(AbstractCamera newCamera) {
                    CameraViewConfigurationComposite.this.setCamera(newCamera);
                }

                @Override
                protected void displayRectifiedChanged(boolean newRectified) {
                    CameraViewConfigurationComposite.this.setDisplayRectifiedImage(newRectified);
                }

                @Override
                protected void imageSizeChanged(int newImageWidth, int newImageHeigh) {
                    CameraViewConfigurationComposite.this.setDisplaySize(newImageWidth, newImageHeigh);
                }

                @Override
                protected void imageFiltersChanged() {
                    CameraViewConfigurationComposite.this.forceImageUpdate();
                }

                @Override
                protected void overlaysChanged() {
                    CameraViewConfigurationComposite.this.forceImageUpdate();
                }

                @Override
                protected void toolsChanged() {
                    CameraViewConfigurationComposite.this.forceImageUpdate();
                }
            };
        }
        return this.cameraViewConfigurationListener;
    }

    protected MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    CameraViewConfigurationComposite.this.mouseButton = 0;
                }

                public void mouseDown(MouseEvent e) {
                    if (CameraViewConfigurationComposite.this.getCamera() != null) {
                        CameraViewConfigurationComposite.this.mouseButton = e.button;
                        Point point = CameraViewConfigurationComposite.this.convertToCurrentImageCoordinates(e);
                        AbstractEImage cameraImage = null;
                        if (CameraViewConfigurationComposite.this.getCamera().getLatestImageSnapshot() != null) {
                            cameraImage = CameraViewConfigurationComposite.this.getCamera().getLatestImageSnapshot().getImage();
                        }
                        for (CameraTool cameraTool : CameraViewConfigurationComposite.this.getCameraViewConfiguration().getToolList().getTools()) {
                            if (!cameraTool.isVisible()) continue;
                            try {
                                cameraTool.positionSelected(cameraImage, CameraViewConfigurationComposite.this.mouseButton, point.x, point.y);
                            }
                            catch (Throwable t) {
                                Logger.error(t.getMessage(), t);
                            }
                        }
                        String toolTipText = CameraViewConfigurationComposite.this.getToolTipText(CameraViewConfigurationComposite.this.getCamera(), CameraViewConfigurationComposite.this.lastImageSnapshot, CameraViewConfigurationComposite.this.mouseButton, point.x, point.y);
                        CameraViewConfigurationComposite.this.imageDisplayComposite.getToolTip().setText(toolTipText);
                        CameraViewConfigurationComposite.this.imageDisplayComposite.getToolTip().show(new Point(e.x, e.y));
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                    CameraViewConfigurationComposite.this.mouseButton = e.button;
                }
            };
        }
        return this.mouseListener;
    }

    protected MouseMoveListener getMouseMoveListener() {
        if (this.mouseMoveListener == null) {
            this.mouseMoveListener = new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (CameraViewConfigurationComposite.this.getCamera() != null) {
                        Point point = CameraViewConfigurationComposite.this.convertToCurrentImageCoordinates(e);
                        AbstractEImage cameraImage = null;
                        if (CameraViewConfigurationComposite.this.getCamera().getLatestImageSnapshot() != null) {
                            cameraImage = CameraViewConfigurationComposite.this.getCamera().getLatestImageSnapshot().getImage();
                        }
                        for (CameraTool cameraTool : CameraViewConfigurationComposite.this.getCameraViewConfiguration().getToolList().getTools()) {
                            if (!cameraTool.isVisible()) continue;
                            try {
                                cameraTool.mouseMoved(cameraImage, CameraViewConfigurationComposite.this.mouseButton, point.x, point.y);
                            }
                            catch (Throwable t) {
                                Logger.error(t.getMessage(), t);
                            }
                        }
                        String toolTipText = CameraViewConfigurationComposite.this.getToolTipText(CameraViewConfigurationComposite.this.getCamera(), CameraViewConfigurationComposite.this.lastImageSnapshot, CameraViewConfigurationComposite.this.mouseButton, point.x, point.y);
                        CameraViewConfigurationComposite.this.imageDisplayComposite.getToolTip().setText(toolTipText);
                    }
                }
            };
        }
        return this.mouseMoveListener;
    }

    protected String getToolTipText(AbstractCamera camera, ImageSnapshot imageSnapshot, int mouseButton, int x, int y) {
        String toolTipText = null;
        List<CameraImageAnnotation> annotations = this.getCameraViewConfiguration().getCameraImageAnnotations();
        for (CameraImageAnnotation annotation : annotations) {
            ToolTipTextProvider toolTipTextProvider;
            String annotationToolTipText;
            if (!annotation.isVisible() || !(annotation instanceof ToolTipTextProvider) || (annotationToolTipText = (toolTipTextProvider = (ToolTipTextProvider)((Object)annotation)).getToolTipText(this.getCamera(), this.lastImageSnapshot, mouseButton, x, y)) == null) continue;
            String prefix = new String();
            prefix = annotation.getName() != null ? String.valueOf(annotation.getName()) + " : " : "? : ";
            if (toolTipText != null) {
                toolTipText = String.valueOf(toolTipText) + "\n" + prefix + annotationToolTipText;
                continue;
            }
            toolTipText = new String();
            toolTipText = String.valueOf(toolTipText) + prefix + annotationToolTipText;
        }
        return toolTipText;
    }

    protected Point convertToCurrentImageCoordinates(MouseEvent e) {
        Point point = this.imageDisplayComposite.convertMouseEventPositionToImagePosition(e);
        Point currentImageSize = this.getImageSize();
        int x = point.x;
        int y = point.y;
        if (this.lastImageSnapshot != null && this.lastImageSnapshot.getImage() != null) {
            CameraViewDisplayRotation cameraViewDisplayRotation = CameraViewDisplayRotation.NONE;
            if (this.getCameraViewConfiguration() != null) {
                cameraViewDisplayRotation = this.getCameraViewConfiguration().getCameraViewDisplayRotation();
            }
            double xRatio = 0.0;
            double yRatio = 0.0;
            switch (cameraViewDisplayRotation.getValue()) {
                case 0: {
                    xRatio = (double)point.x / (double)currentImageSize.x;
                    yRatio = (double)point.y / (double)currentImageSize.y;
                    break;
                }
                case 1: {
                    xRatio = (double)point.y / (double)currentImageSize.x;
                    yRatio = 1.0 - (double)point.x / (double)currentImageSize.y;
                    break;
                }
                case 2: {
                    xRatio = 1.0 - (double)point.y / (double)currentImageSize.x;
                    yRatio = (double)point.x / (double)currentImageSize.y;
                    break;
                }
                case 3: {
                    xRatio = 1.0 - (double)point.x / (double)currentImageSize.x;
                    yRatio = 1.0 - (double)point.y / (double)currentImageSize.y;
                    break;
                }
            }
            x = (int)Math.round(xRatio * (double)this.lastImageSnapshot.getImage().getWidth());
            y = (int)Math.round(yRatio * (double)this.lastImageSnapshot.getImage().getHeight());
        }
        return new Point(x, y);
    }
}

