/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.awt.Color;
import java.text.DecimalFormat;
import javax.measure.unit.Unit;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.EMFFeatureOverlayImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFactory;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.listeners.AbstractVariableFeatureReferenceListener;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.swt.graphics.RGBA;

public class EMFFeatureOverlayCustomImpl
extends EMFFeatureOverlayImpl {
    public static final String NO_VALUE_STRING = "???";
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private AbstractVariableFeatureReferenceListener abstractVariableFeatureReferenceListener = null;

    @Override
    public VariableFeatureReference getVariableFeatureReference() {
        VariableFeatureReference tmp = super.getVariableFeatureReference();
        if (tmp == null) {
            tmp = ApogyCoreInvocatorFactory.eINSTANCE.createVariableFeatureReference();
            this.setVariableFeatureReference(tmp);
        }
        return tmp;
    }

    @Override
    public void setVariableFeatureReference(VariableFeatureReference newVariableFeatureReference) {
        super.setVariableFeatureReference(newVariableFeatureReference);
        this.getAbstractVariableFeatureReferenceListener().setVariableFeatureReference(newVariableFeatureReference);
        this.setVariableFeatureReferenceChangeCount(this.getVariableFeatureReferenceChangeCount() + 1L);
    }

    @Override
    public String getDisplayedString() {
        if (this.getVariableFeatureReference() != null) {
            EObject rootEObject = null;
            if (this.variableFeatureReference.getVariable() != null) {
                Variable variable = this.variableFeatureReference.getVariable();
                rootEObject = this.variableFeatureReference.getTypeMemberReferenceListElement() != null ? ApogyCoreInvocatorFacade.INSTANCE.getTypeMemberInstance(this.variableFeatureReference) : ApogyCoreInvocatorFacade.INSTANCE.getInstance(variable);
            }
            if (rootEObject != null) {
                Object featureValue;
                EObject eObject = rootEObject;
                EStructuralFeature[] eStructuralFeatureArray = this.variableFeatureReference.getFeaturePath().getFeaturePath();
                int n = eStructuralFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature eStructuralFeature = eStructuralFeatureArray[n2];
                    Object object = ApogyCommonEMFFacade.INSTANCE.resolve(rootEObject, eStructuralFeature);
                    if (!(object instanceof EObject)) break;
                    eObject = (EObject)object;
                    ++n2;
                }
                if ((featureValue = ApogyCoreInvocatorFacade.INSTANCE.getEMFFeatureValue(this.variableFeatureReference)) != null) {
                    EStructuralFeature feature = ApogyCommonEMFFacade.INSTANCE.getLastFeature(this.variableFeatureReference.getFeaturePath());
                    IItemPropertySource propertySource = (IItemPropertySource)this.adapterFactory.adapt((Notifier)eObject, IItemPropertySource.class);
                    IItemPropertyDescriptor descriptor = propertySource.getPropertyDescriptor((Object)eObject, (Object)feature);
                    if (descriptor != null) {
                        ItemPropertyDescriptor.PropertyValueWrapper wrapper = (ItemPropertyDescriptor.PropertyValueWrapper)descriptor.getPropertyValue((Object)eObject);
                        if (wrapper != null) {
                            if (featureValue instanceof Number && this.getNumberFormat() != null) {
                                try {
                                    DecimalFormat decimalFormat = new DecimalFormat(this.getNumberFormat());
                                    Double value = ((Number)featureValue).doubleValue();
                                    Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)feature);
                                    if (nativeUnits != null) {
                                        Unit<?> displayUnits = this.getDisplayUnit(feature);
                                        if (displayUnits != null) {
                                            double displayValue = nativeUnits.getConverterTo(displayUnits).convert(value.doubleValue());
                                            String valueAsString = decimalFormat.format(displayValue);
                                            return String.valueOf(descriptor.getDisplayName((Object)eObject)) + " (" + displayUnits.toString() + ") : " + valueAsString;
                                        }
                                        String valueAsString = decimalFormat.format(value);
                                        return String.valueOf(descriptor.getDisplayName((Object)eObject)) + " (" + nativeUnits.toString() + ") : " + valueAsString;
                                    }
                                    String valueAsString = decimalFormat.format(value);
                                    return String.valueOf(descriptor.getDisplayName((Object)eObject)) + " : " + valueAsString;
                                }
                                catch (Throwable t) {
                                    return String.valueOf(descriptor.getDisplayName((Object)eObject)) + " : " + wrapper.getText((Object)eObject);
                                }
                            }
                            return String.valueOf(descriptor.getDisplayName((Object)eObject)) + " : " + wrapper.getText((Object)eObject);
                        }
                    } else {
                        if (featureValue instanceof Number && this.getNumberFormat() != null) {
                            try {
                                DecimalFormat decimalFormat = new DecimalFormat(this.getNumberFormat());
                                Double value = ((Number)featureValue).doubleValue();
                                String valueAsString = decimalFormat.format(value);
                                return String.valueOf(feature.getName()) + " : " + valueAsString;
                            }
                            catch (Throwable t) {
                                return String.valueOf(feature.getName()) + " : " + featureValue;
                            }
                        }
                        return String.valueOf(feature.getName()) + " : " + featureValue;
                    }
                    return NO_VALUE_STRING;
                }
            }
        }
        return NO_VALUE_STRING;
    }

    protected EStructuralFeature resolveEStructuralFeature() {
        return ApogyCommonEMFFacade.INSTANCE.getLastFeature(this.variableFeatureReference.getFeaturePath());
    }

    protected Unit<?> getDisplayUnit(EStructuralFeature feature) {
        Unit units = null;
        try {
            units = Unit.valueOf((CharSequence)this.getDisplayUnits());
        }
        catch (Throwable t) {
            units = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)feature);
        }
        return units;
    }

    protected AbstractVariableFeatureReferenceListener getAbstractVariableFeatureReferenceListener() {
        if (this.abstractVariableFeatureReferenceListener == null) {
            this.abstractVariableFeatureReferenceListener = new AbstractVariableFeatureReferenceListener(this.getVariableFeatureReference()){

                protected void variableChanged(Variable oldVariable, Variable newVariable) {
                    EMFFeatureOverlayCustomImpl.this.setVariableFeatureReferenceChangeCount(EMFFeatureOverlayCustomImpl.this.getVariableFeatureReferenceChangeCount() + 1L);
                }

                protected void listRootNodeChanged() {
                    EMFFeatureOverlayCustomImpl.this.setVariableFeatureReferenceChangeCount(EMFFeatureOverlayCustomImpl.this.getVariableFeatureReferenceChangeCount() + 1L);
                }

                protected void typeApiAdapterChanged(TypeApiAdapter oldTypeApiAdapter, TypeApiAdapter newTypeApiAdapter) {
                    EMFFeatureOverlayCustomImpl.this.setVariableFeatureReferenceChangeCount(EMFFeatureOverlayCustomImpl.this.getVariableFeatureReferenceChangeCount() + 1L);
                }
            };
        }
        return this.abstractVariableFeatureReferenceListener;
    }

    @Override
    protected Color getTextBackgroundColor() {
        RGBA color;
        Ranges ranges;
        Object featureValue;
        EStructuralFeature feature;
        if (this.isEnableRangeColoring() && (feature = this.resolveEStructuralFeature()) != null && (featureValue = ApogyCoreInvocatorFacade.INSTANCE.getEMFFeatureValue(this.variableFeatureReference)) != null && (ranges = ApogyCommonEMFFacade.INSTANCE.getRange((ETypedElement)feature, featureValue)) != null && (color = ApogyCommonEMFUIFacade.INSTANCE.getRGBColorForRange(ranges)) != null) {
            return new Color(color.rgb.red, color.rgb.green, color.rgb.blue);
        }
        return null;
    }
}

