/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.apogy.common.geometry.data.Polygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.BreadthFirstIterator;

public class ClosestNeighbourIteratorProvider {
    private CartesianTriangularMesh mesh = null;
    private DirectedGraph<CartesianTriangle, DefaultEdge> graph = null;

    public ClosestNeighbourIteratorProvider(CartesianTriangularMesh mesh) {
        this.mesh = mesh;
    }

    public BreadthFirstIterator<CartesianTriangle, DefaultEdge> createBreadthFirstIterator(CartesianTriangle startTriangle) {
        if (startTriangle != null) {
            return new BreadthFirstIterator(this.getGraph(), (Object)startTriangle);
        }
        return new BreadthFirstIterator(this.getGraph());
    }

    private DirectedGraph<CartesianTriangle, DefaultEdge> getGraph() {
        if (this.graph == null) {
            this.graph = new DefaultDirectedGraph(DefaultEdge.class);
            for (CartesianTriangle triangle : this.mesh.getPolygons()) {
                this.graph.addVertex((Object)triangle);
            }
            for (CartesianTriangle triangle : this.mesh.getPolygons()) {
                EList neighbours = this.mesh.getPolygonNeighbours((Polygon)triangle);
                for (CartesianTriangle neighbour : neighbours) {
                    if (!this.graph.containsEdge((Object)triangle, (Object)neighbour)) {
                        this.graph.addEdge((Object)triangle, (Object)neighbour);
                    }
                    if (this.graph.containsEdge((Object)neighbour, (Object)triangle)) continue;
                    this.graph.addEdge((Object)neighbour, (Object)triangle);
                }
            }
            ConnectivityInspector ci = new ConnectivityInspector(this.graph);
            List connectedSets = ci.connectedSets();
            for (Set set : connectedSets) {
                if (set.size() <= 0) continue;
                ArrayList setTriangles = new ArrayList(set);
                CartesianTriangle sourceTriangle = (CartesianTriangle)setTriangles.get(0);
                for (Set otherSet : connectedSets) {
                    if (otherSet == set || otherSet.size() <= 0) continue;
                    ArrayList othersetTriangles = new ArrayList(otherSet);
                    CartesianTriangle destinationTriangle = (CartesianTriangle)othersetTriangles.get(0);
                    if (!this.graph.containsEdge((Object)sourceTriangle, (Object)destinationTriangle)) {
                        this.graph.addEdge((Object)sourceTriangle, (Object)destinationTriangle);
                    }
                    if (this.graph.containsEdge((Object)destinationTriangle, (Object)sourceTriangle)) continue;
                    this.graph.addEdge((Object)destinationTriangle, (Object)sourceTriangle);
                }
            }
        }
        return this.graph;
    }
}

