/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.renderers;

import javax.inject.Inject;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBGAControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(RBGAControlSWTRenderer.class);
    private Composite content;
    private ColorSelector selector;
    private Spinner alphaSpinner;
    private IChangeListener changeListener;
    private IPropertyChangeListener propertyChangeListener;

    @Inject
    public RBGAControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        return new Binding[0];
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        this.getModelValue().addChangeListener(this.getChangeListener());
        this.content = new Composite(parent, 0);
        this.content.setBackground(parent.getBackground());
        this.content.setBackgroundMode(2);
        this.content.setLayout((Layout)new GridLayout(5, false));
        this.content.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label alphaLabel = new Label(this.content, 0);
        alphaLabel.setText("Alpha:");
        alphaLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.initSpinner();
        Label colorLabel = new Label(this.content, 0);
        colorLabel.setText("Color:");
        colorLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.initSelector();
        this.content.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RBGAControlSWTRenderer.this.changeListener != null) {
                    try {
                        RBGAControlSWTRenderer.this.getModelValue().removeChangeListener(RBGAControlSWTRenderer.this.getChangeListener());
                    }
                    catch (DatabindingFailedException databindingFailedException) {
                        // empty catch block
                    }
                }
            }
        });
        return this.content;
    }

    private void initSpinner() {
        this.alphaSpinner = new Spinner(this.content, 0);
        GridData gd_alphaSpinner = new GridData(16384, 0x1000000, false, false);
        gd_alphaSpinner.minimumWidth = 200;
        gd_alphaSpinner.widthHint = 200;
        this.alphaSpinner.setLayoutData((Object)gd_alphaSpinner);
        this.alphaSpinner.setToolTipText("Set the aplha value of the color: 0 is fully transparent, 255 is fully opaque.");
        this.alphaSpinner.setMinimum(0);
        this.alphaSpinner.setMaximum(255);
        if (this.getValue() != null) {
            RGBA rgba = (RGBA)this.getValue();
            int selection = rgba.alpha;
            this.alphaSpinner.setSelection(selection);
        } else {
            this.alphaSpinner.setSelection(255);
        }
        this.alphaSpinner.setIncrement(1);
        this.alphaSpinner.setPageIncrement(1);
        this.alphaSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    RGBA previousRGBA = (RGBA)RBGAControlSWTRenderer.this.getModelValue().getValue();
                    RGBA newRGBA = new RGBA(previousRGBA.rgb.red, previousRGBA.rgb.green, previousRGBA.rgb.blue, RBGAControlSWTRenderer.this.alphaSpinner.getSelection());
                    RBGAControlSWTRenderer.this.getModelValue().setValue((Object)newRGBA);
                }
                catch (DatabindingFailedException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void initSelector() {
        this.selector = new ColorSelector(this.content);
        GridData gd_selector = new GridData(16384, 0x1000000, false, false);
        gd_selector.minimumWidth = 200;
        gd_selector.widthHint = 200;
        this.selector.getButton().setText("Select...");
        this.selector.getButton().setLayoutData((Object)gd_selector);
        if (this.getValue() != null) {
            this.selector.setColorValue(this.getRGB());
        }
        this.selector.addListener(this.getPropertyChangeListener());
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    System.out.println("RBGAControlSWTRenderer.getPropertyChangeListener().new IPropertyChangeListener() {...}.propertyChange()");
                    if (event.getNewValue() instanceof RGB) {
                        try {
                            RBGAControlSWTRenderer.this.getModelValue().setValue(RBGAControlSWTRenderer.this.convert((RGB)event.getNewValue()));
                        }
                        catch (DatabindingFailedException e) {
                            Logger.error("Unable to set the color value");
                        }
                    }
                }
            };
        }
        return this.propertyChangeListener;
    }

    public IChangeListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                }
            };
        }
        return this.changeListener;
    }

    protected String getUnsetText() {
        return "Unset";
    }

    protected Object getValue() {
        try {
            Object obj = this.getModelValue().getValue();
            return obj;
        }
        catch (DatabindingFailedException e) {
            Logger.error("Unable to get the RGBA value. ");
            return null;
        }
    }

    protected RGB getRGB() {
        if (this.getValue() instanceof RGBA) {
            RGBA rgba = (RGBA)this.getValue();
            return rgba.rgb;
        }
        return null;
    }

    protected Object convert(RGB rgb) {
        return ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(rgb);
    }
}

