/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.impl;

import java.util.Collection;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.EditingDomainsValidity;
import org.eclipse.apogy.common.emf.impl.ApogyCommonTransactionFacadeImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCommonTransactionFacadeCustomImpl
extends ApogyCommonTransactionFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCommonTransactionFacadeImpl.class);

    @Override
    public TransactionalEditingDomain getDefaultEditingDomain() {
        return TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.apogy.common.emf.defaultApogyEditingDomain");
    }

    @Override
    public void addInTempTransactionalEditingDomain(EObject eObject) {
        if (TransactionUtil.getEditingDomain((EObject)eObject) == null) {
            EObject rootObject = EcoreUtil.getRootContainer((EObject)eObject);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(URI.createURI((String)"TEMP_RESOURCE"));
            if (resource != null) {
                resource.getContents().add((Object)rootObject);
            }
            TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
            resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        } else {
            Logger.error(eObject + " is already in an EditingDomain.\nRemove it from it's EditingDomain using ApogyCommonTransactionFacade.removeFromEditingDomain(EObject eObject).");
        }
    }

    @Override
    public void removeFromEditingDomain(EObject eObject) {
        if (eObject != null && eObject.eResource() != null && eObject.eResource().getResourceSet() != null && TransactionUtil.getEditingDomain((EObject)eObject) != null) {
            eObject.eResource().getResourceSet().getResources().remove((Object)eObject.eResource());
            TransactionUtil.disconnectFromEditingDomain((Resource)eObject.eResource());
        }
    }

    @Override
    public EditingDomainsValidity areEditingDomainsValid(EObject owner, EStructuralFeature feature, Object value, boolean fix) {
        TransactionalEditingDomain ownerDomain = TransactionUtil.getEditingDomain((EObject)owner);
        TransactionalEditingDomain childDomain = TransactionUtil.getEditingDomain((Object)value);
        boolean containment = true;
        if (feature instanceof EReference) {
            containment = ((EReference)feature).isContainment();
        } else if (feature instanceof EAttribute) {
            if (ownerDomain != null) {
                return EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN;
            }
            return EditingDomainsValidity.EXECUTE_EMF_METHOD;
        }
        if (containment) {
            if (value == null) {
                if (ownerDomain != null) {
                    return EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN;
                }
                return EditingDomainsValidity.EXECUTE_EMF_METHOD;
            }
            if (ownerDomain == null) {
                if (childDomain == null) {
                    if (fix) {
                        return EditingDomainsValidity.EXECUTE_EMF_METHOD;
                    }
                    Logger.debug("ApogyCommonEmfTransactionFacade.areEditingDomainsValid: Owner and value domains are null.");
                    return EditingDomainsValidity.DONT_EXECUTE;
                }
                if (fix) {
                    this.removeFromEditingDomain((EObject)value);
                    return EditingDomainsValidity.EXECUTE_EMF_METHOD;
                }
                Logger.error("ApogyCommonEmfTransactionFacade.areEditingDomainsValid: Owner domain is null and value domain is not.");
                return EditingDomainsValidity.DONT_EXECUTE;
            }
            if (childDomain == null || ownerDomain == childDomain) {
                return EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN;
            }
            if (fix) {
                this.removeFromEditingDomain((EObject)value);
                return EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN;
            }
            Logger.error("ApogyCommonEmfTransactionFacade.areEditingDomainsValid: Owner domain and value domain are different.");
            return EditingDomainsValidity.DONT_EXECUTE;
        }
        if (ownerDomain != null) {
            return EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN;
        }
        return EditingDomainsValidity.EXECUTE_EMF_METHOD;
    }

    @Override
    public void basicSet(EObject owner, EStructuralFeature feature, Object value, boolean fix) {
        switch (this.areEditingDomainsValid(owner, feature, value, fix).getValue()) {
            case 0: {
                this.executeCommand((AbstractOverrideableCommand)new SetCommand((EditingDomain)this.getTransactionalEditingDomain(owner), owner, feature, value));
                break;
            }
            case 1: {
                owner.eSet(feature, value);
                break;
            }
            case 2: {
                Logger.error("ApogyCommonEmfTransactionFacade.basicSet: Command was not executed.");
                break;
            }
        }
    }

    @Override
    public void basicSet(EObject owner, EStructuralFeature feature, Object value) {
        this.basicSet(owner, feature, value, false);
    }

    @Override
    public void basicAdd(EObject owner, EStructuralFeature feature, Object value, boolean fix) {
        switch (this.areEditingDomainsValid(owner, feature, value, fix).getValue()) {
            case 0: {
                this.executeCommand((AbstractOverrideableCommand)new AddCommand((EditingDomain)this.getTransactionalEditingDomain(owner), owner, feature, value));
                break;
            }
            case 1: {
                EList list = (EList)owner.eGet(feature);
                list.add(value);
                break;
            }
            case 2: {
                Logger.error("ApogyCommonEmfTransactionFacade.basicAdd: Command was not executed.");
                break;
            }
        }
    }

    @Override
    public void basicAdd(EObject owner, EStructuralFeature feature, Object value) {
        this.basicAdd(owner, feature, value, false);
    }

    @Override
    public void basicAdd(EObject owner, EStructuralFeature feature, Collection<?> collection, boolean fix) {
        if (!collection.isEmpty()) {
            EditingDomainsValidity execute = EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN;
            for (Object object : collection) {
                execute = this.areEditingDomainsValid(owner, feature, object, fix);
                if (execute != EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN) break;
            }
            switch (execute.getValue()) {
                case 0: {
                    this.executeCommand((AbstractOverrideableCommand)new AddCommand((EditingDomain)this.getTransactionalEditingDomain(owner), owner, feature, collection));
                    break;
                }
                case 1: {
                    Logger.error("basicAdd(): Command was not executed, error in editing domains.");
                    break;
                }
                case 2: {
                    Logger.error("basicAdd(): Command was not executed.");
                    break;
                }
            }
        }
    }

    @Override
    public void basicAdd(EObject owner, EStructuralFeature feature, Collection<?> collection) {
        this.basicAdd(owner, feature, collection, false);
    }

    @Override
    public void basicRemove(EObject owner, EStructuralFeature feature, Object value, boolean fix) {
        switch (this.areEditingDomainsValid(owner, feature, value, fix)) {
            case EXECUTE_COMMAND_ON_OWNER_DOMAIN: {
                this.executeCommand((AbstractOverrideableCommand)new RemoveCommand((EditingDomain)this.getTransactionalEditingDomain(owner), owner, feature, value));
                break;
            }
            case EXECUTE_EMF_METHOD: {
                EList list = (EList)owner.eGet(feature);
                list.remove(value);
                break;
            }
            case DONT_EXECUTE: {
                Logger.error("basicRemove(): Command was not executed.");
                break;
            }
        }
    }

    @Override
    public void basicRemove(EObject owner, EStructuralFeature feature, Object value) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)owner);
        if (domain instanceof TransactionalEditingDomain) {
            RemoveCommand command = new RemoveCommand(domain, owner, feature, value);
            domain.getCommandStack().execute((Command)command);
        } else {
            Logger.error("basicRemove():  Editing domain of " + owner + " is not Transactional ");
        }
    }

    @Override
    public void basicRemove(EObject owner, EStructuralFeature feature, Collection<?> collection, boolean fix) {
        EditingDomainsValidity execute = EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN;
        for (Object object : collection) {
            execute = this.areEditingDomainsValid(owner, feature, object, fix);
            if (execute != EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN) break;
        }
        switch (execute) {
            case EXECUTE_COMMAND_ON_OWNER_DOMAIN: {
                this.executeCommand((AbstractOverrideableCommand)new RemoveCommand((EditingDomain)this.getTransactionalEditingDomain(owner), owner, feature, collection));
                break;
            }
            case EXECUTE_EMF_METHOD: {
                ((Collection)owner.eGet(feature)).removeAll(collection);
                break;
            }
            case DONT_EXECUTE: {
                Logger.error("basicRemove(): Command was not executed.");
                break;
            }
        }
    }

    @Override
    public void basicRemove(EObject owner, EStructuralFeature feature, Collection<?> collection) {
        this.basicRemove(owner, feature, collection, false);
    }

    @Override
    public void basicClear(EObject owner, EStructuralFeature feature, boolean fix) {
        this.basicRemove(owner, feature, (Collection)owner.eGet(feature), fix);
    }

    @Override
    public void basicClear(EObject owner, EStructuralFeature feature) {
        this.basicClear(owner, feature, false);
    }

    @Override
    public void basicDelete(EObject owner, FeaturePath featurePath, Object value) {
        this.basicDelete(owner, featurePath, value, true);
    }

    @Override
    public void basicDelete(EObject owner, FeaturePath featurePath, Object value, boolean fix) {
        EObject directOwner = ApogyCommonEMFFacade.INSTANCE.resolveOwner(owner, featurePath);
        if (directOwner != null) {
            EStructuralFeature[] features = featurePath.getFeaturePath();
            this.basicDelete(directOwner, features[features.length - 1], value, fix);
        }
    }

    @Override
    public void basicDelete(EObject owner, FeaturePath featurePath, Collection<?> collection, boolean fix) {
        EObject directOwner = ApogyCommonEMFFacade.INSTANCE.resolveOwner(owner, featurePath);
        if (directOwner != null) {
            EStructuralFeature[] features = featurePath.getFeaturePath();
            this.basicRemove(directOwner, features[features.length - 1], collection, fix);
        }
    }

    @Override
    public void basicDelete(EObject owner, EStructuralFeature feature, Object value, boolean fix) {
        if (feature.isMany()) {
            this.basicRemove(owner, feature, value, fix);
        } else {
            this.basicSet(owner, feature, null, fix);
        }
    }

    @Override
    public void basicDelete(EObject owner, EStructuralFeature feature, Object value) {
        this.basicDelete(owner, feature, value, false);
    }

    @Override
    public void executeCommand(AbstractOverrideableCommand command) {
        if (command.getDomain() instanceof TransactionalEditingDomain) {
            command.getDomain().getCommandStack().execute((Command)command);
        } else {
            try {
                throw new Exception("Command can not be executed. Is the owner in a TransactionalEditingDomain?");
            }
            catch (Exception e) {
                Logger.error("Command can not be executed. Is the owner in a TransactionalEditingDomain?", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    @Override
    public TransactionalEditingDomain getTransactionalEditingDomain(EObject eObject) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
        if (domain instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)domain;
        }
        return null;
    }

    @Override
    public void basicMove(EObject owner, EStructuralFeature feature, int sourceIndex, int targetIndex) {
        this.basicMove(owner, feature, sourceIndex, targetIndex, false);
    }

    @Override
    public void basicMove(EObject owner, EStructuralFeature feature, int sourceIndex, int targetIndex, boolean fix) {
        if (owner != null && feature != null && feature instanceof EReference) {
            this.executeCommand((AbstractOverrideableCommand)new MoveCommand((EditingDomain)this.getTransactionalEditingDomain(owner), owner, feature, sourceIndex, targetIndex));
        }
    }
}

