/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.ui.impl;

import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Data3DUtils;
import org.eclipse.apogy.common.geometry.data3d.ui.Activator;
import org.eclipse.apogy.common.geometry.data3d.ui.impl.CartesianCoordinatesSetPresentationImpl;
import org.eclipse.apogy.common.geometry.data3d.ui.scene_objects.CartesianCoordinatesSetSceneObject;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.ui.SceneObject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class CartesianCoordinatesSetPresentationCustomImpl
extends CartesianCoordinatesSetPresentationImpl {
    protected IPropertyChangeListener preferencesListener = null;

    protected CartesianCoordinatesSetPresentationCustomImpl() {
        this.applyPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    @Override
    public CartesianCoordinatesSet basicGetPointCloud() {
        ContentNode cNode;
        CartesianCoordinatesSet coordSet = null;
        if (this.getNode() != null && (cNode = (ContentNode)this.getNode()).getContent() instanceof CartesianCoordinatesSet) {
            coordSet = (CartesianCoordinatesSet)cNode.getContent();
        }
        return coordSet;
    }

    @Override
    public int getNumberOfPoints() {
        int numberOfPoints = 0;
        if (this.getPointCloud() != null) {
            numberOfPoints = this.getPointCloud().getPoints().size();
        }
        return numberOfPoints;
    }

    public Tuple3d basicGetCentroid() {
        Data3DUtils utils = ApogyCommonGeometryData3DFactory.eINSTANCE.createData3DUtils();
        CartesianPositionCoordinates centroid = utils.computeCentroid(this.getPointCloud());
        Tuple3d point = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)centroid.asPoint3d());
        return point;
    }

    public void setSceneObject(SceneObject newSceneObject) {
        if (newSceneObject != null && !(newSceneObject instanceof CartesianCoordinatesSetSceneObject)) {
            throw new IllegalArgumentException();
        }
        super.setSceneObject(newSceneObject);
    }

    protected void initialSceneObject() {
        CartesianCoordinatesSetSceneObject pointsSceneObject = (CartesianCoordinatesSetSceneObject)this.getSceneObject();
        pointsSceneObject.setPointSize(this.getPointSize());
        super.initialSceneObject();
    }

    protected void updateSceneObject(Notification notification) {
        if (this.sceneObject != null) {
            CartesianCoordinatesSetSceneObject pointsSceneObject = (CartesianCoordinatesSetSceneObject)this.sceneObject;
            if (notification.getNotifier() instanceof CartesianCoordinatesSetPresentationCustomImpl) {
                int featureID = notification.getFeatureID(CartesianCoordinatesSetPresentationCustomImpl.class);
                switch (featureID) {
                    case 17: {
                        pointsSceneObject.setPointSize(this.getPointSize());
                        break;
                    }
                }
            }
        }
        super.updateSceneObject(notification);
    }

    protected void applyPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_CARTESIAN_COORD_SET_COLOR_ID");
        if (rgb != null) {
            this.setColor(ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(rgb));
        }
        this.setVisible(store.getBoolean("DEFAULT_CARTESIAN_COORD_SET_VISIBILITY_ID"));
        int pointSize = store.getInt("DEFAULT_CARTESIAN_COORD_SET_POINT_SIZE_ID");
        this.setPointSize(pointSize);
        super.applyPreferences();
    }

    protected IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    CartesianCoordinatesSetPresentationCustomImpl.this.applyPreferences();
                }
            };
        }
        return this.preferencesListener;
    }
}

