/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.provider.Matrix4x4ItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class Matrix4x4CustomItemProvider
extends Matrix4x4ItemProvider {
    public static final String DEGREE_STRING = "\u00b0";
    public static final String METERS_STRING = "m";
    private final DecimalFormat positionFormat = new DecimalFormat("0.000");
    private final DecimalFormat orientationFormat = new DecimalFormat("0.0");

    public Matrix4x4CustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        Matrix4x4 matrix4x4 = (Matrix4x4)object;
        Tuple3d position = ApogyCommonMathFacade.INSTANCE.extractPosition(matrix4x4);
        Tuple3d orientation = ApogyCommonMathFacade.INSTANCE.extractOrientation(matrix4x4);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getString("_UI_Matrix4x4_type"));
        buffer.append(" (" + this.positionFormat.format(position.getX()) + METERS_STRING + ", ");
        buffer.append(String.valueOf(this.positionFormat.format(position.getY())) + METERS_STRING + ", ");
        buffer.append(String.valueOf(this.positionFormat.format(position.getZ())) + METERS_STRING + ")");
        buffer.append(" (" + this.orientationFormat.format(Math.toDegrees(orientation.getX())) + DEGREE_STRING + ", ");
        buffer.append(String.valueOf(this.orientationFormat.format(Math.toDegrees(orientation.getY()))) + DEGREE_STRING + ", ");
        buffer.append(String.valueOf(this.orientationFormat.format(Math.toDegrees(orientation.getZ()))) + DEGREE_STRING + ")");
        return buffer.toString();
    }
}

