/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import java.util.concurrent.Callable;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.primitives.DirectionalLight;
import org.eclipse.apogy.common.topology.addons.primitives.PointLight;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;

public class DirectionalLightJME3SceneObject
extends DefaultJME3SceneObject<DirectionalLight> {
    private Adapter adapter;
    public static float DEFAULT_POINT_LIGHT_RADIUS = 10.0f;
    private final AssetManager assetManager;
    private com.jme3.light.DirectionalLight directionalLight;

    public DirectionalLightJME3SceneObject(DirectionalLight topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)topologyNode, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.requestUpdate();
        topologyNode.eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.directionalLight == null) {
            this.getDirectionalLight();
        }
        if (((DirectionalLight)this.getTopologyNode()).isEnabled()) {
            this.jme3Application.getRootNode().addLight((Light)this.directionalLight);
        } else {
            this.jme3Application.getRootNode().removeLight((Light)this.directionalLight);
        }
    }

    public void setVisible(final boolean visible) {
        super.setVisible(visible);
        if (this.directionalLight != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (visible) {
                        if (!DirectionalLightJME3SceneObject.this.jme3Application.getRootNode().getChildren().contains(DirectionalLightJME3SceneObject.this.directionalLight)) {
                            DirectionalLightJME3SceneObject.this.jme3Application.getRootNode().addLight((Light)DirectionalLightJME3SceneObject.this.directionalLight);
                        }
                    } else {
                        DirectionalLightJME3SceneObject.this.jme3Application.getRootNode().removeLight((Light)DirectionalLightJME3SceneObject.this.directionalLight);
                    }
                    return null;
                }
            });
        }
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((DirectionalLight)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        if (this.directionalLight != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DirectionalLightJME3SceneObject.this.jme3Application.getRootNode().removeLight((Light)DirectionalLightJME3SceneObject.this.directionalLight);
                    return null;
                }
            });
        }
        super.dispose();
    }

    public void setLightDirection(Tuple3d direction) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return null;
            }
        });
    }

    public void setLightColor(RGBA color) {
        final ColorRGBA lightColor = JME3Utilities.convertToColorRGBA((RGBA)color);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DirectionalLightJME3SceneObject.this.getDirectionalLight().setColor(lightColor);
                return null;
            }
        });
    }

    private com.jme3.light.DirectionalLight getDirectionalLight() {
        if (this.directionalLight == null) {
            this.directionalLight = new com.jme3.light.DirectionalLight();
            this.directionalLight.setColor(ColorRGBA.White);
            this.directionalLight.setDirection(new Vector3f(0.0f, 0.0f, -1.0f));
            if (((DirectionalLight)this.getTopologyNode()).getNodeId() != null) {
                this.directionalLight.setName(((DirectionalLight)this.getTopologyNode()).getNodeId());
            }
        }
        return this.directionalLight;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof PointLight) {
                        int featureID = msg.getFeatureID(PointLight.class);
                        switch (featureID) {
                            case 3: {
                                DirectionalLightJME3SceneObject.this.setVisible(msg.getNewBooleanValue());
                                break;
                            }
                            case 5: {
                                if (!(msg.getNewFloatValue() >= 0.0f) || !(msg.getNewValue() instanceof Tuple3d)) break;
                                Tuple3d direction = (Tuple3d)msg.getNewValue();
                                DirectionalLightJME3SceneObject.this.setLightDirection(direction);
                                break;
                            }
                            case 4: {
                                if (!(msg.getNewValue() instanceof RGBA)) break;
                                DirectionalLightJME3SceneObject.this.setLightColor((RGBA)msg.getNewValue());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

