/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.EObjectReferencesList;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitTool;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitTools;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.planner.AbstractStatelessCostFunction;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ApogyCoreEnvironmentEarthOrbitPlannerFactory;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlanner;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerNode;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerTool;
import org.eclipse.apogy.core.environment.earth.orbit.planner.impl.ApogyCoreEnvironmentEarthOrbitPlannerFacadeImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCoreEnvironmentEarthOrbitPlannerFacadeCustomImpl
extends ApogyCoreEnvironmentEarthOrbitPlannerFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCoreEnvironmentEarthOrbitPlannerFacadeCustomImpl.class);

    @Override
    public ObservationAnalysisPlannerNode generateObservationsPlanTree(List<VisibilityPass> passes, IProgressMonitor monitor) {
        Logger.debug("Generate Observations Plan Tree started.");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)passes.size());
        List<VisibilityPass> sortedPasses = passes.stream().sorted(Comparator.comparing(TimeInterval::getFromDate)).collect(Collectors.toList());
        ObservationAnalysisPlannerNode rootNode = ApogyCoreEnvironmentEarthOrbitPlannerFactory.eINSTANCE.createObservationAnalysisPlannerNode();
        this.generateObservationAnalysisPlannerNode(rootNode, sortedPasses, subMonitor);
        Logger.debug("Generate Observations Plan Tree completed.");
        return rootNode;
    }

    protected void generateObservationAnalysisPlannerNode(ObservationAnalysisPlannerNode parent, List<VisibilityPass> passes, SubMonitor monitor) {
        int childId = 1;
        for (VisibilityPass pass : passes) {
            ObservationAnalysisPlannerNode childNode = ApogyCoreEnvironmentEarthOrbitPlannerFactory.eINSTANCE.createObservationAnalysisPlannerNode();
            childNode.setId(parent.getId() == null ? "" + childId : (parent.getId().isEmpty() ? "" + childId : String.valueOf(parent.getId()) + "." + childId));
            System.err.println("ApogyCoreEnvironmentEarthOrbitPlannerFacadeCustomImpl.generateObservationAnalysisPlannerNode(): " + childNode.getId());
            List<VisibilityPass> reducedVisibilityPasses = passes.stream().filter(p -> p != pass && p.getOutlook() != pass.getOutlook()).collect(Collectors.toList());
            childNode.setPass(pass);
            parent.getChildren().add((Object)childNode);
            SubMonitor subMonitor = monitor.split(reducedVisibilityPasses.size());
            this.generateObservationAnalysisPlannerNode(childNode, reducedVisibilityPasses, subMonitor);
            ++childId;
        }
    }

    @Override
    public ObservationAnalysisPlanner computeObservationAnalysisPlanCosts(ObservationAnalysisPlanner planner, IProgressMonitor monitor) {
        Logger.debug("Computing Observations Plan Costs started.");
        ObservationAnalysisPlannerNode rootNode = planner.getResult().getPlanRootNode();
        planner.getStatelessCostFunctions().forEach(costFunction -> {});
        this.computeObservationAnalysisPlanCosts(planner, rootNode, monitor);
        Logger.debug("Computing Observations Plan Costs failed.");
        return planner;
    }

    protected void computeObservationAnalysisPlanCosts(ObservationAnalysisPlanner planner, ObservationAnalysisPlannerNode parent, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)parent.getChildren().size());
        parent.getChildren().forEach(child -> {
            for (AbstractStatelessCostFunction costFunction : planner.getStatelessCostFunctions()) {
                costFunction.isEnable();
            }
            this.computeObservationAnalysisPlanCosts(planner, parent, (IProgressMonitor)subMonitor);
        });
    }

    @Override
    public ObservationAnalysisPlannerTool getObservationAnalysisPlannerTool() {
        EarthOrbitTools earthOrbitTools = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getActiveEarthOrbitTools();
        ObservationAnalysisPlannerTool tool = null;
        if (earthOrbitTools != null) {
            Iterator it = earthOrbitTools.getTools().iterator();
            while (it.hasNext() && tool == null) {
                EarthOrbitTool earthOrbitTool = (EarthOrbitTool)it.next();
                if (!(earthOrbitTool instanceof ObservationAnalysisPlannerTool)) continue;
                tool = (ObservationAnalysisPlannerTool)earthOrbitTool;
            }
        }
        return tool;
    }

    @Override
    public List<ObservationAnalysisPlannerNode> getLeafs(ObservationAnalysisPlannerNode root) {
        ArrayList<ObservationAnalysisPlannerNode> nodesList = new ArrayList<ObservationAnalysisPlannerNode>();
        for (ObservationAnalysisPlannerNode childNode : root.getChildren()) {
            if (childNode.getChildren().isEmpty()) {
                nodesList.add(childNode);
                continue;
            }
            nodesList.addAll(this.getLeafs(childNode));
        }
        return nodesList;
    }

    @Override
    public EObjectReferencesList<ObservationAnalysisPlannerNode> getPlannerSolution(ObservationAnalysisPlannerNode leaf) {
        EObjectReferencesList solution = ApogyCommonEMFFactory.eINSTANCE.createEObjectReferencesList();
        ObservationAnalysisPlannerNode currentNode = leaf;
        while (currentNode != null && currentNode.getParent() != null && currentNode.getParent() instanceof ObservationAnalysisPlannerNode) {
            solution.getEObjects().add(0, (Object)currentNode);
            currentNode = currentNode.getParent();
        }
        return solution;
    }

    @Override
    public EObjectReferencesList<VisibilityPass> getVisibilityPasses(List<ObservationAnalysisPlannerNode> nodesList) {
        EObjectReferencesList passes = null;
        if (nodesList != null) {
            passes = ApogyCommonEMFFactory.eINSTANCE.createEObjectReferencesList();
            for (ObservationAnalysisPlannerNode node : nodesList) {
                passes.getEObjects().add((Object)node.getPass());
            }
        }
        return passes;
    }
}

