/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.environment.earth.orbit.AbstractObservationTargetImporter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class AbstractObservationTargetImporterListComposite<Root extends EObject>
extends EMFFormsEListComposite<Root, Root, AbstractObservationTargetImporter> {
    public static final int NAME_COL_MIN_WIDTH = 100;
    public static final int DESCRIPTION_COL_MIN_WIDTH = 100;

    public AbstractObservationTargetImporterListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(parent, style, featurePath, eStructuralFeature);
    }

    protected void createColumns(TreeViewer viewer) {
        final TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractObservationTargetImporter) {
                    AbstractObservationTargetImporter importer = (AbstractObservationTargetImporter)element;
                    String text = importer.getName();
                    return text == null || text.length() == 0 ? "" : text;
                }
                return "";
            }
        });
        nameColumn.getColumn().setWidth(100);
        nameColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (nameColumn.getColumn().getWidth() < 100) {
                    nameColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        final TreeViewerColumn descriptionColumn = new TreeViewerColumn(viewer, 0);
        descriptionColumn.getColumn().setText("Description");
        descriptionColumn.getColumn().setAlignment(0x1000000);
        descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractObservationTargetImporter) {
                    AbstractObservationTargetImporter importer = (AbstractObservationTargetImporter)element;
                    String text = importer.getDescription();
                    return text == null || text.length() == 0 ? "" : text;
                }
                return "";
            }
        });
        descriptionColumn.getColumn().setWidth(100);
        descriptionColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (descriptionColumn.getColumn().getWidth() < 100) {
                    descriptionColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
    }

    protected AdapterFactoryLabelProvider.StyledLabelProvider createLabelProvider(AdapterFactory adapterFactory) {
        return null;
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        Button importButton = this.createImportButton(parent, style);
        importButton.setToolTipText("Causes the selected Importer to import Observation Targets.");
    }
}

