/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthPackage;
import org.eclipse.apogy.core.environment.earth.EarthOutlook;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;

public class EarthOutlookListComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemEObject extends EarthOutlook>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemEObject> {
    public static final int NAME_COL_MIN_WIDTH = 150;
    public static final int DESCRIPTION_COL_MIN_WIDTH = 100;
    public static final int LONGITUDE_COL_MIN_WIDTH = 100;
    public static final int LATITUDE_COL_MIN_WIDTH = 100;
    public static final int ELEVATION_COL_MIN_WIDTH = 100;

    public EarthOutlookListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createColumns(TreeViewer viewer) {
        final TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarthOutlook outlook = (EarthOutlook)element;
                String text = outlook.getName();
                return text == null || text.length() == 0 ? "" : text;
            }
        });
        nameColumn.getColumn().setWidth(150);
        nameColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (nameColumn.getColumn().getWidth() < 150) {
                    nameColumn.getColumn().setWidth(150);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        final TreeViewerColumn descriptionColumn = new TreeViewerColumn(viewer, 0);
        descriptionColumn.getColumn().setText("Description");
        descriptionColumn.getColumn().setAlignment(0x1000000);
        descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarthOutlook outlook = (EarthOutlook)element;
                String text = outlook.getDescription();
                return text == null || text.length() == 0 ? "" : text;
            }
        });
        descriptionColumn.getColumn().setWidth(100);
        descriptionColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (descriptionColumn.getColumn().getWidth() < 100) {
                    descriptionColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        Unit longitudeDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE);
        final TreeViewerColumn longitudeViewerColumn = new TreeViewerColumn(viewer, 0);
        longitudeViewerColumn.getColumn().setText("Longitude (" + longitudeDisplayedUnits.toString() + ")");
        longitudeViewerColumn.getColumn().setAlignment(0x1000000);
        longitudeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarthOutlook outlook = (EarthOutlook)element;
                return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)outlook.getLongitude(), (ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE);
            }
        });
        longitudeViewerColumn.getColumn().setWidth(100);
        longitudeViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (longitudeViewerColumn.getColumn().getWidth() < 100) {
                    longitudeViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        Unit latitudeDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE);
        final TreeViewerColumn latitudeViewerColumn = new TreeViewerColumn(viewer, 0);
        latitudeViewerColumn.getColumn().setText("Latitude (" + latitudeDisplayedUnits.toString() + ")");
        latitudeViewerColumn.getColumn().setAlignment(0x1000000);
        latitudeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarthOutlook outlook = (EarthOutlook)element;
                return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)outlook.getLatitude(), (ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE);
            }
        });
        latitudeViewerColumn.getColumn().setWidth(100);
        latitudeViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (latitudeViewerColumn.getColumn().getWidth() < 100) {
                    latitudeViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        Unit elevationDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION);
        final TreeViewerColumn elevationTableViewerColumn = new TreeViewerColumn(viewer, 0);
        elevationTableViewerColumn.getColumn().setText("Elevation (" + elevationDisplayedUnits.toString() + ")");
        elevationTableViewerColumn.getColumn().setAlignment(0x1000000);
        elevationTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarthOutlook outlook = (EarthOutlook)element;
                return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)outlook.getElevation(), (ETypedElement)ApogyCoreEnvironmentEarthPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION);
            }
        });
        elevationTableViewerColumn.getColumn().setWidth(100);
        elevationTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (elevationTableViewerColumn.getColumn().getWidth() < 100) {
                    elevationTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
    }
}

