/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.apogy.common.ui.birt.composites.XYBIRTChartComposite;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class VisibilityPassSpacecraftPositionHistoryElevationVsAzimuthComposite<RootEObject extends EObject>
extends AbstractEObjectComposite<RootEObject, VisibilityPassSpacecraftPositionHistory, VisibilityPassSpacecraftPositionHistory> {
    protected VisibilityPassSpacecraftPositionHistory positionHistory = null;
    protected ETypedElement xValuesETypedElement;
    protected ETypedElement yValuesETypedElement;
    protected XYBIRTChartComposite xyBIRTChartComposite = null;
    protected RGB plotBackgroundColor = new RGB(0, 0, 0);
    protected RGB plotGridColor = new RGB(0, 255, 0);
    protected RGB seriesColor = new RGB(255, 255, 0);

    public VisibilityPassSpacecraftPositionHistoryElevationVsAzimuthComposite(Composite parent, int style) {
        super(parent, style, null, null);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        this.xyBIRTChartComposite = new XYBIRTChartComposite(parent, style);
        this.xyBIRTChartComposite.setChartTitle("Elevation vs Azimuth");
        this.xyBIRTChartComposite.setPlotBackgroundColor(this.plotBackgroundColor);
        this.xyBIRTChartComposite.setPlotGridColor(this.plotGridColor);
        this.xyBIRTChartComposite.setSeriesColor(this.seriesColor);
        this.xyBIRTChartComposite.setXAxisName("Azimuth Angle (" + this.getXValuesDisplayUnits() + ")");
        this.xyBIRTChartComposite.setXAxisFormatString("0.0");
        this.xyBIRTChartComposite.setYAxisName("Elevation Angle (" + this.getYValuesDisplayUnits() + ")");
        this.xyBIRTChartComposite.setYAxisFormatString("0.0");
        return this.xyBIRTChartComposite;
    }

    public void setRootEObject(RootEObject rootEObject) {
        super.setRootEObject(rootEObject);
        this.setPositionHistory((VisibilityPassSpacecraftPositionHistory)this.getResolvedEObject());
    }

    protected VisibilityPassSpacecraftPositionHistory getPositionHistory() {
        return this.positionHistory;
    }

    protected void setPositionHistory(VisibilityPassSpacecraftPositionHistory positionHistory) {
        this.positionHistory = positionHistory;
        this.updateDisplayedValues(positionHistory);
    }

    protected ETypedElement getXValuesDisplayedETypedElement() {
        return ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__AZIMUTH;
    }

    public Unit<?> getXValuesDisplayUnits() {
        ETypedElement eTypedElement = this.getXValuesDisplayedETypedElement();
        if (eTypedElement != null) {
            return ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(eTypedElement);
        }
        return null;
    }

    public Unit<?> getXValuesNativeUnits() {
        ETypedElement eTypedElement = this.getXValuesDisplayedETypedElement();
        if (eTypedElement != null) {
            return ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(eTypedElement);
        }
        return null;
    }

    protected ETypedElement getYValuesDisplayedETypedElement() {
        return ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__ELEVATION;
    }

    public Unit<?> getYValuesDisplayUnits() {
        return Unit.valueOf((CharSequence)"deg");
    }

    public Unit<?> getYValuesNativeUnits() {
        ETypedElement eTypedElement = this.getYValuesDisplayedETypedElement();
        if (eTypedElement != null) {
            return ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(eTypedElement);
        }
        return null;
    }

    protected double convertXvaluesToDisplayedValue(double nativeUnitsValue) {
        Unit<?> displayUnits = this.getXValuesDisplayUnits();
        Unit<?> nativeUnits = this.getXValuesNativeUnits();
        if (displayUnits != null && nativeUnits != null) {
            return nativeUnits.getConverterTo(displayUnits).convert(nativeUnitsValue);
        }
        return nativeUnitsValue;
    }

    protected double convertYvaluesToDisplayedValue(double nativeUnitsValue) {
        Unit<?> displayUnits = this.getXValuesDisplayUnits();
        Unit<?> nativeUnits = this.getXValuesNativeUnits();
        if (displayUnits != null && nativeUnits != null) {
            return nativeUnits.getConverterTo(displayUnits).convert(nativeUnitsValue);
        }
        return nativeUnitsValue;
    }

    protected SortedMap<Double, Double> getAzimuthSortedValues(VisibilityPassSpacecraftPositionHistory positionHistory) {
        TreeMap<Double, Double> sorted = new TreeMap<Double, Double>();
        for (VisibilityPassSpacecraftPosition position : positionHistory.getPositions()) {
            double azimuthNativeValue = ((Number)position.eGet((EStructuralFeature)this.getXValuesDisplayedETypedElement())).doubleValue();
            double azimuthConvertedValue = this.convertXvaluesToDisplayedValue(azimuthNativeValue);
            double elevationNativeValue = ((Number)position.eGet((EStructuralFeature)this.getYValuesDisplayedETypedElement())).doubleValue();
            double elevationConvertedValue = this.convertYvaluesToDisplayedValue(elevationNativeValue);
            sorted.put(azimuthConvertedValue, elevationConvertedValue);
        }
        return sorted;
    }

    protected void updateDisplayedValues(VisibilityPassSpacecraftPositionHistory positionHistory) {
        ArrayList<Double> xValues = null;
        ArrayList<Double> yValues = null;
        if (positionHistory != null) {
            SortedMap<Double, Double> sortedSeriesData = this.getAzimuthSortedValues(positionHistory);
            xValues = new ArrayList();
            xValues.addAll(sortedSeriesData.keySet());
            yValues = new ArrayList();
            yValues.addAll(sortedSeriesData.values());
        } else {
            xValues = new ArrayList<Double>();
            xValues.add(new Double(0.0));
            yValues = new ArrayList<Double>();
            yValues.add(new Double(0.0));
        }
        this.xyBIRTChartComposite.updateValues(xValues, yValues);
    }
}

