/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.ui.wizards.ExportToFileWizard;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.apogy.core.environment.earth.orbit.ui.composites.VisibilityPassSpacecraftPositionHistoryComposite;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class VisibilityPassesListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, VisibilityPass> {
    private static final int ORBIT_MODEL_COL_MIN_WIDTH = 100;
    private static final int LOCATION_COL_MIN_WIDTH = 100;
    private static final int DURATION_COL_MIN_WIDTH = 100;
    private static final int START_TIME_COL_MIN_WIDTH = 100;
    private static final int END_TIME_COL_MIN_WIDTH = 100;
    private DecimalFormat durationFormat = new DecimalFormat("0.0");
    private VisibilityPassSpacecraftPositionHistoryComposite<VisibilityPass, VisibilityPass> visibilityPassSpacecraftPositionHistoryComposite;

    public VisibilityPassesListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createExportButton(parent, style);
    }

    protected void doExport() {
        for (VisibilityPass pass : this.getSelectedItemObjects()) {
            VisibilityPassSpacecraftPositionHistory positionHistory = pass.getPositionHistory();
            if (positionHistory == null) continue;
            IFileExporter iFileExporter = ApogyCommonConvertersFacade.INSTANCE.getIFileExporter((Object)positionHistory);
            ExportToFileWizard wizard = new ExportToFileWizard(iFileExporter, (Object)positionHistory);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    protected void createColumns(TreeViewer viewer) {
        this.createOrbitModelTableColumn(viewer);
        final TreeViewerColumn outlookTableViewerColumn = new TreeViewerColumn(viewer, 0);
        outlookTableViewerColumn.getColumn().setText("Location");
        outlookTableViewerColumn.getColumn().setAlignment(0x1000000);
        outlookTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                if (visibilityPass != null) {
                    if (visibilityPass.getOutlook() != null) {
                        if (visibilityPass.getOutlook().getName() != null) {
                            return visibilityPass.getOutlook().getName();
                        }
                        return "?";
                    }
                    return "?";
                }
                return "";
            }
        });
        outlookTableViewerColumn.getColumn().setWidth(100);
        outlookTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (outlookTableViewerColumn.getColumn().getWidth() < 100) {
                    outlookTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        final TreeViewerColumn durationTableViewerColumn = new TreeViewerColumn(viewer, 0);
        durationTableViewerColumn.getColumn().setText("Duration (s)");
        durationTableViewerColumn.getColumn().setAlignment(0x1000000);
        durationTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                return VisibilityPassesListComposite.this.durationFormat.format(0.001 * (double)ApogyCommonEMFFacade.INSTANCE.getDuration((TimeInterval)visibilityPass));
            }
        });
        durationTableViewerColumn.getColumn().setWidth(100);
        durationTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (durationTableViewerColumn.getColumn().getWidth() < 100) {
                    durationTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        final TreeViewerColumn startTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        startTimeTableViewerColumn.getColumn().setText("Start Time");
        startTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        startTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                if (visibilityPass.getFromDate() != null) {
                    return ApogyCommonEMFFacade.INSTANCE.format(visibilityPass.getFromDate());
                }
                return "?";
            }
        });
        startTimeTableViewerColumn.getColumn().setWidth(100);
        startTimeTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (startTimeTableViewerColumn.getColumn().getWidth() < 100) {
                    startTimeTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        final TreeViewerColumn endTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        endTimeTableViewerColumn.getColumn().setText("End Time");
        endTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        endTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                if (visibilityPass.getFromDate() != null) {
                    return ApogyCommonEMFFacade.INSTANCE.format(visibilityPass.getToDate());
                }
                return "?";
            }
        });
        endTimeTableViewerColumn.getColumn().setWidth(100);
        endTimeTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (endTimeTableViewerColumn.getColumn().getWidth() < 100) {
                    endTimeTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
    }

    protected Composite createDetailComposite(Composite parent, int style) {
        final FormToolkit formToolkit = new FormToolkit(Display.getCurrent());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                formToolkit.dispose();
            }
        });
        Composite container = new Composite(parent, style);
        container.setLayout((Layout)new FillLayout());
        ScrolledForm scrldfrmNewScrolledform = formToolkit.createScrolledForm(container);
        scrldfrmNewScrolledform.getBody().setLayout((Layout)new GridLayout(1, false));
        scrldfrmNewScrolledform.setShowFocusedControl(true);
        formToolkit.paintBordersFor((Composite)scrldfrmNewScrolledform);
        scrldfrmNewScrolledform.setText(null);
        Section sctnVisibilityPassDetails = formToolkit.createSection(scrldfrmNewScrolledform.getBody(), 322);
        formToolkit.paintBordersFor((Composite)sctnVisibilityPassDetails);
        sctnVisibilityPassDetails.setText("Visibility Pass Details");
        Section sctnPositionHistory = formToolkit.createSection(scrldfrmNewScrolledform.getBody(), 322);
        formToolkit.paintBordersFor((Composite)sctnPositionHistory);
        sctnPositionHistory.setText("Pass Position History");
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setCollectionSectionTitle("Position History");
        settings.setButtonsSectionDisplayed(false);
        settings.setDetailSectionDisplayed(false);
        this.visibilityPassSpacecraftPositionHistoryComposite = new VisibilityPassSpacecraftPositionHistoryComposite((Composite)sctnPositionHistory, 0, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS__POSITION_HISTORY}), (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION_HISTORY__POSITIONS, settings);
        formToolkit.adapt(this.visibilityPassSpacecraftPositionHistoryComposite);
        formToolkit.paintBordersFor(this.visibilityPassSpacecraftPositionHistoryComposite);
        sctnPositionHistory.setClient(this.visibilityPassSpacecraftPositionHistoryComposite);
        return container;
    }

    protected void createOrbitModelTableColumn(TreeViewer tableViewer) {
        final TreeViewerColumn orbitModelTableViewerColumn = new TreeViewerColumn(tableViewer, 0);
        orbitModelTableViewerColumn.getColumn().setText("Spacecraft");
        orbitModelTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                if (visibilityPass.getSpacecraft() != null) {
                    if (visibilityPass.getSpacecraft().getName() != null) {
                        return visibilityPass.getSpacecraft().getName();
                    }
                    return "?";
                }
                return "?";
            }
        });
        orbitModelTableViewerColumn.getColumn().setWidth(100);
        orbitModelTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (orbitModelTableViewerColumn.getColumn().getWidth() < 100) {
                    orbitModelTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
    }

    protected VisibilityPass getVisibilityPass(Object element) {
        return (VisibilityPass)element;
    }
}

