/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.GroundStation;
import org.eclipse.apogy.core.environment.earth.orbit.ObservationTarget;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisDataSet;
import org.eclipse.apogy.core.environment.earth.orbit.ui.AllVisibilityPassesWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIPackage;
import org.eclipse.apogy.core.environment.earth.orbit.ui.GroundStationWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.SpacecraftOrbitAnalysisWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.OrbitAnalysisDataSetWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIFactory;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.EarthOutlookWorldWindLayer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.RGBA;

public class OrbitAnalysisDataSetWorldWindLayerCustomImpl
extends OrbitAnalysisDataSetWorldWindLayerImpl {
    protected boolean initialized = false;
    private Adapter orbitAnalysisDataSetAdapter;
    private Adapter orbitAnalysisDataAdapter;
    private Map<EarthSpacecraft, RGBA> spacecraftToColorMap = new HashMap<EarthSpacecraft, RGBA>();

    public void initialise() {
        super.initialise();
        this.initialized = true;
    }

    @Override
    public void setOrbitAnalysisDataSet(OrbitAnalysisDataSet newOrbitAnalysisDataSet) {
        if (this.getOrbitAnalysisDataSet() != null) {
            this.getOrbitAnalysisDataSet().eAdapters().remove((Object)this.getOrbitAnalysisDataSetAdapter());
        }
        super.setOrbitAnalysisDataSet(newOrbitAnalysisDataSet);
        if (newOrbitAnalysisDataSet != null) {
            newOrbitAnalysisDataSet.eAdapters().add((Object)this.getOrbitAnalysisDataSetAdapter());
        }
        if (this.initialized) {
            if (newOrbitAnalysisDataSet != null) {
                this.updateActiveOrbitAnalysisData(newOrbitAnalysisDataSet.getActiveData());
            } else {
                this.updateActiveOrbitAnalysisData(null);
            }
        }
    }

    @Override
    public void setGroundStationsDefaultColor(RGBA newGroundStationsDefaultColor) {
        super.setGroundStationsDefaultColor(newGroundStationsDefaultColor);
        if (newGroundStationsDefaultColor != null) {
            for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
                layer.setColor(newGroundStationsDefaultColor);
            }
        }
    }

    @Override
    public void setObservationTargetsDefaultColor(RGBA newObservationTargetsDefaultColor) {
        super.setObservationTargetsDefaultColor(newObservationTargetsDefaultColor);
        if (newObservationTargetsDefaultColor != null) {
            for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
                layer.setColor(newObservationTargetsDefaultColor);
            }
        }
    }

    protected void updateActiveOrbitAnalysisData(OrbitAnalysisData newOrbitAnalysisData) {
        ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__GROUND_STATION_WORLD_WIND_LAYERS, true);
        ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__EARTH_OUTLOOK_WORLD_WIND_LAYERS, true);
        ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__SPACECRAFT_ORBIT_ANALYSIS_WORLD_WIND_LAYERS, true);
        ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, true);
        if (newOrbitAnalysisData != null) {
            this.createAllGroundStationWorldWindLayer(newOrbitAnalysisData);
            this.createAllObservationTargets(newOrbitAnalysisData);
            this.createAllSpacecraftOrbitAnalysisWorldWindLayer(newOrbitAnalysisData);
            this.createAllVisibilityPasses(newOrbitAnalysisData);
        }
    }

    protected RGBA getColorForSpacecraft(EarthSpacecraft spacecraft) {
        RGBA color = this.spacecraftToColorMap.get(spacecraft);
        if (color == null) {
            Random random = new Random();
            int r = random.nextInt(255);
            int g = random.nextInt(255);
            int b = random.nextInt(255);
            color = new RGBA(r, g, b, 255);
            this.spacecraftToColorMap.put(spacecraft, color);
        }
        return color;
    }

    protected void addGroundStationWorldWindLayer(GroundStation groundStation) {
        if (groundStation != null) {
            GroundStationWorldWindLayer layer = this.createGroundStationWorldWindLayer(groundStation);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, (Object)layer, true);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__GROUND_STATION_WORLD_WIND_LAYERS, (Object)layer, true);
        }
    }

    protected void removeGroundStationWorldWindLayer(GroundStation groundStation) {
        GroundStationWorldWindLayer layer;
        if (groundStation != null && (layer = this.getGroundStationWorldWindLayerFor(groundStation)) != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__GROUND_STATION_WORLD_WIND_LAYERS, (Object)layer, true);
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, (Object)layer, true);
        }
    }

    protected GroundStationWorldWindLayer getGroundStationWorldWindLayerFor(GroundStation groundStation) {
        GroundStationWorldWindLayer layer = null;
        Iterator it = this.getGroundStationWorldWindLayers().iterator();
        while (it.hasNext() && layer == null) {
            GroundStationWorldWindLayer next = (GroundStationWorldWindLayer)it.next();
            if (next.getEarthSurfaceLocation() != groundStation) continue;
            layer = next;
        }
        return layer;
    }

    protected void createAllGroundStationWorldWindLayer(OrbitAnalysisData newOrbitAnalysisData) {
        if (newOrbitAnalysisData != null) {
            for (GroundStation groundStation : newOrbitAnalysisData.getGroundStations()) {
                this.addGroundStationWorldWindLayer(groundStation);
            }
        }
    }

    protected GroundStationWorldWindLayer createGroundStationWorldWindLayer(GroundStation groundStation) {
        GroundStationWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createGroundStationWorldWindLayer();
        layer.setAutoUpdateEnabled(true);
        layer.setEarthSurfaceLocation((EarthSurfaceLocation)groundStation);
        layer.setName(groundStation.getName());
        layer.setVisible(true);
        layer.setDisplayBalloon(true);
        layer.setDisplayLocation(false);
        layer.setShowVisibilityCone(false);
        layer.setOpacity(0.2);
        layer.setColor(this.getGroundStationsDefaultColor());
        layer.setDescription("Layer representing ground station <" + groundStation.getName() + ">.");
        return layer;
    }

    protected void addObservationTargetWorldWindLayer(ObservationTarget observationTarget) {
        if (observationTarget != null) {
            EarthOutlookWorldWindLayer layer = this.createEarthOutlookWorldWindLayer(observationTarget);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, (Object)layer, true);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__EARTH_OUTLOOK_WORLD_WIND_LAYERS, (Object)layer, true);
        }
    }

    protected void removeObservationTargetWorldWindLayer(ObservationTarget observationTarget) {
        EarthOutlookWorldWindLayer layer;
        if (observationTarget != null && (layer = this.getEarthOutlookWorldWindLayerFor(observationTarget)) != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__EARTH_OUTLOOK_WORLD_WIND_LAYERS, (Object)layer, true);
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, (Object)layer, true);
        }
    }

    protected void createAllObservationTargets(OrbitAnalysisData newOrbitAnalysisData) {
        if (newOrbitAnalysisData != null) {
            for (ObservationTarget target : newOrbitAnalysisData.getObservationTargets()) {
                this.addObservationTargetWorldWindLayer(target);
            }
        }
    }

    protected EarthOutlookWorldWindLayer createEarthOutlookWorldWindLayer(ObservationTarget observationTarget) {
        EarthOutlookWorldWindLayer layer = ApogyEarthEnvironmentUIFactory.eINSTANCE.createEarthOutlookWorldWindLayer();
        layer.setAutoUpdateEnabled(true);
        layer.setEarthSurfaceLocation((EarthSurfaceLocation)observationTarget);
        layer.setName(observationTarget.getName());
        layer.setVisible(true);
        layer.setDisplayBalloon(true);
        layer.setDisplayLocation(false);
        layer.setShowVisibilityCircle(false);
        layer.setShowVisibilityCone(false);
        layer.setColor(this.getObservationTargetsDefaultColor());
        layer.setOpacity(0.2);
        layer.setDescription("Layer representing target <" + observationTarget.getName() + ">.");
        return layer;
    }

    protected EarthOutlookWorldWindLayer getEarthOutlookWorldWindLayerFor(ObservationTarget observationTarget) {
        EarthOutlookWorldWindLayer layer = null;
        Iterator it = this.getEarthOutlookWorldWindLayers().iterator();
        while (it.hasNext() && layer == null) {
            EarthOutlookWorldWindLayer next = (EarthOutlookWorldWindLayer)it.next();
            if (next.getEarthSurfaceLocation() != observationTarget) continue;
            layer = next;
        }
        return layer;
    }

    protected void addSpacecraftOrbitAnalysisWorldWindLayer(EarthSpacecraft spacecraft, OrbitAnalysisData newOrbitAnalysisData) {
        if (spacecraft != null) {
            SpacecraftOrbitAnalysisWorldWindLayer layer = this.createSpacecraftOrbitAnalysisWorldWindLayer(spacecraft, newOrbitAnalysisData);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, (Object)layer, true);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__SPACECRAFT_ORBIT_ANALYSIS_WORLD_WIND_LAYERS, (Object)layer, true);
        }
    }

    protected void removeSpacecraftOrbitAnalysisWorldWindLayer(EarthSpacecraft spacecraft) {
        SpacecraftOrbitAnalysisWorldWindLayer layer;
        if (spacecraft != null && (layer = this.getSpacecraftOrbitAnalysisWorldWindLayerFor(spacecraft)) != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__SPACECRAFT_ORBIT_ANALYSIS_WORLD_WIND_LAYERS, (Object)layer, true);
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, (Object)layer, true);
        }
    }

    protected void createAllSpacecraftOrbitAnalysisWorldWindLayer(OrbitAnalysisData newOrbitAnalysisData) {
        if (newOrbitAnalysisData != null) {
            for (EarthSpacecraft spacecraft : newOrbitAnalysisData.getSpacecrafts()) {
                this.addSpacecraftOrbitAnalysisWorldWindLayer(spacecraft, newOrbitAnalysisData);
            }
        }
    }

    protected SpacecraftOrbitAnalysisWorldWindLayer createSpacecraftOrbitAnalysisWorldWindLayer(EarthSpacecraft spacecraft, OrbitAnalysisData newOrbitAnalysisData) {
        SpacecraftOrbitAnalysisWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFacade.INSTANCE.createSpacecraftOrbitAnalysisWorldWindLayer(newOrbitAnalysisData, spacecraft);
        layer.setName(spacecraft.getName());
        layer.setDescription("Layer representing the orbit and eclipses for spacecraft <" + spacecraft.getName() + ">.");
        layer.getSpacecraftOrbitLayer().setName("Orbit - " + spacecraft.getName());
        layer.getEclipseWorldWindLayer().setName("Eclipses - " + spacecraft.getName());
        return layer;
    }

    protected SpacecraftOrbitAnalysisWorldWindLayer getSpacecraftOrbitAnalysisWorldWindLayerFor(EarthSpacecraft spacecraft) {
        SpacecraftOrbitAnalysisWorldWindLayer layer = null;
        Iterator it = this.getSpacecraftOrbitAnalysisWorldWindLayers().iterator();
        while (it.hasNext() && layer == null) {
            SpacecraftOrbitAnalysisWorldWindLayer next = (SpacecraftOrbitAnalysisWorldWindLayer)it.next();
            if (next.getSpacecraft() != spacecraft) continue;
            layer = next;
        }
        return layer;
    }

    protected void createAllVisibilityPasses(OrbitAnalysisData newOrbitAnalysisData) {
        if (newOrbitAnalysisData != null) {
            for (EarthSpacecraft spacecraft : newOrbitAnalysisData.getSpacecrafts()) {
                AllVisibilityPassesWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFacade.INSTANCE.createAllVisibilityPassesWorldWindLayer(newOrbitAnalysisData, spacecraft);
                layer.setVisible(true);
                layer.setShowGroundStationPasses(true);
                layer.setShowObservationTargetPasses(true);
                layer.setName(String.valueOf(spacecraft.getName()) + " - Passes");
                layer.setDescription("Layer representing all passes (Ground Stations and Targets) for spacecraft <" + spacecraft.getName() + ">.");
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, (Object)layer, true);
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_ANALYSIS_DATA_SET_WORLD_WIND_LAYER__VISIBILITY_PASSES_WORLD_WIND_LAYERS, (Object)layer, true);
            }
        }
    }

    protected Adapter getOrbitAnalysisDataSetAdapter() {
        if (this.orbitAnalysisDataSetAdapter == null) {
            this.orbitAnalysisDataSetAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof OrbitAnalysisDataSet) {
                        int featureId = msg.getFeatureID(OrbitAnalysisDataSet.class);
                        switch (featureId) {
                            case 1: {
                                System.out.println("Active Data Set has changed");
                                OrbitAnalysisData newOrbitAnalysisData = (OrbitAnalysisData)msg.getNewValue();
                                OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.updateActiveOrbitAnalysisData(newOrbitAnalysisData);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.orbitAnalysisDataSetAdapter;
    }

    protected Adapter getOrbitAnalysisDataAdapter() {
        if (this.orbitAnalysisDataAdapter == null) {
            this.orbitAnalysisDataAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof OrbitAnalysisData) {
                        int featureId = msg.getFeatureID(OrbitAnalysisData.class);
                        block0 : switch (featureId) {
                            case 5: {
                                switch (msg.getEventType()) {
                                    case 3: {
                                        OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.addGroundStationWorldWindLayer((GroundStation)msg.getNewValue());
                                        break;
                                    }
                                    case 5: {
                                        Collection toAdd = (Collection)msg.getNewValue();
                                        for (GroundStation groundStation : toAdd) {
                                            OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.addGroundStationWorldWindLayer(groundStation);
                                        }
                                        break block0;
                                    }
                                    case 4: {
                                        OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.removeGroundStationWorldWindLayer((GroundStation)msg.getOldValue());
                                        break;
                                    }
                                    case 6: {
                                        Collection toRemove = (Collection)msg.getOldValue();
                                        for (GroundStation groundStation : toRemove) {
                                            OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.removeGroundStationWorldWindLayer(groundStation);
                                        }
                                        break block0;
                                    }
                                }
                                break;
                            }
                            case 6: {
                                switch (msg.getEventType()) {
                                    case 3: {
                                        OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.addObservationTargetWorldWindLayer((ObservationTarget)msg.getNewValue());
                                        break;
                                    }
                                    case 5: {
                                        Collection toAdd = (Collection)msg.getNewValue();
                                        for (ObservationTarget target : toAdd) {
                                            OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.addObservationTargetWorldWindLayer(target);
                                        }
                                        break block0;
                                    }
                                    case 4: {
                                        OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.removeObservationTargetWorldWindLayer((ObservationTarget)msg.getOldValue());
                                        break;
                                    }
                                    case 6: {
                                        Collection toRemove = (Collection)msg.getOldValue();
                                        for (ObservationTarget target : toRemove) {
                                            OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.removeObservationTargetWorldWindLayer(target);
                                        }
                                        break block0;
                                    }
                                }
                                break;
                            }
                            case 4: {
                                switch (msg.getEventType()) {
                                    case 3: {
                                        OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.addSpacecraftOrbitAnalysisWorldWindLayer((EarthSpacecraft)msg.getNewValue(), OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.getOrbitAnalysisDataSet().getActiveData());
                                        break;
                                    }
                                    case 5: {
                                        Collection toAdd = (Collection)msg.getNewValue();
                                        for (EarthSpacecraft spacecraft : toAdd) {
                                            OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.addSpacecraftOrbitAnalysisWorldWindLayer(spacecraft, OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.getOrbitAnalysisDataSet().getActiveData());
                                        }
                                        break block0;
                                    }
                                    case 4: {
                                        OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.removeSpacecraftOrbitAnalysisWorldWindLayer((EarthSpacecraft)msg.getOldValue());
                                        break;
                                    }
                                    case 6: {
                                        Collection toRemove = (Collection)msg.getOldValue();
                                        for (EarthSpacecraft spacecraft : toRemove) {
                                            OrbitAnalysisDataSetWorldWindLayerCustomImpl.this.removeSpacecraftOrbitAnalysisWorldWindLayer(spacecraft);
                                        }
                                        break block0;
                                    }
                                }
                                break;
                            }
                            case 10: {
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.orbitAnalysisDataAdapter;
    }
}

