/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.Timed;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIPackage;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.OrbitModelWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.orbit.ui.utils.WorldWindOrbitUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitModelWorldWindLayerCustomImpl
extends OrbitModelWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(OrbitModelWorldWindLayerImpl.class);
    public static final short GROUND_TRACE_STIPPLE_PATTERN = 255;
    public static final int GROUND_TRACE_STIPPLE_FACTOR = 1;
    private Adapter timedAdapter = null;

    @Override
    public void setOrbitModel(EarthOrbitModel newOrbitModel) {
        super.setOrbitModel(newOrbitModel);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setTimeSource(Timed newTimeSource) {
        if (this.timeSource != null) {
            this.timeSource.eAdapters().remove((Object)this.getTimedAdapter());
        }
        super.setTimeSource(newTimeSource);
        if (newTimeSource != null) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            newTimeSource.eAdapters().add((Object)this.getTimedAdapter());
        }
    }

    @Override
    public void setForwardPropagationDuration(double newForwardPropagationDuration) {
        super.setForwardPropagationDuration(newForwardPropagationDuration);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setBackwardPropagationDuration(double newBackwardPropagationDuration) {
        super.setBackwardPropagationDuration(newBackwardPropagationDuration);
        if (this.isAutoUpdateEnabled()) {
            this.updateRenderableLayer();
        }
    }

    @Override
    public void setShowGroundTrace(boolean newShowGroundTrace) {
        super.setShowGroundTrace(newShowGroundTrace);
        if (this.isAutoUpdateEnabled()) {
            this.updateRenderableLayer();
        }
    }

    public void dispose() {
        if (this.getTimeSource() != null) {
            this.getTimeSource().eAdapters().remove((Object)this.getTimedAdapter());
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ORBIT_MODEL_WORLD_WIND_LAYER__ORBIT_MODEL, null, true);
        super.dispose();
    }

    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible() && !this.isDisposed() && this.getOrbitModel() != null && this.getTimeSource() != null) {
            try {
                Polyline groundTrace;
                List<Polyline> polylines;
                List states;
                Date endDate;
                Date startDate;
                long duration;
                if (this.getBackwardPropagationDuration() > 0.0) {
                    duration = Math.round(this.getBackwardPropagationDuration() * 1000.0);
                    startDate = new Date(this.getTimeSource().getTime().getTime() - duration);
                    endDate = this.getTimeSource().getTime();
                    states = this.getOrbitModel().getSpacecraftStates(startDate, endDate, this.getTimeInterval());
                    polylines = WorldWindOrbitUtils.createPolyLineWithNoWrapAround(states, 99);
                    if (this.isShowOrbit()) {
                        for (Polyline line : polylines) {
                            line.setColor(Color.YELLOW);
                            layer.addRenderable((Renderable)line);
                        }
                    }
                    if (this.isShowGroundTrace()) {
                        for (Polyline line : polylines) {
                            groundTrace = new Polyline(line.getPositions());
                            groundTrace.setFollowTerrain(true);
                            groundTrace.setColor(Color.YELLOW);
                            groundTrace.setStippleFactor(1);
                            groundTrace.setStipplePattern((short)255);
                            layer.addRenderable((Renderable)groundTrace);
                        }
                    }
                }
                if (this.getForwardPropagationDuration() > 0.0) {
                    duration = Math.round(this.getForwardPropagationDuration() * 1000.0);
                    startDate = this.getTimeSource().getTime();
                    endDate = new Date(this.getTimeSource().getTime().getTime() + duration);
                    states = this.getOrbitModel().getSpacecraftStates(startDate, endDate, this.getTimeInterval());
                    polylines = WorldWindOrbitUtils.createPolyLineWithNoWrapAround(states, 99);
                    if (this.isShowOrbit()) {
                        for (Polyline line : polylines) {
                            line.setColor(Color.RED);
                            layer.addRenderable((Renderable)line);
                        }
                    }
                    if (this.isShowGroundTrace()) {
                        for (Polyline line : polylines) {
                            groundTrace = new Polyline(line.getPositions());
                            groundTrace.setFollowTerrain(true);
                            groundTrace.setColor(Color.RED);
                            groundTrace.setStippleFactor(1);
                            groundTrace.setStipplePattern((short)255);
                            layer.addRenderable((Renderable)groundTrace);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.error("Error occured during updateRenderableLayer().", (Throwable)e);
            }
        }
    }

    protected Adapter getTimedAdapter() {
        if (this.timedAdapter == null) {
            this.timedAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Timed) {
                        int featureId = msg.getFeatureID(Timed.class);
                        switch (featureId) {
                            case 0: {
                                if (!OrbitModelWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) break;
                                OrbitModelWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.timedAdapter;
    }
}

