/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.orbit.GroundStation;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIPackage;
import org.eclipse.apogy.core.environment.earth.orbit.ui.GroundStationWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.SelectedGroundStationsWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.AbstractWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class SelectedGroundStationsWorldWindLayerCustomImpl
extends SelectedGroundStationsWorldWindLayerImpl {
    @Override
    public void selectionChanged(final List<EObject> items) {
        if (!this.isLockSelection() && !this.isUpdating()) {
            UIJob job = new UIJob(Display.getCurrent(), ""){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    try {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)SelectedGroundStationsWorldWindLayerCustomImpl.this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)true, true);
                        ArrayList<GroundStation> groundStations = new ArrayList<GroundStation>();
                        for (EObject eObject : items) {
                            if (!(eObject instanceof GroundStation)) continue;
                            groundStations.add((GroundStation)eObject);
                        }
                        ArrayList<AbstractWorldWindLayer> currentLayers = new ArrayList<AbstractWorldWindLayer>();
                        currentLayers.addAll((Collection<AbstractWorldWindLayer>)SelectedGroundStationsWorldWindLayerCustomImpl.this.getLayers());
                        SelectedGroundStationsWorldWindLayerCustomImpl.this.deleteGroundStationWorldWindLayer(currentLayers);
                        SelectedGroundStationsWorldWindLayerCustomImpl.this.addGroundStationWorldWindLayer(groundStations);
                        SelectedGroundStationsWorldWindLayerCustomImpl.this.update();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)SelectedGroundStationsWorldWindLayerCustomImpl.this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)false, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    @Override
    public void setColor(RGBA newColor) {
        super.setColor(newColor);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setColor(newColor);
        }
    }

    @Override
    public void setShowOutline(boolean newShowOutline) {
        super.setShowOutline(newShowOutline);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setShowOutline(newShowOutline);
        }
    }

    @Override
    public void setDisplayBalloon(boolean newDisplayBalloon) {
        super.setDisplayBalloon(newDisplayBalloon);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setDisplayBalloon(newDisplayBalloon);
        }
    }

    @Override
    public void setDisplayLocation(boolean newDisplayLocation) {
        super.setDisplayLocation(newDisplayLocation);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setDisplayLocation(newDisplayLocation);
        }
    }

    @Override
    public void setOpacity(double newOpacity) {
        super.setOpacity(newOpacity);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setOpacity(newOpacity);
        }
    }

    @Override
    public void setShowVisibilityCircle(boolean newShowVisibilityCircle) {
        super.setShowVisibilityCircle(newShowVisibilityCircle);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setShowVisibilityCircle(newShowVisibilityCircle);
        }
    }

    @Override
    public void setShowVisibilityCone(boolean newShowVisibilityCone) {
        super.setShowVisibilityCone(newShowVisibilityCone);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setShowVisibilityCone(newShowVisibilityCone);
        }
    }

    @Override
    public void setTargetRadius(double newTargetRadius) {
        super.setTargetRadius(newTargetRadius);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setTargetRadius(newTargetRadius);
        }
    }

    public void setAutoUpdateEnabled(boolean newAutoUpdateEnabled) {
        super.setAutoUpdateEnabled(newAutoUpdateEnabled);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setAutoUpdateEnabled(newAutoUpdateEnabled);
        }
    }

    protected void updateRenderableLayer() {
    }

    protected void addGroundStationWorldWindLayer(List<GroundStation> groundStations) {
        ArrayList<GroundStationWorldWindLayer> layers = new ArrayList<GroundStationWorldWindLayer>();
        for (GroundStation groundStation : groundStations) {
            if (groundStation == null) continue;
            GroundStationWorldWindLayer layer = this.createGroundStationWorldWindLayer(groundStation);
            layers.add(layer);
        }
        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, layers, true);
        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.SELECTED_GROUND_STATIONS_WORLD_WIND_LAYER__GROUND_STATION_WORLD_WIND_LAYERS, layers, true);
    }

    protected GroundStationWorldWindLayer createGroundStationWorldWindLayer(GroundStation groundStation) {
        GroundStationWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createGroundStationWorldWindLayer();
        layer.setEarthSurfaceLocation((EarthSurfaceLocation)groundStation);
        layer.setAutoUpdateEnabled(true);
        layer.setVisible(true);
        layer.setShowOutline(this.isShowOutline());
        layer.setDisplayBalloon(this.isDisplayBalloon());
        layer.setDisplayLocation(this.isDisplayLocation());
        layer.setOpacity(this.getOpacity());
        layer.setShowVisibilityCircle(this.isShowVisibilityCircle());
        layer.setShowVisibilityCone(this.isShowVisibilityCone());
        layer.setTargetRadius(this.getTargetRadius());
        layer.setName(groundStation.getName());
        layer.setDescription("Layer representing the Ground station name <" + groundStation.getName() + ">.");
        return layer;
    }

    protected void deleteGroundStationWorldWindLayer(List<AbstractWorldWindLayer> layers) {
        ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.SELECTED_GROUND_STATIONS_WORLD_WIND_LAYER__GROUND_STATION_WORLD_WIND_LAYERS, layers, true);
        ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, layers, true);
    }
}

