/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.EObjectReferencesList;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.core.environment.earth.orbit.ObservationTarget;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.ui.composites.ObservationTargetListComposite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CommitImportedObservationWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.earth.orbit.ui.wizards.CommitImportedObservationWizardPage";
    private OrbitAnalysisData orbitAnalysisData;
    private List<ObservationTarget> importedTargets = new ArrayList<ObservationTarget>();
    private Set<ObservationTarget> displayedImportedTargets = new TreeSet<ObservationTarget>(new ObservationTargetComparator());
    private Set<ObservationTarget> displayedCurrentTargets = new TreeSet<ObservationTarget>(new ObservationTargetComparator());
    private List<ObservationTarget> selectedImportedTargets = new ArrayList<ObservationTarget>();
    private List<ObservationTarget> selectedCurrentTargets = new ArrayList<ObservationTarget>();
    private ObservationTargetListComposite<EObjectReferencesList<ObservationTarget>, EObjectReferencesList<ObservationTarget>, ObservationTarget> importedObservationTargetListComposite;
    private ObservationTargetListComposite<EObjectReferencesList<ObservationTarget>, EObjectReferencesList<ObservationTarget>, ObservationTarget> currentObservationTargetListComposite;
    private Button addBtn = null;
    private Button addAllBtn = null;
    private Button removeBtn = null;
    private Button clearExistingBtn = null;

    public CommitImportedObservationWizardPage(OrbitAnalysisData orbitAnalysisData) {
        super(WIZARD_PAGE_ID);
        this.setTitle("Select the Observation(s) to add to the Analysis.");
        this.orbitAnalysisData = orbitAnalysisData;
        this.setPageComplete(true);
        this.displayedCurrentTargets.addAll((Collection<ObservationTarget>)orbitAnalysisData.getObservationTargets());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)container);
        Label importedTargetLabel = new Label(container, 0);
        importedTargetLabel.setText("Imported Observation Targets");
        new Label(container, 0);
        Label currentTargetLabel = new Label(container, 0);
        currentTargetLabel.setText("Current Observation Targets");
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setCollectionSectionTitle("Observation Targets");
        settings.setDetailSectionTitle("Details");
        settings.setButtonsSectionDisplayed(false);
        this.importedObservationTargetListComposite = new ObservationTargetListComposite<EObjectReferencesList<ObservationTarget>, EObjectReferencesList<ObservationTarget>, ObservationTarget>(container, 0, null, (EStructuralFeature)ApogyCommonEMFPackage.Literals.EOBJECT_REFERENCES_LIST__EOBJECTS, settings){

            protected void selectionChanged(IStructuredSelection selection) {
                CommitImportedObservationWizardPage.this.addBtn.setEnabled(!selection.isEmpty());
                CommitImportedObservationWizardPage.this.selectedImportedTargets.clear();
                CommitImportedObservationWizardPage.this.selectedImportedTargets.addAll(this.getSelectedItemObjects());
            }
        };
        this.importedObservationTargetListComposite.setLayoutData(new GridData(4, 4, true, true));
        Composite buttonsComposite = new Composite(container, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        GridData buttonsComposite_gd = new GridData(4, 128, true, false, 1, 1);
        buttonsComposite_gd.minimumWidth = 75;
        buttonsComposite_gd.widthHint = 75;
        buttonsComposite.setLayoutData((Object)buttonsComposite_gd);
        this.addBtn = new Button(buttonsComposite, 0);
        this.addBtn.setSize(74, 29);
        this.addBtn.setText("->");
        this.addBtn.setToolTipText("Adds the selected Observation target(s) to the Analysis");
        this.addBtn.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.addBtn.setEnabled(true);
        this.addBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    CommitImportedObservationWizardPage.this.addObservationTarget(CommitImportedObservationWizardPage.this.selectedImportedTargets);
                    CommitImportedObservationWizardPage.this.updateImportedObservationTargetList(CommitImportedObservationWizardPage.this.displayedImportedTargets);
                    CommitImportedObservationWizardPage.this.updateCurrentObservationTargetList(CommitImportedObservationWizardPage.this.displayedCurrentTargets);
                }
            }
        });
        this.addAllBtn = new Button(buttonsComposite, 0);
        this.addAllBtn.setSize(74, 29);
        this.addAllBtn.setText("->>");
        this.addAllBtn.setToolTipText("Adds all imported Observation target(s) to the Analysis");
        this.addAllBtn.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.addAllBtn.setEnabled(true);
        this.addAllBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    CommitImportedObservationWizardPage.this.addObservationTarget(CommitImportedObservationWizardPage.this.importedTargets);
                    CommitImportedObservationWizardPage.this.updateImportedObservationTargetList(CommitImportedObservationWizardPage.this.displayedImportedTargets);
                    CommitImportedObservationWizardPage.this.updateCurrentObservationTargetList(CommitImportedObservationWizardPage.this.displayedCurrentTargets);
                }
            }
        });
        this.removeBtn = new Button(buttonsComposite, 0);
        this.removeBtn.setSize(74, 29);
        this.removeBtn.setText("<-");
        this.removeBtn.setToolTipText("Remove the selected Observation target(s) from the Analysis");
        this.removeBtn.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.removeBtn.setEnabled(true);
        this.removeBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    CommitImportedObservationWizardPage.this.removeObservationTarget(CommitImportedObservationWizardPage.this.selectedCurrentTargets);
                    CommitImportedObservationWizardPage.this.updateImportedObservationTargetList(CommitImportedObservationWizardPage.this.displayedImportedTargets);
                    CommitImportedObservationWizardPage.this.updateCurrentObservationTargetList(CommitImportedObservationWizardPage.this.displayedCurrentTargets);
                }
            }
        });
        this.clearExistingBtn = new Button(buttonsComposite, 0);
        this.clearExistingBtn.setSize(150, 29);
        this.clearExistingBtn.setText("Clear Existing");
        this.clearExistingBtn.setToolTipText("Clear all existing in the Analysis");
        this.clearExistingBtn.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.clearExistingBtn.setEnabled(true);
        this.clearExistingBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    CommitImportedObservationWizardPage.this.clearExistingTargets(CommitImportedObservationWizardPage.this.orbitAnalysisData);
                    CommitImportedObservationWizardPage.this.updateImportedObservationTargetList(CommitImportedObservationWizardPage.this.displayedImportedTargets);
                    CommitImportedObservationWizardPage.this.updateCurrentObservationTargetList(CommitImportedObservationWizardPage.this.displayedCurrentTargets);
                }
            }
        });
        ECollectionCompositeSettings currentObservationsSettings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        currentObservationsSettings.setCollectionSectionTitle("Current Observation Targets");
        currentObservationsSettings.setDetailSectionTitle("Details");
        currentObservationsSettings.setButtonsSectionDisplayed(false);
        this.currentObservationTargetListComposite = new ObservationTargetListComposite<EObjectReferencesList<ObservationTarget>, EObjectReferencesList<ObservationTarget>, ObservationTarget>(container, 0, null, (EStructuralFeature)ApogyCommonEMFPackage.Literals.EOBJECT_REFERENCES_LIST__EOBJECTS, currentObservationsSettings){

            protected void selectionChanged(IStructuredSelection selection) {
                CommitImportedObservationWizardPage.this.removeBtn.setEnabled(!selection.isEmpty());
                CommitImportedObservationWizardPage.this.selectedCurrentTargets.clear();
                CommitImportedObservationWizardPage.this.selectedCurrentTargets.addAll(this.getSelectedItemObjects());
            }
        };
        this.currentObservationTargetListComposite.setLayoutData(new GridData(4, 4, true, true));
        this.updateImportedObservationTargetList(this.importedTargets);
        this.updateCurrentObservationTargetList((Collection<ObservationTarget>)this.orbitAnalysisData.getObservationTargets());
        this.setPageComplete(true);
    }

    public void setImportedTargets(List<ObservationTarget> newImportedTargets) {
        this.importedTargets.clear();
        this.displayedImportedTargets.clear();
        if (newImportedTargets != null) {
            this.importedTargets.addAll(newImportedTargets);
            this.displayedImportedTargets.addAll(newImportedTargets);
        }
        this.updateImportedObservationTargetList(this.displayedImportedTargets);
        this.updateCurrentObservationTargetList(this.displayedCurrentTargets);
    }

    public Set<ObservationTarget> getTargetsToAddToOrbitAnalysisData() {
        TreeSet<ObservationTarget> result = new TreeSet<ObservationTarget>(new ObservationTargetComparator());
        for (ObservationTarget target : this.displayedCurrentTargets) {
            if (this.orbitAnalysisData.getObservationTargets().contains((Object)target)) continue;
            result.add(target);
        }
        return result;
    }

    public Set<ObservationTarget> getTargetsToRemoveFromOrbitAnalysisData() {
        TreeSet<ObservationTarget> result = new TreeSet<ObservationTarget>(new ObservationTargetComparator());
        for (ObservationTarget target : this.orbitAnalysisData.getObservationTargets()) {
            if (this.displayedCurrentTargets.contains(target)) continue;
            result.add(target);
        }
        return result;
    }

    protected void addObservationTarget(List<ObservationTarget> targets) {
        this.displayedImportedTargets.removeAll(targets);
        this.displayedCurrentTargets.addAll(targets);
    }

    protected void removeObservationTarget(List<ObservationTarget> targets) {
        this.displayedImportedTargets.addAll(targets);
        this.displayedCurrentTargets.removeAll(targets);
    }

    protected void clearExistingTargets(OrbitAnalysisData orbitAnalysisData) {
        if (orbitAnalysisData != null) {
            this.displayedCurrentTargets.removeAll((Collection<?>)orbitAnalysisData.getObservationTargets());
        }
    }

    private void updateImportedObservationTargetList(Collection<ObservationTarget> targets) {
        EObjectReferencesList eObjectReferencesList = ApogyCommonEMFFactory.eINSTANCE.createEObjectReferencesList();
        if (targets != null) {
            eObjectReferencesList.getEObjects().addAll(targets);
        }
        this.importedObservationTargetListComposite.setRootEObject((EObject)eObjectReferencesList);
    }

    private void updateCurrentObservationTargetList(Collection<ObservationTarget> targets) {
        EObjectReferencesList eObjectReferencesList = ApogyCommonEMFFactory.eINSTANCE.createEObjectReferencesList();
        if (targets != null) {
            eObjectReferencesList.getEObjects().addAll(targets);
        }
        this.currentObservationTargetListComposite.setRootEObject((EObject)eObjectReferencesList);
    }

    private class ObservationTargetComparator
    implements Comparator<ObservationTarget> {
        private ObservationTargetComparator() {
        }

        @Override
        public int compare(ObservationTarget arg0, ObservationTarget arg1) {
            if (arg0.getLongitude() > arg1.getLongitude()) {
                return 1;
            }
            if (arg0.getLongitude() < arg1.getLongitude()) {
                return -1;
            }
            if (arg0.getLatitude() > arg1.getLatitude()) {
                return 1;
            }
            if (arg0.getLatitude() < arg1.getLatitude()) {
                return -1;
            }
            return arg0.hashCode() - arg1.hashCode();
        }
    }
}

