/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.wizards;

import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.core.environment.earth.orbit.TLEEarthOrbitModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TLEEarthOrbitModelWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.earth.orbit.ui.wizards.TLEEarthOrbitModelWizardPage";
    private TLEEarthOrbitModel tleEarthOrbitModel;
    private Composite tleDetailsComposite;
    private Button editButton;

    public TLEEarthOrbitModelWizardPage(TLEEarthOrbitModel tleEarthOrbitModel) {
        super(WIZARD_PAGE_ID);
        this.tleEarthOrbitModel = tleEarthOrbitModel;
        this.setTitle("TLE Based Earth Orbit Model.");
        this.setDescription("Edit the Two-Lines Element (TLE) defining the Orbit Model.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)container);
        Group existingTLEGroup = new Group(container, 2048);
        existingTLEGroup.setText("Current TLE");
        existingTLEGroup.setLayout((Layout)new GridLayout(1, false));
        existingTLEGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)existingTLEGroup, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.tleDetailsComposite = new Composite((Composite)scrolledComposite, 0);
        GridData gd_compositeDetails = new GridData(4, 4, true, true, 1, 1);
        gd_compositeDetails.widthHint = 400;
        gd_compositeDetails.minimumWidth = 400;
        gd_compositeDetails.minimumHeight = 800;
        gd_compositeDetails.heightHint = 800;
        this.tleDetailsComposite.setLayoutData((Object)gd_compositeDetails);
        this.tleDetailsComposite.setLayout((Layout)new GridLayout(1, false));
        if (this.tleEarthOrbitModel != null && this.tleEarthOrbitModel.getTle() != null) {
            ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.tleDetailsComposite, (EObject)this.tleEarthOrbitModel.getTle());
        } else {
            Label noTLELabel = new Label(this.tleDetailsComposite, 0);
            noTLELabel.setText("No TLE to display.");
            noTLELabel.setLayoutData((Object)new GridData(0x1000000, 4, false, false, 1, 1));
        }
        scrolledComposite.setContent((Control)this.tleDetailsComposite);
        scrolledComposite.setMinSize(this.tleDetailsComposite.computeSize(-1, -1));
        this.editButton = new Button(container, 8);
        this.editButton.setText("Edit TLE...");
        this.editButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                    settings.getUserDataMap().put("originalEarthOrbitModel", TLEEarthOrbitModelWizardPage.this.tleEarthOrbitModel);
                    if (TLEEarthOrbitModelWizardPage.this.tleEarthOrbitModel != null) {
                        settings.getUserDataMap().put("originalTLE", TLEEarthOrbitModelWizardPage.this.tleEarthOrbitModel.getTle());
                    }
                }
            }
        });
    }

    protected void validate() {
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

