/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.common.ui.composites.URLSelectionComposite;
import org.eclipse.apogy.core.environment.earth.orbit.AbstractTLE;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.TLE;
import org.eclipse.apogy.core.environment.earth.orbit.URLBasedTLE;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class URLBasedTLEWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.earth.orbit.ui.wizards.URLBasedTLEWizardPage";
    private URLBasedTLE urlBasedTLE;
    private URLSelectionComposite urlSelectionComposite;
    private ComboViewer viewer;
    private Composite compositeDetails;
    private List<TLE> loadedTLEs;

    public URLBasedTLEWizardPage(URLBasedTLE urlBasedTLE) {
        super(WIZARD_PAGE_ID);
        this.urlBasedTLE = urlBasedTLE;
        this.setMessage("Select the URL to the TLE and review its content.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)container);
        this.urlSelectionComposite = new URLSelectionComposite(container, 0){

            protected void urlStringSelected(String newURLString) {
                URLBasedTLEWizardPage.this.setURL(newURLString, false);
            }
        };
        this.urlSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label satelliteNumberLabel = new Label(container, 0);
        satelliteNumberLabel.setText("Selected Satellite Number:");
        satelliteNumberLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.viewer = new ComboViewer(container, 8);
        GridData gd_viewer = new GridData(16384, 0x1000000, false, false);
        gd_viewer.minimumWidth = 150;
        gd_viewer.widthHint = 150;
        this.viewer.getCombo().setLayoutData((Object)gd_viewer);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractTLE) {
                    AbstractTLE abstractTLE = (AbstractTLE)element;
                    return Integer.toString(abstractTLE.getSatelliteNumber());
                }
                return super.getText(element);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() > 0) {
                    AbstractTLE tle = (AbstractTLE)selection.getFirstElement();
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)URLBasedTLEWizardPage.this.urlBasedTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.URL_BASED_TLE__TARGET_SATELLITE_NUMBER, (Object)tle.getSatelliteNumber());
                    if (URLBasedTLEWizardPage.this.compositeDetails != null) {
                        ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.updateExistingTLE((AbstractTLE)URLBasedTLEWizardPage.this.urlBasedTLE, tle);
                        ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(URLBasedTLEWizardPage.this.compositeDetails, (EObject)tle);
                        URLBasedTLEWizardPage.this.compositeDetails.layout();
                    }
                }
            }
        });
        Group tleDetailsGroup = new Group(container, 2048);
        tleDetailsGroup.setText("Selected TLE");
        tleDetailsGroup.setLayout((Layout)new GridLayout(1, false));
        tleDetailsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.compositeDetails = new Composite((Composite)tleDetailsGroup, 0);
        GridData gd_compositeDetails = new GridData(4, 4, true, true, 1, 1);
        gd_compositeDetails.widthHint = 450;
        gd_compositeDetails.minimumWidth = 450;
        this.compositeDetails.setLayoutData((Object)gd_compositeDetails);
        this.compositeDetails.setLayout((Layout)new GridLayout(1, false));
        if (this.urlBasedTLE != null) {
            ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.compositeDetails, (EObject)this.urlBasedTLE);
        }
        this.setURL(this.urlBasedTLE.getUrl(), true);
    }

    protected void validate() {
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void setURL(String urlString, boolean updateURLText) {
        try {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.urlBasedTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.URL_BASED_TLE__URL, (Object)urlString);
            this.loadedTLEs = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.loadAllTLE(urlString);
            if (this.viewer != null) {
                this.viewer.setInput(this.loadedTLEs);
                this.setSelectedTLE(this.urlBasedTLE.getTargetSatelliteNumber());
            }
            if (this.loadedTLEs == null || this.loadedTLEs.size() == 0) {
                this.setErrorMessage("Could mot load any TLE from the specified URL !");
            } else {
                this.setErrorMessage(null);
            }
        }
        catch (Exception e) {
            this.viewer.setSelection(null);
            this.setErrorMessage(e.getMessage());
        }
        this.validate();
    }

    private void setSelectedTLE(int targetSateliteNumber) {
        if (this.loadedTLEs != null) {
            AbstractTLE tle = null;
            if (targetSateliteNumber == -1) {
                if (!this.loadedTLEs.isEmpty()) {
                    tle = (AbstractTLE)this.loadedTLEs.get(0);
                }
            } else {
                tle = this.getTargetTLE(this.loadedTLEs, targetSateliteNumber);
            }
            if (tle != null) {
                StructuredSelection sel = new StructuredSelection((Object)tle);
                this.viewer.setSelection((ISelection)sel);
                if (this.compositeDetails != null) {
                    ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.compositeDetails, (EObject)tle);
                    this.compositeDetails.layout();
                }
            } else {
                this.viewer.setSelection(null);
            }
        }
    }

    private AbstractTLE getTargetTLE(List<TLE> loadedTLE, int targetSateliteNumber) {
        AbstractTLE result = null;
        Iterator<TLE> it = loadedTLE.iterator();
        while (it.hasNext() && result == null) {
            AbstractTLE next = (AbstractTLE)it.next();
            if (next.getSatelliteNumber() != targetSateliteNumber) continue;
            result = next;
        }
        return result;
    }
}

