/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraftOrbitHistory;
import org.eclipse.apogy.core.environment.earth.orbit.Eclipse;
import org.eclipse.apogy.core.environment.earth.orbit.GroundStation;
import org.eclipse.apogy.core.environment.earth.orbit.ObservationTarget;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisResult;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.impl.AbstractOrbitAnalysisProcessorImpl;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractOrbitAnalysisProcessorCustomImpl
extends AbstractOrbitAnalysisProcessorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractOrbitAnalysisProcessorCustomImpl.class);

    public OrbitAnalysisResult doProcess(OrbitAnalysisData input, IProgressMonitor progressMonitor) throws Exception {
        long startTime = System.currentTimeMillis();
        Logger.debug("Processing Orbital Data started");
        OrbitAnalysisResult result = this.createOrbitAnalysisResultInstance();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)input, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__RESULT, (Object)result, true);
        int spacecraftsCount = input.getSpacecrafts().size();
        int maxNumberOfThreads = this.getMaxNumberThreads() < 1 ? Runtime.getRuntime().availableProcessors() : this.getMaxNumberThreads();
        int numberOfThreads = maxNumberOfThreads > spacecraftsCount ? spacecraftsCount : maxNumberOfThreads;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Orbit Analysis Processor", (int)spacecraftsCount);
        JobGroup jobGroup = new JobGroup("Orbit Analysis Processor", numberOfThreads, spacecraftsCount);
        Iterator spacecrafts = input.getSpacecrafts().iterator();
        while (spacecrafts.hasNext()) {
            SpacecraftProcessingJob job = new SpacecraftProcessingJob((EarthSpacecraft)spacecrafts.next(), input, result, (IProgressMonitor)subMonitor);
            job.setJobGroup(jobGroup);
            job.schedule();
        }
        jobGroup.join(0L, progressMonitor);
        long endTime = System.currentTimeMillis();
        double durationSeconds = (double)(endTime - startTime) * 0.001;
        Logger.debug("Processing Orbital Data completed in " + durationSeconds + " seconds.");
        return result;
    }

    @Override
    public OrbitAnalysisResult createOrbitAnalysisResultInstance() {
        return ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createOrbitAnalysisResult();
    }

    protected class SpacecraftProcessingJob
    extends Job {
        private EarthSpacecraft spacecraft;
        private OrbitAnalysisData analysisData;
        private OrbitAnalysisResult analysisResult;

        public SpacecraftProcessingJob(EarthSpacecraft spacecraft, OrbitAnalysisData analysisData, OrbitAnalysisResult analysisResult, IProgressMonitor monitor) {
            super("Process " + spacecraft.getName() == null ? "Unnamed" : spacecraft.getName());
            this.spacecraft = spacecraft;
            this.analysisData = analysisData;
            this.analysisResult = analysisResult;
        }

        protected IStatus run(IProgressMonitor progressMonitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)3);
            try {
                ArrayList<Object> allLocations = new ArrayList<Object>();
                allLocations.addAll((Collection<Object>)this.analysisData.getObservationTargets());
                allLocations.addAll((Collection<Object>)this.analysisData.getGroundStations());
                List<VisibilityPass> visibilityPasses = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getVisibilityPasses(this.spacecraft, allLocations, this.analysisData.getFromDate(), this.analysisData.getToDate(), this.analysisData.getActiveProcessor().getTimeInterval(), (IProgressMonitor)subMonitor);
                ArrayList<VisibilityPass> groundStationPasses = new ArrayList<VisibilityPass>();
                ArrayList<VisibilityPass> observationTargetPasses = new ArrayList<VisibilityPass>();
                for (VisibilityPass visibilityPass : visibilityPasses) {
                    if (visibilityPass.getOutlook() instanceof GroundStation) {
                        groundStationPasses.add(visibilityPass);
                        continue;
                    }
                    if (!(visibilityPass.getOutlook() instanceof ObservationTarget)) continue;
                    observationTargetPasses.add(visibilityPass);
                }
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.analysisResult, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_RESULT__GROUND_STATION_VISIBILITY_PASSES, groundStationPasses, true);
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.analysisResult, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_RESULT__OBSERVATION_TARGET_VISIBILITY_PASSES, observationTargetPasses, true);
                subMonitor.worked(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                subMonitor.done();
                this.cancel();
                return Status.CANCEL_STATUS;
            }
            try {
                List<Eclipse> eclipses = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getEclipses(this.spacecraft, this.analysisData.getFromDate(), this.analysisData.getToDate(), this.analysisData.getActiveProcessor().getTimeInterval(), (IProgressMonitor)subMonitor);
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.analysisResult, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_RESULT__ECLIPSES, eclipses, true);
                subMonitor.worked(1);
            }
            catch (Exception e) {
                subMonitor.done();
                this.cancel();
                return Status.CANCEL_STATUS;
            }
            try {
                List<SpacecraftState> spacecraftStates = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getSpacecraftStates(this.spacecraft, this.analysisData.getFromDate(), this.analysisData.getToDate(), this.analysisData.getActiveProcessor().getTimeInterval(), (IProgressMonitor)subMonitor);
                TreeSet<SpacecraftState> sorted = new TreeSet<SpacecraftState>(new SpacecraftStateDateComparator());
                sorted.addAll(spacecraftStates);
                for (Eclipse eclipse : this.analysisResult.getEclipses(this.spacecraft)) {
                    if (eclipse.getPenumbraEntry() != null) {
                        sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getPenumbraEntry().getTime()));
                    }
                    if (eclipse.getPenumbraExit() != null) {
                        sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getPenumbraExit().getTime()));
                    }
                    if (eclipse.getUmbraEntry() != null) {
                        sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getUmbraEntry().getTime()));
                    }
                    if (eclipse.getUmbraExit() == null) continue;
                    sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getUmbraExit().getTime()));
                }
                EarthSpacecraftOrbitHistory trajectory = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createEarthSpacecraftOrbitHistory();
                trajectory.setSpacecraft(this.spacecraft);
                trajectory.setFromDate(this.analysisData.getFromDate());
                trajectory.setToDate(this.analysisData.getToDate());
                trajectory.getSpacecraftStates().addAll(sorted);
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.analysisResult, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_RESULT__SPACECRAFT_TRAJECTORIES, (Object)trajectory, true);
            }
            catch (Exception e) {
                subMonitor.done();
                this.cancel();
                return Status.CANCEL_STATUS;
            }
            subMonitor.done();
            return Status.OK_STATUS;
        }
    }

    private class SpacecraftStateDateComparator
    implements Comparator<SpacecraftState> {
        private SpacecraftStateDateComparator() {
        }

        @Override
        public int compare(SpacecraftState o1, SpacecraftState o2) {
            long o2Date;
            long o1Date = o1.getTime().getTime();
            if (o1Date > (o2Date = o2.getTime().getTime())) {
                return 1;
            }
            if (o1Date < o2Date) {
                return -1;
            }
            return 0;
        }
    }
}

