/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.vecmath.Matrix3d;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.eclipse.apogy.common.ApogyCommonFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.environment.earth.AbstractSkyline;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFacade;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFactory;
import org.eclipse.apogy.core.environment.earth.EarthOutlook;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.SimpleSkyline;
import org.eclipse.apogy.core.environment.earth.orbit.AbstractTLE;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.CartesianEarthOrbit;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbit;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitPropagator;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitTool;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitTools;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraftOrbitHistory;
import org.eclipse.apogy.core.environment.earth.orbit.Eclipse;
import org.eclipse.apogy.core.environment.earth.orbit.EclipseEvent;
import org.eclipse.apogy.core.environment.earth.orbit.EclipseEventType;
import org.eclipse.apogy.core.environment.earth.orbit.EphemerisType;
import org.eclipse.apogy.core.environment.earth.orbit.KeplerianEarthOrbit;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisDataSet;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisResult;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisTool;
import org.eclipse.apogy.core.environment.earth.orbit.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.earth.orbit.TLE;
import org.eclipse.apogy.core.environment.earth.orbit.TLEEarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.apogy.core.environment.earth.orbit.impl.ApogyCoreEnvironmentEarthOrbitFacadeImpl;
import org.eclipse.apogy.core.environment.orbit.ApogyCoreEnvironmentOrbitFactory;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.apogy.core.environment.orbit.TimedStampedAngularCoordinates;
import org.eclipse.apogy.core.environment.orbit.TimedStampedPVACoordinates;
import org.eclipse.apogy.core.invocator.AbstractToolsListContainer;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ToolsList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.PropagationException;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.LOFType;
import org.orekit.frames.LocalOrbitalFrame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.frames.Transform;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EclipseDetector;
import org.orekit.propagation.events.ElevationDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;
import org.orekit.time.UTCScale;
import org.orekit.utils.ElevationMask;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl
extends ApogyCoreEnvironmentEarthOrbitFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.class);
    private Adapter activeSessionAdapter;

    protected ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl() {
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().add((Object)this.getActiveSessionAdapter());
    }

    @Override
    public double getMu() {
        return 3.986004415E14;
    }

    @Override
    public AbsoluteDate createAbsoluteDate(Date date) {
        try {
            UTCScale utcScale = TimeScalesFactory.getUTC();
            return new AbsoluteDate(date, (TimeScale)utcScale);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Date createDate(AbsoluteDate absoluteDate) {
        try {
            UTCScale utcScale = TimeScalesFactory.getUTC();
            Date date = absoluteDate.toDate((TimeScale)utcScale);
            return date;
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
            return null;
        }
    }

    @Override
    public GeographicCoordinates getSpacecraftEarthSubPoint(OreKitBackedSpacecraftState oreKitBackedSpacecraftState) throws Exception {
        org.orekit.propagation.SpacecraftState currentState = oreKitBackedSpacecraftState.getOreKitSpacecraftState();
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)false));
        AbsoluteDate date = currentState.getDate();
        TimeStampedPVCoordinates pvInert = currentState.getPVCoordinates();
        Transform t = currentState.getFrame().getTransformTo(earth.getBodyFrame(), date);
        Vector3D p = t.transformPosition(pvInert.getPosition());
        Line centerLine = new Line(p, new Vector3D(0.0, 0.0, 0.0));
        GeodeticPoint centerPoint = earth.getIntersectionPoint(centerLine, p, earth.getBodyFrame(), date);
        GeographicCoordinates geographicCoordinates = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(centerPoint.getLongitude(), centerPoint.getLatitude(), 0.0);
        return geographicCoordinates;
    }

    @Override
    public double getSpacecraftElevationAngle(SpacecraftState spacecraftState, EarthSurfaceLocation earthSurfaceLocation) throws Exception {
        OreKitBackedSpacecraftState oss = (OreKitBackedSpacecraftState)spacecraftState;
        GeodeticPoint location = new GeodeticPoint(earthSurfaceLocation.getLatitude(), earthSurfaceLocation.getLongitude(), earthSurfaceLocation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        TopocentricFrame loc = new TopocentricFrame((BodyShape)earth, location, "location");
        FactoryManagedFrame inertialFrame = FramesFactory.getEME2000();
        LocalOrbitalFrame lof = new LocalOrbitalFrame((Frame)inertialFrame, LOFType.QSW, (PVCoordinatesProvider)oss.getOreKitSpacecraftState().getOrbit(), "QSW");
        PVCoordinates pv = lof.getTransformTo((Frame)loc, oss.getOreKitSpacecraftState().getDate()).transformPVCoordinates(PVCoordinates.ZERO);
        double l = Math.sqrt(pv.getPosition().getX() * pv.getPosition().getX() + pv.getPosition().getY() * pv.getPosition().getY());
        double elevation = Math.atan2(pv.getPosition().getZ(), l);
        return elevation;
    }

    @Override
    public double getSpacecraftAzimuthAngle(SpacecraftState spacecraftState, EarthSurfaceLocation earthSurfaceLocation) throws Exception {
        OreKitBackedSpacecraftState oss = (OreKitBackedSpacecraftState)spacecraftState;
        GeodeticPoint location = new GeodeticPoint(earthSurfaceLocation.getLatitude(), earthSurfaceLocation.getLongitude(), earthSurfaceLocation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        TopocentricFrame loc = new TopocentricFrame((BodyShape)earth, location, "location");
        FactoryManagedFrame inertialFrame = FramesFactory.getEME2000();
        LocalOrbitalFrame lof = new LocalOrbitalFrame((Frame)inertialFrame, LOFType.QSW, (PVCoordinatesProvider)oss.getOreKitSpacecraftState().getOrbit(), "QSW");
        PVCoordinates pv = lof.getTransformTo((Frame)loc, oss.getOreKitSpacecraftState().getDate()).transformPVCoordinates(PVCoordinates.ZERO);
        double azimuth = Math.atan2(pv.getPosition().getX(), pv.getPosition().getY());
        return azimuth;
    }

    @Override
    public double getRange(SpacecraftState spacecraftState, EarthSurfaceLocation earthSurfaceLocation) throws Exception {
        OreKitBackedSpacecraftState oss = (OreKitBackedSpacecraftState)spacecraftState;
        GeodeticPoint location = new GeodeticPoint(earthSurfaceLocation.getLatitude(), earthSurfaceLocation.getLongitude(), earthSurfaceLocation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        TopocentricFrame loc = new TopocentricFrame((BodyShape)earth, location, "location");
        FactoryManagedFrame inertialFrame = FramesFactory.getEME2000();
        LocalOrbitalFrame lof = new LocalOrbitalFrame((Frame)inertialFrame, LOFType.QSW, (PVCoordinatesProvider)oss.getOreKitSpacecraftState().getOrbit(), "QSW");
        PVCoordinates pv = lof.getTransformTo((Frame)loc, oss.getOreKitSpacecraftState().getDate()).transformPVCoordinates(PVCoordinates.ZERO);
        double range = pv.getPosition().getNorm();
        return range;
    }

    @Override
    public SpacecraftState createSpacecraftState(org.eclipse.apogy.core.environment.orbit.Orbit orbit, org.orekit.propagation.SpacecraftState oreKitSpacecraftState) {
        OreKitBackedSpacecraftState ss = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createOreKitBackedSpacecraftState();
        TimedStampedPVACoordinates timedStampedPVACoordinates = this.createTimedStampedPVACoordinates(oreKitSpacecraftState.getPVCoordinates());
        ss.setCoordinates(timedStampedPVACoordinates);
        Date date = this.createDate(oreKitSpacecraftState.getDate());
        ss.setTime(date);
        ss.setOreKitSpacecraftState(oreKitSpacecraftState);
        return ss;
    }

    @Override
    public OreKitBackedSpacecraftState createOreKitBackedSpacecraftState(org.eclipse.apogy.core.environment.orbit.Orbit orbit, org.orekit.propagation.SpacecraftState oreKitSpacecraftState) {
        OreKitBackedSpacecraftState ss = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createOreKitBackedSpacecraftState();
        TimedStampedPVACoordinates timedStampedPVACoordinates = this.createTimedStampedPVACoordinates(oreKitSpacecraftState.getPVCoordinates());
        ss.setCoordinates(timedStampedPVACoordinates);
        Date date = this.createDate(oreKitSpacecraftState.getDate());
        ss.setTime(date);
        ss.setOreKitSpacecraftState(oreKitSpacecraftState);
        return ss;
    }

    @Override
    public TimedStampedPVACoordinates createTimedStampedPVACoordinates(TimeStampedPVCoordinates oreKitTimeStampedPVCoordinates) {
        TimedStampedPVACoordinates coord = ApogyCoreEnvironmentOrbitFactory.eINSTANCE.createTimedStampedPVACoordinates();
        Date date = this.createDate(oreKitTimeStampedPVCoordinates.getDate());
        coord.setTime(date);
        Tuple3d position = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedPVCoordinates.getPosition().getX(), oreKitTimeStampedPVCoordinates.getPosition().getY(), oreKitTimeStampedPVCoordinates.getPosition().getZ());
        coord.setPosition(position);
        Tuple3d velocity = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedPVCoordinates.getVelocity().getX(), oreKitTimeStampedPVCoordinates.getVelocity().getY(), oreKitTimeStampedPVCoordinates.getVelocity().getZ());
        coord.setVelocity(velocity);
        Tuple3d acceleration = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedPVCoordinates.getAcceleration().getX(), oreKitTimeStampedPVCoordinates.getAcceleration().getY(), oreKitTimeStampedPVCoordinates.getAcceleration().getZ());
        coord.setAcceleration(acceleration);
        Tuple3d angularVelocity = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedPVCoordinates.getAngularVelocity().getX(), oreKitTimeStampedPVCoordinates.getAngularVelocity().getY(), oreKitTimeStampedPVCoordinates.getAngularVelocity().getZ());
        coord.setAngularVelocity(angularVelocity);
        return coord;
    }

    @Override
    public TimedStampedAngularCoordinates createTimedStampedAngularCoordinates(TimeStampedAngularCoordinates oreKitTimeStampedAngularCoordinates) {
        TimedStampedAngularCoordinates timedStampedAngularCoordinates = ApogyCoreEnvironmentOrbitFactory.eINSTANCE.createTimedStampedAngularCoordinates();
        Date date = this.createDate(oreKitTimeStampedAngularCoordinates.getDate());
        timedStampedAngularCoordinates.setTime(date);
        Tuple3d angularAcceleration = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedAngularCoordinates.getRotationAcceleration().getX(), oreKitTimeStampedAngularCoordinates.getRotationAcceleration().getY(), oreKitTimeStampedAngularCoordinates.getRotationAcceleration().getZ());
        timedStampedAngularCoordinates.setAngularAcceleration(angularAcceleration);
        Matrix3x3 rotationMatrix = this.createMatrix3x3(oreKitTimeStampedAngularCoordinates.getRotation());
        timedStampedAngularCoordinates.setRotation(rotationMatrix);
        return timedStampedAngularCoordinates;
    }

    public Matrix3x3 createMatrix3x3(Rotation rotation) {
        Matrix3x3 matrix3x3 = ApogyCommonMathFactory.eINSTANCE.createMatrix3x3();
        Matrix3d rot = new Matrix3d();
        double[][] m = rotation.getMatrix();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                rot.setElement(i, j, m[i][j]);
                ++j;
            }
            ++i;
        }
        return matrix3x3;
    }

    public Rotation createRotation(Matrix3x3 matrix3x3) {
        Matrix3d rot = matrix3x3.asMatrix3d();
        double[][] m = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                m[i][j] = rot.getElement(i, j);
                ++j;
            }
            ++i;
        }
        Rotation rotation = new Rotation((double[][])m, 1.0E-10);
        return rotation;
    }

    @Override
    public KeplerianEarthOrbit createKeplerianOrbit(EarthOrbitPropagator earthOrbitPropagator) throws Exception {
        if (earthOrbitPropagator.getInitialOrbit() instanceof EarthOrbit) {
            EarthOrbit eo = (EarthOrbit)earthOrbitPropagator.getInitialOrbit();
            KeplerianOrbit ko = new KeplerianOrbit(eo.getOreKitOrbit());
            return this.createKeplerianOrbit(ko);
        }
        throw new Exception("Unsupported EarthOrbitPropagator type <" + earthOrbitPropagator + "> !");
    }

    @Override
    public CartesianEarthOrbit createCartesianEarthOrbit(EarthOrbitPropagator earthOrbitPropagator) throws Exception {
        KeplerianEarthOrbit keo = this.createKeplerianOrbit(earthOrbitPropagator);
        KeplerianOrbit ko = keo.getOreKitKeplerianOrbit();
        CartesianOrbit co = new CartesianOrbit((Orbit)ko);
        return this.createCartesianEarthOrbit(co);
    }

    @Override
    public KeplerianEarthOrbit createKeplerianOrbit(KeplerianOrbit oreKitKeplerianOrbit) {
        KeplerianEarthOrbit keo = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createKeplerianEarthOrbit();
        keo.setTime(this.createDate(oreKitKeplerianOrbit.getDate()));
        keo.setEccentricity(oreKitKeplerianOrbit.getE());
        keo.setInclination(oreKitKeplerianOrbit.getI());
        keo.setMeanAnomaly(oreKitKeplerianOrbit.getMeanAnomaly());
        keo.setTrueAnomaly(oreKitKeplerianOrbit.getTrueAnomaly());
        keo.setPerigeeArgument(oreKitKeplerianOrbit.getPerigeeArgument());
        keo.setRightAscentionOfAscendingNode(oreKitKeplerianOrbit.getRightAscensionOfAscendingNode());
        keo.setSemiMajorAxis(oreKitKeplerianOrbit.getA());
        return keo;
    }

    @Override
    public CartesianEarthOrbit createCartesianEarthOrbit(CartesianOrbit oreKitCartesianOrbit) {
        CartesianEarthOrbit ceo = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createCartesianEarthOrbit();
        TimedStampedPVACoordinates pva = this.createTimedStampedPVACoordinates(oreKitCartesianOrbit.getPVCoordinates());
        ceo.setPvaCoordinates(pva);
        ceo.setTime(this.createDate(oreKitCartesianOrbit.getDate()));
        return ceo;
    }

    @Override
    public GeographicCoordinates convertToGeographicCoordinates(OreKitBackedSpacecraftState oreKitBackedSpacecraftState) throws Exception {
        GeographicCoordinates geographicCoordinates = null;
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)false));
        org.orekit.propagation.SpacecraftState currentState = oreKitBackedSpacecraftState.getOreKitSpacecraftState();
        AbsoluteDate date = currentState.getDate();
        TimeStampedPVCoordinates pvInert = currentState.getPVCoordinates();
        Transform t = currentState.getFrame().getTransformTo(earth.getBodyFrame(), date);
        Vector3D p = t.transformPosition(pvInert.getPosition());
        GeodeticPoint center = earth.transform(p, earth.getBodyFrame(), date);
        geographicCoordinates = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(center.getLongitude(), center.getLatitude(), center.getAltitude());
        return geographicCoordinates;
    }

    @Override
    public double getVelocityHeading(SpacecraftState spacecraftState) throws Exception {
        OreKitBackedSpacecraftState oss = (OreKitBackedSpacecraftState)spacecraftState;
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)false));
        org.orekit.propagation.SpacecraftState currentState = oss.getOreKitSpacecraftState();
        AbsoluteDate date = currentState.getDate();
        TimeStampedPVCoordinates pvInert = currentState.getPVCoordinates();
        Transform t = currentState.getFrame().getTransformTo(earth.getBodyFrame(), date);
        Vector3D p = t.transformPosition(pvInert.getPosition());
        GeodeticPoint satPosition = earth.transform(p, earth.getBodyFrame(), date);
        TopocentricFrame satLocation = new TopocentricFrame((BodyShape)earth, satPosition, "satLocation");
        FactoryManagedFrame inertialFrame = FramesFactory.getEME2000();
        LocalOrbitalFrame lof = new LocalOrbitalFrame((Frame)inertialFrame, LOFType.QSW, (PVCoordinatesProvider)oss.getOreKitSpacecraftState().getOrbit(), "QSW");
        PVCoordinates pv = lof.getTransformTo((Frame)satLocation, oss.getOreKitSpacecraftState().getDate()).transformPVCoordinates(PVCoordinates.ZERO);
        double azimuth = Math.atan2(pv.getVelocity().getX(), pv.getVelocity().getY());
        return azimuth;
    }

    @Override
    public List<SpacecraftState> getSpacecraftStates(Propagator propagator, final Date startDate, final Date endDate, double timeInterval) throws Exception {
        double duration = (double)(endDate.getTime() - startDate.getTime()) * 0.001;
        final ArrayList<SpacecraftState> states = new ArrayList<SpacecraftState>();
        propagator.setMasterMode(timeInterval, new OrekitFixedStepHandler(){

            public void init(org.orekit.propagation.SpacecraftState spacecraftState, AbsoluteDate arg1) throws PropagationException {
            }

            public void handleStep(org.orekit.propagation.SpacecraftState spacecraftState, boolean arg1) throws PropagationException {
                try {
                    Date date = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(spacecraftState.getDate());
                    if (date.getTime() >= startDate.getTime() && endDate.getTime() >= date.getTime()) {
                        EarthOrbit orbit = null;
                        if (spacecraftState.getOrbit() instanceof KeplerianOrbit) {
                            orbit = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createKeplerianOrbit((KeplerianOrbit)spacecraftState.getOrbit());
                        } else if (spacecraftState.getOrbit() instanceof CartesianOrbit) {
                            orbit = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createCartesianEarthOrbit((CartesianOrbit)spacecraftState.getOrbit());
                        }
                        OreKitBackedSpacecraftState ss = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createOreKitBackedSpacecraftState(orbit, spacecraftState);
                        states.add(ss);
                    }
                }
                catch (PropagationException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw new PropagationException((Throwable)e, null, new Object[]{this});
                }
            }
        });
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(startDate);
        try {
            propagator.propagate(new AbsoluteDate(startAbsoluteDate, duration));
            AbsoluteDate absoluteDateEndDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(endDate);
            SpacecraftState endState = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createSpacecraftState(null, propagator.propagate(absoluteDateEndDate));
            states.add(endState);
        }
        catch (PropagationException e1) {
            Logger.error("Error occured during execution.", (Throwable)e1);
            throw e1;
        }
        return states;
    }

    @Override
    public List<SpacecraftState> getSpacecraftStates(EarthSpacecraft earthSpacecraft, final Date startDate, final Date endDate, double timeStep, IProgressMonitor monitor) throws Exception {
        Propagator propagator = ((EarthOrbitModel)earthSpacecraft.getOrbitModel()).getOreKitPropagator();
        final ArrayList<SpacecraftState> states = new ArrayList<SpacecraftState>();
        propagator.setMasterMode(timeStep, new OrekitFixedStepHandler(){

            public void init(org.orekit.propagation.SpacecraftState spacecraftState, AbsoluteDate arg1) throws PropagationException {
            }

            public void handleStep(org.orekit.propagation.SpacecraftState spacecraftState, boolean arg1) throws PropagationException {
                try {
                    Date date = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(spacecraftState.getDate());
                    if (date.getTime() >= startDate.getTime() && endDate.getTime() >= date.getTime()) {
                        EarthOrbit orbit = null;
                        if (spacecraftState.getOrbit() instanceof KeplerianOrbit) {
                            orbit = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createKeplerianOrbit((KeplerianOrbit)spacecraftState.getOrbit());
                        } else if (spacecraftState.getOrbit() instanceof CartesianOrbit) {
                            orbit = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createCartesianEarthOrbit((CartesianOrbit)spacecraftState.getOrbit());
                        }
                        OreKitBackedSpacecraftState ss = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createOreKitBackedSpacecraftState(orbit, spacecraftState);
                        states.add(ss);
                    }
                }
                catch (PropagationException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw new PropagationException((Throwable)e, null, new Object[]{this});
                }
            }
        });
        try {
            AbsoluteDate start = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(startDate);
            AbsoluteDate end = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(endDate);
            propagator.propagate(start, end);
            AbsoluteDate absoluteDateEndDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(endDate);
            SpacecraftState endState = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createSpacecraftState(null, propagator.propagate(absoluteDateEndDate));
            states.add(endState);
        }
        catch (PropagationException e1) {
            Logger.error("Error occured during execution.", (Throwable)e1);
            throw e1;
        }
        return states;
    }

    @Override
    public EarthSpacecraftOrbitHistory getApplicableEarthSpacecraftOrbitHistory(Collection<EarthSpacecraftOrbitHistory> earthSpacecraftOrbitHistories, EarthSpacecraft earthSpacecraft) {
        EarthSpacecraftOrbitHistory earthSpacecraftOrbitHistory = null;
        Iterator<EarthSpacecraftOrbitHistory> it = earthSpacecraftOrbitHistories.iterator();
        while (it.hasNext() && earthSpacecraftOrbitHistory == null) {
            EarthSpacecraftOrbitHistory history = it.next();
            if (history.getSpacecraft() != earthSpacecraft) continue;
            earthSpacecraftOrbitHistory = history;
        }
        return earthSpacecraftOrbitHistory;
    }

    @Override
    public SortedSet<SpacecraftState> getSpacecraftStatesInInterval(List<SpacecraftState> spacecraftStateList, Date startDate, Date endDate) {
        if (!spacecraftStateList.isEmpty()) {
            TreeSet<SpacecraftState> sortedInput = new TreeSet<SpacecraftState>(new SpacecraftStateDateComparator());
            sortedInput.addAll(spacecraftStateList);
            ArrayList<SpacecraftState> temp = new ArrayList<SpacecraftState>();
            long start = startDate.getTime();
            long end = endDate.getTime();
            Iterator it = sortedInput.iterator();
            boolean endReached = false;
            while (it.hasNext() && !endReached) {
                SpacecraftState spacecraftState = (SpacecraftState)it.next();
                long date = spacecraftState.getTime().getTime();
                if (date >= start && date <= end) {
                    temp.add(spacecraftState);
                }
                if (date <= end) continue;
                endReached = true;
            }
            TreeSet<SpacecraftState> result = new TreeSet<SpacecraftState>(new SpacecraftStateDateComparator());
            result.addAll(temp);
            return result;
        }
        return new TreeSet<SpacecraftState>();
    }

    @Override
    public List<VisibilityPass> getVisibilityPasses(EarthSpacecraft earthSpacecraft, List<? extends EarthOutlook> earthOutlooks, Date fromDate, Date toDate, double timeStep, IProgressMonitor monitor) throws Exception {
        double convergenceThreshold = 0.001;
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        Propagator propagator = ((EarthOrbitModel)earthSpacecraft.getOrbitModel()).getOreKitPropagator();
        propagator.setSlaveMode();
        ArrayList<EarthOutlookEventHandler> earthSurfaceLocationEventHandlers = new ArrayList<EarthOutlookEventHandler>();
        for (EarthOutlook earthOutlook : earthOutlooks) {
            GeodeticPoint target = new GeodeticPoint(earthOutlook.getLatitude(), earthOutlook.getLongitude(), earthOutlook.getElevation());
            String name = "?";
            if (earthOutlook.getName() != null) {
                name = earthOutlook.getName();
            }
            TopocentricFrame targetFrame = new TopocentricFrame((BodyShape)earth, target, name);
            EarthOutlookEventHandler eventHandler = new EarthOutlookEventHandler(earthSpacecraft, earthOutlook, fromDate, toDate, timeStep);
            earthSurfaceLocationEventHandlers.add(eventHandler);
            ElevationDetector detector = null;
            if (earthOutlook.getSkyline() instanceof SimpleSkyline) {
                double elevation = ((SimpleSkyline)earthOutlook.getSkyline()).getConstantElevation();
                detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withConstantElevation(elevation).withHandler((EventHandler)eventHandler);
            } else {
                detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withElevationMask(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getOreKitElevationMask(earthOutlook.getSkyline())).withHandler((EventHandler)eventHandler);
            }
            propagator.addEventDetector((EventDetector)detector);
        }
        if (monitor != null) {
            monitor.beginTask("Get Target Passes for EarthSurfaceLocation.", 100);
            DateDetector dateDetector = this.createTimeProgressDateDetector(fromDate, toDate, 100, monitor);
            propagator.addEventDetector((EventDetector)dateDetector);
        }
        AbsoluteDate absoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(fromDate);
        AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(toDate);
        propagator.propagate(absoluteDate, endAbsoluteDate);
        ArrayList<VisibilityPass> passes = new ArrayList<VisibilityPass>();
        for (EarthOutlookEventHandler handler : earthSurfaceLocationEventHandlers) {
            passes.addAll(handler.getFoundPasses());
        }
        if (monitor != null) {
            monitor.done();
        }
        return passes;
    }

    @Override
    public List<Eclipse> getEclipses(final EarthSpacecraft spacecraft, Date startDate, Date endDate, double timeStep, IProgressMonitor monitor) throws Exception {
        final ArrayList<Eclipse> eclipses = new ArrayList<Eclipse>();
        CelestialBody earth = CelestialBodyFactory.getEarth();
        CelestialBody sun = CelestialBodyFactory.getSun();
        EventHandler<EclipseDetector> eventHandler = new EventHandler<EclipseDetector>(){
            Eclipse latestEclipse = null;

            public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState ss, EclipseDetector eclipseDetector, boolean increasing) throws OrekitException {
                if (this.latestEclipse == null) {
                    this.latestEclipse = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createEclipse();
                    this.latestEclipse.setSpacecraft(spacecraft);
                    eclipses.add(this.latestEclipse);
                }
                if (eclipseDetector.getTotalEclipse()) {
                    if (increasing) {
                        EclipseEvent umbraExit = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createEclipseEvent();
                        umbraExit.setTime(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(ss.getDate()));
                        umbraExit.setType(EclipseEventType.UMBRA_EXIT);
                        this.setGeographicCoordinates(umbraExit, ss);
                        this.latestEclipse.setUmbraExit(umbraExit);
                    } else {
                        EclipseEvent umbraEntry = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createEclipseEvent();
                        umbraEntry.setTime(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(ss.getDate()));
                        umbraEntry.setType(EclipseEventType.UMBRA_ENTRY);
                        this.setGeographicCoordinates(umbraEntry, ss);
                        this.latestEclipse.setUmbraEntry(umbraEntry);
                    }
                } else if (increasing) {
                    EclipseEvent penumbraExit = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createEclipseEvent();
                    penumbraExit.setTime(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(ss.getDate()));
                    penumbraExit.setType(EclipseEventType.PENUMBRA_EXIT);
                    this.setGeographicCoordinates(penumbraExit, ss);
                    this.latestEclipse.setPenumbraExit(penumbraExit);
                    this.latestEclipse = null;
                } else {
                    EclipseEvent penumbraEntry = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createEclipseEvent();
                    penumbraEntry.setTime(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(ss.getDate()));
                    penumbraEntry.setType(EclipseEventType.PENUMBRA_ENTRY);
                    this.setGeographicCoordinates(penumbraEntry, ss);
                    this.latestEclipse.setPenumbraEntry(penumbraEntry);
                }
                return EventHandler.Action.CONTINUE;
            }

            public org.orekit.propagation.SpacecraftState resetState(EclipseDetector arg0, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
                return oldState;
            }

            private void setGeographicCoordinates(EclipseEvent eclipseEvent, org.orekit.propagation.SpacecraftState ss) {
                try {
                    OreKitBackedSpacecraftState oreKitBackedSpacecraftState = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createOreKitBackedSpacecraftState();
                    oreKitBackedSpacecraftState.setOreKitSpacecraftState(ss);
                    GeographicCoordinates geographicCoordinates = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.convertToGeographicCoordinates(oreKitBackedSpacecraftState);
                    eclipseEvent.setElevation(geographicCoordinates.getElevation());
                    eclipseEvent.setLatitude(geographicCoordinates.getLatitude());
                    eclipseEvent.setLongitude(geographicCoordinates.getLongitude());
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        };
        EclipseDetector umbraDetector = (EclipseDetector)new EclipseDetector((PVCoordinatesProvider)sun, 6.96E8, (PVCoordinatesProvider)earth, 6378137.0).withUmbra().withHandler((EventHandler)eventHandler);
        EclipseDetector penumbraDetector = (EclipseDetector)new EclipseDetector((PVCoordinatesProvider)sun, 6.96E8, (PVCoordinatesProvider)earth, 6378137.0).withPenumbra().withHandler((EventHandler)eventHandler);
        Propagator propagator = ((EarthOrbitModel)spacecraft.getOrbitModel()).getOreKitPropagator();
        propagator.setSlaveMode();
        propagator.addEventDetector((EventDetector)umbraDetector);
        propagator.addEventDetector((EventDetector)penumbraDetector);
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(startDate);
        AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(endDate);
        propagator.propagate(startAbsoluteDate, endAbsoluteDate);
        for (Eclipse eclipse : eclipses) {
            List<SpacecraftState> states;
            TimeInterval umbraInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
            TimeInterval penumbraEntryInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
            TimeInterval penumbraExitInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
            this.getEclipseIntervals(eclipse, startDate, endDate, umbraInterval, penumbraEntryInterval, penumbraExitInterval);
            if (umbraInterval.getFromDate() != null && umbraInterval.getToDate() != null) {
                states = this.getSpacecraftStates(spacecraft, umbraInterval.getFromDate(), umbraInterval.getToDate(), timeStep, monitor);
                eclipse.getUmbraTrajectorySegment().addAll(states);
            }
            if (penumbraEntryInterval.getFromDate() != null && penumbraEntryInterval.getToDate() != null) {
                states = this.getSpacecraftStates(spacecraft, penumbraEntryInterval.getFromDate(), penumbraEntryInterval.getToDate(), timeStep, monitor);
                eclipse.getPenumbraFirstTrajectorySegment().addAll(states);
            }
            if (penumbraExitInterval.getFromDate() == null || penumbraExitInterval.getToDate() == null) continue;
            states = this.getSpacecraftStates(spacecraft, penumbraExitInterval.getFromDate(), penumbraExitInterval.getToDate(), timeStep, monitor);
            eclipse.getPenumbraSecondTrajectorySegment().addAll(states);
        }
        return eclipses;
    }

    @Override
    public void getEclipseIntervals(Eclipse eclipse, Date fromDate, Date toDate, TimeInterval umbraInterval, TimeInterval penumbraEntryInterval, TimeInterval penumbraExitInterval) {
        umbraInterval.setFromDate(null);
        umbraInterval.setToDate(null);
        penumbraEntryInterval.setFromDate(null);
        penumbraEntryInterval.setToDate(null);
        penumbraExitInterval.setFromDate(null);
        penumbraExitInterval.setToDate(null);
        if (eclipse.getUmbraEntry() != null && eclipse.getUmbraExit() != null) {
            umbraInterval.setFromDate(eclipse.getUmbraEntry().getTime());
            umbraInterval.setToDate(eclipse.getUmbraExit().getTime());
            if (eclipse.getPenumbraEntry() != null) {
                penumbraEntryInterval.setFromDate(eclipse.getPenumbraEntry().getTime());
            } else {
                penumbraEntryInterval.setFromDate(fromDate);
            }
            penumbraEntryInterval.setToDate(eclipse.getUmbraEntry().getTime());
            penumbraExitInterval.setFromDate(eclipse.getUmbraExit().getTime());
            if (eclipse.getPenumbraExit() != null) {
                penumbraExitInterval.setToDate(eclipse.getPenumbraExit().getTime());
            } else {
                penumbraExitInterval.setToDate(toDate);
            }
        } else if (eclipse.getUmbraEntry() != null) {
            umbraInterval.setFromDate(eclipse.getUmbraEntry().getTime());
            umbraInterval.setToDate(toDate);
            if (eclipse.getPenumbraEntry() != null) {
                penumbraEntryInterval.setFromDate(eclipse.getPenumbraEntry().getTime());
            } else {
                penumbraEntryInterval.setFromDate(fromDate);
            }
        } else if (eclipse.getUmbraExit() != null) {
            umbraInterval.setFromDate(fromDate);
            umbraInterval.setToDate(eclipse.getUmbraExit().getTime());
            penumbraExitInterval.setFromDate(eclipse.getUmbraExit().getTime());
            if (eclipse.getPenumbraExit() != null) {
                penumbraExitInterval.setToDate(eclipse.getPenumbraExit().getTime());
            } else {
                penumbraExitInterval.setToDate(toDate);
            }
        } else if (eclipse.getUmbraEntry() == null && eclipse.getUmbraExit() == null) {
            if (eclipse.getPenumbraEntry() != null) {
                penumbraEntryInterval.setFromDate(eclipse.getPenumbraEntry().getTime());
                if (eclipse.getPenumbraExit() != null) {
                    penumbraEntryInterval.setToDate(eclipse.getPenumbraExit().getTime());
                } else {
                    penumbraEntryInterval.setToDate(toDate);
                }
            } else if (eclipse.getPenumbraExit() != null) {
                penumbraExitInterval.setFromDate(fromDate);
                penumbraExitInterval.setToDate(eclipse.getPenumbraExit().getTime());
            }
        }
    }

    @Override
    public List<Eclipse> getApplicableEclipse(Collection<Eclipse> eclipses, EarthSpacecraft spacecraft) {
        ArrayList<Eclipse> applicableEclipses = new ArrayList<Eclipse>();
        for (Eclipse eclipse : eclipses) {
            if (eclipse.getSpacecraft() != spacecraft) continue;
            applicableEclipses.add(eclipse);
        }
        return applicableEclipses;
    }

    @Override
    public SortedSet<VisibilityPass> getVisibilityPassSortedByStartDate(List<VisibilityPass> passes) {
        TreeSet<VisibilityPass> sortedSet = new TreeSet<VisibilityPass>(new VisibilityPassStartDateComparator());
        sortedSet.addAll(passes);
        return sortedSet;
    }

    @Override
    public SortedSet<VisibilityPass> getVisibilityPassSortedByDuration(List<VisibilityPass> passes) {
        TreeSet<VisibilityPass> sortedSet = new TreeSet<VisibilityPass>(new VisibilityPassDurationComparator());
        sortedSet.addAll(passes);
        return sortedSet;
    }

    @Override
    public SortedSet<VisibilityPassSpacecraftPosition> getVisibilityPassSpacecraftPositionSortedByElevation(List<VisibilityPassSpacecraftPosition> positions) {
        TreeSet<VisibilityPassSpacecraftPosition> sortedSet = new TreeSet<VisibilityPassSpacecraftPosition>(new VisibilityPassSpacecraftPositionElevationComparator());
        sortedSet.addAll(positions);
        return sortedSet;
    }

    @Override
    public SortedSet<VisibilityPassSpacecraftPosition> getVisibilityPassSpacecraftPositionSortedBySpacecraftCrossTrackAngle(List<VisibilityPassSpacecraftPosition> positions) {
        TreeSet<VisibilityPassSpacecraftPosition> sortedSet = new TreeSet<VisibilityPassSpacecraftPosition>(new VisibilityPassSpacecraftPositionSpacecraftCrossTrackAngleComparator());
        sortedSet.addAll(positions);
        return sortedSet;
    }

    @Override
    public TLE createTLE(String firstLine, String secondLine) throws Exception {
        org.orekit.propagation.analytical.tle.TLE orekitTLE = new org.orekit.propagation.analytical.tle.TLE(firstLine, secondLine);
        TLE tle = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createTLE();
        tle.setBStar(orekitTLE.getBStar());
        tle.setEpoch(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(orekitTLE.getDate()));
        tle.setEccentricity(orekitTLE.getE());
        tle.setElementNumber(orekitTLE.getElementNumber());
        tle.setEphemerisType(EphemerisType.get(orekitTLE.getEphemerisType()));
        tle.setInclination(orekitTLE.getI());
        tle.setMeanAnomaly(orekitTLE.getMeanAnomaly());
        tle.setMeanMotion(orekitTLE.getMeanMotion());
        double revPerDay = tle.getMeanMotion() * 24.0 * 60.0 * 60.0 / (Math.PI * 2);
        tle.setRevolutionPerDay(revPerDay);
        tle.setMeanMotionFirstDerivative(orekitTLE.getMeanMotionFirstDerivative());
        tle.setMeanMotionSecondDerivative(orekitTLE.getMeanMotionSecondDerivative());
        tle.setArgumentOfPerigee(orekitTLE.getPerigeeArgument());
        tle.setRightAscentionOfAscendingNode(orekitTLE.getRaan());
        tle.setRevolutionNumberAtEpoch(orekitTLE.getRevolutionNumberAtEpoch());
        tle.setSatelliteNumber(orekitTLE.getSatelliteNumber());
        return tle;
    }

    @Override
    public void updateExistingTLE(AbstractTLE originalTLE, AbstractTLE newTLE) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__ARGUMENT_OF_PERIGEE, (Object)newTLE.getArgumentOfPerigee(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__BSTAR, (Object)newTLE.getBStar(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__ECCENTRICITY, (Object)newTLE.getEccentricity(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__ELEMENT_NUMBER, (Object)newTLE.getElementNumber(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__EPHEMERIS_TYPE, (Object)newTLE.getEphemerisType(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__EPOCH, (Object)newTLE.getEpoch(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__INCLINATION, (Object)newTLE.getInclination(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__MEAN_ANOMALY, (Object)newTLE.getMeanAnomaly(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__MEAN_MOTION, (Object)newTLE.getMeanMotion(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__MEAN_MOTION_FIRST_DERIVATIVE, (Object)newTLE.getMeanMotionFirstDerivative(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__MEAN_MOTION_SECOND_DERIVATIVE, (Object)newTLE.getMeanMotionSecondDerivative(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__REVOLUTION_NUMBER_AT_EPOCH, (Object)newTLE.getRevolutionNumberAtEpoch(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__REVOLUTION_PER_DAY, (Object)newTLE.getRevolutionPerDay(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__RIGHT_ASCENTION_OF_ASCENDING_NODE, (Object)newTLE.getRightAscentionOfAscendingNode(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)originalTLE, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_TLE__SATELLITE_NUMBER, (Object)newTLE.getSatelliteNumber(), true);
    }

    @Override
    public TLE loadTLE(String urlString) throws Exception {
        URL url = new URL(urlString);
        File tempFile = ApogyCommonFacade.INSTANCE.copyURLContent(url);
        FileInputStream fis = new FileInputStream(tempFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        String[] lines = new String[2];
        int i = 0;
        String line = null;
        while ((line = br.readLine()) != null && i < 2) {
            lines[i] = line;
            ++i;
        }
        br.close();
        return this.createTLE(lines[0], lines[1]);
    }

    @Override
    public List<TLE> loadAllTLE(String urlString) throws Exception {
        URL url = new URL(urlString);
        File tempFile = ApogyCommonFacade.INSTANCE.copyURLContent(url);
        FileInputStream fis = new FileInputStream(tempFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        ArrayList<String> lines = new ArrayList<String>();
        if (br.ready()) {
            String line = null;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            br.close();
        }
        ArrayList<String> lines1 = new ArrayList<String>();
        ArrayList<String> lines2 = new ArrayList<String>();
        for (String next : lines) {
            if (next.trim().startsWith("1")) {
                lines1.add(next.trim());
                continue;
            }
            if (!next.trim().startsWith("2")) continue;
            lines2.add(next.trim());
        }
        ArrayList<TLE> tles = new ArrayList<TLE>();
        int j = 0;
        while (j < lines1.size()) {
            try {
                TLE tle = this.createTLE((String)lines1.get(j), (String)lines2.get(j));
                if (tle != null) {
                    tles.add(tle);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++j;
        }
        return tles;
    }

    @Override
    public void exportTLE(TLE tle, String urlString) throws Exception {
        throw new RuntimeException("Not supported.");
    }

    @Override
    public TLEEarthOrbitModel createTLEEarthOrbitModel(TLE tle) throws Exception {
        TLEEarthOrbitModel propagator = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createTLEEarthOrbitModel();
        propagator.setTle(tle);
        return propagator;
    }

    @Override
    public String exportAsCSV(VisibilityPassSpacecraftPositionHistory visibilityPassSpacecraftPositionHistory, boolean includeHeader) {
        StringBuffer buffer = new StringBuffer();
        if (includeHeader) {
            buffer.append("Time, Azimuth (deg),Elevation (deg),Range (km), Range Rate (m/s), Target Along Track Angle (deg), Target Cross Track Angle (deg), S/C Latitude (deg), S/C Longitude (deg), S/C Altitude (km) \n");
        }
        for (VisibilityPassSpacecraftPosition position : visibilityPassSpacecraftPositionHistory.getPositions()) {
            buffer.append(String.valueOf(position.getTime().toString()) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getAzimuth()))) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getElevation()))) + ",");
            buffer.append(String.valueOf(Double.toString(position.getRange() * 0.001)) + ",");
            buffer.append(String.valueOf(Double.toString(position.getRangeRate())) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getAlongTrackAngle()))) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getCrossTrackAngle()))) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getCoordinates().getLatitude()))) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getCoordinates().getLongitude()))) + ",");
            buffer.append(String.valueOf(Double.toString(position.getCoordinates().getElevation() * 0.001)) + ",");
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected DateDetector createTimeProgressDateDetector(Date startDate, Date endDate, int totalWorkUnits, IProgressMonitor monitor) {
        long duration = endDate.getTime() - startDate.getTime();
        long timeIncrement = Math.round(1.0 * (double)duration / (double)totalWorkUnits);
        AbsoluteDate absoluteStartDate = this.createAbsoluteDate(startDate);
        TimeProgressEventHandler handler = new TimeProgressEventHandler(monitor);
        DateDetector dateDetector = (DateDetector)new DateDetector(1.0, 1.0, new TimeStamped[]{absoluteStartDate}).withHandler((EventHandler)handler);
        long time = startDate.getTime() + timeIncrement;
        while (time < endDate.getTime()) {
            Date date = new Date(time);
            AbsoluteDate absoluteDate = this.createAbsoluteDate(date);
            dateDetector.addEventDate(absoluteDate);
            time += timeIncrement;
        }
        return dateDetector;
    }

    @Override
    public ElevationMask getOreKitElevationMask(final AbstractSkyline skyline) {
        AbstractSkyline activeSkyline = skyline;
        if (activeSkyline == null) {
            activeSkyline = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createSimpleSkyline();
        }
        ElevationMask mask = null;
        if (activeSkyline instanceof SimpleSkyline) {
            double[][] maskValues = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
            mask = new ElevationMask(maskValues){
                private static final long serialVersionUID = -89818792036112341L;

                public double getElevation(double arg0) {
                    return ((SimpleSkyline)skyline).getConstantElevation();
                }
            };
        } else {
            Logger.error("The skyline <" + skyline.getClass().getName() + "> is not supported");
        }
        return mask;
    }

    @Override
    public VisibilityPassSpacecraftPosition getClosestRangePosition(VisibilityPassSpacecraftPositionHistory history) {
        VisibilityPassSpacecraftPosition smallestRangePosition = null;
        if (!history.getPositions().isEmpty()) {
            double closestRange = Double.POSITIVE_INFINITY;
            for (VisibilityPassSpacecraftPosition p : history.getPositions()) {
                if (!(p.getRange() < closestRange)) continue;
                closestRange = p.getRange();
                smallestRangePosition = p;
            }
        }
        return smallestRangePosition;
    }

    @Override
    public VisibilityPassSpacecraftPosition getHighestElevationPosition(VisibilityPassSpacecraftPositionHistory history) {
        VisibilityPassSpacecraftPosition higestElevationPosition = null;
        if (!history.getPositions().isEmpty()) {
            double highestElevation = Double.NEGATIVE_INFINITY;
            for (VisibilityPassSpacecraftPosition p : history.getPositions()) {
                if (!(p.getElevation() > highestElevation)) continue;
                highestElevation = p.getElevation();
                higestElevationPosition = p;
            }
        }
        return higestElevationPosition;
    }

    @Override
    public VisibilityPassSpacecraftPosition getSmallestSpacecraftCrossTrackAnglePosition(VisibilityPassSpacecraftPositionHistory history) {
        VisibilityPassSpacecraftPosition smallestSpacecraftCrossTrackAnglePosition = null;
        if (!history.getPositions().isEmpty()) {
            double smallestCrossTrackAngle = Double.MAX_VALUE;
            for (VisibilityPassSpacecraftPosition p : history.getPositions()) {
                double crossTrackAngle = Math.abs(p.getCrossTrackAngle());
                if (!(crossTrackAngle < smallestCrossTrackAngle)) continue;
                smallestCrossTrackAngle = crossTrackAngle;
                smallestSpacecraftCrossTrackAnglePosition = p;
            }
        }
        return smallestSpacecraftCrossTrackAnglePosition;
    }

    @Override
    public void refreshOreKitBackedSpacecraftState(EarthOrbitModel orbitModel, Collection<SpacecraftState> spacecraftStates) {
        for (SpacecraftState spacecraftState : spacecraftStates) {
            OreKitBackedSpacecraftState oreKitBackedSpacecraftState;
            if (!(spacecraftState instanceof OreKitBackedSpacecraftState) || (oreKitBackedSpacecraftState = (OreKitBackedSpacecraftState)spacecraftState).getOreKitSpacecraftState() != null) continue;
            try {
                SpacecraftState newSpacecraftState = orbitModel.propagate(spacecraftState.getTime());
                if (!(newSpacecraftState instanceof OreKitBackedSpacecraftState)) continue;
                OreKitBackedSpacecraftState newOreKitBackedSpacecraftState = (OreKitBackedSpacecraftState)newSpacecraftState;
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)oreKitBackedSpacecraftState, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORE_KIT_BACKED_SPACECRAFT_STATE__ORE_KIT_SPACECRAFT_STATE, (Object)newOreKitBackedSpacecraftState.getOreKitSpacecraftState(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public VisibilityPassSpacecraftPositionHistory getVisibilityPassPositionHistory(VisibilityPass pass, Date fromDate, Date toDate, double timeStep) {
        VisibilityPassSpacecraftPositionHistory history = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createVisibilityPassSpacecraftPositionHistory();
        try {
            Propagator propagator = ((EarthOrbitModel)pass.getSpacecraft().getOrbitModel()).getOreKitPropagator();
            FactoryManagedFrame inertialFrame = FramesFactory.getEME2000();
            LocalOrbitalFrame lof = new LocalOrbitalFrame((Frame)inertialFrame, LOFType.QSW, (PVCoordinatesProvider)propagator, "QSW");
            EarthOutlook coord = pass.getOutlook();
            GeodeticPoint location = new GeodeticPoint(coord.getLatitude(), coord.getLongitude(), coord.getElevation());
            FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
            OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
            TopocentricFrame loc = new TopocentricFrame((BodyShape)earth, location, "location");
            UTCScale utc = TimeScalesFactory.getUTC();
            AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(fromDate);
            AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(toDate);
            AbsoluteDate extrapDate = startAbsoluteDate;
            while (extrapDate.compareTo(endAbsoluteDate) <= 0) {
                PVCoordinates pv = lof.getTransformTo((Frame)loc, extrapDate).transformPVCoordinates(PVCoordinates.ZERO);
                double range = pv.getPosition().getNorm();
                double rangeRate = Vector3D.dotProduct((Vector3D)pv.getPosition(), (Vector3D)pv.getVelocity()) / pv.getPosition().getNorm();
                double azimuth = Math.atan2(pv.getPosition().getX(), pv.getPosition().getY());
                double l = Math.sqrt(pv.getPosition().getX() * pv.getPosition().getX() + pv.getPosition().getY() * pv.getPosition().getY());
                double elevation = Math.atan2(pv.getPosition().getZ(), l);
                PVCoordinates sc = lof.getTransformTo(earth.getBodyFrame(), extrapDate).transformPVCoordinates(PVCoordinates.ZERO);
                PVCoordinates tgt = loc.getTransformTo(earth.getBodyFrame(), extrapDate).transformPVCoordinates(PVCoordinates.ZERO);
                Vector3D p = sc.getPosition();
                Vector3D v = sc.getVelocity();
                Vector3D crossTrack = p.crossProduct((Vector)v);
                Vector3D target = tgt.getPosition();
                Vector3D scToTarget = p.subtract((Vector)target);
                Vector3D scToTargetOntoOrbitalPlane = this.projectOntoPlane(scToTarget, crossTrack.normalize());
                Vector3D scToTargetOntoCrossTrackPlane = this.projectOntoPlane(scToTarget, v.normalize());
                double scAlongTrackAngle = this.getAlongTrackAngle(p, scToTargetOntoOrbitalPlane, crossTrack);
                double scCrossTrackAngle = this.getCrossTrackAngle(p, scToTargetOntoCrossTrackPlane, v);
                VisibilityPassSpacecraftPosition position = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createVisibilityPassSpacecraftPosition();
                position.setTime(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(extrapDate));
                position.setRange(range);
                position.setRangeRate(rangeRate);
                position.setAzimuth(azimuth);
                position.setElevation(elevation);
                position.setCrossTrackAngle(scCrossTrackAngle);
                position.setAlongTrackAngle(scAlongTrackAngle);
                GeodeticPoint scCoords = earth.transform(sc.getPosition(), earth.getBodyFrame(), extrapDate);
                GeographicCoordinates geo = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(scCoords.getLongitude(), scCoords.getLatitude(), scCoords.getAltitude());
                position.setCoordinates(geo);
                history.getPositions().add((Object)position);
                extrapDate = new AbsoluteDate(extrapDate, timeStep, (TimeScale)utc);
            }
            long duration = toDate.getTime() - fromDate.getTime();
            propagator.propagate(new AbsoluteDate(startAbsoluteDate, (double)duration));
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        return history;
    }

    @Override
    public List<VisibilityPass> getGroundStationsVisibilityPassesOverlap(OrbitAnalysisResult orbitAnalysisResult, TimeInterval timeInterval) {
        ArrayList<VisibilityPass> results = new ArrayList<VisibilityPass>();
        boolean toAdd = false;
        for (VisibilityPass visibilityPass : orbitAnalysisResult.getGroundStationVisibilityPasses()) {
            toAdd = false;
            if (ApogyCommonEMFFacade.INSTANCE.isDateInValidRange(timeInterval, visibilityPass.getFromDate()) || ApogyCommonEMFFacade.INSTANCE.isDateInValidRange(timeInterval, visibilityPass.getToDate())) {
                toAdd = true;
            }
            if (!toAdd && timeInterval.getFromDate().getTime() <= visibilityPass.getFromDate().getTime() && timeInterval.getToDate().getTime() >= visibilityPass.getToDate().getTime()) {
                toAdd = true;
            }
            if (!toAdd) continue;
            results.add(visibilityPass);
        }
        return results;
    }

    @Override
    public List<VisibilityPass> getObservationTargetVisibilityPassesOverlap(OrbitAnalysisResult orbitAnalysisResult, TimeInterval timeInterval) {
        ArrayList<VisibilityPass> results = new ArrayList<VisibilityPass>();
        boolean toAdd = false;
        for (VisibilityPass visibilityPass : orbitAnalysisResult.getObservationTargetVisibilityPasses()) {
            toAdd = false;
            if (ApogyCommonEMFFacade.INSTANCE.isDateInValidRange(timeInterval, visibilityPass.getFromDate()) || ApogyCommonEMFFacade.INSTANCE.isDateInValidRange(timeInterval, visibilityPass.getToDate())) {
                toAdd = true;
            }
            if (!toAdd && timeInterval.getFromDate().getTime() <= visibilityPass.getFromDate().getTime() && timeInterval.getToDate().getTime() >= visibilityPass.getToDate().getTime()) {
                toAdd = true;
            }
            if (!toAdd) continue;
            results.add(visibilityPass);
        }
        return results;
    }

    @Override
    public List<Eclipse> getEclipsesOverlap(OrbitAnalysisResult orbitAnalysisResult, TimeInterval timeInterval) {
        ArrayList<Eclipse> results = new ArrayList<Eclipse>();
        Date fromDate = null;
        Date toDate = null;
        boolean toAdd = false;
        for (Eclipse eclipse : orbitAnalysisResult.getEclipses()) {
            toAdd = false;
            fromDate = null;
            toDate = null;
            if (eclipse.getPenumbraEntry() != null) {
                fromDate = eclipse.getPenumbraEntry().getTime();
            }
            if (eclipse.getUmbraEntry() != null && fromDate == null) {
                fromDate = eclipse.getUmbraEntry().getTime();
            }
            if (eclipse.getPenumbraExit() != null) {
                toDate = eclipse.getPenumbraExit().getTime();
            }
            if (eclipse.getUmbraExit() != null && toDate == null) {
                toDate = eclipse.getUmbraExit().getTime();
            }
            if (fromDate != null && ApogyCommonEMFFacade.INSTANCE.isDateInValidRange(timeInterval, fromDate)) {
                toAdd = true;
            }
            if (toDate != null && !toAdd && ApogyCommonEMFFacade.INSTANCE.isDateInValidRange(timeInterval, toDate)) {
                toAdd = true;
            }
            if (!toAdd) {
                if (fromDate != null && fromDate.getTime() <= timeInterval.getFromDate().getTime()) {
                    toAdd = true;
                }
                if (toDate != null && toDate.getTime() >= timeInterval.getToDate().getTime()) {
                    toAdd = true;
                }
            }
            if (!toAdd) continue;
            results.add(eclipse);
        }
        return results;
    }

    private double getAlongTrackAngle(Vector3D p, Vector3D scToTargetOntoOrbitalPlane, Vector3D crossTrackVector) {
        double angle = this.getAngle(p, scToTargetOntoOrbitalPlane);
        Vector3D rotation = p.crossProduct((Vector)scToTargetOntoOrbitalPlane).normalize();
        double dotProduct = rotation.dotProduct((Vector)crossTrackVector.normalize());
        if (dotProduct < 0.0) {
            angle = -angle;
        }
        return Math.abs(angle);
    }

    private double getCrossTrackAngle(Vector3D p, Vector3D scToTargetOntoCrossTrackPlane, Vector3D alongTrackVector) {
        double angle = this.getAngle(p, scToTargetOntoCrossTrackPlane);
        Vector3D rotation = p.crossProduct((Vector)scToTargetOntoCrossTrackPlane).normalize();
        double dotProduct = rotation.dotProduct((Vector)alongTrackVector.normalize());
        if (dotProduct > 0.0) {
            angle = -angle;
        }
        return angle;
    }

    private double getAngle(Vector3D v1, Vector3D v2) {
        double dotProduct = v1.dotProduct((Vector)v2);
        return Math.acos(dotProduct / (v1.getNorm() * v2.getNorm()));
    }

    private Vector3D projectOntoPlane(Vector3D u, Vector3D planeNormal) {
        double projUOnNormalLenght = u.dotProduct((Vector)planeNormal) / planeNormal.getNormSq();
        Vector3D projUOnNormal = planeNormal.scalarMultiply(projUOnNormalLenght);
        return u.subtract((Vector)projUOnNormal);
    }

    @Override
    public EarthOrbitTools getActiveEarthOrbitTools() {
        EarthOrbitTools earthOrbitTools = null;
        InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (invocatorSession != null && (earthOrbitTools = this.getEarthOrbitTools(invocatorSession)) == null) {
            earthOrbitTools = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createEarthOrbitTools();
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)invocatorSession.getToolsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_TOOLS_LIST_CONTAINER__TOOLS_LIST, (Object)earthOrbitTools, true);
        }
        return earthOrbitTools;
    }

    private EarthOrbitTools getEarthOrbitTools(InvocatorSession invocatorSession) {
        EarthOrbitTools earthOrbitTools = null;
        Iterator it = invocatorSession.getToolsList().getToolsListContainers().iterator();
        while (it.hasNext() && earthOrbitTools == null) {
            AbstractToolsListContainer list = (AbstractToolsListContainer)it.next();
            if (!(list instanceof EarthOrbitTools)) continue;
            earthOrbitTools = (EarthOrbitTools)list;
        }
        return earthOrbitTools;
    }

    private Adapter getActiveSessionAdapter() {
        if (this.activeSessionAdapter == null) {
            this.activeSessionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureID;
                    if (msg.getNotifier() instanceof ApogyCoreInvocatorFacade) {
                        int featureID2 = msg.getFeatureID(ApogyCoreInvocatorFacade.class);
                        if (featureID2 == 2) {
                            InvocatorSession newInvocatorSession;
                            InvocatorSession oldInvocatorSession = (InvocatorSession)msg.getOldValue();
                            if (oldInvocatorSession != null) {
                                oldInvocatorSession.eAdapters().remove((Object)ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this.getActiveSessionAdapter());
                                oldInvocatorSession.getToolsList().eAdapters().remove((Object)ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this.getActiveSessionAdapter());
                            }
                            if ((newInvocatorSession = (InvocatorSession)msg.getNewValue()) != null) {
                                newInvocatorSession.eAdapters().add((Object)ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this.getActiveSessionAdapter());
                                newInvocatorSession.getToolsList().eAdapters().add((Object)ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this.getActiveSessionAdapter());
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.APOGY_CORE_ENVIRONMENT_EARTH_ORBIT_FACADE__ACTIVE_EARTH_ORBIT_TOOLS, (Object)ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this.getEarthOrbitTools(newInvocatorSession), true);
                            } else {
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.APOGY_CORE_ENVIRONMENT_EARTH_ORBIT_FACADE__ACTIVE_EARTH_ORBIT_TOOLS, null, true);
                            }
                        }
                    } else if (msg.getNotifier() instanceof ToolsList && (featureID = msg.getFeatureID(ToolsList.class)) == 7) {
                        ToolsList toolsList = (ToolsList)msg.getNotifier();
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.APOGY_CORE_ENVIRONMENT_EARTH_ORBIT_FACADE__ACTIVE_EARTH_ORBIT_TOOLS, (Object)ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this.getEarthOrbitTools(toolsList.getInvocatorSession()), true);
                    }
                }
            };
        }
        return this.activeSessionAdapter;
    }

    @Override
    public OrbitAnalysisTool getOrbitAnalysisTool() {
        EarthOrbitTools earthOrbitTools = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getActiveEarthOrbitTools();
        OrbitAnalysisTool tool = null;
        if (earthOrbitTools != null) {
            Iterator it = earthOrbitTools.getTools().iterator();
            while (it.hasNext() && tool == null) {
                EarthOrbitTool earthOrbitTool = (EarthOrbitTool)it.next();
                if (!(earthOrbitTool instanceof OrbitAnalysisTool)) continue;
                tool = (OrbitAnalysisTool)earthOrbitTool;
            }
        }
        return tool;
    }

    @Override
    public OrbitAnalysisDataSet getOrbitAnalysisDataSet() {
        OrbitAnalysisTool tool = this.getOrbitAnalysisTool();
        return tool == null ? null : tool.getDataSet();
    }

    private class EarthOutlookEventHandler
    implements EventHandler<ElevationDetector> {
        private final EarthOutlook earthOutlook;
        private final EarthSpacecraft earthSpacecraft;
        private VisibilityPass lastPass = null;
        private final List<VisibilityPass> passes = new ArrayList<VisibilityPass>();
        private Date fromDate;
        private Date toDate;
        private Date passStartTime = null;
        private Date passEndTime = null;
        double timeStep;

        public EarthOutlookEventHandler(EarthSpacecraft earthSpacecraft, EarthOutlook earthOutlook, Date fromDate, Date toDate, double timeStep) {
            this.earthSpacecraft = earthSpacecraft;
            this.earthOutlook = earthOutlook;
            this.fromDate = fromDate;
            this.toDate = toDate;
            this.timeStep = timeStep;
        }

        public List<VisibilityPass> getFoundPasses() {
            return this.passes;
        }

        public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState s, ElevationDetector detector, boolean increasing) throws OrekitException {
            if (increasing) {
                if (this.lastPass == null) {
                    this.lastPass = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createVisibilityPass();
                    this.passStartTime = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(s.getDate());
                    this.lastPass.setFromDate(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(s.getDate()));
                    this.lastPass.setOutlook(this.earthOutlook);
                    this.lastPass.setSpacecraft(this.earthSpacecraft);
                }
            } else if (this.lastPass != null) {
                this.passEndTime = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(s.getDate());
                this.lastPass.setToDate(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(s.getDate()));
                this.passes.add(this.lastPass);
                VisibilityPassSpacecraftPositionHistory history = ApogyCoreEnvironmentEarthOrbitFacadeCustomImpl.this.getVisibilityPassPositionHistory(this.lastPass, this.passStartTime, this.passEndTime, this.timeStep);
                this.lastPass.setPositionHistory(history);
                this.lastPass = null;
                this.passStartTime = null;
                this.passEndTime = null;
            }
            return EventHandler.Action.CONTINUE;
        }

        public org.orekit.propagation.SpacecraftState resetState(ElevationDetector arg0, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
            return oldState;
        }
    }

    private class SpacecraftStateDateComparator
    implements Comparator<SpacecraftState> {
        private SpacecraftStateDateComparator() {
        }

        @Override
        public int compare(SpacecraftState o1, SpacecraftState o2) {
            long o2Date;
            long o1Date = o1.getTime().getTime();
            if (o1Date > (o2Date = o2.getTime().getTime())) {
                return 1;
            }
            if (o1Date < o2Date) {
                return -1;
            }
            return 0;
        }
    }

    private class TimeProgressEventHandler
    implements EventHandler<DateDetector> {
        private final IProgressMonitor monitor;

        public TimeProgressEventHandler(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState arg0, DateDetector arg1, boolean increasing) throws OrekitException {
            this.monitor.worked(1);
            return EventHandler.Action.CONTINUE;
        }

        public org.orekit.propagation.SpacecraftState resetState(DateDetector arg0, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
            return oldState;
        }
    }

    private class VisibilityPassDurationComparator
    implements Comparator<VisibilityPass> {
        private VisibilityPassDurationComparator() {
        }

        @Override
        public int compare(VisibilityPass arg0, VisibilityPass arg1) {
            long startTime1;
            double duration1;
            double duration0 = ApogyCommonEMFFacade.INSTANCE.getDuration((TimeInterval)arg0);
            if (duration0 > (duration1 = (double)ApogyCommonEMFFacade.INSTANCE.getDuration((TimeInterval)arg1))) {
                return 1;
            }
            if (duration0 < duration1) {
                return -1;
            }
            long startTime0 = arg0.getFromDate().getTime();
            if (startTime0 > (startTime1 = arg1.getFromDate().getTime())) {
                return 1;
            }
            if (startTime0 < startTime1) {
                return -1;
            }
            return 0;
        }
    }

    private class VisibilityPassSpacecraftPositionElevationComparator
    implements Comparator<VisibilityPassSpacecraftPosition> {
        private VisibilityPassSpacecraftPositionElevationComparator() {
        }

        @Override
        public int compare(VisibilityPassSpacecraftPosition arg0, VisibilityPassSpacecraftPosition arg1) {
            if (arg0.getElevation() > arg1.getElevation()) {
                return 1;
            }
            if (arg0.getElevation() < arg1.getElevation()) {
                return -1;
            }
            return 0;
        }
    }

    private class VisibilityPassSpacecraftPositionSpacecraftCrossTrackAngleComparator
    implements Comparator<VisibilityPassSpacecraftPosition> {
        private VisibilityPassSpacecraftPositionSpacecraftCrossTrackAngleComparator() {
        }

        @Override
        public int compare(VisibilityPassSpacecraftPosition arg0, VisibilityPassSpacecraftPosition arg1) {
            if (arg0.getCrossTrackAngle() > arg1.getCrossTrackAngle()) {
                return 1;
            }
            if (arg0.getCrossTrackAngle() < arg1.getCrossTrackAngle()) {
                return -1;
            }
            return 0;
        }
    }

    private class VisibilityPassStartDateComparator
    implements Comparator<VisibilityPass> {
        private VisibilityPassStartDateComparator() {
        }

        @Override
        public int compare(VisibilityPass arg0, VisibilityPass arg1) {
            double duration1;
            long startTime1;
            long startTime0 = arg0.getFromDate().getTime();
            if (startTime0 > (startTime1 = arg1.getFromDate().getTime())) {
                return 1;
            }
            if (startTime0 < startTime1) {
                return -1;
            }
            double duration0 = ApogyCommonEMFFacade.INSTANCE.getDuration((TimeInterval)arg0);
            if (duration0 > (duration1 = (double)ApogyCommonEMFFacade.INSTANCE.getDuration((TimeInterval)arg1))) {
                return 1;
            }
            if (duration0 < duration1) {
                return -1;
            }
            return 0;
        }
    }
}

