/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.ApogyCommonFacade;
import org.eclipse.apogy.core.environment.earth.AbstractSkyline;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFactory;
import org.eclipse.apogy.core.environment.earth.SimpleSkyline;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ObservationTarget;
import org.eclipse.apogy.core.environment.earth.orbit.impl.DefaultObservationTargetImporterImpl;
import org.eclipse.core.runtime.IProgressMonitor;

public class DefaultObservationTargetImporterCustomImpl
extends DefaultObservationTargetImporterImpl {
    @Override
    public List<ObservationTarget> importTargets(IProgressMonitor monitor) throws Exception {
        if (this.getFileURL() == null || this.getFileURL().length() == 0) {
            throw new RuntimeException("No URL defined !");
        }
        return this.parseFile(this.getFileURL());
    }

    private List<ObservationTarget> parseFile(String urlString) throws Exception {
        ArrayList<ObservationTarget> targets = new ArrayList<ObservationTarget>();
        URL url = new URL(urlString);
        File tempFile = ApogyCommonFacade.INSTANCE.copyURLContent(url);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(tempFile));
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            System.out.println("Line :" + line);
            ObservationTarget observationTarget = this.parseLine(line);
            if (observationTarget == null) continue;
            targets.add(observationTarget);
        }
        bufferedReader.close();
        return targets;
    }

    private ObservationTarget parseLine(String line) {
        ObservationTarget observationTarget = null;
        String[] values = line.split(",");
        if (values.length == 6) {
            String name = values[0].trim();
            String description = values[1].trim();
            double longitude = Double.parseDouble(values[2].trim());
            double latitude = Double.parseDouble(values[3].trim());
            double elevation = Double.parseDouble(values[4].trim());
            double elevationMask = Double.parseDouble(values[5].trim());
            observationTarget = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createObservationTarget();
            observationTarget.setName(name);
            observationTarget.setDescription(description);
            observationTarget.setLongitude(Math.toRadians(longitude));
            observationTarget.setLatitude(Math.toRadians(latitude));
            observationTarget.setElevation(elevation);
            SimpleSkyline skyline = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createSimpleSkyline();
            skyline.setConstantElevation(Math.toRadians(elevationMask));
            observationTarget.setSkyline((AbstractSkyline)skyline);
        }
        return observationTarget;
    }
}

